<?xml version="1.0"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    
    <xsl:param name="frame_name"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:output method="html" doctype-public='-//W3C//DTD HTML 4.0 TRANSITIONAL//EN"' doctype-system="http://www.w3c.org/TR/REC-html40/loose.dtd"/>
    
    <xsl:variable name="newline">
    <xsl:text>  
    </xsl:text>
    </xsl:variable>
    
    <xsl:template match="/">
        <xsl:apply-templates select="Library"/>
    </xsl:template>
    
    <xsl:template match="Library">
        <xsl:call-template name="all-classes">
            
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="all-classes">
        
        <html>  
        <xsl:value-of select="$newline"/>             
            <head>
                <xsl:call-template name="generateDateStamp">
                    <xsl:with-param name="printDate" select="@date"/>  
                </xsl:call-template>
                <Title>All Classes</Title>
                
                <LINK REL="stylesheet" TYPE="text/css" HREF="stylesheet.css" TITLE="Style"/>      
            </head> 
            
            <xsl:value-of select="$newline"/>
            <body BGCOLOR="white" >
            <br/>
                <font size="+1" CLASS="FrameHeadingFont">
                    <b>All Classes</b>
                </font>
                <br/>
                <xsl:if test="count(Symbol/Interface) &gt; 0">
                <br/>
                    <font CLASS="FrameHeadingFont">
                    <b>Interfaces</b></font><br/>
                    <xsl:for-each select="Symbol/Interface">
                        <a href="{../SymbolName/@name}-v{../SymbolName/@version}.html" target="{$frame_name}">
                            <xsl:value-of select="../SymbolName/@name"/>-v<xsl:value-of select="../SymbolName/@version"/>
                        </a><br/>
                    </xsl:for-each> 
                </xsl:if> 
                <xsl:if test="count(Symbol/Class) &gt; 0">
                <br/>
                    <font CLASS="FrameHeadingFont">
                        <b>Classes</b>
                     </font>
                    <xsl:for-each select="Symbol/Class">
                        <br/>
                        <font CLASS="FrameItemFont">
                        <xsl:if test="../@abstract = 'true'"><xsl:text disable-output-escaping="yes">&lt;i&gt;</xsl:text></xsl:if>
                        <a href="{../SymbolName/@name}-v{../SymbolName/@version}.html" target="{$frame_name}">
                            <xsl:value-of select="../SymbolName/@name"/>-v<xsl:value-of select="../SymbolName/@version"/>
                        </a>
                        <xsl:if test="@abstract = 'true'"><xsl:text disable-output-escaping="yes">&lt;/i&gt;</xsl:text></xsl:if>
                        </font>
                    </xsl:for-each> 
                </xsl:if>
                <br/>
                <xsl:if test="count(Symbol/Enumeration) &gt; 0">
                <br/>
                    <font CLASS="FrameHeadingFont">
                        <b>Enumerations</b>
                     </font>
                     <br/>
                    <xsl:for-each select="Symbol/Enumeration">
                        <a href="{../SymbolName/@name}-v{../SymbolName/@version}.html" target="{$frame_name}">
                            <xsl:value-of select="../SymbolName/@name"/>-v<xsl:value-of select="../SymbolName/@version"/>
                        </a><br/>
                    </xsl:for-each> 
                </xsl:if>
            </body>
            <xsl:value-of select="$newline"/>
           
        </html> 
    </xsl:template>
    
    
    
    
    
    <xsl:template name="generateDateStamp">
        <xsl:param name="printDate"/>
        <xsl:value-of select="$newline"/>
        <xsl:comment>Generated by babeldoc on <xsl:value-of select="$printDate"/> </xsl:comment>
        <xsl:value-of select="$newline"/>
    </xsl:template> 
      
    <xsl:template name="generateOtherHeader">
        <xsl:param name="docTitle"/>  
        <xsl:value-of select="$newline"/>
        <LINK REL="stylesheet" TYPE="text/css" HREF="stylesheet.css" TITLE="Style"/>
        
        <SCRIPT>
        function asd()
        {
        parent.document.title="<xsl:value-of select="$docTitle"/>"
        }
        </SCRIPT> 
        <xsl:value-of select="$newline"/>
     </xsl:template>
    
</xsl:stylesheet>