/*
Copyright (C) 2000-2001 Jos Roberto B. de A. Monteiro <jrm@autsens.com>
                        and Pedro Zorzenon Neto <pzn@autsens.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _AVRPP_H
#define _AVRPP_H

/*
  This object represents a single bit in parallel port
*/

struct reg_pp {
  unsigned short base;
  int offset;
  int row;
};

struct reg_pp * rpp_new();
struct reg_pp * rpp_init(struct reg_pp * reg,
			 unsigned short base, int offset, int row);
void rpp_delete(struct reg_pp * reg);

void rpp_set(struct reg_pp * reg);
void rpp_clear(struct reg_pp * reg);
void rpp_write(struct reg_pp * reg, int data);
unsigned char rpp_read(struct reg_pp * reg);

/*
  Object that contains all bits of control for a parallel port
*/
struct avr_serial_pp {
  struct reg_pp *NSCK, *NMISO, *MOSI, *RESET;
};

typedef struct avr_serial_pp ASPP;

ASPP * aspp_new();
ASPP * aspp_init(ASPP *aspp, unsigned short base);
void aspp_delete(ASPP *aspp);

void aspp_SCK(ASPP *aspp, int data);
void aspp_RESET(ASPP *aspp, int data);
void aspp_MOSI(ASPP *aspp, int data);
int aspp_MISO(ASPP *aspp);

#endif
