// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/ACClassDatabase.h"
#include "Puma/ACAspectInfo.h"
#include "Puma/ACPointcutInfo.h"
#include "Puma/ACSliceInfo.h"
#include "Puma/CClassInfo.h"
#include "Puma/CFunctionInfo.h"
#include <string.h>

namespace Puma {


ACAspectInfo *ACClassDatabase::new_aspect (CClassInfo *ci) { 
  ACAspectInfo *ai = new ACAspectInfo (ci);
  _aspect.append (ai);
  return ai;
}

ACPointcutInfo *ACClassDatabase::new_pointcut (CFunctionInfo *fi) { 
  ACPointcutInfo *pi = new ACPointcutInfo (fi);
  _pointcut.append (pi);
  return pi;
}

ACSliceInfo *ACClassDatabase::new_slice (CObjectInfo *oi) { 
  ACSliceInfo *si = new ACSliceInfo (oi);
  _slice.append (si);
  return si;
}

ACAspectInfo *ACClassDatabase::AspectInfo (const char *n) const {
  for (int a = 0; a < AspectInfos (); a++)
    if (strcmp (AspectInfo (a)->name (), n) == 0)
      return AspectInfo(a);
  return (ACAspectInfo*)0;
}

ACAspectInfo *ACClassDatabase::AspectInfo (CClassInfo *ci) const {
  for (int a = 0; a < AspectInfos (); a++)
    if (AspectInfo (a)->ClassInfo () == ci)
      return AspectInfo (a);
  return (ACAspectInfo*)0;
}

ACPointcutInfo *ACClassDatabase::PointcutInfo (CFunctionInfo *fi) const {
  for (int p = 0; p < PointcutInfos (); p++)
    if (PointcutInfo (p)->function () == fi)
      return PointcutInfo (p);
  return (ACPointcutInfo*)0;
}

ACSliceInfo *ACClassDatabase::SliceInfo (CObjectInfo *oi) const {
  for (int s = 0; s < SliceInfos (); s++)
    if (SliceInfo (s)->object () == oi)
      return SliceInfo (s);
  return (ACSliceInfo*)0;
}

void ACClassDatabase::clear () {
  for (int a = _aspect.length () - 1; a >= 0; a--) {
    delete _aspect[a];
    _aspect.remove (a);
  }
  for (int p = _pointcut.length () - 1; p >= 0; p--) {
    delete _pointcut[p];
    _pointcut.remove (p);
  }
  for (int s = _slice.length () - 1; s >= 0; s--) {
    delete _slice[s];
    _slice.remove (s);
  }
}

// dump the contents of the database
void ACClassDatabase::Dump (ostream &out, int level) const {
  out << "aspect-db:" << endl;
  out << "  " << AspectInfos () << " aspects:" << endl;
  for (int i = 0; i < AspectInfos (); i++) {
    out << "    " << AspectInfo (i)->name ()
        << " (" << AspectInfo (i)->PointcutInfos () << " pointcuts, "
        << AspectInfo (i)->AdviceNodes () << " advice nodes, "
        << AspectInfo (i)->IntroNodes () << " intro nodes)" << endl;
  }
  out << "  " << PointcutInfos () << " pointcuts:" << endl;
  for (int i = 0; i < PointcutInfos (); i++) {
    out << "    " << PointcutInfo (i)->name ();
    if (PointcutInfo (i)->Aspect ())
      out << " (aspect: " << PointcutInfo (i)->Aspect ()->name () << ")";
    out << endl;
  }
  out << "  " << SliceInfos () << " slices:" << endl;
  for (int i = 0; i < SliceInfos (); i++) {
    out << "    " << SliceInfo (i)->object ()->QualName ();
    out << endl;
  }
}


} // namespace Puma
