// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __UnitState__
#define __UnitState__

// The state of a unit: 
// 1. modified by manipulations and not updated at the class registry
// 2. modified by manipulations and updated at the class registry
// 3. unmodified by manipulations and not updated at the class registry
// 4. unmodified by manipulations and updated at the class registry

namespace Puma {


class UnitState {
  bool _modified;
  bool _updated;
  long _lastModified;
      
public:
  UnitState ();
      
  bool isModified () const;
  bool isUpdated () const;
  long lastModified () const;

  // Is modified and has to be updated.
  void modified ();
  void lastModified (long);
  void unmodified ();
  void updated ();
};

inline UnitState::UnitState ()
 { _modified = false; _updated = false; _lastModified = 0; }

inline bool UnitState::isModified () const 
 { return _modified; }
inline bool UnitState::isUpdated () const 
 { return _updated; }
inline long UnitState::lastModified () const
 { return _lastModified; }

inline void UnitState::modified () 
 { _modified = true; _updated = false; _lastModified = 0; }
inline void UnitState::unmodified () 
 { _modified = false; }
inline void UnitState::updated () 
 { _updated = true; }
inline void UnitState::lastModified (long when) 
 { _lastModified = when; }


} // namespace Puma

#endif /* __UnitState__ */
