/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;

public class ProjectSorter {
    private final DAG dag = new DAG();
    private final List sortedProjects;
    private MavenProject topLevelProject;

    public ProjectSorter(List projects) throws CycleDetectedException, DuplicateProjectException {
        String id;
        MavenProject project;
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            project = (MavenProject)i.next();
            id = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
            if (this.dag.getVertex(id) != null) {
                throw new DuplicateProjectException("Project '" + id + "' is duplicated in the reactor");
            }
            this.dag.addVertex(id);
            projectMap.put(id, project);
        }
        i = projects.iterator();
        while (i.hasNext()) {
            Iterator j;
            List reportPlugins;
            List buildPlugins;
            String parentId;
            project = (MavenProject)i.next();
            id = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
            Iterator j2 = project.getDependencies().iterator();
            while (j2.hasNext()) {
                Dependency dependency = (Dependency)j2.next();
                String dependencyId = ArtifactUtils.versionlessKey(dependency.getGroupId(), dependency.getArtifactId());
                if (this.dag.getVertex(dependencyId) == null) continue;
                project.addProjectReference((MavenProject)projectMap.get(dependencyId));
                this.dag.addEdge(id, dependencyId);
            }
            MavenProject parent = project.getParent();
            if (parent != null && this.dag.getVertex(parentId = ArtifactUtils.versionlessKey(parent.getGroupId(), parent.getArtifactId())) != null) {
                if (this.dag.hasEdge(parentId, id)) {
                    this.dag.removeEdge(parentId, id);
                }
                this.dag.addEdge(id, parentId);
            }
            if ((buildPlugins = project.getBuildPlugins()) != null) {
                Iterator j3 = buildPlugins.iterator();
                while (j3.hasNext()) {
                    Plugin plugin = (Plugin)j3.next();
                    String pluginId = ArtifactUtils.versionlessKey(plugin.getGroupId(), plugin.getArtifactId());
                    if (this.dag.getVertex(pluginId) == null || pluginId.equals(id)) continue;
                    this.addEdgeWithParentCheck(projectMap, pluginId, project, id);
                }
            }
            if ((reportPlugins = project.getReportPlugins()) != null) {
                j = reportPlugins.iterator();
                while (j.hasNext()) {
                    ReportPlugin plugin = (ReportPlugin)j.next();
                    String pluginId = ArtifactUtils.versionlessKey(plugin.getGroupId(), plugin.getArtifactId());
                    if (this.dag.getVertex(pluginId) == null || pluginId.equals(id)) continue;
                    this.addEdgeWithParentCheck(projectMap, pluginId, project, id);
                }
            }
            j = project.getBuildExtensions().iterator();
            while (j.hasNext()) {
                Extension extension = (Extension)j.next();
                String extensionId = ArtifactUtils.versionlessKey(extension.getGroupId(), extension.getArtifactId());
                if (this.dag.getVertex(extensionId) == null) continue;
                this.addEdgeWithParentCheck(projectMap, extensionId, project, id);
            }
        }
        ArrayList sortedProjects = new ArrayList();
        Iterator i2 = TopologicalSorter.sort(this.dag).iterator();
        while (i2.hasNext()) {
            id = (String)i2.next();
            sortedProjects.add(projectMap.get(id));
        }
        this.sortedProjects = Collections.unmodifiableList(sortedProjects);
    }

    private void addEdgeWithParentCheck(Map projectMap, String extensionId, MavenProject project, String id) throws CycleDetectedException {
        MavenProject extProject = (MavenProject)projectMap.get(extensionId);
        project.addProjectReference(extProject);
        MavenProject extParent = extProject.getParent();
        if (extParent != null) {
            String parentId = ArtifactUtils.versionlessKey(extParent.getGroupId(), extParent.getArtifactId());
            if (!this.dag.hasEdge(extensionId, id) || !parentId.equals(id)) {
                this.dag.addEdge(id, extensionId);
            }
        }
    }

    public MavenProject getTopLevelProject() {
        if (this.topLevelProject == null) {
            Iterator i = this.sortedProjects.iterator();
            while (i.hasNext() && this.topLevelProject == null) {
                MavenProject project = (MavenProject)i.next();
                if (!project.isExecutionRoot()) continue;
                this.topLevelProject = project;
            }
        }
        return this.topLevelProject;
    }

    public List getSortedProjects() {
        return this.sortedProjects;
    }

    public boolean hasMultipleProjects() {
        return this.sortedProjects.size() > 1;
    }

    public List getDependents(String id) {
        return this.dag.getParentLabels(id);
    }
}

