/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xpath.XPathException;

public class DeepEqual
extends CollatingFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        boolean bl;
        block9: {
            AtomicComparer atomicComparer = this.getAtomicComparer(2, xPathContext);
            SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
            SequenceIterator sequenceIterator2 = this.argument[1].iterate(xPathContext);
            bl = true;
            try {
                while (true) {
                    Item item = sequenceIterator.next();
                    Item item2 = sequenceIterator2.next();
                    if (item == null && item2 == null) break block9;
                    if (item == null || item2 == null) {
                        bl = false;
                        break block9;
                    }
                    if (item instanceof NodeInfo) {
                        if (item2 instanceof NodeInfo) {
                            if (DeepEqual.deepEquals((NodeInfo)item, (NodeInfo)item2, atomicComparer)) continue;
                            bl = false;
                        } else {
                            bl = false;
                        }
                        break block9;
                    }
                    if (item2 instanceof NodeInfo) {
                        bl = false;
                        break block9;
                    }
                    if (!atomicComparer.comparesEqual(item, item2)) break;
                }
                bl = false;
            }
            catch (ClassCastException classCastException) {
                bl = false;
            }
            catch (XPathException xPathException) {
                bl = false;
            }
        }
        return BooleanValue.get(bl);
    }

    public static boolean deepEquals(NodeInfo nodeInfo, NodeInfo nodeInfo2, AtomicComparer atomicComparer) throws XPathException {
        if (nodeInfo.isSameNode(nodeInfo2)) {
            return true;
        }
        if (nodeInfo.getNodeKind() != nodeInfo2.getNodeKind()) {
            return false;
        }
        switch (nodeInfo.getNodeKind()) {
            case 1: {
                Object object;
                Object object2;
                if (nodeInfo.getFingerprint() != nodeInfo2.getFingerprint()) {
                    return false;
                }
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2);
                AxisIterator axisIterator2 = nodeInfo2.iterateAxis((byte)2);
                if (Aggregate.count(axisIterator.getAnother()) != Aggregate.count(axisIterator2.getAnother())) {
                    return false;
                }
                while ((object2 = (NodeInfo)axisIterator.next()) != null) {
                    object = nodeInfo2.getAttributeValue(object2.getFingerprint());
                    if (object == null) {
                        return false;
                    }
                    if (atomicComparer.comparesEqual(object, object2.getStringValue())) continue;
                    return false;
                }
            }
            case 9: {
                NodeInfo nodeInfo3;
                NodeInfo nodeInfo4;
                Object object2 = nodeInfo.iterateAxis((byte)3);
                Object object = nodeInfo2.iterateAxis((byte)3);
                do {
                    nodeInfo4 = (NodeInfo)object2.next();
                    while (nodeInfo4 != null && (nodeInfo4.getNodeKind() == 8 || nodeInfo4.getNodeKind() == 7)) {
                        nodeInfo4 = (NodeInfo)object2.next();
                    }
                    nodeInfo3 = (NodeInfo)object.next();
                    while (nodeInfo3 != null && (nodeInfo3.getNodeKind() == 8 || nodeInfo3.getNodeKind() == 7)) {
                        nodeInfo3 = (NodeInfo)object.next();
                    }
                    if (nodeInfo4 != null && nodeInfo3 != null) continue;
                    return nodeInfo4 == nodeInfo3;
                } while (DeepEqual.deepEquals(nodeInfo4, nodeInfo3, atomicComparer));
                return false;
            }
            case 2: 
            case 7: 
            case 13: {
                if (nodeInfo.getFingerprint() != nodeInfo2.getFingerprint()) {
                    return false;
                }
            }
            case 3: 
            case 8: {
                return atomicComparer.comparesEqual(nodeInfo.getStringValue(), nodeInfo2.getStringValue());
            }
        }
        throw new IllegalArgumentException("Unknown node type");
    }
}

