
/* 
 * International Color Consortium color transform expanded support
 *
 * Author:  Graeme W. Gill
 * Date:    30/3/2007
 * Version: 1.00
 *
 * Copyright 2002 - 2007 Graeme W. Gill
 * All rights reserved.
 * This material is licenced under the GNU AFFERO GENERAL PUBLIC LICENSE Version 3 :-
 * see the License.txt file for licencing details.
 *
 */

/*
 * This is some more test code to test the FWA compensation
 * feature of the spectal to CIE conversion.
 * Check how well the FWA is estimated from some paper samples.
 */

#define DOPLOT		/* Graphs: Black = target curve */
					/*         Red   = uncorrected curve */
					/*         Green = corrected curve */

#include <stdio.h>
#include <math.h>
#include "xspect.h"
#include "insttypes.h"
//#include "inst.h"
#include "numlib.h"
#ifdef DOPLOT
#include "plot.h"
#endif
#include "ui.h"


/* Normal 'A' spectra, then UV filtered version */

xspect mat[2][20] = {
	/* 'A' illuminant */
	{
		{	/* 1 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				14.267, 15.584, 20.723, 41.993, 84.338, 104.728, 108.065, 104.009, 98.717, 95.746, 93.079, 90.568, 88.689, 87.157, 85.795, 84.303, 83.109, 81.981, 80.966, 80.685, 80.361, 80.369, 80.530, 81.249, 82.823, 85.006, 87.685, 90.146, 91.902, 92.799, 93.246, 93.458, 93.767, 94.212, 94.372, 94.651
			}
		},
		{	/* 2 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				14.983, 16.831, 22.426, 43.716, 84.430, 105.538, 109.685, 105.582, 100.060, 96.944, 94.119, 91.251, 88.909, 86.894, 84.962, 83.264, 82.636, 82.203, 81.208, 80.950, 81.420, 82.457, 83.033, 83.040, 83.033, 83.700, 85.422, 87.339, 88.728, 89.234, 89.152, 88.913, 89.203, 89.990, 90.613, 91.301
			}
		},
		{	/* 3 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				24.488, 29.581, 37.749, 69.706, 94.472, 100.591, 100.273, 98.291, 97.532, 96.351, 95.134, 94.261, 93.428, 92.569, 91.950, 91.181, 90.660, 90.115, 89.426, 89.326, 89.147, 89.154, 89.151, 89.321, 89.636, 89.984, 90.717, 91.607, 92.478, 93.171, 93.867, 94.470, 95.044, 95.638, 95.840, 96.071
			}
		},
		{	/* 4 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				44.123, 45.345, 46.333, 52.603, 77.805, 95.763, 102.401, 99.326, 95.610, 95.188, 94.009, 92.570, 92.002, 91.687, 91.396, 90.911, 90.662, 90.464, 90.104, 90.172, 89.881, 89.799, 89.690, 89.664, 89.708, 89.679, 89.894, 90.203, 90.473, 90.556, 90.720, 90.841, 91.078, 91.416, 91.445, 91.559
			}
		},
		{	/* 5 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				59.175, 67.893, 72.295, 79.833, 89.531, 92.976, 93.994, 93.660, 93.322, 93.028, 92.527, 91.913, 91.195, 90.494, 89.974, 89.258, 88.761, 88.208, 87.470, 87.222, 86.769, 86.608, 86.590, 86.842, 87.344, 87.956, 88.924, 90.036, 91.088, 91.870, 92.720, 93.474, 94.280, 95.064, 95.370, 95.685
			}
		},
		{	/* 6 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				37.749, 42.672, 50.439, 75.066, 95.496, 97.450, 98.295, 95.268, 93.331, 92.634, 91.847, 91.403, 91.410, 91.538, 91.791, 91.771, 91.955, 92.073, 91.974, 92.312, 92.335, 92.575, 92.698, 92.835, 93.066, 93.277, 93.761, 94.294, 94.661, 94.719, 94.749, 94.757, 95.001, 95.429, 95.619, 95.931
			}
		},
		{	/* 7 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				57.122, 62.955, 67.576, 72.801, 76.460, 78.437, 79.846, 80.856, 81.509, 82.098, 82.427, 82.523, 82.718, 82.593, 82.345, 82.122, 82.183, 82.198, 82.035, 82.353, 82.618, 83.188, 83.512, 83.549, 83.583, 84.044, 85.291, 86.585, 87.429, 87.476, 87.439, 87.590, 88.241, 89.077, 89.530, 90.008
			}
		},
		{	/* 8 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				58.637, 64.082, 68.830, 73.651, 76.911, 78.772, 80.309, 81.192, 82.121, 82.541, 82.893, 83.226, 83.147, 83.038, 83.058, 82.702, 82.727, 83.025, 82.982, 83.281, 83.705, 84.410, 84.663, 84.619, 84.804, 85.372, 86.410, 87.352, 88.013, 88.340, 88.616, 88.753, 89.031, 89.572, 89.914, 90.712
			}
		},
		{	/* 9 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				32.774, 38.428, 47.037, 72.668, 97.391, 102.330, 102.404, 99.655, 97.093, 95.368, 93.825, 92.567, 91.674, 90.957, 90.507, 89.992, 89.784, 89.565, 89.259, 89.610, 89.881, 90.199, 90.325, 90.465, 90.671, 90.878, 91.428, 92.051, 92.507, 92.607, 92.842, 93.236, 93.963, 94.682, 94.942, 95.146
			}
		},
		{	/* 10 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				66.797, 69.934, 72.229, 74.822, 76.630, 78.036, 78.706, 79.021, 79.371, 79.281, 79.175, 79.144, 79.095, 79.119, 79.272, 79.143, 79.064, 78.924, 78.588, 78.615, 78.296, 78.132, 77.969, 77.909, 77.943, 77.812, 77.925, 78.115, 78.213, 78.133, 78.181, 78.345, 78.757, 79.268, 79.782, 80.318
			}
		},
		{	/* 11 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				29.478, 33.585, 40.588, 60.658, 85.350, 92.218, 93.564, 91.366, 88.913, 87.742, 86.793, 86.094, 85.874, 85.915, 86.117, 86.130, 86.333, 86.510, 86.589, 87.051, 87.157, 87.444, 87.677, 88.083, 88.545, 88.907, 89.442, 90.002, 90.440, 90.591, 90.787, 91.029, 91.434, 91.878, 92.014, 92.373
			}
		},
		{	/* 12 */
			0, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				0.0
			}
		}
	},

	/* UV filtered */
	{
		{	/* 1 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				28.419, 33.018, 42.215, 51.413, 69.808, 85.626, 88.515, 88.544, 88.433, 88.268, 87.971, 87.553, 86.919, 86.138, 85.337, 84.207, 83.249, 82.288, 81.393, 81.182, 80.923, 80.961, 81.138, 81.828, 83.388, 85.583, 88.212, 90.650, 92.373, 93.250, 93.633, 93.778, 94.089, 94.424, 94.498, 94.910
			}
		},
		{	/* 2 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				28.104, 32.711, 41.924, 51.137, 69.563, 85.811, 89.046, 89.203, 89.062, 88.799, 88.455, 87.735, 86.713, 85.504, 84.103, 82.802, 82.413, 82.146, 81.252, 81.067, 81.568, 82.671, 83.263, 83.214, 83.248, 83.963, 85.592, 87.499, 88.976, 89.428, 89.257, 89.095, 89.302, 90.015, 90.578, 91.308
			}
		},
		{	/* 3 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				70.653, 72.514, 76.238, 79.961, 87.407, 92.047, 92.848, 93.040, 93.369, 93.389, 93.257, 93.088, 92.713, 92.239, 91.847, 91.231, 90.837, 90.378, 89.765, 89.702, 89.530, 89.587, 89.577, 89.724, 90.020, 90.395, 91.115, 91.948, 92.866, 93.526, 94.160, 94.800, 95.340, 95.785, 96.001, 96.205
			}
		},
		{	/* 4 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				39.580, 43.280, 50.681, 58.081, 72.882, 86.792, 90.031, 90.136, 90.086, 90.403, 90.619, 90.769, 90.883, 90.942, 91.074, 90.832, 90.758, 90.656, 90.367, 90.489, 90.233, 90.180, 90.049, 90.013, 90.100, 90.021, 90.238, 90.576, 90.811, 90.900, 91.031, 91.114, 91.314, 91.537, 91.438, 91.634
			}
		},
		{	/* 5 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				77.775, 78.760, 80.729, 82.698, 86.637, 89.962, 90.821, 91.214, 91.679, 91.804, 91.748, 91.501, 91.059, 90.523, 90.154, 89.541, 89.136, 88.644, 87.956, 87.743, 87.265, 87.155, 87.163, 87.349, 87.809, 88.407, 89.293, 90.340, 91.417, 92.181, 92.880, 93.690, 94.331, 94.912, 95.209, 95.549
			}
		},
		{	/* 6 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				70.130, 71.508, 74.263, 77.018, 82.527, 85.915, 86.959, 87.455, 88.211, 88.869, 89.502, 90.186, 90.813, 91.367, 91.951, 92.170, 92.518, 92.720, 92.703, 93.117, 93.192, 93.453, 93.621, 93.771, 94.057, 94.262, 94.695, 95.157, 95.508, 95.572, 95.574, 95.771, 96.080, 96.418, 96.573, 96.865
			}
		},
		{	/* 7 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				70.903, 71.374, 72.316, 73.259, 75.144, 77.016, 78.664, 79.797, 80.774, 81.501, 81.859, 82.236, 82.471, 82.309, 82.265, 82.050, 82.044, 82.123, 82.052, 82.288, 82.492, 83.143, 83.510, 83.466, 83.495, 84.034, 85.312, 86.528, 87.301, 87.403, 87.410, 87.697, 88.149, 88.800, 89.108, 89.670
			}
		},
		{	/* 8 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				71.356, 71.858, 72.862, 73.867, 75.875, 77.895, 79.391, 80.476, 81.601, 82.106, 82.559, 83.048, 83.056, 83.041, 83.107, 82.713, 82.781, 83.133, 83.088, 83.355, 83.790, 84.538, 84.821, 84.683, 84.892, 85.550, 86.553, 87.512, 88.192, 88.505, 88.733, 88.959, 89.162, 89.539, 89.868, 90.603
			}
		},
		{	/* 9 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				68.893, 70.690, 74.285, 77.880, 85.070, 89.766, 90.646, 90.753, 90.971, 90.955, 90.895, 90.798, 90.641, 90.406, 90.284, 89.991, 89.943, 89.840, 89.591, 89.991, 90.279, 90.608, 90.760, 90.860, 91.096, 91.360, 91.836, 92.435, 92.923, 93.002, 93.227, 93.684, 94.312, 94.851, 95.151, 95.382
			}
		},
		{	/* 10 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				71.725, 72.140, 72.969, 73.798, 75.457, 76.827, 77.511, 78.066, 78.560, 78.621, 78.659, 78.711, 78.736, 78.759, 78.905, 78.808, 78.824, 78.662, 78.369, 78.382, 78.062, 77.906, 77.778, 77.756, 77.796, 77.681, 77.606, 77.754, 77.733, 77.637, 77.658, 77.616, 77.867, 78.183, 78.446, 78.888
			}
		},
		{	/* 11 */
			36, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				56.723, 58.809,  62.983,  67.157,  75.504,  81.580,  82.970,  83.489,  84.048,  84.454,  84.913,  85.415,  85.885,  86.365,  86.852,  87.052,  87.381,  87.634,  87.777,  88.262,  88.371,  88.665,  88.885,  89.250,  89.674,  89.930,  90.462,  90.913,  91.339,  91.367,  91.548,  91.681,  92.032,  92.466,  92.440,  92.765
			}
		},
		{	/* 12 */
			0, 380.0, 730.0,	/* 36 bands from 380 to 730 in 10nm steps */
			100.0,				/* Scale factor */
			{
				0.0
			}
		}
	}
};

int
main(void) {
	int m, i;
	xspect insp;
	double xx[500],y1[500],y2[500],y3[500];

	if (inst_illuminant(&insp, instSpectrolino) != 0)
		error ("Instrument doesn't have an FWA illuminent");

	printf("Hi there\n");

	/* For each material */
	for (m = 0; ; m++) {
		xsp2cie *con;		/* Conversions */

		if (mat[0][m].spec_n == 0)
			break;

		printf("Material %d\n", m+1);

		/* Create two conversions for the target/check illuminant */
		if ((con = new_xsp2cie(icxIT_D50, NULL, icxOT_CIE_1931_2,
		                       NULL, icSigLabData, 1)) == NULL)
			error ("Creating conversion failed");

		if (con->set_fwa(con, &insp, NULL, &mat[0][m]))
			error ("Setting FWA compensation failed");

		for (i = 0; i < mat[0][m].spec_n; i++) {
			double ww;

			ww = (mat[0][m].spec_wl_long - mat[0][m].spec_wl_short)
			   * ((double)i/(mat[0][m].spec_n-1.0)) + mat[0][m].spec_wl_short;

			xx[i] = ww;
			y1[i] = mat[0][m].spec[i];				/* 'A' Black = Input Measurement */
			y2[i] = con->media.spec[i] * 100.0;		/* Red = Estimated media */
			y3[i] = mat[1][m].spec[i];				/* Green = Target Measurement with UV */
		}
//		do_plot(xx,y1,y2,y3,i);
		do_plot_x(xx,y1,y2,y3,i,
		          1, 370.0, 740.0, 0.0, 120.0, 2.0);
		con->del(con);
	}
	return 0;
}








