// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(feature = "v4_10")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
use crate::MemoryFormat;
use crate::Paintable;
use glib::{prelude::*, translate::*};
use std::{fmt, ptr};

glib::wrapper! {
    #[doc(alias = "GdkTexture")]
    pub struct Texture(Object<ffi::GdkTexture, ffi::GdkTextureClass>) @implements Paintable, gio::Icon, gio::LoadableIcon;

    match fn {
        type_ => || ffi::gdk_texture_get_type(),
    }
}

impl Texture {
    pub const NONE: Option<&'static Texture> = None;

    #[doc(alias = "gdk_texture_new_for_pixbuf")]
    #[doc(alias = "new_for_pixbuf")]
    pub fn for_pixbuf(pixbuf: &gdk_pixbuf::Pixbuf) -> Texture {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gdk_texture_new_for_pixbuf(pixbuf.to_glib_none().0)) }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gdk_texture_new_from_bytes")]
    #[doc(alias = "new_from_bytes")]
    pub fn from_bytes(bytes: &glib::Bytes) -> Result<Texture, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::gdk_texture_new_from_bytes(bytes.to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gdk_texture_new_from_file")]
    #[doc(alias = "new_from_file")]
    pub fn from_file(file: &impl IsA<gio::File>) -> Result<Texture, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::gdk_texture_new_from_file(file.as_ref().to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gdk_texture_new_from_filename")]
    #[doc(alias = "new_from_filename")]
    pub fn from_filename(path: impl AsRef<std::path::Path>) -> Result<Texture, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret =
                ffi::gdk_texture_new_from_filename(path.as_ref().to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gdk_texture_new_from_resource")]
    #[doc(alias = "new_from_resource")]
    pub fn from_resource(resource_path: &str) -> Texture {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gdk_texture_new_from_resource(
                resource_path.to_glib_none().0,
            ))
        }
    }
}

unsafe impl Send for Texture {}
unsafe impl Sync for Texture {}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Texture>> Sealed for T {}
}

pub trait TextureExt: IsA<Texture> + sealed::Sealed + 'static {
    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    #[doc(alias = "gdk_texture_get_format")]
    #[doc(alias = "get_format")]
    fn format(&self) -> MemoryFormat {
        unsafe { from_glib(ffi::gdk_texture_get_format(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gdk_texture_get_height")]
    #[doc(alias = "get_height")]
    fn height(&self) -> i32 {
        unsafe { ffi::gdk_texture_get_height(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gdk_texture_get_width")]
    #[doc(alias = "get_width")]
    fn width(&self) -> i32 {
        unsafe { ffi::gdk_texture_get_width(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gdk_texture_save_to_png")]
    fn save_to_png(
        &self,
        filename: impl AsRef<std::path::Path>,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gdk_texture_save_to_png(
                    self.as_ref().to_glib_none().0,
                    filename.as_ref().to_glib_none().0
                ),
                "Failed to save the texture as png"
            )
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gdk_texture_save_to_png_bytes")]
    fn save_to_png_bytes(&self) -> glib::Bytes {
        unsafe {
            from_glib_full(ffi::gdk_texture_save_to_png_bytes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gdk_texture_save_to_tiff")]
    fn save_to_tiff(
        &self,
        filename: impl AsRef<std::path::Path>,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gdk_texture_save_to_tiff(
                    self.as_ref().to_glib_none().0,
                    filename.as_ref().to_glib_none().0
                ),
                "Failed to save the texture as tiff"
            )
        }
    }

    #[cfg(feature = "v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gdk_texture_save_to_tiff_bytes")]
    fn save_to_tiff_bytes(&self) -> glib::Bytes {
        unsafe {
            from_glib_full(ffi::gdk_texture_save_to_tiff_bytes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl<O: IsA<Texture>> TextureExt for O {}

impl fmt::Display for Texture {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Texture")
    }
}
