/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 2
#define YYMINOR 0
#define YYPATCH 20220114

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#undef YYBTYACC
#define YYBTYACC 0
#define YYDEBUGSTR YYPREFIX "debug"
#define YYPREFIX "yy"

#define YYPURE 0

#line 2 "mon_parse.y"
/* -*- C -*-
 *
 * mon_parse.y - Parser for the VICE built-in monitor.
 *
 * Written by
 *  Daniel Sladic <sladic@eecg.toronto.edu>
 *  Andreas Boose <viceteam@t-online.de>
 *  Thomas Giesel <skoe@directbox.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#ifdef __GNUC__
#undef alloca
#define        alloca(n)       __builtin_alloca (n)
#else /* not __GNUC__ */
#ifdef HAVE_ALLOCA_H
#include <alloca.h>
#else  /* Not HAVE_ALLOCA_H  */
extern char *alloca();
#endif /* HAVE_ALLOCA_H.  */
#endif /* __GNUC__ */

#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "asm.h"
#include "console.h"
#include "drive.h"
#include "interrupt.h"
#include "lib.h"
#include "machine.h"
#include "mon_breakpoint.h"
#include "mon_command.h"
#include "mon_disassemble.h"
#include "mon_drive.h"
#include "mon_file.h"
#include "mon_memmap.h"
#include "mon_memory.h"
#include "mon_register.h"
#include "mon_util.h"
#include "montypes.h"
#include "tapeport.h"
#include "resources.h"
#include "types.h"
#include "uimon.h"
#include "vsync.h"

#define join_ints(x,y) (LO16_TO_HI16(x)|y)
#define separate_int1(x) (HI16_TO_LO16(x))
#define separate_int2(x) (LO16(x))

static int yyerror(char *s);
static int temp;
static int resolve_datatype(unsigned guess_type, const char *num);
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num);

/* Defined in the lexer */
extern int new_cmd, opt_asm;
extern void free_buffer(void);
extern void make_buffer(char *str);
extern int yylex(void);
extern int cur_len, last_len;

#define ERR_ILLEGAL_INPUT 1     /* Generic error as returned by yacc.  */
#define ERR_RANGE_BAD_START 2
#define ERR_RANGE_BAD_END 3
#define ERR_BAD_CMD 4
#define ERR_EXPECT_CHECKNUM 5
#define ERR_EXPECT_END_CMD 6
#define ERR_MISSING_CLOSE_PAREN 7
#define ERR_INCOMPLETE_COND_OP 8
#define ERR_EXPECT_FILENAME 9
#define ERR_ADDR_TOO_BIG 10
#define ERR_IMM_TOO_BIG 11
#define ERR_EXPECT_STRING 12
#define ERR_UNDEFINED_LABEL 13
#define ERR_EXPECT_DEVICE_NUM 14
#define ERR_EXPECT_ADDRESS 15
#define ERR_INVALID_REGISTER 16

#define BAD_ADDR (new_addr(e_invalid_space, 0))
#define CHECK_ADDR(x) ((x) == addr_mask(x))

#define YYDEBUG 1

#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#line 113 "mon_parse.y"
typedef union YYSTYPE {
    MON_ADDR a;
    MON_ADDR range[2];
    int i;
    REG_ID reg;
    CONDITIONAL cond_op;
    cond_node_t *cond_node;
    RADIXTYPE rt;
    ACTION action;
    char *str;
    asm_mode_addr_info_t mode;
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
#line 154 "mon_parse.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

#if !(defined(yylex) || defined(YYSTATE))
int YYLEX_DECL();
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define H_NUMBER 257
#define D_NUMBER 258
#define O_NUMBER 259
#define B_NUMBER 260
#define CONVERT_OP 261
#define B_DATA 262
#define H_RANGE_GUESS 263
#define D_NUMBER_GUESS 264
#define O_NUMBER_GUESS 265
#define B_NUMBER_GUESS 266
#define BAD_CMD 267
#define MEM_OP 268
#define IF 269
#define MEM_COMP 270
#define MEM_DISK8 271
#define MEM_DISK9 272
#define MEM_DISK10 273
#define MEM_DISK11 274
#define EQUALS 275
#define TRAIL 276
#define CMD_SEP 277
#define LABEL_ASGN_COMMENT 278
#define CMD_LOG 279
#define CMD_LOGNAME 280
#define CMD_SIDEFX 281
#define CMD_DUMMY 282
#define CMD_RETURN 283
#define CMD_BLOCK_READ 284
#define CMD_BLOCK_WRITE 285
#define CMD_UP 286
#define CMD_DOWN 287
#define CMD_LOAD 288
#define CMD_SAVE 289
#define CMD_VERIFY 290
#define CMD_BVERIFY 291
#define CMD_IGNORE 292
#define CMD_HUNT 293
#define CMD_FILL 294
#define CMD_MOVE 295
#define CMD_GOTO 296
#define CMD_REGISTERS 297
#define CMD_READSPACE 298
#define CMD_WRITESPACE 299
#define CMD_RADIX 300
#define CMD_MEM_DISPLAY 301
#define CMD_BREAK 302
#define CMD_TRACE 303
#define CMD_IO 304
#define CMD_BRMON 305
#define CMD_COMPARE 306
#define CMD_DUMP 307
#define CMD_UNDUMP 308
#define CMD_EXIT 309
#define CMD_DELETE 310
#define CMD_CONDITION 311
#define CMD_COMMAND 312
#define CMD_ASSEMBLE 313
#define CMD_DISASSEMBLE 314
#define CMD_NEXT 315
#define CMD_STEP 316
#define CMD_PRINT 317
#define CMD_DEVICE 318
#define CMD_HELP 319
#define CMD_WATCH 320
#define CMD_DISK 321
#define CMD_QUIT 322
#define CMD_CHDIR 323
#define CMD_BANK 324
#define CMD_LOAD_LABELS 325
#define CMD_SAVE_LABELS 326
#define CMD_ADD_LABEL 327
#define CMD_DEL_LABEL 328
#define CMD_SHOW_LABELS 329
#define CMD_CLEAR_LABELS 330
#define CMD_RECORD 331
#define CMD_MON_STOP 332
#define CMD_PLAYBACK 333
#define CMD_CHAR_DISPLAY 334
#define CMD_SPRITE_DISPLAY 335
#define CMD_TEXT_DISPLAY 336
#define CMD_SCREENCODE_DISPLAY 337
#define CMD_ENTER_DATA 338
#define CMD_ENTER_BIN_DATA 339
#define CMD_KEYBUF 340
#define CMD_BLOAD 341
#define CMD_BSAVE 342
#define CMD_SCREEN 343
#define CMD_UNTIL 344
#define CMD_CPU 345
#define CMD_YYDEBUG 346
#define CMD_BACKTRACE 347
#define CMD_SCREENSHOT 348
#define CMD_PWD 349
#define CMD_DIR 350
#define CMD_MKDIR 351
#define CMD_RMDIR 352
#define CMD_RESOURCE_GET 353
#define CMD_RESOURCE_SET 354
#define CMD_LOAD_RESOURCES 355
#define CMD_SAVE_RESOURCES 356
#define CMD_ATTACH 357
#define CMD_DETACH 358
#define CMD_MON_RESET 359
#define CMD_TAPECTRL 360
#define CMD_CARTFREEZE 361
#define CMD_UPDB 362
#define CMD_JPDB 363
#define CMD_CPUHISTORY 364
#define CMD_MEMMAPZAP 365
#define CMD_MEMMAPSHOW 366
#define CMD_MEMMAPSAVE 367
#define CMD_COMMENT 368
#define CMD_LIST 369
#define CMD_STOPWATCH 370
#define RESET 371
#define CMD_EXPORT 372
#define CMD_AUTOSTART 373
#define CMD_AUTOLOAD 374
#define CMD_MAINCPU_TRACE 375
#define CMD_WARP 376
#define CMD_LABEL_ASGN 377
#define L_PAREN 378
#define R_PAREN 379
#define ARG_IMMEDIATE 380
#define REG_A 381
#define REG_X 382
#define REG_Y 383
#define COMMA 384
#define INST_SEP 385
#define L_BRACKET 386
#define R_BRACKET 387
#define LESS_THAN 388
#define REG_U 389
#define REG_S 390
#define REG_PC 391
#define REG_PCR 392
#define REG_B 393
#define REG_C 394
#define REG_D 395
#define REG_E 396
#define REG_H 397
#define REG_L 398
#define REG_AF 399
#define REG_BC 400
#define REG_DE 401
#define REG_HL 402
#define REG_IX 403
#define REG_IY 404
#define REG_SP 405
#define REG_IXH 406
#define REG_IXL 407
#define REG_IYH 408
#define REG_IYL 409
#define PLUS 410
#define MINUS 411
#define STRING 412
#define FILENAME 413
#define R_O_L 414
#define R_O_L_Q 415
#define OPCODE 416
#define LABEL 417
#define BANKNAME 418
#define CPUTYPE 419
#define MON_REGISTER 420
#define COND_OP 421
#define RADIX_TYPE 422
#define INPUT_SPEC 423
#define CMD_CHECKPT_ON 424
#define CMD_CHECKPT_OFF 425
#define TOGGLE 426
#define MASK 427
#define YYERRCODE 256
typedef int YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    0,   33,   33,   35,   35,   35,   34,   34,
   34,   34,   34,   34,   34,   34,   34,   34,   34,   34,
   34,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   49,
   49,   49,   37,   37,   37,   37,   37,   37,   37,   37,
   37,   37,   37,   37,   37,   52,   39,   39,   39,   39,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
   40,   40,   40,   40,   40,   40,   40,   40,   41,   41,
   41,   41,   41,   41,   41,   41,   41,   41,   41,   42,
   42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
   42,   42,   42,   42,   43,   43,   43,   43,   43,   43,
   43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
   43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
   43,   44,   44,   44,   44,   44,   44,   44,   44,   44,
   44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
   44,   44,   45,   45,   45,   46,   46,   47,   22,   23,
   23,   24,   27,   27,   12,   12,   17,   17,   18,   18,
   21,   21,   50,   50,   53,   16,   16,    2,    2,    1,
    1,    1,    4,    4,    3,    3,    3,   48,   48,   13,
   13,   13,   13,   13,   14,   15,    9,    9,    9,    9,
    9,    9,    9,    5,    5,    6,    6,    6,    6,    6,
    7,    7,    7,   25,   25,   26,   26,   28,   28,   29,
   29,   29,   19,   19,   10,   10,   10,   10,   11,   11,
   11,    8,    8,    8,    8,    8,   54,   54,   54,   20,
   51,   51,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   30,   30,   30,   30,   30,   30,
   30,   30,   30,   30,   31,   31,   31,   31,   32,
};
static const YYINT yylen[] = {                            2,
    1,    2,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    3,    3,    5,    3,    2,    2,    3,    2,
    3,    2,    4,    6,    8,   10,   12,    4,    6,    8,
   10,   12,   14,    2,    3,    3,    2,    4,    2,    4,
    2,    4,    2,    4,    2,    3,    2,    3,    1,    2,
    3,    3,    5,    3,    5,    3,    5,    3,    5,    3,
    2,    3,    2,    4,    5,    0,    5,    3,    3,    2,
    5,    5,    5,    5,    5,    3,    2,    3,    2,    3,
    2,    3,    2,    3,    2,    2,    2,    4,    5,    5,
    5,    2,    3,    2,    5,    2,    5,    2,    3,    2,
    3,    2,    3,    5,    3,    2,    5,    5,    4,    3,
    2,    3,    2,    3,    2,    3,    3,    2,    2,    3,
    2,    2,    2,    3,    3,    3,    2,    3,    3,    3,
    3,    2,    3,    2,    3,    3,    3,    5,    3,    4,
    3,    3,    2,    4,    4,    2,    3,    4,    3,    3,
    2,    5,    5,    4,    5,    3,    4,    5,    4,    5,
    5,    4,    5,    5,    2,    3,    4,    3,    3,    5,
    3,    5,    3,    2,    3,    4,    2,    2,    1,    1,
    0,    1,    1,    1,    1,    1,    2,    1,    1,    0,
    1,    2,    3,    1,    3,    1,    1,    1,    1,    3,
    1,    3,    2,    0,    1,    3,    1,    1,    0,    1,
    1,    1,    1,    1,    1,    1,    3,    3,    3,    3,
    3,    3,    1,    2,    0,    3,    3,    3,    3,    1,
    1,    1,    4,    3,    1,    1,    1,    2,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    3,    3,    2,    2,
    1,    1,    2,    1,    3,    3,    3,    3,    3,    5,
    7,    5,    3,    3,    3,    3,    3,    3,    5,    5,
    5,    5,    0,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    3,    3,    4,    3,    4,    2,    3,    3,
    3,    3,    5,    5,    6,    5,    6,    4,    5,    5,
    5,    5,    3,    5,    1,    1,    1,    1,    1,
};
static const YYINT yydefred[] = {                         0,
    0,   21,    3,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    4,    9,   10,   11,   12,   13,
   14,   15,   16,   17,   18,   19,   20,   59,  262,  264,
  265,  263,  260,  261,  259,  220,  221,  222,  223,  224,
  201,    0,  253,    0,  266,    0,  233,  254,    8,    7,
    6,    0,  125,  194,  193,    0,    0,  121,    0,  123,
   44,    0,    0,  218,   51,    0,   53,    0,    0,    0,
    0,    0,  207,  255,  257,  258,  256,  206,    0,  211,
  217,    0,    0,  226,    0,  215,  225,    0,    0,    0,
    0,   27,    0,    0,   60,    0,  204,    0,  128,    0,
  208,    0,    0,   87,  198,    0,    0,  102,    0,  108,
    0,   28,    0,    0,    0,  133,    0,    0,  116,    0,
    0,    0,    0,   80,   49,    0,   47,    0,    0,    0,
  129,  189,    0,  137,    0,  106,    0,  132,  192,    0,
    0,    0,   22,    0,    0,    0,    0,    0,    0,    0,
    0,   71,    0,   73,    0,  184,    0,    0,   89,    0,
   91,    0,   93,    0,   95,    0,  187,    0,    0,    0,
    0,   55,    0,  104,    0,   30,  188,  142,    0,  144,
  190,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  153,    0,    0,  156,    0,    0,   32,    0,   96,   97,
    0,    0,    0,    0,  195,    0,  175,    0,  161,  131,
    0,    0,    0,    0,   57,    0,    0,    0,    0,    0,
    0,    0,    0,  296,    0,  298,  299,  302,  305,  306,
  307,  308,  309,  310,  311,  300,  303,  301,  304,    0,
  270,    0,  110,    0,  112,    2,    5,    0,    0,    0,
    0,    0,  139,  202,  124,  126,  120,  122,    0,    0,
    0,    0,  196,    0,    0,    0,    0,    0,  113,    0,
    0,    0,    0,    0,    0,   26,    0,   61,    0,    0,
   62,  127,    0,   86,  197,    0,    0,   29,    0,   45,
   46,  115,    0,    0,    0,   78,    0,   79,    0,    0,
  136,  130,  138,    0,  135,  140,   24,   23,    0,    0,
   64,    0,   66,    0,   68,    0,   70,   72,  183,  185,
   88,   90,   92,   94,  247,  246,    0,  245,  141,    0,
    0,   56,  103,   31,  147,    0,  143,  145,  146,  149,
    0,  151,  152,    0,  178,    0,    0,  157,    0,    0,
    0,    0,    0,  159,  176,  160,  179,    0,  181,    0,
  134,   58,    0,    0,    0,    0,    0,    0,    0,    0,
  273,    0,  335,  336,  339,  338,    0,    0,  337,    0,
    0,    0,    0,    0,  312,    0,    0,    0,  109,  111,
  232,  231,    0,    0,  229,  230,    0,    0,    0,   52,
   54,    0,  167,    0,    0,  172,    0,    0,  252,  251,
  250,    0,  249,  210,  212,  216,    0,    0,  205,  203,
    0,    0,    0,    0,    0,    0,    0,    0,  240,  242,
  241,  119,    0,    0,    0,    0,   50,   48,    0,    0,
    0,    0,    0,    0,  186,    0,  164,    0,  169,    0,
    0,  150,  177,  154,  155,  158,   38,    0,   33,    0,
    0,   98,    0,    0,    0,    0,   74,  283,  284,  285,
  286,  287,  288,    0,    0,  320,    0,  316,    0,    0,
    0,    0,    0,    0,    0,    0,  319,  321,  275,  276,
  277,  322,  278,  313,  173,  213,  174,  162,  165,  170,
  171,  114,  248,   84,   83,   81,   85,    0,  101,  107,
   82,    0,    0,    0,  117,  118,    0,   77,    0,  105,
   25,   63,   65,   67,   69,  244,  163,  168,  148,    0,
    0,   99,  100,  180,  182,   75,    0,    0,    0,  317,
  315,    0,    0,    0,  328,    0,    0,    0,    0,    0,
    0,  239,  238,    0,  237,  236,  268,  267,   39,    0,
   34,    0,  289,  282,  290,  291,  292,  280,    0,  330,
    0,  326,  324,    0,  329,  331,  332,  323,  334,  243,
    0,    0,    0,  327,  325,   40,    0,   35,    0,  281,
    0,    0,   41,    0,   36,    0,    0,    0,   42,    0,
   37,    0,   43,
};
#if defined(YYDESTRUCT_CALL) || defined(YYSTYPE_TOSTRING)
static const YYINT yystos[] = {                           0,
  261,  267,  276,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  300,  301,  302,  303,  304,  306,  307,  308,
  309,  310,  311,  312,  313,  314,  315,  316,  317,  318,
  319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,  336,  337,  338,
  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  372,  373,  374,  375,  376,  377,  416,  424,
  425,  429,  449,  462,  463,  465,  466,  467,  468,  469,
  470,  471,  472,  473,  474,  475,  476,  478,  257,  258,
  259,  260,  264,  265,  266,  270,  271,  272,  273,  274,
  420,   40,  437,  438,  440,  442,  448,  450,  256,  276,
  277,  426,  464,  256,  413,  456,  426,  464,  426,  464,
  464,  438,  438,  384,  464,  477,  464,  477,  456,  456,
  456,  456,  256,  258,  264,  265,  266,  439,  445,  263,
  417,  430,  432,  437,  442,  443,  444,  430,  430,  432,
  442,  464,  442,  450,  464,  479,  482,  422,  464,  422,
  430,  431,  432,  464,  268,  446,  447,  464,  447,  464,
  432,  464,  430,  456,  456,  464,  256,  445,  464,  445,
  445,  432,  431,  464,  464,  477,  464,  477,  438,  442,
  464,  414,  451,  464,  447,  464,  451,  464,  415,  453,
  418,  442,  464,  442,  456,  442,  456,  432,  417,  442,
  442,  464,  442,  464,  456,  464,  456,  431,  464,  431,
  464,  431,  464,  431,  464,  432,  464,  451,  456,  456,
  432,  464,  431,  464,  419,  464,  464,  464,  456,  464,
  414,  452,  453,  453,  412,  412,  456,  456,  456,  438,
  464,  477,  477,  464,  437,  437,  464,  477,  464,  464,
  477,  456,  452,  256,  439,  441,  464,  371,  464,  464,
  456,  456,  426,  426,  464,  275,  378,  380,  381,  384,
  386,  388,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  437,
  459,  445,  464,  445,  464,  276,  463,  438,   43,   45,
   42,   47,  464,  420,  464,  464,  464,  464,  438,  438,
  438,  438,  256,  441,  256,  441,  441,  441,  464,  477,
  477,  477,  477,  477,  477,  464,  477,  464,  275,  384,
  464,  464,  477,  464,  268,  431,  431,  464,  477,  464,
  464,  464,  269,  256,  477,  464,  481,  464,  438,  438,
  464,  464,  464,  431,  464,  464,  464,  464,  477,  477,
  464,  477,  464,  477,  464,  477,  464,  464,  464,  464,
  464,  464,  464,  464,  412,  437,  454,  455,  464,  441,
  441,  464,  464,  464,  464,  477,  464,  464,  464,  464,
  412,  464,  464,  438,  464,  438,  438,  464,  437,  439,
  442,  438,  477,  464,  464,  464,  464,  477,  464,  477,
  464,  464,  432,  400,  401,  402,  403,  404,  405,  437,
  437,  384,  382,  383,  389,  390,  411,  460,  461,  381,
  384,  393,  395,  437,  437,  384,  384,  384,  464,  464,
  256,   41,  438,  438,  438,  438,  433,  477,  432,  464,
  464,  433,  256,  430,  433,  256,  432,  438,  412,  427,
  437,  457,  458,  432,  263,  443,  454,  432,  437,  482,
  431,  269,  434,  434,  432,  378,   64,  435,  436,  437,
  450,  464,  412,  449,  480,  483,  464,  464,  434,  418,
  456,  456,  417,  417,  464,  477,  256,  432,  256,  430,
  438,  464,  464,  464,  464,  464,  464,  477,  464,  477,
  431,  464,  438,  437,  437,  278,  464,  379,  379,  379,
  379,  379,  379,  379,  384,  460,  411,  460,  410,  384,
  411,  460,  384,  384,  384,  387,  460,  460,  382,  383,
  390,  391,  437,  461,  464,  432,  464,  464,  464,  464,
  464,  464,  458,  464,  464,  464,  464,  435,  464,  464,
  464,  435,  418,  421,  464,  464,  385,  464,  385,  464,
  464,  464,  464,  464,  464,  455,  464,  464,  464,  442,
  442,  464,  464,  464,  464,  464,  384,  382,  390,  460,
  410,  460,  411,  460,  387,  410,  460,  460,  391,  460,
  384,  256,  379,   58,  256,  435,  449,  449,  464,  477,
  464,  477,  381,  383,  402,  403,  404,  379,  379,  387,
  460,  387,  387,  410,  387,  387,  387,  387,  383,  432,
  442,  442,  384,  387,  387,  464,  477,  464,  477,  383,
  442,  442,  464,  477,  464,  477,  442,  442,  464,  477,
  464,  442,  464,
};
#endif /* YYDESTRUCT_CALL || YYSTYPE_TOSTRING */
static const YYINT yydgoto[] = {                        102,
  191,  192,  193,  487,  513,  518,  519,  174,  134,  295,
  135,  296,  136,  176,  177,  169,  196,  197,  137,  103,
  138,  223,  272,  230,  417,  418,  146,  502,  503,  331,
  468,  469,  104,  105,  143,  106,  107,  108,  109,  110,
  111,  112,  113,  114,  115,  116,  117,  488,  118,  186,
  525,  387,  187,  526,
};
static const YYINT yysindex[] = {                      1389,
  116,    0,    0, -253, -242, -234, -188,  218,  116,  116,
  129,  129, -242, -242, -242, -242,  -46, 1762, 1762, 1762,
 1387,   83, -164,  814,  376,  376, 1387, 1762, -242, -242,
  218,  561,  -46,  -46, 1842, 1511,  129,  129,  116,  859,
 -126,  376, -367,  218, -376,  167,   35,   35, 1842,   12,
  859,  859, -242,  218, -242, 1511, 1511, 1511, 1511, 1842,
  218, -367, -242, -242, 1387, 1511,  -72,  218,  218, -242,
  218, -331, -376, -376, -312, -310, -242, -242, -242,  116,
  129, -258,  218, 1898, 1898,  129,  218,  129, -242, -331,
  912, -101,  218, -242, -242, -277, -166, -117, 1886,  561,
  561,    0,  -97, 1536,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  116,    0,   75,    0, -235,    0,    0,    0,    0,
    0,  218,    0,    0,    0,  218,  218,    0,  218,    0,
    0, 1111, 1111,    0,    0,  116,    0,  116,  154,  616,
  154,  154,    0,    0,    0,    0,    0,    0,  129,    0,
    0, -258, -258,    0, -258,    0,    0, -258, -258,  218,
 -258,    0,  -86,  -88,    0,  277,    0,  218,    0, -258,
    0,  218, -258,    0,    0,  -79, 1762,    0, 1762,    0,
  218,    0, -258,  218,  218,    0,    0,  218,    0,  -76,
 -227,  218,  218,    0,    0,  116,    0,  116,   75,  218,
    0,    0,  218,    0, 1762,    0,  218,    0,    0,  218,
  218,  129,    0, -258,  218, -258,  218, -258,  218, -258,
  218,    0,  218,    0,  218,    0,  218,  218,    0,  218,
    0,  218,    0,  218,    0,  371,    0,  218,  154,  154,
  218,    0,  218,    0,  218,    0,    0,    0,  129,    0,
    0,  218,  218,  218,  218, -216,  218,  218,  116,   75,
    0,  116,  116,    0,  218, 1898,    0,  948,    0,    0,
  116, -258,  218,    0,    0,  218,    0,  218,    0,    0,
  129,  129,  218,  218,    0, 1842,  738, 1898, -187,  515,
 1142, 1898, -184,    0, -183,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -181,
    0,  218,    0,  218,    0,    0,    0,   56,  116,  116,
  116,  116,    0,    0,    0,    0,    0,    0,  -34,  495,
   75,   75,    0, -258,    0, 1681, -258, 1725,    0,  116,
  -98, 1842,  933,  371, 1842,    0, 1898,    0, 1898, -139,
    0,    0, 1762,    0,    0,  -54,  -54,    0, 1842,    0,
    0,    0,  467,  218, -196,    0, -193,    0,   75,   75,
    0,    0,    0,  -54,    0,    0,    0,    0, -182, -242,
    0, -242,    0, -177,    0, -174,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  129,    0,    0, 1744,
 1706,    0,    0,    0,    0,  116,    0,    0,    0,    0,
  218,    0,    0,   75,    0,   75,   75,    0,  218,  129,
  129,  847,  116,    0,    0,    0,    0, 1898,    0, 1898,
    0,    0,  193, -125, -123, -118, -115, -114, -104, -306,
    0, -274,    0,    0,    0,    0,  566, -157,    0, -122,
  577, -108, -107, -245,    0, -274, -274, 1916,    0,    0,
    0,    0,  180,  180,    0,    0,  218, 1842,  218,    0,
    0,  218,    0,  218,  218,    0,  218,   75,    0,    0,
    0, -112,    0,    0,    0,    0,  129,  218,    0,    0,
  218,  467,  218,  218,  218,  467, -140, -249,    0,    0,
    0,    0,  218, -105,  218,  -96,    0,    0,  218,  218,
  218,  218,  218,  218,    0,  371,    0,  218,    0,  218,
   75,    0,    0,    0,    0,    0,    0,  735,    0,  735,
  218,    0,   75,  218,  218,  218,    0,    0,    0,    0,
    0,    0,    0,  -85, -261,    0, -274,    0,  -87, -274,
  670, -346, -274, -274,  458,  -71,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  -99,    0,    0,
    0, -252,  266,  605,    0,    0, -193,    0, -193,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  129,
  129,    0,    0,    0,    0,    0, -153,  -52,  -49,    0,
    0,  -47, -274,  -43,    0, -343,  -38,  -26,  -25,  -22,
  -50,    0,    0, 1842,    0,    0,    0,    0,    0,  735,
    0,  735,    0,    0,    0,    0,    0,    0,  -18,    0,
  -20,    0,    0,  -15,    0,    0,    0,    0,    0,    0,
  129,  129,  -48,    0,    0,    0,  735,    0,  735,    0,
  129,  129,    0,  735,    0,  735,  129,  218,    0,  735,
    0,  218,    0,
};
static const YYINT yyrindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  143,  143,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1780, 1780,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  143,  143,    0,    0,
    0, 1780,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  304,    0,    0,    0,    0,    0,    0,    0,    0,
  143,  143,    0,    0,    0, 1528,    0,  143,    0,  304,
    0,    0,    0,    0,    0,    0,    0,    0,  -68,    0,
    0,    0,    0,  338,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  143,    0,
    0,  361, 1860,    0, 1131,    0,    0,  680, 1860,    0,
 1926,    0,    0,    0,    0,    0,    0,    0,    0, 1798,
    0,    0,  436,    0,    0, 1820,    0,    0,    0,    0,
    0,    0, 1860,    0,    0,    0, 1137,    0,    0,    0,
  -33,  -24,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -27,    0, -219,    0, -219,    0,  -21,    0,  -21,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  143,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  143,    0, 1263,    0,    0,    0,    0,    0,    0,
 1926, 1926,    0,    0,    0,    0,    0,    0,   60,    0,
    0,    0,   65,    0,  121,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  221,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1659,    0,
    0,    0,    0, 1659,  986,    0, 1659,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  391,  391,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  391,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  680,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  772,
  772,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  300,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  764,  791,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  680,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  407,    0,  442,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  366,    0,    0,    0,    0,  378,    0,
    0,    0,    0,    0,    0,  401,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  480,    0,    0,
    0,    0,    0,    0,    0,    0,  414,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  772,
  772,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  772,  772,    0,    0,    0,    0,    0,    0,    0,    0,
  772,  772,    0,    0,    0,    0,  772,    0,    0,    0,
    0,    0,    0,
};
#if YYBTYACC
static const YYINT yycindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,
};
#endif
static const YYINT yygindex[] = {                         0,
   38,   48,  283, -176, -298, -393,    0,  650,  640,   37,
    0,  555,  551, -291,    0,  710,    0,    7,    0, -375,
  -12,   31,  279,   51,   29, -141,  765,    0, -103,    0,
   -9,  -74,    0,  318,   -6,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  282,    0,    0,
    0,    0,   54,    0,
};
#define YYTABLESIZE 2307
static const YYINT yytable[] = {                        148,
  150,  151,  139,  642,  155,  157,  139,  341,  339,  184,
  340,  524,  342,  144,  182,  185,  189,  194,  198,  200,
  202,  139,  140,  141,  206,  209,  140,  141,  384,  214,
  215,  217,  199,  221,  224,  226,  219,  228,  229,  233,
  635,  140,  141,  663,  242,  244,  222,  246,  225,  249,
  251,  253,  255,  168,  257,  172,  178,  179,  262,  264,
  266,  267,  268,  636,  270,  203,  664,  139,  168,  168,
  168,  506,  564,  227,  281,  506,  284,  565,  514,  287,
  289,  290,  271,  213,  297,  299,  300,  140,  141,  139,
  305,  139,  258,  333,  335,  529,  482,  341,  339,  275,
  340,  276,  342,  248,  250,  252,  254,  463,  464,  140,
  141,  140,  141,  263,  465,  466,  341,  339,  598,  340,
  628,  342,  602,  273,  274,  154,  643,  343,  629,  139,
  126,  127,  128,  129,  130,  345,  168,  168,  575,  346,
  347,  576,  348,  139,  119,  120,  121,  122,  303,  140,
  141,  123,  124,  125,  139,  132,  154,  306,  119,  120,
  121,  122,  359,  140,  141,  123,  124,  125,  604,  139,
  145,  604,  142,  366,  140,  141,  368,  492,  336,  371,
  495,  372,  219,  139,  344,  374,  369,  293,  375,  140,
  141,  147,  383,  219,  378,  431,  462,  380,  381,  476,
  477,  382,  478,  140,  141,  386,  388,  293,  293,  163,
  646,  164,  391,  392,  512,  523,  393,  165,  166,  167,
  395,  341,   99,  396,  397,  398,  342,  653,  401,  654,
  403,  647,  405,  648,  407,  530,  408,  149,  409,  533,
  410,  411,  534,  412,  376,  413,  377,  414,  655,  656,
  657,  419,  569,  558,  422,  559,  423,  188,  424,  304,
  560,  570,  425,  561,  562,  427,  428,  429,  430,  298,
  432,  433,  394,  435,  563,  573,  574,  603,  438,  607,
  131,  126,  127,  128,  129,  130,  444,  222,  609,  445,
  144,  446,  156,  158,  447,  449,  451,  452,  627,  499,
  173,  173,  173,  180,  126,  127,  128,  129,  130,  201,
  173,  481,  641,  499,  500,  294,  293,  212,  216,  218,
  295,  604,  631,  644,  440,  479,  658,  480,  500,  659,
  139,  238,  669,  344,  680,  294,  294,    1,  139,  660,
  295,  295,  256,  662,  490,  491,  265,  261,  665,  154,
  140,  141,  126,  127,  128,  129,  130,  184,  140,  141,
  666,  667,  282,  283,  668,  673,  674,  288,  293,  291,
  521,  675,  119,  120,  121,  122,  297,  522,  219,  123,
  124,  125,  527,  528,  139,  126,  127,  128,  129,  130,
  219,   76,  507,  494,  616,  219,  297,  297,  593,  219,
  219,  219,  219,  584,  140,  141,  219,  219,  219,  353,
  535,  164,  219,  219,  219,  219,  219,  165,  166,  167,
  511,  337,  139,  510,  542,    0,    0,  543,  239,  544,
  545,    0,  546,  547,  549,  552,  126,  127,  128,  129,
  130,    0,  140,  141,  294,    0,  557,  145,  139,  295,
  360,    0,  566,  361,  362,    0,  363,  568,  540,  364,
  365,  572,  367,    0,    0,    0,  577,  578,  140,  141,
  556,  373,    0,  139,  362,    0,  274,    0,    0,    0,
  585,    0,  587,    0,  379,  588,    0,  589,  590,  551,
  591,  592,  385,  140,  141,  594,  274,  274,    0,  521,
  595,  596,  131,  521,  597,  297,  599,  600,  601,    0,
    0,  605,  154,  399,    0,  400,  606,  402,  608,  404,
    0,  406,  610,  611,  612,  613,  614,  615,    0,    0,
  517,  617,  139,  618,  619,  131,  341,  339,    0,  340,
    0,  342,    0,    0,  622,    0,  623,  624,  625,  626,
  426,    0,  140,  141,    0,  318,    0,  630,    0,  191,
  632,  634,  219,  637,  638,  640,    0,    0,  175,  175,
  175,  181,  183,  443,  175,  318,  318,  181,  175,  191,
  191,    0,  448,  450,  231,  181,  175,    0,  453,    0,
  220,  521,    0,    0,    0,    0,  232,  234,  236,  181,
  240,  241,  243,    0,    0,  274,  175,  175,  175,  175,
  181,    0,    0,  649,  651,  181,  175,  219,  219,  219,
  219,  279,    0,  661,  219,  219,  219,  119,  120,  121,
  122,  139,  489,  314,  123,  124,  125,    0,  173,    0,
  497,  279,  279,  195,  504,    0,  235,  508,  152,  153,
  133,  140,  141,  314,  314,    0,  333,    0,  133,  133,
  370,  515,  271,    0,  676,  678,  235,  235,  517,  269,
    0,    0,    0,    0,  683,  685,  333,  333,  219,    0,
  689,  691,  271,  271,  318,  693,    0,    0,  133,  269,
  269,  209,  219,  219,  219,  219,    0,  272,  536,  219,
  219,  219,  538,  173,  209,  219,  219,  219,  219,  219,
    0,  209,  209,  354,  356,  357,  358,  272,  272,  280,
    0,  548,  550,  119,  120,  121,  122,    0,    0,  133,
  123,  124,  125,  285,  286,  234,  126,  127,  128,  129,
  130,  208,  210,  211,    0,    0,    0,  175,  330,  175,
  279,  119,  120,  121,  122,  234,  234,    0,  123,  124,
  125,    0,  314,    0,  126,  127,  128,  129,  130,    0,
  586,  338,  219,    0,    0,  175,    0,  159,  160,  161,
  162,  133,  415,    0,    0,  333,    0,  219,  536,    0,
    0,  349,  350,  204,  205,  351,    0,  352,  269,    0,
    0,  133,  133,  227,  227,  133,  227,  133,  227,  332,
  334,  235,  237,  420,  421,    0,  207,  245,  164,  247,
    0,    0,    0,    0,  165,  166,  167,  259,  260,    0,
  228,  228,    0,  228,  269,  228,  140,  141,  441,  463,
  464,  277,  278,  279,  516,    0,  465,  466,  639,    0,
    0,    0,  219,  292,    0,  389,  181,  390,  301,  302,
  645,  119,  120,  121,  122,  133,    0,  133,  123,  124,
  125,  355,    0,  164,  126,  127,  128,  129,  130,  165,
  166,  167,    0,    0,    0,    0,  131,    0,  341,  339,
    0,  340,    0,  342,    0,    0,  463,  464,    0,    0,
  181,  650,  652,  465,  466,  416,  175,    0,  181,    0,
    0,  171,  181,    0,    0,  181,    0,    0,  434,    0,
    0,  436,  437,  175,    0,  467,  670,    0,  133,  181,
  442,  133,  133,    0,    0,  439,  219,  219,  219,  219,
  133,    0,    0,  219,  219,  219,    0,  463,  464,    0,
    0,    0,  677,  679,  465,  466,  460,  461,  463,  464,
  474,  475,  684,  686,    0,  465,  466,    0,  690,    0,
  181,  175,    0,    0,    0,    0,  567,    0,  483,  484,
  485,  486,  516,    0,    0,  166,    0,  571,  133,  133,
  133,  133,  175,    0,  119,  120,  121,  122,    0,  498,
    0,  123,  124,  125,  126,  127,  128,  129,  130,  133,
  501,    0,    0,  416,    0,    0,    0,    0,  509,  227,
  227,  227,  227,  227,  131,    0,  227,  227,  227,  227,
    0,    0,  520,  227,  227,  227,  227,  227,  181,  227,
  227,  219,  219,  219,  219,  219,  228,  228,  228,  228,
  228,  463,  464,  228,  228,  228,  228,    0,  465,  466,
  228,  228,  228,  228,  228,  541,  228,  228,    0,  139,
  119,  120,  121,  122,    0,  133,  170,  123,  124,  125,
  633,    0,  553,  126,  127,  128,  129,  130,    0,  140,
  141,  219,  133,    0,    0,    0,    0,  554,  620,  555,
  621,    0,  139,  119,  120,  121,  122,    0,    0,  170,
  123,  124,  125,    0,  139,    0,  126,  127,  128,  129,
  130,    0,  140,  141,    0,    0,    0,  583,  126,  127,
  128,  129,  130,    0,  140,  141,    8,  454,  455,  456,
  457,  458,  459,    0,    0,    0,    0,  227,    0,    0,
  132,  501,  341,  339,    0,  340,    0,  342,    0,    0,
    0,  520,    0,    0,  531,  520,  532,  294,    0,  164,
    0,    0,    0,    0,  228,  165,  166,  167,    0,    0,
  227,    0,    0,  227,    0,  416,    0,  140,  141,  119,
  120,  121,  122,    0,  181,  505,  123,  124,  125,    0,
  671,    0,  672,    0,    0,  164,    0,  228,    0,    0,
  228,  165,  166,  167,    0,    0,    0,  126,  127,  128,
  129,  130,    0,    0,    0,    0,    0,  681,    0,  682,
  171,    0,    0,    0,  687,  190,  688,    0,    0,    0,
  692,  196,  196,  196,  196,  196,  166,    0,  196,  196,
  196,  196,  166,  520,    0,  196,  196,  196,  196,  196,
    0,    0,    8,  171,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,    0,    0,  166,  166,  166,  166,  166,
    0,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,
  166,  166,  166,  166,  166,  166,    0,  166,  166,  166,
  166,  166,  166,    0,    0,    0,    0,  119,  120,  121,
  122,    0,    0,    0,  123,  124,  125,    0,    0,    0,
  126,  127,  128,  129,  130,    0,    0,  219,  219,  219,
  219,    0,  207,  219,  219,  219,  219,    8,  119,  120,
  121,  122,  196,    8,    0,  123,  124,  125,    0,  166,
  166,    0,  207,  207,    0,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    0,    0,    8,    8,    8,    8,
    8,    0,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    0,    8,    8,
    8,    8,    8,    8,    0,    0,    0,    0,  196,    0,
    0,    0,  470,    8,    0,  471,    0,    0,    0,    8,
  131,    0,    0,    0,  472,    0,  473,    0,  196,  196,
    0,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    0,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    0,    8,    8,    8,    8,    8,    8,
    0,    0,  139,  119,  120,  121,  122,    0,    0,    1,
  123,  124,  125,    0,    0,    2,  126,  127,  128,  129,
  130,    0,  140,  141,    3,    0,    0,    4,    5,    6,
    7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
   17,   18,   19,   20,   21,   22,    8,    8,   23,   24,
   25,   26,   27,    0,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
   74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
   84,   85,   86,   87,   88,   89,   90,   91,   92,    0,
   93,   94,   95,   96,   97,   98,  139,  119,  120,  121,
  122,    0,    0,  170,  123,  124,  125,    0,    0,    0,
  126,  127,  128,  129,  130,  219,  140,  141,    0,    0,
    0,  219,  219,  219,    0,    0,    1,  219,  219,  219,
  219,  219,    2,  171,   99,    0,    0,    0,    0,    0,
    0,    0,  100,  101,    4,    5,    6,    7,    8,    9,
   10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
   20,   21,   22,    0,    0,   23,   24,   25,   26,   27,
    0,   28,   29,   30,   31,   32,   33,   34,   35,   36,
   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
   47,   48,   49,   50,   51,   52,   53,   54,   55,   56,
   57,   58,   59,   60,   61,   62,   63,   64,   65,   66,
   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
   77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
   87,   88,   89,   90,   91,   92,    0,   93,   94,   95,
   96,   97,   98,    0,  214,  219,  219,  219,  219,    0,
    0,    0,  219,  219,  219,    0,    0,  171,  219,  219,
  219,  219,  219,    0,  214,  214,  493,  119,  120,  121,
  122,    0,    0,  170,  123,  124,  125,    0,    0,    0,
  126,  127,  128,  129,  130,    0,    0,    0,    0,  100,
  101,  539,  119,  120,  121,  122,    0,    0,  170,  123,
  124,  125,    0,    0,    0,  126,  127,  128,  129,  130,
  496,  119,  120,  121,  122,    0,    0,    0,  123,  124,
  125,    0,    0,    0,  126,  127,  128,  129,  130,  537,
  119,  120,  121,  122,    0,    0,    0,  123,  124,  125,
    0,    0,    0,  126,  127,  128,  129,  130,  119,  120,
  121,  122,    0,    0,  170,  123,  124,  125,    0,    0,
    0,  126,  127,  128,  129,  130,  200,  200,  200,  200,
    0,    0,  200,  200,  200,  200,    0,    0,    0,  200,
  200,  200,  200,  200,  219,  219,  219,  219,    0,    0,
  219,  219,  219,  219,    0,    0,    0,  219,  219,  219,
  219,  219,    0,    0,    0,  219,  199,  199,  199,  199,
    0,    0,  199,  199,  199,  199,    0,    0,    0,  199,
  199,  199,  199,  199,    0,    0,    0,  171,  119,  120,
  121,  122,    0,    0,    0,  123,  124,  125,    0,    0,
    0,  126,  127,  128,  129,  130,  219,  219,  219,  219,
    0,    0,  171,  219,  219,  219,    0,    0,    0,  219,
  219,  219,  219,  219,    0,    0,    0,    0,    0,    0,
    0,  171,  119,  120,  121,  122,    0,    0,    0,  123,
  124,  125,    0,    0,  119,  120,  121,  122,    0,    0,
  171,  123,  124,  125,    0,    0,    0,    0,    0,    0,
    0,    0,  119,  120,  121,  122,    0,    0,  171,  123,
  124,  125,  219,  219,  219,  219,    0,    0,    0,  219,
  219,  219,    0,    0,    0,    0,  200,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  219,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  199,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  171,    0,
    0,    0,    0,  307,    0,  308,  309,    0,    0,  310,
    0,  311,    0,  312,    0,    0,  219,    0,  313,  314,
  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,    0,    0,  579,  580,    0,
    0,    0,    0,    0,  465,  581,  582,
};
static const YYINT yycheck[] = {                          6,
    7,    8,  256,  256,   11,   12,  256,   42,   43,   22,
   45,  387,   47,  256,   21,   22,   23,   24,   25,   26,
   27,  256,  276,  277,   31,   32,  276,  277,  256,   36,
   37,   38,   26,   40,   41,   42,  256,   44,  415,   46,
  387,  276,  277,  387,   51,   52,  414,   54,   42,   56,
   57,   58,   59,   17,   61,   18,   19,   20,   65,   66,
   67,   68,   69,  410,   71,   28,  410,  256,   32,   33,
   34,  363,  379,   43,   81,  367,   83,  384,  377,   86,
   87,   88,  414,   36,   91,   92,   93,  276,  277,  256,
   97,  256,   62,  100,  101,  394,   41,   42,   43,  412,
   45,  412,   47,   56,   57,   58,   59,  382,  383,  276,
  277,  276,  277,   66,  389,  390,   42,   43,  512,   45,
  382,   47,  516,   73,   74,  384,  379,  134,  390,  256,
  270,  271,  272,  273,  274,  142,  100,  101,  384,  146,
  147,  387,  149,  256,  257,  258,  259,  260,  426,  276,
  277,  264,  265,  266,  256,   40,  384,  275,  257,  258,
  259,  260,  169,  276,  277,  264,  265,  266,  421,  256,
  413,  421,  426,  180,  276,  277,  183,  354,  276,  186,
  357,  188,   40,  256,  420,  192,  275,  256,  268,  276,
  277,  426,  269,  413,  201,  412,  384,  204,  205,  384,
  384,  208,  384,  276,  277,  212,  213,  276,  277,  256,
  604,  258,  219,  220,  269,  412,  223,  264,  265,  266,
  227,   42,  416,  230,  231,  232,   47,  381,  235,  383,
  237,  607,  239,  609,  241,  418,  243,  426,  245,  417,
  247,  248,  417,  250,  197,  252,  199,  254,  402,  403,
  404,  258,  410,  379,  261,  379,  263,  422,  265,  426,
  379,  384,  269,  379,  379,  272,  273,  274,  275,  371,
  277,  278,  225,  280,  379,  384,  384,  418,  285,  385,
  420,  270,  271,  272,  273,  274,  293,  414,  385,  296,
  256,  298,   11,   12,  301,  302,  303,  304,  384,  412,
   18,   19,   20,   21,  270,  271,  272,  273,  274,   27,
   28,  256,  384,  412,  427,  256,  385,   35,   37,   38,
  256,  421,  410,   58,  288,  332,  379,  334,  427,  379,
  256,   49,  383,  420,  383,  276,  277,    0,  256,  387,
  276,  277,   60,  387,  351,  352,  419,   65,  387,  384,
  276,  277,  270,  271,  272,  273,  274,  370,  276,  277,
  387,  387,   81,   82,  387,  384,  387,   86,   90,   88,
  383,  387,  257,  258,  259,  260,  256,  384,  412,  264,
  265,  266,  389,  390,  256,  270,  271,  272,  273,  274,
  418,  416,  364,  356,  536,  417,  276,  277,  502,  257,
  258,  259,  260,  478,  276,  277,  264,  265,  266,  256,
  417,  258,  270,  271,  272,  273,  274,  264,  265,  266,
  373,  104,  256,  370,  431,   -1,   -1,  434,  417,  436,
  437,   -1,  439,  440,  441,  442,  270,  271,  272,  273,
  274,   -1,  276,  277,  385,   -1,  453,  413,  256,  385,
  169,   -1,  462,  172,  173,   -1,  175,  467,  421,  178,
  179,  471,  181,   -1,   -1,   -1,  476,  477,  276,  277,
  278,  190,   -1,  256,  193,   -1,  256,   -1,   -1,   -1,
  487,   -1,  489,   -1,  203,  492,   -1,  494,  495,  442,
  497,  498,  211,  276,  277,  502,  276,  277,   -1,  512,
  507,  508,  420,  516,  511,  385,  513,  514,  515,   -1,
   -1,  518,  384,  232,   -1,  234,  523,  236,  525,  238,
   -1,  240,  529,  530,  531,  532,  533,  534,   -1,   -1,
   64,  538,  256,  540,  541,  420,   42,   43,   -1,   45,
   -1,   47,   -1,   -1,  551,   -1,  553,  554,  555,  556,
  269,   -1,  276,  277,   -1,  256,   -1,  567,   -1,  256,
  570,  571,  420,  573,  574,  575,   -1,   -1,   18,   19,
   20,   21,   22,  292,   24,  276,  277,   27,   28,  276,
  277,   -1,  301,  302,  418,   35,   36,   -1,  306,   -1,
   40,  604,   -1,   -1,   -1,   -1,   46,   47,   48,   49,
   50,   51,   52,   -1,   -1,  385,   56,   57,   58,   59,
   60,   -1,   -1,  620,  621,   65,   66,  257,  258,  259,
  260,  256,   -1,  633,  264,  265,  266,  257,  258,  259,
  260,  256,  350,  256,  264,  265,  266,   -1,  356,   -1,
  358,  276,  277,  268,  362,   -1,  256,  365,    9,   10,
    1,  276,  277,  276,  277,   -1,  256,   -1,    9,   10,
  384,  379,  256,   -1,  671,  672,  276,  277,   64,  256,
   -1,   -1,   -1,   -1,  681,  682,  276,  277,   39,   -1,
  687,  688,  276,  277,  385,  692,   -1,   -1,   39,  276,
  277,  256,  257,  258,  259,  260,   -1,  256,  417,  264,
  265,  266,  420,  421,  269,  270,  271,  272,  273,  274,
   -1,  276,  277,  159,  160,  161,  162,  276,  277,   80,
   -1,  440,  441,  257,  258,  259,  260,   -1,   -1,   80,
  264,  265,  266,   84,   85,  256,  270,  271,  272,  273,
  274,   32,   33,   34,   -1,   -1,   -1,  197,   99,  199,
  385,  257,  258,  259,  260,  276,  277,   -1,  264,  265,
  266,   -1,  385,   -1,  270,  271,  272,  273,  274,   -1,
  488,  132,  412,   -1,   -1,  225,   -1,   13,   14,   15,
   16,  132,  412,   -1,   -1,  385,   -1,  427,  507,   -1,
   -1,  152,  153,   29,   30,  156,   -1,  158,  385,   -1,
   -1,  152,  153,   40,   41,  156,   43,  158,   45,  100,
  101,   47,   48,  259,  260,   -1,  256,   53,  258,   55,
   -1,   -1,   -1,   -1,  264,  265,  266,   63,   64,   -1,
   40,   41,   -1,   43,   70,   45,  276,  277,  288,  382,
  383,   77,   78,   79,  378,   -1,  389,  390,  391,   -1,
   -1,   -1,  417,   89,   -1,  216,  306,  218,   94,   95,
  256,  257,  258,  259,  260,  216,   -1,  218,  264,  265,
  266,  256,   -1,  258,  270,  271,  272,  273,  274,  264,
  265,  266,   -1,   -1,   -1,   -1,  420,   -1,   42,   43,
   -1,   45,   -1,   47,   -1,   -1,  382,  383,   -1,   -1,
  350,  620,  621,  389,  390,  256,  356,   -1,  358,   -1,
   -1,  417,  362,   -1,   -1,  365,   -1,   -1,  279,   -1,
   -1,  282,  283,  373,   -1,  411,  644,   -1,  279,  379,
  291,  282,  283,   -1,   -1,  286,  257,  258,  259,  260,
  291,   -1,   -1,  264,  265,  266,   -1,  382,  383,   -1,
   -1,   -1,  671,  672,  389,  390,  307,  308,  382,  383,
  311,  312,  681,  682,   -1,  389,  390,   -1,  687,   -1,
  420,  421,   -1,   -1,   -1,   -1,  411,   -1,  339,  340,
  341,  342,  378,   -1,   -1,    0,   -1,  411,  339,  340,
  341,  342,  442,   -1,  257,  258,  259,  260,   -1,  360,
   -1,  264,  265,  266,  270,  271,  272,  273,  274,  360,
  361,   -1,   -1,  364,   -1,   -1,   -1,   -1,  369,  256,
  257,  258,  259,  260,  420,   -1,  263,  264,  265,  266,
   -1,   -1,  383,  270,  271,  272,  273,  274,  488,  276,
  277,  270,  271,  272,  273,  274,  256,  257,  258,  259,
  260,  382,  383,  263,  264,  265,  266,   -1,  389,  390,
  270,  271,  272,  273,  274,  426,  276,  277,   -1,  256,
  257,  258,  259,  260,   -1,  426,  263,  264,  265,  266,
  411,   -1,  443,  270,  271,  272,  273,  274,   -1,  276,
  277,  412,  443,   -1,   -1,   -1,   -1,  448,  548,  450,
  550,   -1,  256,  257,  258,  259,  260,   -1,   -1,  263,
  264,  265,  266,   -1,  256,   -1,  270,  271,  272,  273,
  274,   -1,  276,  277,   -1,   -1,   -1,  478,  270,  271,
  272,  273,  274,   -1,  276,  277,    0,  400,  401,  402,
  403,  404,  405,   -1,   -1,   -1,   -1,  384,   -1,   -1,
   40,  502,   42,   43,   -1,   45,   -1,   47,   -1,   -1,
   -1,  512,   -1,   -1,  400,  516,  402,  256,   -1,  258,
   -1,   -1,   -1,   -1,  384,  264,  265,  266,   -1,   -1,
  417,   -1,   -1,  420,   -1,  536,   -1,  276,  277,  257,
  258,  259,  260,   -1,  644,  263,  264,  265,  266,   -1,
  650,   -1,  652,   -1,   -1,  258,   -1,  417,   -1,   -1,
  420,  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,
  273,  274,   -1,   -1,   -1,   -1,   -1,  677,   -1,  679,
  417,   -1,   -1,   -1,  684,  422,  686,   -1,   -1,   -1,
  690,  256,  257,  258,  259,  260,  261,   -1,  263,  264,
  265,  266,  267,  604,   -1,  270,  271,  272,  273,  274,
   -1,   -1,    0,  417,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,   -1,   -1,  300,  301,  302,  303,  304,
   -1,  306,  307,  308,  309,  310,  311,  312,  313,  314,
  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,  336,  337,  338,  339,  340,  341,  342,  343,  344,
  345,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,   -1,  372,  373,  374,
  375,  376,  377,   -1,   -1,   -1,   -1,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,   -1,   -1,  257,  258,  259,
  260,   -1,  256,  263,  264,  265,  266,  261,  257,  258,
  259,  260,  417,  267,   -1,  264,  265,  266,   -1,  424,
  425,   -1,  276,  277,   -1,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,   -1,   -1,  300,  301,  302,  303,
  304,   -1,  306,  307,  308,  309,  310,  311,  312,  313,
  314,  315,  316,  317,  318,  319,  320,  321,  322,  323,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,  336,  337,  338,  339,  340,  341,  342,  343,
  344,  345,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,   -1,  372,  373,
  374,  375,  376,  377,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  381,  261,   -1,  384,   -1,   -1,   -1,  267,
  420,   -1,   -1,   -1,  393,   -1,  395,   -1,  276,  277,
   -1,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  424,  425,  300,  301,  302,  303,  304,   -1,  306,  307,
  308,  309,  310,  311,  312,  313,  314,  315,  316,  317,
  318,  319,  320,  321,  322,  323,  324,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,  336,  337,
  338,  339,  340,  341,  342,  343,  344,  345,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
  358,  359,  360,  361,  362,  363,  364,  365,  366,  367,
  368,  369,  370,   -1,  372,  373,  374,  375,  376,  377,
   -1,   -1,  256,  257,  258,  259,  260,   -1,   -1,  261,
  264,  265,  266,   -1,   -1,  267,  270,  271,  272,  273,
  274,   -1,  276,  277,  276,   -1,   -1,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  424,  425,  300,  301,
  302,  303,  304,   -1,  306,  307,  308,  309,  310,  311,
  312,  313,  314,  315,  316,  317,  318,  319,  320,  321,
  322,  323,  324,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,  336,  337,  338,  339,  340,  341,
  342,  343,  344,  345,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,   -1,
  372,  373,  374,  375,  376,  377,  256,  257,  258,  259,
  260,   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,  258,  276,  277,   -1,   -1,
   -1,  264,  265,  266,   -1,   -1,  261,  270,  271,  272,
  273,  274,  267,  417,  416,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  424,  425,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,   -1,   -1,  300,  301,  302,  303,  304,
   -1,  306,  307,  308,  309,  310,  311,  312,  313,  314,
  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,  336,  337,  338,  339,  340,  341,  342,  343,  344,
  345,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,   -1,  372,  373,  374,
  375,  376,  377,   -1,  256,  257,  258,  259,  260,   -1,
   -1,   -1,  264,  265,  266,   -1,   -1,  417,  270,  271,
  272,  273,  274,   -1,  276,  277,  256,  257,  258,  259,
  260,   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,
  270,  271,  272,  273,  274,   -1,   -1,   -1,   -1,  424,
  425,  256,  257,  258,  259,  260,   -1,   -1,  263,  264,
  265,  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,
  256,  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,
  266,   -1,   -1,   -1,  270,  271,  272,  273,  274,  256,
  257,  258,  259,  260,   -1,   -1,   -1,  264,  265,  266,
   -1,   -1,   -1,  270,  271,  272,  273,  274,  257,  258,
  259,  260,   -1,   -1,  263,  264,  265,  266,   -1,   -1,
   -1,  270,  271,  272,  273,  274,  257,  258,  259,  260,
   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,  270,
  271,  272,  273,  274,  257,  258,  259,  260,   -1,   -1,
  263,  264,  265,  266,   -1,   -1,   -1,  270,  271,  272,
  273,  274,   -1,   -1,   -1,  417,  257,  258,  259,  260,
   -1,   -1,  263,  264,  265,  266,   -1,   -1,   -1,  270,
  271,  272,  273,  274,   -1,   -1,   -1,  417,  257,  258,
  259,  260,   -1,   -1,   -1,  264,  265,  266,   -1,   -1,
   -1,  270,  271,  272,  273,  274,  257,  258,  259,  260,
   -1,   -1,  417,  264,  265,  266,   -1,   -1,   -1,  270,
  271,  272,  273,  274,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  417,  257,  258,  259,  260,   -1,   -1,   -1,  264,
  265,  266,   -1,   -1,  257,  258,  259,  260,   -1,   -1,
  417,  264,  265,  266,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  257,  258,  259,  260,   -1,   -1,  417,  264,
  265,  266,  257,  258,  259,  260,   -1,   -1,   -1,  264,
  265,  266,   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  417,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  417,   -1,
   -1,   -1,   -1,  378,   -1,  380,  381,   -1,   -1,  384,
   -1,  386,   -1,  388,   -1,   -1,  417,   -1,  393,  394,
  395,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,   -1,   -1,  382,  383,   -1,
   -1,   -1,   -1,   -1,  389,  390,  391,
};
#if YYBTYACC
static const YYINT yyctable[] = {                        -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,
};
#endif
#define YYFINAL 102
#ifndef YYDEBUG
#define YYDEBUG 1
#endif
#define YYMAXTOKEN 427
#define YYUNDFTOKEN 484
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"$end",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,"'('","')'","'*'","'+'",0,"'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,"':'",0,0,0,0,
0,"'@'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"error",
"H_NUMBER","D_NUMBER","O_NUMBER","B_NUMBER","CONVERT_OP","B_DATA",
"H_RANGE_GUESS","D_NUMBER_GUESS","O_NUMBER_GUESS","B_NUMBER_GUESS","BAD_CMD",
"MEM_OP","IF","MEM_COMP","MEM_DISK8","MEM_DISK9","MEM_DISK10","MEM_DISK11",
"EQUALS","TRAIL","CMD_SEP","LABEL_ASGN_COMMENT","CMD_LOG","CMD_LOGNAME",
"CMD_SIDEFX","CMD_DUMMY","CMD_RETURN","CMD_BLOCK_READ","CMD_BLOCK_WRITE",
"CMD_UP","CMD_DOWN","CMD_LOAD","CMD_SAVE","CMD_VERIFY","CMD_BVERIFY",
"CMD_IGNORE","CMD_HUNT","CMD_FILL","CMD_MOVE","CMD_GOTO","CMD_REGISTERS",
"CMD_READSPACE","CMD_WRITESPACE","CMD_RADIX","CMD_MEM_DISPLAY","CMD_BREAK",
"CMD_TRACE","CMD_IO","CMD_BRMON","CMD_COMPARE","CMD_DUMP","CMD_UNDUMP",
"CMD_EXIT","CMD_DELETE","CMD_CONDITION","CMD_COMMAND","CMD_ASSEMBLE",
"CMD_DISASSEMBLE","CMD_NEXT","CMD_STEP","CMD_PRINT","CMD_DEVICE","CMD_HELP",
"CMD_WATCH","CMD_DISK","CMD_QUIT","CMD_CHDIR","CMD_BANK","CMD_LOAD_LABELS",
"CMD_SAVE_LABELS","CMD_ADD_LABEL","CMD_DEL_LABEL","CMD_SHOW_LABELS",
"CMD_CLEAR_LABELS","CMD_RECORD","CMD_MON_STOP","CMD_PLAYBACK",
"CMD_CHAR_DISPLAY","CMD_SPRITE_DISPLAY","CMD_TEXT_DISPLAY",
"CMD_SCREENCODE_DISPLAY","CMD_ENTER_DATA","CMD_ENTER_BIN_DATA","CMD_KEYBUF",
"CMD_BLOAD","CMD_BSAVE","CMD_SCREEN","CMD_UNTIL","CMD_CPU","CMD_YYDEBUG",
"CMD_BACKTRACE","CMD_SCREENSHOT","CMD_PWD","CMD_DIR","CMD_MKDIR","CMD_RMDIR",
"CMD_RESOURCE_GET","CMD_RESOURCE_SET","CMD_LOAD_RESOURCES","CMD_SAVE_RESOURCES",
"CMD_ATTACH","CMD_DETACH","CMD_MON_RESET","CMD_TAPECTRL","CMD_CARTFREEZE",
"CMD_UPDB","CMD_JPDB","CMD_CPUHISTORY","CMD_MEMMAPZAP","CMD_MEMMAPSHOW",
"CMD_MEMMAPSAVE","CMD_COMMENT","CMD_LIST","CMD_STOPWATCH","RESET","CMD_EXPORT",
"CMD_AUTOSTART","CMD_AUTOLOAD","CMD_MAINCPU_TRACE","CMD_WARP","CMD_LABEL_ASGN",
"L_PAREN","R_PAREN","ARG_IMMEDIATE","REG_A","REG_X","REG_Y","COMMA","INST_SEP",
"L_BRACKET","R_BRACKET","LESS_THAN","REG_U","REG_S","REG_PC","REG_PCR","REG_B",
"REG_C","REG_D","REG_E","REG_H","REG_L","REG_AF","REG_BC","REG_DE","REG_HL",
"REG_IX","REG_IY","REG_SP","REG_IXH","REG_IXL","REG_IYH","REG_IYL","PLUS",
"MINUS","STRING","FILENAME","R_O_L","R_O_L_Q","OPCODE","LABEL","BANKNAME",
"CPUTYPE","MON_REGISTER","COND_OP","RADIX_TYPE","INPUT_SPEC","CMD_CHECKPT_ON",
"CMD_CHECKPT_OFF","TOGGLE","MASK","$accept","top_level","address_range",
"address_opt_range","address","opt_address","opt_if_cond_expr","cond_expr",
"cond_operand","number","expression","d_number","guess_default","device_num",
"memspace","memloc","memaddr","checkpt_num","mem_op","opt_mem_op","value",
"assembly_instruction","register","rest_of_line","opt_rest_of_line",
"rest_of_line_or_quoted","data_list","data_element","filename","hunt_list",
"hunt_element","asm_operand_mode","index_reg","index_ureg","command_list",
"command","end_cmd","machine_state_rules","symbol_table_rules","memory_rules",
"asm_rules","checkpoint_rules","checkpoint_control_rules","monitor_state_rules",
"monitor_misc_rules","disk_rules","cmd_file_rules","data_entry_rules",
"monitor_debug_rules","opt_sep","register_mod","reg_list","post_assemble","$$1",
"reg_asgn","assembly_instr_list","illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : top_level",
"top_level : command_list",
"top_level : assembly_instruction TRAIL",
"top_level : TRAIL",
"command_list : command",
"command_list : command_list command",
"end_cmd : CMD_SEP",
"end_cmd : TRAIL",
"end_cmd : error",
"command : machine_state_rules",
"command : symbol_table_rules",
"command : memory_rules",
"command : asm_rules",
"command : checkpoint_rules",
"command : checkpoint_control_rules",
"command : monitor_state_rules",
"command : monitor_misc_rules",
"command : disk_rules",
"command : cmd_file_rules",
"command : data_entry_rules",
"command : monitor_debug_rules",
"command : BAD_CMD",
"machine_state_rules : CMD_BANK end_cmd",
"machine_state_rules : CMD_BANK memspace end_cmd",
"machine_state_rules : CMD_BANK BANKNAME end_cmd",
"machine_state_rules : CMD_BANK memspace opt_sep BANKNAME end_cmd",
"machine_state_rules : CMD_GOTO address end_cmd",
"machine_state_rules : CMD_GOTO end_cmd",
"machine_state_rules : CMD_IO end_cmd",
"machine_state_rules : CMD_IO address end_cmd",
"machine_state_rules : CMD_CPU end_cmd",
"machine_state_rules : CMD_CPU CPUTYPE end_cmd",
"machine_state_rules : CMD_CPUHISTORY end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_CPUHISTORY opt_sep d_number opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace opt_sep memspace end_cmd",
"machine_state_rules : CMD_RETURN end_cmd",
"machine_state_rules : CMD_DUMP filename end_cmd",
"machine_state_rules : CMD_UNDUMP filename end_cmd",
"machine_state_rules : CMD_STEP end_cmd",
"machine_state_rules : CMD_STEP opt_sep expression end_cmd",
"machine_state_rules : CMD_NEXT end_cmd",
"machine_state_rules : CMD_NEXT opt_sep expression end_cmd",
"machine_state_rules : CMD_UP end_cmd",
"machine_state_rules : CMD_UP opt_sep expression end_cmd",
"machine_state_rules : CMD_DOWN end_cmd",
"machine_state_rules : CMD_DOWN opt_sep expression end_cmd",
"machine_state_rules : CMD_SCREEN end_cmd",
"machine_state_rules : CMD_SCREEN address end_cmd",
"machine_state_rules : CMD_WARP end_cmd",
"machine_state_rules : CMD_WARP TOGGLE end_cmd",
"machine_state_rules : register_mod",
"register_mod : CMD_REGISTERS end_cmd",
"register_mod : CMD_REGISTERS memspace end_cmd",
"register_mod : CMD_REGISTERS reg_list end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_LOAD_LABELS filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS memspace opt_sep filename end_cmd",
"symbol_table_rules : CMD_SAVE_LABELS filename end_cmd",
"symbol_table_rules : CMD_ADD_LABEL address opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL LABEL end_cmd",
"symbol_table_rules : CMD_DEL_LABEL memspace opt_sep LABEL end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS memspace end_cmd",
"symbol_table_rules : CMD_SHOW_LABELS end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS memspace end_cmd",
"symbol_table_rules : CMD_CLEAR_LABELS end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address end_cmd",
"symbol_table_rules : CMD_LABEL_ASGN EQUALS address LABEL_ASGN_COMMENT end_cmd",
"$$1 :",
"asm_rules : CMD_ASSEMBLE address $$1 post_assemble end_cmd",
"asm_rules : CMD_ASSEMBLE address end_cmd",
"asm_rules : CMD_DISASSEMBLE address_opt_range end_cmd",
"asm_rules : CMD_DISASSEMBLE end_cmd",
"memory_rules : CMD_MOVE address_range opt_sep address end_cmd",
"memory_rules : CMD_COMPARE address_range opt_sep address end_cmd",
"memory_rules : CMD_FILL address_range opt_sep data_list end_cmd",
"memory_rules : CMD_HUNT address_range opt_sep hunt_list end_cmd",
"memory_rules : CMD_MEM_DISPLAY RADIX_TYPE opt_sep address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_MEM_DISPLAY end_cmd",
"memory_rules : CMD_CHAR_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_CHAR_DISPLAY end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SPRITE_DISPLAY end_cmd",
"memory_rules : CMD_TEXT_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_TEXT_DISPLAY end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY address_opt_range end_cmd",
"memory_rules : CMD_SCREENCODE_DISPLAY end_cmd",
"memory_rules : CMD_MEMMAPZAP end_cmd",
"memory_rules : CMD_MEMMAPSHOW end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression end_cmd",
"memory_rules : CMD_MEMMAPSHOW opt_sep expression address_opt_range end_cmd",
"memory_rules : CMD_MEMMAPSAVE filename opt_sep expression end_cmd",
"checkpoint_rules : CMD_BREAK opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_BREAK end_cmd",
"checkpoint_rules : CMD_UNTIL address_opt_range end_cmd",
"checkpoint_rules : CMD_UNTIL end_cmd",
"checkpoint_rules : CMD_WATCH opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_WATCH end_cmd",
"checkpoint_rules : CMD_TRACE opt_mem_op address_opt_range opt_if_cond_expr end_cmd",
"checkpoint_rules : CMD_TRACE end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_ON end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF checkpt_num end_cmd",
"checkpoint_control_rules : CMD_CHECKPT_OFF end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_IGNORE checkpt_num opt_sep expression end_cmd",
"checkpoint_control_rules : CMD_DELETE checkpt_num end_cmd",
"checkpoint_control_rules : CMD_DELETE end_cmd",
"checkpoint_control_rules : CMD_CONDITION checkpt_num IF cond_expr end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num opt_sep STRING end_cmd",
"checkpoint_control_rules : CMD_COMMAND checkpt_num error end_cmd",
"monitor_state_rules : CMD_SIDEFX TOGGLE end_cmd",
"monitor_state_rules : CMD_SIDEFX end_cmd",
"monitor_state_rules : CMD_DUMMY TOGGLE end_cmd",
"monitor_state_rules : CMD_DUMMY end_cmd",
"monitor_state_rules : CMD_LOG TOGGLE end_cmd",
"monitor_state_rules : CMD_LOG end_cmd",
"monitor_state_rules : CMD_LOGNAME filename end_cmd",
"monitor_state_rules : CMD_RADIX RADIX_TYPE end_cmd",
"monitor_state_rules : CMD_RADIX end_cmd",
"monitor_state_rules : CMD_DEVICE end_cmd",
"monitor_state_rules : CMD_DEVICE memspace end_cmd",
"monitor_state_rules : CMD_EXPORT end_cmd",
"monitor_state_rules : CMD_QUIT end_cmd",
"monitor_state_rules : CMD_EXIT end_cmd",
"monitor_state_rules : CMD_MAINCPU_TRACE TOGGLE end_cmd",
"monitor_misc_rules : CMD_DISK rest_of_line end_cmd",
"monitor_misc_rules : CMD_PRINT expression end_cmd",
"monitor_misc_rules : CMD_HELP end_cmd",
"monitor_misc_rules : CMD_HELP rest_of_line end_cmd",
"monitor_misc_rules : CONVERT_OP expression end_cmd",
"monitor_misc_rules : CMD_CHDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_KEYBUF rest_of_line end_cmd",
"monitor_misc_rules : CMD_BACKTRACE end_cmd",
"monitor_misc_rules : CMD_DIR opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_PWD end_cmd",
"monitor_misc_rules : CMD_MKDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_RMDIR rest_of_line_or_quoted end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename end_cmd",
"monitor_misc_rules : CMD_SCREENSHOT filename opt_sep expression end_cmd",
"monitor_misc_rules : CMD_RESOURCE_GET STRING end_cmd",
"monitor_misc_rules : CMD_RESOURCE_SET STRING STRING end_cmd",
"monitor_misc_rules : CMD_LOAD_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_SAVE_RESOURCES filename end_cmd",
"monitor_misc_rules : CMD_MON_RESET end_cmd",
"monitor_misc_rules : CMD_MON_RESET opt_sep expression end_cmd",
"monitor_misc_rules : CMD_TAPECTRL opt_sep expression end_cmd",
"monitor_misc_rules : CMD_CARTFREEZE end_cmd",
"monitor_misc_rules : CMD_UPDB number end_cmd",
"monitor_misc_rules : CMD_JPDB number number end_cmd",
"monitor_misc_rules : CMD_COMMENT opt_rest_of_line end_cmd",
"monitor_misc_rules : CMD_STOPWATCH RESET end_cmd",
"monitor_misc_rules : CMD_STOPWATCH end_cmd",
"disk_rules : CMD_LOAD filename device_num opt_address end_cmd",
"disk_rules : CMD_BLOAD filename device_num address end_cmd",
"disk_rules : CMD_BLOAD filename device_num error",
"disk_rules : CMD_SAVE filename device_num address_range end_cmd",
"disk_rules : CMD_SAVE filename error",
"disk_rules : CMD_SAVE filename device_num error",
"disk_rules : CMD_BSAVE filename device_num address_range end_cmd",
"disk_rules : CMD_BSAVE filename device_num error",
"disk_rules : CMD_VERIFY filename device_num opt_address end_cmd",
"disk_rules : CMD_BVERIFY filename device_num address end_cmd",
"disk_rules : CMD_BVERIFY filename device_num error",
"disk_rules : CMD_BLOCK_READ expression expression opt_address end_cmd",
"disk_rules : CMD_BLOCK_WRITE expression expression address end_cmd",
"disk_rules : CMD_LIST end_cmd",
"disk_rules : CMD_LIST device_num end_cmd",
"disk_rules : CMD_ATTACH filename expression end_cmd",
"disk_rules : CMD_DETACH expression end_cmd",
"disk_rules : CMD_AUTOSTART filename end_cmd",
"disk_rules : CMD_AUTOSTART filename opt_sep number end_cmd",
"disk_rules : CMD_AUTOLOAD filename end_cmd",
"disk_rules : CMD_AUTOLOAD filename opt_sep number end_cmd",
"cmd_file_rules : CMD_RECORD filename end_cmd",
"cmd_file_rules : CMD_MON_STOP end_cmd",
"cmd_file_rules : CMD_PLAYBACK filename end_cmd",
"data_entry_rules : CMD_ENTER_DATA address data_list end_cmd",
"data_entry_rules : CMD_ENTER_BIN_DATA end_cmd",
"monitor_debug_rules : CMD_YYDEBUG end_cmd",
"rest_of_line : R_O_L",
"opt_rest_of_line : R_O_L",
"opt_rest_of_line :",
"rest_of_line_or_quoted : R_O_L_Q",
"filename : FILENAME",
"filename : error",
"device_num : d_number",
"device_num : error",
"mem_op : mem_op MEM_OP",
"mem_op : MEM_OP",
"opt_mem_op : mem_op",
"opt_mem_op :",
"register : MON_REGISTER",
"register : memspace MON_REGISTER",
"reg_list : reg_list COMMA reg_asgn",
"reg_list : reg_asgn",
"reg_asgn : register EQUALS number",
"checkpt_num : d_number",
"checkpt_num : error",
"address_opt_range : address_range",
"address_opt_range : address",
"address_range : address opt_sep address",
"address_range : H_RANGE_GUESS",
"address_range : memspace opt_sep H_RANGE_GUESS",
"opt_address : opt_sep address",
"opt_address :",
"address : memloc",
"address : memspace opt_sep memloc",
"address : LABEL",
"opt_sep : COMMA",
"opt_sep :",
"memspace : MEM_COMP",
"memspace : MEM_DISK8",
"memspace : MEM_DISK9",
"memspace : MEM_DISK10",
"memspace : MEM_DISK11",
"memloc : memaddr",
"memaddr : number",
"expression : expression '+' expression",
"expression : expression '-' expression",
"expression : expression '*' expression",
"expression : expression '/' expression",
"expression : '(' expression ')'",
"expression : '(' expression error",
"expression : value",
"opt_if_cond_expr : IF cond_expr",
"opt_if_cond_expr :",
"cond_expr : cond_expr COND_OP cond_expr",
"cond_expr : cond_expr COND_OP error",
"cond_expr : L_PAREN cond_expr R_PAREN",
"cond_expr : L_PAREN cond_expr error",
"cond_expr : cond_operand",
"cond_operand : register",
"cond_operand : number",
"cond_operand : '@' BANKNAME ':' address",
"data_list : data_list opt_sep data_element",
"data_list : data_element",
"data_element : number",
"data_element : STRING",
"hunt_list : hunt_list hunt_element",
"hunt_list : hunt_element",
"hunt_element : number",
"hunt_element : MASK",
"hunt_element : STRING",
"value : number",
"value : register",
"d_number : D_NUMBER",
"d_number : B_NUMBER_GUESS",
"d_number : D_NUMBER_GUESS",
"d_number : O_NUMBER_GUESS",
"guess_default : B_NUMBER_GUESS",
"guess_default : D_NUMBER_GUESS",
"guess_default : O_NUMBER_GUESS",
"number : H_NUMBER",
"number : B_NUMBER",
"number : D_NUMBER",
"number : O_NUMBER",
"number : guess_default",
"assembly_instr_list : assembly_instr_list INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP assembly_instruction",
"assembly_instr_list : assembly_instruction INST_SEP",
"assembly_instruction : OPCODE asm_operand_mode",
"post_assemble : assembly_instruction",
"post_assemble : assembly_instr_list",
"asm_operand_mode : ARG_IMMEDIATE number",
"asm_operand_mode : number",
"asm_operand_mode : number COMMA REG_X",
"asm_operand_mode : number COMMA REG_Y",
"asm_operand_mode : number COMMA REG_S",
"asm_operand_mode : number COMMA number",
"asm_operand_mode : L_PAREN number R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_X R_PAREN",
"asm_operand_mode : L_PAREN number COMMA REG_S R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_Y",
"asm_operand_mode : L_PAREN REG_BC R_PAREN",
"asm_operand_mode : L_PAREN REG_DE R_PAREN",
"asm_operand_mode : L_PAREN REG_HL R_PAREN",
"asm_operand_mode : L_PAREN REG_IX R_PAREN",
"asm_operand_mode : L_PAREN REG_IY R_PAREN",
"asm_operand_mode : L_PAREN REG_SP R_PAREN",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_A",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_HL",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IX",
"asm_operand_mode : L_PAREN number R_PAREN COMMA REG_IY",
"asm_operand_mode :",
"asm_operand_mode : REG_A",
"asm_operand_mode : REG_B",
"asm_operand_mode : REG_C",
"asm_operand_mode : REG_D",
"asm_operand_mode : REG_E",
"asm_operand_mode : REG_H",
"asm_operand_mode : REG_IXH",
"asm_operand_mode : REG_IYH",
"asm_operand_mode : REG_L",
"asm_operand_mode : REG_IXL",
"asm_operand_mode : REG_IYL",
"asm_operand_mode : REG_AF",
"asm_operand_mode : REG_BC",
"asm_operand_mode : REG_DE",
"asm_operand_mode : REG_HL",
"asm_operand_mode : REG_IX",
"asm_operand_mode : REG_IY",
"asm_operand_mode : REG_SP",
"asm_operand_mode : LESS_THAN number",
"asm_operand_mode : number COMMA index_ureg",
"asm_operand_mode : COMMA index_reg PLUS",
"asm_operand_mode : COMMA index_reg PLUS PLUS",
"asm_operand_mode : COMMA MINUS index_reg",
"asm_operand_mode : COMMA MINUS MINUS index_reg",
"asm_operand_mode : COMMA index_reg",
"asm_operand_mode : REG_B COMMA index_reg",
"asm_operand_mode : REG_A COMMA index_reg",
"asm_operand_mode : REG_D COMMA index_reg",
"asm_operand_mode : number COMMA REG_PC",
"asm_operand_mode : L_BRACKET number COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg PLUS PLUS R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA MINUS MINUS index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_B COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_A COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET REG_D COMMA index_reg R_BRACKET",
"asm_operand_mode : L_BRACKET number COMMA REG_PC R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET",
"asm_operand_mode : L_BRACKET number R_BRACKET COMMA REG_Y",
"index_reg : REG_X",
"index_reg : REG_Y",
"index_reg : index_ureg",
"index_reg : REG_S",
"index_ureg : REG_U",

};
#endif

#if YYDEBUG
int      yydebug;
#endif

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;
int      yynerrs;

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
YYLTYPE  yyloc; /* position returned by actions */
YYLTYPE  yylloc; /* position from the lexer */
#endif

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
#ifndef YYLLOC_DEFAULT
#define YYLLOC_DEFAULT(loc, rhs, n) \
do \
{ \
    if (n == 0) \
    { \
        (loc).first_line   = YYRHSLOC(rhs, 0).last_line; \
        (loc).first_column = YYRHSLOC(rhs, 0).last_column; \
        (loc).last_line    = YYRHSLOC(rhs, 0).last_line; \
        (loc).last_column  = YYRHSLOC(rhs, 0).last_column; \
    } \
    else \
    { \
        (loc).first_line   = YYRHSLOC(rhs, 1).first_line; \
        (loc).first_column = YYRHSLOC(rhs, 1).first_column; \
        (loc).last_line    = YYRHSLOC(rhs, n).last_line; \
        (loc).last_column  = YYRHSLOC(rhs, n).last_column; \
    } \
} while (0)
#endif /* YYLLOC_DEFAULT */
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
#if YYBTYACC

#ifndef YYLVQUEUEGROWTH
#define YYLVQUEUEGROWTH 32
#endif
#endif /* YYBTYACC */

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#ifndef YYINITSTACKSIZE
#define YYINITSTACKSIZE 200
#endif

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    YYLTYPE  *p_base;
    YYLTYPE  *p_mark;
#endif
} YYSTACKDATA;
#if YYBTYACC

struct YYParseState_s
{
    struct YYParseState_s *save;    /* Previously saved parser state */
    YYSTACKDATA            yystack; /* saved parser stack */
    int                    state;   /* saved parser state */
    int                    errflag; /* saved error recovery status */
    int                    lexeme;  /* saved index of the conflict lexeme in the lexical queue */
    YYINT                  ctry;    /* saved index in yyctable[] for this conflict */
};
typedef struct YYParseState_s YYParseState;
#endif /* YYBTYACC */
/* variables for the parser stack */
static YYSTACKDATA yystack;
#if YYBTYACC

/* Current parser state */
static YYParseState *yyps = 0;

/* yypath != NULL: do the full parse, starting at *yypath parser state. */
static YYParseState *yypath = 0;

/* Base of the lexical value queue */
static YYSTYPE *yylvals = 0;

/* Current position at lexical value queue */
static YYSTYPE *yylvp = 0;

/* End position of lexical value queue */
static YYSTYPE *yylve = 0;

/* The last allocated position at the lexical value queue */
static YYSTYPE *yylvlim = 0;

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
/* Base of the lexical position queue */
static YYLTYPE *yylpsns = 0;

/* Current position at lexical position queue */
static YYLTYPE *yylpp = 0;

/* End position of lexical position queue */
static YYLTYPE *yylpe = 0;

/* The last allocated position at the lexical position queue */
static YYLTYPE *yylplim = 0;
#endif

/* Current position at lexical token queue */
static YYINT  *yylexp = 0;

static YYINT  *yylexemes = 0;
#endif /* YYBTYACC */
#line 1124 "mon_parse.y"

int parse_and_execute_line(char *input)
{
   char *temp_buf;
   int i, rc;

   if (default_memspace == e_comp_space) {
       /*
        * If the command is to be executed when the default address space is the main cpu,
        * Ensure drive CPU emulation is up to date with main cpu CLOCK.
        */
       drive_cpu_execute_all(maincpu_clk);
   }

   temp_buf = lib_malloc(strlen(input) + 3);
   strcpy(temp_buf,input);
   i = (int)strlen(input);
   temp_buf[i++] = '\n';
   temp_buf[i++] = '\0';
   temp_buf[i++] = '\0';

   make_buffer(temp_buf);
   mon_clear_buffer();
   if ( (rc =yyparse()) != 0) {
       mon_out("ERROR -- ");
       switch(rc) {
         case ERR_BAD_CMD:
           mon_out("Bad command:\n");
           break;
         case ERR_RANGE_BAD_START:
           mon_out("Bad first address in range:\n");
           break;
         case ERR_RANGE_BAD_END:
           mon_out("Bad second address in range:\n");
           break;
         case ERR_EXPECT_CHECKNUM:
           mon_out("Checkpoint number expected:\n");
           break;
         case ERR_EXPECT_END_CMD:
           mon_out("Unexpected token:\n");
           break;
         case ERR_MISSING_CLOSE_PAREN:
           mon_out("')' expected:\n");
           break;
         case ERR_INCOMPLETE_COND_OP:
           mon_out("Conditional operation missing an operand:\n");
           break;
         case ERR_EXPECT_FILENAME:
           mon_out("Expecting a filename:\n");
           break;
         case ERR_ADDR_TOO_BIG:
           mon_out("Address too large:\n");
           break;
         case ERR_IMM_TOO_BIG:
           mon_out("Immediate argument too large:\n");
           break;
         case ERR_EXPECT_STRING:
           mon_out("Expecting a string.\n");
           break;
         case ERR_UNDEFINED_LABEL:
           mon_out("Found an undefined label.\n");
           break;
         case ERR_EXPECT_DEVICE_NUM:
           mon_out("Expecting a device number.\n");
           break;
         case ERR_EXPECT_ADDRESS:
           mon_out("Expecting an address.\n");
           break;
         case ERR_INVALID_REGISTER:
           mon_out("Invalid register.\n");
           break;
         case ERR_ILLEGAL_INPUT:
         default:
           mon_out("Wrong syntax:\n");
       }
       mon_out("  %s\n", input);
       for (i = 0; i < last_len; i++)
           mon_out(" ");
       mon_out("  ^\n");
       asm_mode = 0;
       new_cmd = 1;
   }
   lib_free(temp_buf);
   free_buffer();

   return rc;
}

static int yyerror(char *s)
{
#if 0
   fprintf(stderr, "ERR:%s\n", s);
#endif
   return 0;
}

/* convert the string in "num" to a numeric value, depending on radix. this 
   function does some magic conversion on addresses when radix is not hex.
*/
static int resolve_datatype(unsigned guess_type, const char *num)
{
    int binary = 1, hex = 0, octal = 0, decimal = 1;
    const char *c;

    /* FIXME: Handle cases when default type is non-numerical */
    if (default_radix == e_hexadecimal) {
        return (int)strtol(num, NULL, 16);
    }

    /* we do some educated guessing on what type of number we have here */
    if (num[0] == '0') {
        /* might be octal with leading zero */
        octal = 1;
    }
    /* a string containing any digits not 0 or 1 can't be a binary number */
    c = num;
    while (*c) {
        if ((*c != '0') && (*c != '1')) {
            binary = 0;
            break;
        }
        c++;
    }
    /* a string containing 8 or 9 can't be an octal number */
    c = num;
    while (*c) {
        if ((*c == '8') && (*c == '9')) {
            octal = 0;
            break;
        }
        c++;
    }
    /* a string containing any of A-F can only be a hex number */
    c = num;
    while (*c) {
        if ((tolower(*c) >= 'a') && (tolower(*c) <= 'f')) {
            hex = 1;
            octal = 0;
            binary = 0;
            decimal = 0;
            break;
        }
        c++;
    }

    /* a hex number can only be hex no matter what */
    if (hex) {
        return (int)strtol(num, NULL, 16);
    }

    /* first, if default radix and detected number matches, just do it */
    if (binary && (default_radix == e_binary)) {
        return (int)strtol(num, NULL, 2);
    }
    if (decimal && (default_radix == e_decimal)) {
        return (int)strtol(num, NULL, 10);
    }
    if (octal && (default_radix == e_octal)) {
        return (int)strtol(num, NULL, 8);
    }

    /* second, if detected number matches guess type, do it */
    if (binary && (guess_type == B_NUMBER)) {
        return (int)strtol(num, NULL, 2);
    }
    if (decimal && (guess_type == D_NUMBER)) {
        return (int)strtol(num, NULL, 10);
    }
    if (octal && (guess_type == O_NUMBER)) {
        return (int)strtol(num, NULL, 8);
    }

    /* third only use the detected type */
    if (binary) {
        return (int)strtol(num, NULL, 2);
    }
    if (decimal) {
        return (int)strtol(num, NULL, 10);
    }
    if (octal) {
        return (int)strtol(num, NULL, 8);
    }

    /* use hex as default, should we ever come here */
    return (int)strtol(num, NULL, 16);
}

/*
 * Resolve a character sequence containing 8 hex digits like "08001000".
 * This could be a lazy version of "0800 1000". If the default radix is not
 * hexadecimal, we handle it like a ordinary number, in the latter case there
 * is only one number in the range.
 */
static int resolve_range(enum t_memspace memspace, MON_ADDR range[2],
                         const char *num)
{
    char start[5];
    char end[5];
    long sa;

    range[1] = BAD_ADDR;

    switch (default_radix)
    {
    case e_hexadecimal:
        /* checked twice, but as the code must have exactly 8 digits: */
        if (strlen(num) == 8) {
            memcpy(start, num, 4);
            start[4] = '\0';
            memcpy(end, num + 4, 4);
            end[4] = '\0';
            sa = strtol(start, NULL, 16);
            range[1] = (int)new_addr(memspace, strtol(end, NULL, 16));
        }
        else
            sa = strtol(num, NULL, 16);
        break;

    case e_decimal:
       sa = strtol(num, NULL, 10);
       break;

    case e_octal:
       sa = strtol(num, NULL, 8);
       break;

    default:
       sa = strtol(num, NULL, 2);
    }

    if (!CHECK_ADDR(sa))
        return ERR_ADDR_TOO_BIG;

    range[0] = (int)new_addr(memspace, sa);
    return 0;
}
#line 2286 "mon_parse.c"

/* For use in generated program */
#define yydepth (int)(yystack.s_mark - yystack.s_base)
#if YYBTYACC
#define yytrial (yyps->save)
#endif /* YYBTYACC */

#if YYDEBUG
#include <stdio.h>	/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    YYLTYPE *newps;
#endif

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    newps = (YYLTYPE *)realloc(data->p_base, newsize * sizeof(*newps));
    if (newps == 0)
        return YYENOMEM;

    data->p_base = newps;
    data->p_mark = newps + i;
#endif

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;

#if YYDEBUG
    if (yydebug)
        fprintf(stderr, "%sdebug: stack size increased to %d\n", YYPREFIX, newsize);
#endif
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    free(data->p_base);
#endif
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif /* YYPURE || defined(YY_NO_LEAKS) */
#if YYBTYACC

static YYParseState *
yyNewState(unsigned size)
{
    YYParseState *p = (YYParseState *) malloc(sizeof(YYParseState));
    if (p == NULL) return NULL;

    p->yystack.stacksize = size;
    if (size == 0)
    {
        p->yystack.s_base = NULL;
        p->yystack.l_base = NULL;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        p->yystack.p_base = NULL;
#endif
        return p;
    }
    p->yystack.s_base    = (YYINT *) malloc(size * sizeof(YYINT));
    if (p->yystack.s_base == NULL) return NULL;
    p->yystack.l_base    = (YYSTYPE *) malloc(size * sizeof(YYSTYPE));
    if (p->yystack.l_base == NULL) return NULL;
    memset(p->yystack.l_base, 0, size * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    p->yystack.p_base    = (YYLTYPE *) malloc(size * sizeof(YYLTYPE));
    if (p->yystack.p_base == NULL) return NULL;
    memset(p->yystack.p_base, 0, size * sizeof(YYLTYPE));
#endif

    return p;
}

static void
yyFreeState(YYParseState *p)
{
    yyfreestack(&p->yystack);
    free(p);
}
#endif /* YYBTYACC */

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab
#if YYBTYACC
#define YYVALID        do { if (yyps->save)            goto yyvalid; } while(0)
#define YYVALID_NESTED do { if (yyps->save && \
                                yyps->save->save == 0) goto yyvalid; } while(0)
#endif /* YYBTYACC */

int
YYPARSE_DECL()
{
    int yym, yyn, yystate, yyresult;
#if YYBTYACC
    int yynewerrflag;
    YYParseState *yyerrctx = NULL;
#endif /* YYBTYACC */
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    YYLTYPE  yyerror_loc_range[3]; /* position of error start/end (0 unused) */
#endif
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
    if (yydebug)
        fprintf(stderr, "%sdebug[<# of symbols on state stack>]\n", YYPREFIX);
#endif
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    memset(yyerror_loc_range, 0, sizeof(yyerror_loc_range));
#endif

#if YYBTYACC
    yyps = yyNewState(0); if (yyps == 0) goto yyenomem;
    yyps->save = 0;
#endif /* YYBTYACC */
    yym = 0;
    /* yyn is set below */
    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark = yystack.p_base;
#endif
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
#if YYBTYACC
        do {
        if (yylvp < yylve)
        {
            /* we're currently re-reading tokens */
            yylval = *yylvp++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yylloc = *yylpp++;
#endif
            yychar = *yylexp++;
            break;
        }
        if (yyps->save)
        {
            /* in trial mode; save scanner results for future parse attempts */
            if (yylvp == yylvlim)
            {   /* Enlarge lexical value queue */
                size_t p = (size_t) (yylvp - yylvals);
                size_t s = (size_t) (yylvlim - yylvals);

                s += YYLVQUEUEGROWTH;
                if ((yylexemes = (YYINT *)realloc(yylexemes, s * sizeof(YYINT))) == NULL) goto yyenomem;
                if ((yylvals   = (YYSTYPE *)realloc(yylvals, s * sizeof(YYSTYPE))) == NULL) goto yyenomem;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                if ((yylpsns   = (YYLTYPE *)realloc(yylpsns, s * sizeof(YYLTYPE))) == NULL) goto yyenomem;
#endif
                yylvp   = yylve = yylvals + p;
                yylvlim = yylvals + s;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylpp   = yylpe = yylpsns + p;
                yylplim = yylpsns + s;
#endif
                yylexp  = yylexemes + p;
            }
            *yylexp = (YYINT) YYLEX;
            *yylvp++ = yylval;
            yylve++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            *yylpp++ = yylloc;
            yylpe++;
#endif
            yychar = *yylexp++;
            break;
        }
        /* normal operation, no conflict encountered */
#endif /* YYBTYACC */
        yychar = YYLEX;
#if YYBTYACC
        } while (0);
#endif /* YYBTYACC */
        if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            fprintf(stderr, "%s[%d]: state %d, reading token %d (%s)",
                            YYDEBUGSTR, yydepth, yystate, yychar, yys);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
            if (!yytrial)
#endif /* YYBTYACC */
                fprintf(stderr, " <%s>", YYSTYPE_TOSTRING(yychar, yylval));
#endif
            fputc('\n', stderr);
        }
#endif
    }
#if YYBTYACC

    /* Do we have a conflict? */
    if (((yyn = yycindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
        yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        YYINT ctry;

        if (yypath)
        {
            YYParseState *save;
#if YYDEBUG
            if (yydebug)
                fprintf(stderr, "%s[%d]: CONFLICT in state %d: following successful trial parse\n",
                                YYDEBUGSTR, yydepth, yystate);
#endif
            /* Switch to the next conflict context */
            save = yypath;
            yypath = save->save;
            save->save = NULL;
            ctry = save->ctry;
            if (save->state != yystate) YYABORT;
            yyFreeState(save);

        }
        else
        {

            /* Unresolved conflict - start/continue trial parse */
            YYParseState *save;
#if YYDEBUG
            if (yydebug)
            {
                fprintf(stderr, "%s[%d]: CONFLICT in state %d. ", YYDEBUGSTR, yydepth, yystate);
                if (yyps->save)
                    fputs("ALREADY in conflict, continuing trial parse.\n", stderr);
                else
                    fputs("Starting trial parse.\n", stderr);
            }
#endif
            save                  = yyNewState((unsigned)(yystack.s_mark - yystack.s_base + 1));
            if (save == NULL) goto yyenomem;
            save->save            = yyps->save;
            save->state           = yystate;
            save->errflag         = yyerrflag;
            save->yystack.s_mark  = save->yystack.s_base + (yystack.s_mark - yystack.s_base);
            memcpy (save->yystack.s_base, yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
            save->yystack.l_mark  = save->yystack.l_base + (yystack.l_mark - yystack.l_base);
            memcpy (save->yystack.l_base, yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            save->yystack.p_mark  = save->yystack.p_base + (yystack.p_mark - yystack.p_base);
            memcpy (save->yystack.p_base, yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
            ctry                  = yytable[yyn];
            if (yyctable[ctry] == -1)
            {
#if YYDEBUG
                if (yydebug && yychar >= YYEOF)
                    fprintf(stderr, "%s[%d]: backtracking 1 token\n", YYDEBUGSTR, yydepth);
#endif
                ctry++;
            }
            save->ctry = ctry;
            if (yyps->save == NULL)
            {
                /* If this is a first conflict in the stack, start saving lexemes */
                if (!yylexemes)
                {
                    yylexemes = (YYINT *) malloc((YYLVQUEUEGROWTH) * sizeof(YYINT));
                    if (yylexemes == NULL) goto yyenomem;
                    yylvals   = (YYSTYPE *) malloc((YYLVQUEUEGROWTH) * sizeof(YYSTYPE));
                    if (yylvals == NULL) goto yyenomem;
                    yylvlim   = yylvals + YYLVQUEUEGROWTH;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    yylpsns   = (YYLTYPE *) malloc((YYLVQUEUEGROWTH) * sizeof(YYLTYPE));
                    if (yylpsns == NULL) goto yyenomem;
                    yylplim   = yylpsns + YYLVQUEUEGROWTH;
#endif
                }
                if (yylvp == yylve)
                {
                    yylvp  = yylve = yylvals;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    yylpp  = yylpe = yylpsns;
#endif
                    yylexp = yylexemes;
                    if (yychar >= YYEOF)
                    {
                        *yylve++ = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                        *yylpe++ = yylloc;
#endif
                        *yylexp  = (YYINT) yychar;
                        yychar   = YYEMPTY;
                    }
                }
            }
            if (yychar >= YYEOF)
            {
                yylvp--;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylpp--;
#endif
                yylexp--;
                yychar = YYEMPTY;
            }
            save->lexeme = (int) (yylvp - yylvals);
            yyps->save   = save;
        }
        if (yytable[yyn] == ctry)
        {
#if YYDEBUG
            if (yydebug)
                fprintf(stderr, "%s[%d]: state %d, shifting to state %d\n",
                                YYDEBUGSTR, yydepth, yystate, yyctable[ctry]);
#endif
            if (yychar < 0)
            {
                yylvp++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylpp++;
#endif
                yylexp++;
            }
            if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM)
                goto yyoverflow;
            yystate = yyctable[ctry];
            *++yystack.s_mark = (YYINT) yystate;
            *++yystack.l_mark = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            *++yystack.p_mark = yylloc;
#endif
            yychar  = YYEMPTY;
            if (yyerrflag > 0) --yyerrflag;
            goto yyloop;
        }
        else
        {
            yyn = yyctable[ctry];
            goto yyreduce;
        }
    } /* End of code dealing with conflicts */
#endif /* YYBTYACC */
    if (((yyn = yysindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
#if YYDEBUG
        if (yydebug)
            fprintf(stderr, "%s[%d]: state %d, shifting to state %d\n",
                            YYDEBUGSTR, yydepth, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        *++yystack.p_mark = yylloc;
#endif
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if (((yyn = yyrindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag != 0) goto yyinrecovery;
#if YYBTYACC

    yynewerrflag = 1;
    goto yyerrhandler;
    goto yyerrlab; /* redundant goto avoids 'unused label' warning */

yyerrlab:
    /* explicit YYERROR from an action -- pop the rhs of the rule reduced
     * before looking for error recovery */
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark -= yym;
#endif

    yynewerrflag = 0;
yyerrhandler:
    while (yyps->save)
    {
        int ctry;
        YYParseState *save = yyps->save;
#if YYDEBUG
        if (yydebug)
            fprintf(stderr, "%s[%d]: ERROR in state %d, CONFLICT BACKTRACKING to state %d, %d tokens\n",
                            YYDEBUGSTR, yydepth, yystate, yyps->save->state,
                    (int)(yylvp - yylvals - yyps->save->lexeme));
#endif
        /* Memorize most forward-looking error state in case it's really an error. */
        if (yyerrctx == NULL || yyerrctx->lexeme < yylvp - yylvals)
        {
            /* Free old saved error context state */
            if (yyerrctx) yyFreeState(yyerrctx);
            /* Create and fill out new saved error context state */
            yyerrctx                 = yyNewState((unsigned)(yystack.s_mark - yystack.s_base + 1));
            if (yyerrctx == NULL) goto yyenomem;
            yyerrctx->save           = yyps->save;
            yyerrctx->state          = yystate;
            yyerrctx->errflag        = yyerrflag;
            yyerrctx->yystack.s_mark = yyerrctx->yystack.s_base + (yystack.s_mark - yystack.s_base);
            memcpy (yyerrctx->yystack.s_base, yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
            yyerrctx->yystack.l_mark = yyerrctx->yystack.l_base + (yystack.l_mark - yystack.l_base);
            memcpy (yyerrctx->yystack.l_base, yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yyerrctx->yystack.p_mark = yyerrctx->yystack.p_base + (yystack.p_mark - yystack.p_base);
            memcpy (yyerrctx->yystack.p_base, yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
            yyerrctx->lexeme         = (int) (yylvp - yylvals);
        }
        yylvp          = yylvals   + save->lexeme;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        yylpp          = yylpsns   + save->lexeme;
#endif
        yylexp         = yylexemes + save->lexeme;
        yychar         = YYEMPTY;
        yystack.s_mark = yystack.s_base + (save->yystack.s_mark - save->yystack.s_base);
        memcpy (yystack.s_base, save->yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
        yystack.l_mark = yystack.l_base + (save->yystack.l_mark - save->yystack.l_base);
        memcpy (yystack.l_base, save->yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        yystack.p_mark = yystack.p_base + (save->yystack.p_mark - save->yystack.p_base);
        memcpy (yystack.p_base, save->yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
        ctry           = ++save->ctry;
        yystate        = save->state;
        /* We tried shift, try reduce now */
        if ((yyn = yyctable[ctry]) >= 0) goto yyreduce;
        yyps->save     = save->save;
        save->save     = NULL;
        yyFreeState(save);

        /* Nothing left on the stack -- error */
        if (!yyps->save)
        {
#if YYDEBUG
            if (yydebug)
                fprintf(stderr, "%sdebug[%d,trial]: trial parse FAILED, entering ERROR mode\n",
                                YYPREFIX, yydepth);
#endif
            /* Restore state as it was in the most forward-advanced error */
            yylvp          = yylvals   + yyerrctx->lexeme;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yylpp          = yylpsns   + yyerrctx->lexeme;
#endif
            yylexp         = yylexemes + yyerrctx->lexeme;
            yychar         = yylexp[-1];
            yylval         = yylvp[-1];
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yylloc         = yylpp[-1];
#endif
            yystack.s_mark = yystack.s_base + (yyerrctx->yystack.s_mark - yyerrctx->yystack.s_base);
            memcpy (yystack.s_base, yyerrctx->yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
            yystack.l_mark = yystack.l_base + (yyerrctx->yystack.l_mark - yyerrctx->yystack.l_base);
            memcpy (yystack.l_base, yyerrctx->yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            yystack.p_mark = yystack.p_base + (yyerrctx->yystack.p_mark - yyerrctx->yystack.p_base);
            memcpy (yystack.p_base, yyerrctx->yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
            yystate        = yyerrctx->state;
            yyFreeState(yyerrctx);
            yyerrctx       = NULL;
        }
        yynewerrflag = 1;
    }
    if (yynewerrflag == 0) goto yyinrecovery;
#endif /* YYBTYACC */

    YYERROR_CALL("syntax error");
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yyerror_loc_range[1] = yylloc; /* lookahead position is error start position */
#endif

#if !YYBTYACC
    goto yyerrlab; /* redundant goto avoids 'unused label' warning */
yyerrlab:
#endif
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if (((yyn = yysindex[*yystack.s_mark]) != 0) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    fprintf(stderr, "%s[%d]: state %d, error recovery shifting to state %d\n",
                                    YYDEBUGSTR, yydepth, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                /* lookahead position is error end position */
                yyerror_loc_range[2] = yylloc;
                YYLLOC_DEFAULT(yyloc, yyerror_loc_range, 2); /* position of error span */
                *++yystack.p_mark = yyloc;
#endif
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    fprintf(stderr, "%s[%d]: error recovery discarding state %d\n",
                                    YYDEBUGSTR, yydepth, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                /* the current TOS position is the error start position */
                yyerror_loc_range[1] = *yystack.p_mark;
#endif
#if defined(YYDESTRUCT_CALL)
#if YYBTYACC
                if (!yytrial)
#endif /* YYBTYACC */
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    YYDESTRUCT_CALL("error: discarding state",
                                    yystos[*yystack.s_mark], yystack.l_mark, yystack.p_mark);
#else
                    YYDESTRUCT_CALL("error: discarding state",
                                    yystos[*yystack.s_mark], yystack.l_mark);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
#endif /* defined(YYDESTRUCT_CALL) */
                --yystack.s_mark;
                --yystack.l_mark;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                --yystack.p_mark;
#endif
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            fprintf(stderr, "%s[%d]: state %d, error recovery discarding token %d (%s)\n",
                            YYDEBUGSTR, yydepth, yystate, yychar, yys);
        }
#endif
#if defined(YYDESTRUCT_CALL)
#if YYBTYACC
        if (!yytrial)
#endif /* YYBTYACC */
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
            YYDESTRUCT_CALL("error: discarding token", yychar, &yylval, &yylloc);
#else
            YYDESTRUCT_CALL("error: discarding token", yychar, &yylval);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
#endif /* defined(YYDESTRUCT_CALL) */
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
    yym = yylen[yyn];
#if YYDEBUG
    if (yydebug)
    {
        fprintf(stderr, "%s[%d]: state %d, reducing by rule %d (%s)",
                        YYDEBUGSTR, yydepth, yystate, yyn, yyrule[yyn]);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
        if (!yytrial)
#endif /* YYBTYACC */
            if (yym > 0)
            {
                int i;
                fputc('<', stderr);
                for (i = yym; i > 0; i--)
                {
                    if (i != yym) fputs(", ", stderr);
                    fputs(YYSTYPE_TOSTRING(yystos[yystack.s_mark[1-i]],
                                           yystack.l_mark[1-i]), stderr);
                }
                fputc('>', stderr);
            }
#endif
        fputc('\n', stderr);
    }
#endif
    if (yym > 0)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)

    /* Perform position reduction */
    memset(&yyloc, 0, sizeof(yyloc));
#if YYBTYACC
    if (!yytrial)
#endif /* YYBTYACC */
    {
        YYLLOC_DEFAULT(yyloc, &yystack.p_mark[-yym], yym);
        /* just in case YYERROR is invoked within the action, save
           the start of the rhs as the error start position */
        yyerror_loc_range[1] = yystack.p_mark[1-yym];
    }
#endif

    switch (yyn)
    {
case 1:
#line 178 "mon_parse.y"
	{ yyval.i = 0; }
#line 2959 "mon_parse.c"
break;
case 2:
#line 179 "mon_parse.y"
	{ yyval.i = 0; }
#line 2964 "mon_parse.c"
break;
case 3:
#line 180 "mon_parse.y"
	{ new_cmd = 1; asm_mode = 0;  yyval.i = 0; }
#line 2969 "mon_parse.c"
break;
case 8:
#line 189 "mon_parse.y"
	{ return ERR_EXPECT_END_CMD; }
#line 2974 "mon_parse.c"
break;
case 21:
#line 204 "mon_parse.y"
	{ return ERR_BAD_CMD; }
#line 2979 "mon_parse.c"
break;
case 22:
#line 208 "mon_parse.y"
	{ mon_bank(e_default_space, NULL); }
#line 2984 "mon_parse.c"
break;
case 23:
#line 210 "mon_parse.y"
	{ mon_bank(yystack.l_mark[-1].i, NULL); }
#line 2989 "mon_parse.c"
break;
case 24:
#line 212 "mon_parse.y"
	{ mon_bank(e_default_space, yystack.l_mark[-1].str); }
#line 2994 "mon_parse.c"
break;
case 25:
#line 214 "mon_parse.y"
	{ mon_bank(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 2999 "mon_parse.c"
break;
case 26:
#line 216 "mon_parse.y"
	{ mon_jump(yystack.l_mark[-1].a); }
#line 3004 "mon_parse.c"
break;
case 27:
#line 218 "mon_parse.y"
	{ mon_go(); }
#line 3009 "mon_parse.c"
break;
case 28:
#line 220 "mon_parse.y"
	{ mon_display_io_regs(0); }
#line 3014 "mon_parse.c"
break;
case 29:
#line 222 "mon_parse.y"
	{ mon_display_io_regs(yystack.l_mark[-1].a); }
#line 3019 "mon_parse.c"
break;
case 30:
#line 224 "mon_parse.y"
	{ monitor_cpu_type_set(""); }
#line 3024 "mon_parse.c"
break;
case 31:
#line 226 "mon_parse.y"
	{ monitor_cpu_type_set(yystack.l_mark[-1].str); }
#line 3029 "mon_parse.c"
break;
case 32:
#line 228 "mon_parse.y"
	{ mon_cpuhistory(-1,  0,  0,  0,   0,   0); }
#line 3034 "mon_parse.c"
break;
case 33:
#line 230 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-1].i,  0,  0,   0,   0); }
#line 3039 "mon_parse.c"
break;
case 34:
#line 232 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-3].i, yystack.l_mark[-1].i,  0,   0,   0); }
#line 3044 "mon_parse.c"
break;
case 35:
#line 234 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,   0,   0); }
#line 3049 "mon_parse.c"
break;
case 36:
#line 236 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i,  yystack.l_mark[-1].i,   0); }
#line 3054 "mon_parse.c"
break;
case 37:
#line 238 "mon_parse.y"
	{ mon_cpuhistory(-1, yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i,  yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3059 "mon_parse.c"
break;
case 38:
#line 240 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-1].i,  0,  0,  0,   0,   0); }
#line 3064 "mon_parse.c"
break;
case 39:
#line 242 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-3].i, yystack.l_mark[-1].i,  0,  0,   0,   0); }
#line 3069 "mon_parse.c"
break;
case 40:
#line 244 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,  0,   0,   0); }
#line 3074 "mon_parse.c"
break;
case 41:
#line 246 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,   0,   0); }
#line 3079 "mon_parse.c"
break;
case 42:
#line 248 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i,   0); }
#line 3084 "mon_parse.c"
break;
case 43:
#line 250 "mon_parse.y"
	{ mon_cpuhistory(yystack.l_mark[-11].i, yystack.l_mark[-9].i, yystack.l_mark[-7].i, yystack.l_mark[-5].i, yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3089 "mon_parse.c"
break;
case 44:
#line 252 "mon_parse.y"
	{ mon_instruction_return(); }
#line 3094 "mon_parse.c"
break;
case 45:
#line 254 "mon_parse.y"
	{ mon_write_snapshot(yystack.l_mark[-1].str,0,0,0); /* FIXME */ }
#line 3099 "mon_parse.c"
break;
case 46:
#line 256 "mon_parse.y"
	{ mon_read_snapshot(yystack.l_mark[-1].str, 0); }
#line 3104 "mon_parse.c"
break;
case 47:
#line 258 "mon_parse.y"
	{ mon_instructions_step(-1); }
#line 3109 "mon_parse.c"
break;
case 48:
#line 260 "mon_parse.y"
	{ mon_instructions_step(yystack.l_mark[-1].i); }
#line 3114 "mon_parse.c"
break;
case 49:
#line 262 "mon_parse.y"
	{ mon_instructions_next(-1); }
#line 3119 "mon_parse.c"
break;
case 50:
#line 264 "mon_parse.y"
	{ mon_instructions_next(yystack.l_mark[-1].i); }
#line 3124 "mon_parse.c"
break;
case 51:
#line 266 "mon_parse.y"
	{ mon_stack_up(-1); }
#line 3129 "mon_parse.c"
break;
case 52:
#line 268 "mon_parse.y"
	{ mon_stack_up(yystack.l_mark[-1].i); }
#line 3134 "mon_parse.c"
break;
case 53:
#line 270 "mon_parse.y"
	{ mon_stack_down(-1); }
#line 3139 "mon_parse.c"
break;
case 54:
#line 272 "mon_parse.y"
	{ mon_stack_down(yystack.l_mark[-1].i); }
#line 3144 "mon_parse.c"
break;
case 55:
#line 274 "mon_parse.y"
	{ mon_display_screen(-1); }
#line 3149 "mon_parse.c"
break;
case 56:
#line 276 "mon_parse.y"
	{ mon_display_screen(yystack.l_mark[-1].a); }
#line 3154 "mon_parse.c"
break;
case 57:
#line 278 "mon_parse.y"
	{
                        mon_out("Warp mode is %s.\n",
                                vsync_get_warp_mode() ? "on" : "off");
                     }
#line 3162 "mon_parse.c"
break;
case 58:
#line 283 "mon_parse.y"
	{
                        vsync_set_warp_mode(!vsync_get_warp_mode());
                     }
#line 3169 "mon_parse.c"
break;
case 60:
#line 290 "mon_parse.y"
	{ (monitor_cpu_for_memspace[default_memspace]->mon_register_print)(default_memspace); }
#line 3174 "mon_parse.c"
break;
case 61:
#line 292 "mon_parse.y"
	{ (monitor_cpu_for_memspace[yystack.l_mark[-1].i]->mon_register_print)(yystack.l_mark[-1].i); }
#line 3179 "mon_parse.c"
break;
case 63:
#line 297 "mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_commands(yystack.l_mark[-1].str,true);
                    }
#line 3187 "mon_parse.c"
break;
case 64:
#line 302 "mon_parse.y"
	{
                        /* What about the memspace? */
                        mon_playback_commands(yystack.l_mark[-1].str,true);
                    }
#line 3195 "mon_parse.c"
break;
case 65:
#line 307 "mon_parse.y"
	{ mon_save_symbols(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3200 "mon_parse.c"
break;
case 66:
#line 309 "mon_parse.y"
	{ mon_save_symbols(e_default_space, yystack.l_mark[-1].str); }
#line 3205 "mon_parse.c"
break;
case 67:
#line 311 "mon_parse.y"
	{ mon_add_name_to_symbol_table(yystack.l_mark[-3].a, yystack.l_mark[-1].str); }
#line 3210 "mon_parse.c"
break;
case 68:
#line 313 "mon_parse.y"
	{ mon_remove_name_from_symbol_table(e_default_space, yystack.l_mark[-1].str); }
#line 3215 "mon_parse.c"
break;
case 69:
#line 315 "mon_parse.y"
	{ mon_remove_name_from_symbol_table(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3220 "mon_parse.c"
break;
case 70:
#line 317 "mon_parse.y"
	{ mon_print_symbol_table(yystack.l_mark[-1].i); }
#line 3225 "mon_parse.c"
break;
case 71:
#line 319 "mon_parse.y"
	{ mon_print_symbol_table(e_default_space); }
#line 3230 "mon_parse.c"
break;
case 72:
#line 321 "mon_parse.y"
	{ mon_clear_symbol_table(yystack.l_mark[-1].i); }
#line 3235 "mon_parse.c"
break;
case 73:
#line 323 "mon_parse.y"
	{ mon_clear_symbol_table(e_default_space); }
#line 3240 "mon_parse.c"
break;
case 74:
#line 325 "mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-1].a, mon_prepend_dot_to_name(yystack.l_mark[-3].str));
                    }
#line 3247 "mon_parse.c"
break;
case 75:
#line 329 "mon_parse.y"
	{
                        mon_add_name_to_symbol_table(yystack.l_mark[-2].a, mon_prepend_dot_to_name(yystack.l_mark[-4].str));
                    }
#line 3254 "mon_parse.c"
break;
case 76:
#line 335 "mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[0].a, NULL); }
#line 3259 "mon_parse.c"
break;
case 77:
#line 336 "mon_parse.y"
	{ }
#line 3264 "mon_parse.c"
break;
case 78:
#line 338 "mon_parse.y"
	{ mon_start_assemble_mode(yystack.l_mark[-1].a, NULL); }
#line 3269 "mon_parse.c"
break;
case 79:
#line 340 "mon_parse.y"
	{ mon_disassemble_lines(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1]); }
#line 3274 "mon_parse.c"
break;
case 80:
#line 342 "mon_parse.y"
	{ mon_disassemble_lines(BAD_ADDR, BAD_ADDR); }
#line 3279 "mon_parse.c"
break;
case 81:
#line 346 "mon_parse.y"
	{ mon_memory_move(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
#line 3284 "mon_parse.c"
break;
case 82:
#line 348 "mon_parse.y"
	{ mon_memory_compare(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1], yystack.l_mark[-1].a); }
#line 3289 "mon_parse.c"
break;
case 83:
#line 350 "mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
#line 3294 "mon_parse.c"
break;
case 84:
#line 352 "mon_parse.y"
	{ mon_memory_hunt(yystack.l_mark[-3].range[0], yystack.l_mark[-3].range[1],(unsigned char *)yystack.l_mark[-1].str); }
#line 3299 "mon_parse.c"
break;
case 85:
#line 354 "mon_parse.y"
	{ mon_memory_display(yystack.l_mark[-3].rt, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
#line 3304 "mon_parse.c"
break;
case 86:
#line 356 "mon_parse.y"
	{ mon_memory_display(default_radix, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
#line 3309 "mon_parse.c"
break;
case 87:
#line 358 "mon_parse.y"
	{ mon_memory_display(default_radix, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
#line 3314 "mon_parse.c"
break;
case 88:
#line 360 "mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 8, 8); }
#line 3319 "mon_parse.c"
break;
case 89:
#line 362 "mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 8, 8); }
#line 3324 "mon_parse.c"
break;
case 90:
#line 364 "mon_parse.y"
	{ mon_memory_display_data(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], 24, 21); }
#line 3329 "mon_parse.c"
break;
case 91:
#line 366 "mon_parse.y"
	{ mon_memory_display_data(BAD_ADDR, BAD_ADDR, 24, 21); }
#line 3334 "mon_parse.c"
break;
case 92:
#line 368 "mon_parse.y"
	{ mon_memory_display(0, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_PETSCII); }
#line 3339 "mon_parse.c"
break;
case 93:
#line 370 "mon_parse.y"
	{ mon_memory_display(0, BAD_ADDR, BAD_ADDR, DF_PETSCII); }
#line 3344 "mon_parse.c"
break;
case 94:
#line 372 "mon_parse.y"
	{ mon_memory_display(0, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], DF_SCREEN_CODE); }
#line 3349 "mon_parse.c"
break;
case 95:
#line 374 "mon_parse.y"
	{ mon_memory_display(0, BAD_ADDR, BAD_ADDR, DF_SCREEN_CODE); }
#line 3354 "mon_parse.c"
break;
case 96:
#line 376 "mon_parse.y"
	{ mon_memmap_zap(); }
#line 3359 "mon_parse.c"
break;
case 97:
#line 378 "mon_parse.y"
	{ mon_memmap_show(-1,BAD_ADDR,BAD_ADDR); }
#line 3364 "mon_parse.c"
break;
case 98:
#line 380 "mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-1].i,BAD_ADDR,BAD_ADDR); }
#line 3369 "mon_parse.c"
break;
case 99:
#line 382 "mon_parse.y"
	{ mon_memmap_show(yystack.l_mark[-2].i,yystack.l_mark[-1].range[0],yystack.l_mark[-1].range[1]); }
#line 3374 "mon_parse.c"
break;
case 100:
#line 384 "mon_parse.y"
	{ mon_memmap_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
#line 3379 "mon_parse.c"
break;
case 101:
#line 388 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_exec, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
#line 3391 "mon_parse.c"
break;
case 102:
#line 397 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3396 "mon_parse.c"
break;
case 103:
#line 400 "mon_parse.y"
	{
                      mon_breakpoint_add_checkpoint(yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE, e_exec, TRUE, TRUE);
                  }
#line 3403 "mon_parse.c"
break;
case 104:
#line 404 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3408 "mon_parse.c"
break;
case 105:
#line 407 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], TRUE, e_load | e_store, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
#line 3420 "mon_parse.c"
break;
case 106:
#line 416 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3425 "mon_parse.c"
break;
case 107:
#line 419 "mon_parse.y"
	{
                      if (yystack.l_mark[-3].i) {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, yystack.l_mark[-3].i, FALSE, TRUE);
                      } else {
                          temp = mon_breakpoint_add_checkpoint(yystack.l_mark[-2].range[0], yystack.l_mark[-2].range[1], FALSE, e_exec | e_load | e_store, FALSE, TRUE);
                      }
                      mon_breakpoint_set_checkpoint_condition(temp, yystack.l_mark[-1].cond_node);
                  }
#line 3437 "mon_parse.c"
break;
case 108:
#line 428 "mon_parse.y"
	{ mon_breakpoint_print_checkpoints(); }
#line 3442 "mon_parse.c"
break;
case 109:
#line 433 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, yystack.l_mark[-1].i); }
#line 3447 "mon_parse.c"
break;
case 110:
#line 435 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_ON, -1); }
#line 3452 "mon_parse.c"
break;
case 111:
#line 437 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, yystack.l_mark[-1].i); }
#line 3457 "mon_parse.c"
break;
case 112:
#line 439 "mon_parse.y"
	{ mon_breakpoint_switch_checkpoint(e_OFF, -1); }
#line 3462 "mon_parse.c"
break;
case 113:
#line 441 "mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-1].i, -1); }
#line 3467 "mon_parse.c"
break;
case 114:
#line 443 "mon_parse.y"
	{ mon_breakpoint_set_ignore_count(yystack.l_mark[-3].i, yystack.l_mark[-1].i); }
#line 3472 "mon_parse.c"
break;
case 115:
#line 445 "mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(yystack.l_mark[-1].i); }
#line 3477 "mon_parse.c"
break;
case 116:
#line 447 "mon_parse.y"
	{ mon_breakpoint_delete_checkpoint(-1); }
#line 3482 "mon_parse.c"
break;
case 117:
#line 449 "mon_parse.y"
	{ mon_breakpoint_set_checkpoint_condition(yystack.l_mark[-3].i, yystack.l_mark[-1].cond_node); }
#line 3487 "mon_parse.c"
break;
case 118:
#line 451 "mon_parse.y"
	{ mon_breakpoint_set_checkpoint_command(yystack.l_mark[-3].i, yystack.l_mark[-1].str); }
#line 3492 "mon_parse.c"
break;
case 119:
#line 453 "mon_parse.y"
	{ return ERR_EXPECT_STRING; }
#line 3497 "mon_parse.c"
break;
case 120:
#line 457 "mon_parse.y"
	{ sidefx = ((yystack.l_mark[-1].action == e_TOGGLE) ? (sidefx ^ 1) : yystack.l_mark[-1].action); }
#line 3502 "mon_parse.c"
break;
case 121:
#line 459 "mon_parse.y"
	{
                         mon_out("I/O side effects are %s\n",
                                   sidefx ? "enabled" : "disabled");
                     }
#line 3510 "mon_parse.c"
break;
case 122:
#line 464 "mon_parse.y"
	{ 
                         break_on_dummy_access = ((yystack.l_mark[-1].action == e_TOGGLE) ? (break_on_dummy_access ^ 1) : yystack.l_mark[-1].action); 
                         /* FIXME: some day we might want to toggle the break-on-dummy-access 
                                   per MEMSPACE, for now its a global option */                         
                         mon_breakpoint_set_dummy_state(e_default_space, break_on_dummy_access);
                     }
#line 3520 "mon_parse.c"
break;
case 123:
#line 471 "mon_parse.y"
	{
                         mon_out("Checkpoints will %strigger on dummy accesses.\n",
                                   break_on_dummy_access ? "" : "not ");
                         /* FIXME: some day we might want to toggle the break-on-dummy-access 
                                   per MEMSPACE, for now its a global option */                         
                         mon_breakpoint_set_dummy_state(e_default_space, break_on_dummy_access);
                     }
#line 3531 "mon_parse.c"
break;
case 124:
#line 479 "mon_parse.y"
	{ 
                        int logenabled;
                        resources_get_int("MonitorLogEnabled", &logenabled);
                        logenabled = ((yystack.l_mark[-1].action == e_TOGGLE) ? (logenabled ^ 1) : yystack.l_mark[-1].action);
                        resources_set_int("MonitorLogEnabled", logenabled);
                     }
#line 3541 "mon_parse.c"
break;
case 125:
#line 486 "mon_parse.y"
	{
                         int logenabled;
                         const char *logfilename;
                         resources_get_int("MonitorLogEnabled", &logenabled);
                         resources_get_string("MonitorLogFileName", &logfilename);
                         if (logenabled) {
                            mon_out("Logging to '%s' is enabled.\n", logfilename);
                         } else {
                            mon_out("Logging is disabled.\n");
                         }
                     }
#line 3556 "mon_parse.c"
break;
case 126:
#line 498 "mon_parse.y"
	{ 
                        resources_set_string("MonitorLogFileName", yystack.l_mark[-1].str);
                     }
#line 3563 "mon_parse.c"
break;
case 127:
#line 502 "mon_parse.y"
	{ default_radix = yystack.l_mark[-1].rt; }
#line 3568 "mon_parse.c"
break;
case 128:
#line 504 "mon_parse.y"
	{
                         const char *p;

                         if (default_radix == e_hexadecimal)
                             p = "Hexadecimal";
                         else if (default_radix == e_decimal)
                             p = "Decimal";
                         else if (default_radix == e_octal)
                             p = "Octal";
                         else if (default_radix == e_binary)
                             p = "Binary";
                         else
                             p = "Unknown";

                         mon_out("Default radix is %s\n", p);
                     }
#line 3588 "mon_parse.c"
break;
case 129:
#line 522 "mon_parse.y"
	{ monitor_change_device(e_default_space); }
#line 3593 "mon_parse.c"
break;
case 130:
#line 524 "mon_parse.y"
	{ monitor_change_device(yystack.l_mark[-1].i); }
#line 3598 "mon_parse.c"
break;
case 131:
#line 526 "mon_parse.y"
	{ mon_export(); }
#line 3603 "mon_parse.c"
break;
case 132:
#line 528 "mon_parse.y"
	{ mon_quit(); YYACCEPT; }
#line 3608 "mon_parse.c"
break;
case 133:
#line 530 "mon_parse.y"
	{ mon_exit(); YYACCEPT; }
#line 3613 "mon_parse.c"
break;
case 134:
#line 532 "mon_parse.y"
	{ mon_maincpu_toggle_trace(yystack.l_mark[-1].action); }
#line 3618 "mon_parse.c"
break;
case 135:
#line 536 "mon_parse.y"
	{ mon_drive_execute_disk_cmd(yystack.l_mark[-1].str); }
#line 3623 "mon_parse.c"
break;
case 136:
#line 538 "mon_parse.y"
	{ mon_out("\t%d\n",yystack.l_mark[-1].i); }
#line 3628 "mon_parse.c"
break;
case 137:
#line 540 "mon_parse.y"
	{ mon_command_print_help(NULL); }
#line 3633 "mon_parse.c"
break;
case 138:
#line 542 "mon_parse.y"
	{ mon_command_print_help(yystack.l_mark[-1].str); }
#line 3638 "mon_parse.c"
break;
case 139:
#line 544 "mon_parse.y"
	{ mon_print_convert(yystack.l_mark[-1].i); }
#line 3643 "mon_parse.c"
break;
case 140:
#line 546 "mon_parse.y"
	{ mon_change_dir(yystack.l_mark[-1].str); }
#line 3648 "mon_parse.c"
break;
case 141:
#line 548 "mon_parse.y"
	{ mon_keyboard_feed(yystack.l_mark[-1].str); }
#line 3653 "mon_parse.c"
break;
case 142:
#line 550 "mon_parse.y"
	{ mon_backtrace(); }
#line 3658 "mon_parse.c"
break;
case 143:
#line 552 "mon_parse.y"
	{ mon_show_dir(yystack.l_mark[-1].str); }
#line 3663 "mon_parse.c"
break;
case 144:
#line 554 "mon_parse.y"
	{ mon_show_pwd(); }
#line 3668 "mon_parse.c"
break;
case 145:
#line 556 "mon_parse.y"
	{ mon_make_dir(yystack.l_mark[-1].str); }
#line 3673 "mon_parse.c"
break;
case 146:
#line 558 "mon_parse.y"
	{ mon_remove_dir(yystack.l_mark[-1].str); }
#line 3678 "mon_parse.c"
break;
case 147:
#line 560 "mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-1].str,-1); }
#line 3683 "mon_parse.c"
break;
case 148:
#line 562 "mon_parse.y"
	{ mon_screenshot_save(yystack.l_mark[-3].str,yystack.l_mark[-1].i); }
#line 3688 "mon_parse.c"
break;
case 149:
#line 564 "mon_parse.y"
	{ mon_resource_get(yystack.l_mark[-1].str); }
#line 3693 "mon_parse.c"
break;
case 150:
#line 566 "mon_parse.y"
	{ mon_resource_set(yystack.l_mark[-2].str,yystack.l_mark[-1].str); }
#line 3698 "mon_parse.c"
break;
case 151:
#line 568 "mon_parse.y"
	{ resources_load(yystack.l_mark[-1].str); }
#line 3703 "mon_parse.c"
break;
case 152:
#line 570 "mon_parse.y"
	{ resources_save(yystack.l_mark[-1].str); }
#line 3708 "mon_parse.c"
break;
case 153:
#line 572 "mon_parse.y"
	{ mon_reset_machine(-1); }
#line 3713 "mon_parse.c"
break;
case 154:
#line 574 "mon_parse.y"
	{ mon_reset_machine(yystack.l_mark[-1].i); }
#line 3718 "mon_parse.c"
break;
case 155:
#line 576 "mon_parse.y"
	{ mon_tape_ctrl(TAPEPORT_PORT_1, yystack.l_mark[-1].i); }
#line 3723 "mon_parse.c"
break;
case 156:
#line 578 "mon_parse.y"
	{ mon_cart_freeze(); }
#line 3728 "mon_parse.c"
break;
case 157:
#line 580 "mon_parse.y"
	{ mon_userport_set_output(yystack.l_mark[-1].i); }
#line 3733 "mon_parse.c"
break;
case 158:
#line 582 "mon_parse.y"
	{ mon_joyport_set_output(yystack.l_mark[-2].i, yystack.l_mark[-1].i); }
#line 3738 "mon_parse.c"
break;
case 159:
#line 584 "mon_parse.y"
	{ }
#line 3743 "mon_parse.c"
break;
case 160:
#line 586 "mon_parse.y"
	{ mon_stopwatch_reset(); }
#line 3748 "mon_parse.c"
break;
case 161:
#line 588 "mon_parse.y"
	{ mon_stopwatch_show("Stopwatch: ", "\n"); }
#line 3753 "mon_parse.c"
break;
case 162:
#line 592 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, FALSE); }
#line 3758 "mon_parse.c"
break;
case 163:
#line 594 "mon_parse.y"
	{ mon_file_load(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].a, TRUE); }
#line 3763 "mon_parse.c"
break;
case 164:
#line 596 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3768 "mon_parse.c"
break;
case 165:
#line 598 "mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], FALSE); }
#line 3773 "mon_parse.c"
break;
case 166:
#line 600 "mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
#line 3778 "mon_parse.c"
break;
case 167:
#line 602 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3783 "mon_parse.c"
break;
case 168:
#line 604 "mon_parse.y"
	{ mon_file_save(yystack.l_mark[-3].str, yystack.l_mark[-2].i, yystack.l_mark[-1].range[0], yystack.l_mark[-1].range[1], TRUE); }
#line 3788 "mon_parse.c"
break;
case 169:
#line 606 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3793 "mon_parse.c"
break;
case 170:
#line 608 "mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a,FALSE); }
#line 3798 "mon_parse.c"
break;
case 171:
#line 610 "mon_parse.y"
	{ mon_file_verify(yystack.l_mark[-3].str,yystack.l_mark[-2].i,yystack.l_mark[-1].a,TRUE); }
#line 3803 "mon_parse.c"
break;
case 172:
#line 612 "mon_parse.y"
	{ return ERR_EXPECT_ADDRESS; }
#line 3808 "mon_parse.c"
break;
case 173:
#line 614 "mon_parse.y"
	{ mon_drive_block_cmd(0,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
#line 3813 "mon_parse.c"
break;
case 174:
#line 616 "mon_parse.y"
	{ mon_drive_block_cmd(1,yystack.l_mark[-3].i,yystack.l_mark[-2].i,yystack.l_mark[-1].a); }
#line 3818 "mon_parse.c"
break;
case 175:
#line 618 "mon_parse.y"
	{ mon_drive_list(-1); }
#line 3823 "mon_parse.c"
break;
case 176:
#line 620 "mon_parse.y"
	{ mon_drive_list(yystack.l_mark[-1].i); }
#line 3828 "mon_parse.c"
break;
case 177:
#line 622 "mon_parse.y"
	{ mon_attach(yystack.l_mark[-2].str,yystack.l_mark[-1].i); }
#line 3833 "mon_parse.c"
break;
case 178:
#line 624 "mon_parse.y"
	{ mon_detach(yystack.l_mark[-1].i); }
#line 3838 "mon_parse.c"
break;
case 179:
#line 626 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,1); }
#line 3843 "mon_parse.c"
break;
case 180:
#line 628 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,1); }
#line 3848 "mon_parse.c"
break;
case 181:
#line 630 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-1].str,0,0); }
#line 3853 "mon_parse.c"
break;
case 182:
#line 632 "mon_parse.y"
	{ mon_autostart(yystack.l_mark[-3].str,yystack.l_mark[-1].i,0); }
#line 3858 "mon_parse.c"
break;
case 183:
#line 636 "mon_parse.y"
	{ mon_record_commands(yystack.l_mark[-1].str); }
#line 3863 "mon_parse.c"
break;
case 184:
#line 638 "mon_parse.y"
	{ mon_end_recording(); }
#line 3868 "mon_parse.c"
break;
case 185:
#line 640 "mon_parse.y"
	{ mon_playback_commands(yystack.l_mark[-1].str,true); }
#line 3873 "mon_parse.c"
break;
case 186:
#line 644 "mon_parse.y"
	{ mon_memory_fill(yystack.l_mark[-2].a, BAD_ADDR, (unsigned char *)yystack.l_mark[-1].str); }
#line 3878 "mon_parse.c"
break;
case 187:
#line 646 "mon_parse.y"
	{ printf("Not yet.\n"); }
#line 3883 "mon_parse.c"
break;
case 188:
#line 650 "mon_parse.y"
	{ yydebug = 1; }
#line 3888 "mon_parse.c"
break;
case 189:
#line 653 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
#line 3893 "mon_parse.c"
break;
case 190:
#line 656 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
#line 3898 "mon_parse.c"
break;
case 191:
#line 657 "mon_parse.y"
	{ yyval.str = NULL; }
#line 3903 "mon_parse.c"
break;
case 192:
#line 660 "mon_parse.y"
	{ yyval.str = yystack.l_mark[0].str; }
#line 3908 "mon_parse.c"
break;
case 194:
#line 664 "mon_parse.y"
	{ return ERR_EXPECT_FILENAME; }
#line 3913 "mon_parse.c"
break;
case 196:
#line 668 "mon_parse.y"
	{ return ERR_EXPECT_DEVICE_NUM; }
#line 3918 "mon_parse.c"
break;
case 197:
#line 671 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i | yystack.l_mark[0].i; }
#line 3923 "mon_parse.c"
break;
case 198:
#line 672 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 3928 "mon_parse.c"
break;
case 199:
#line 675 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 3933 "mon_parse.c"
break;
case 200:
#line 676 "mon_parse.y"
	{ yyval.i = 0; }
#line 3938 "mon_parse.c"
break;
case 201:
#line 679 "mon_parse.y"
	{
                                    if (!mon_register_valid(default_memspace, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(default_memspace, yystack.l_mark[0].reg);
                                }
#line 3948 "mon_parse.c"
break;
case 202:
#line 685 "mon_parse.y"
	{
                                    if (!mon_register_valid(yystack.l_mark[-1].i, yystack.l_mark[0].reg)) {
                                        return ERR_INVALID_REGISTER;
                                    }
                                    yyval.i = new_reg(yystack.l_mark[-1].i, yystack.l_mark[0].reg);
                                }
#line 3958 "mon_parse.c"
break;
case 205:
#line 698 "mon_parse.y"
	{ (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[-2].i)]->mon_register_set_val)(reg_memspace(yystack.l_mark[-2].i), reg_regid(yystack.l_mark[-2].i), (uint16_t) yystack.l_mark[0].i); }
#line 3963 "mon_parse.c"
break;
case 206:
#line 701 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 3968 "mon_parse.c"
break;
case 207:
#line 702 "mon_parse.y"
	{ return ERR_EXPECT_CHECKNUM; }
#line 3973 "mon_parse.c"
break;
case 209:
#line 706 "mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[0].a; yyval.range[1] = BAD_ADDR; }
#line 3978 "mon_parse.c"
break;
case 210:
#line 709 "mon_parse.y"
	{ yyval.range[0] = yystack.l_mark[-2].a; yyval.range[1] = yystack.l_mark[0].a; }
#line 3983 "mon_parse.c"
break;
case 211:
#line 711 "mon_parse.y"
	{ if (resolve_range(e_default_space, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
#line 3988 "mon_parse.c"
break;
case 212:
#line 713 "mon_parse.y"
	{ if (resolve_range(yystack.l_mark[-2].i, yyval.range, yystack.l_mark[0].str)) return ERR_ADDR_TOO_BIG; }
#line 3993 "mon_parse.c"
break;
case 213:
#line 716 "mon_parse.y"
	{ yyval.a = yystack.l_mark[0].a; }
#line 3998 "mon_parse.c"
break;
case 214:
#line 717 "mon_parse.y"
	{ yyval.a = BAD_ADDR; }
#line 4003 "mon_parse.c"
break;
case 215:
#line 721 "mon_parse.y"
	{
             yyval.a = new_addr(e_default_space,yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
#line 4011 "mon_parse.c"
break;
case 216:
#line 726 "mon_parse.y"
	{
             yyval.a = new_addr(yystack.l_mark[-2].i, yystack.l_mark[0].i);
             if (opt_asm) new_cmd = asm_mode = 1;
         }
#line 4019 "mon_parse.c"
break;
case 217:
#line 731 "mon_parse.y"
	{
             temp = mon_symbol_table_lookup_addr(e_default_space, yystack.l_mark[0].str);
             if (temp >= 0)
                 yyval.a = new_addr(e_default_space, temp);
             else
                 return ERR_UNDEFINED_LABEL;
         }
#line 4030 "mon_parse.c"
break;
case 220:
#line 744 "mon_parse.y"
	{ yyval.i = e_comp_space; }
#line 4035 "mon_parse.c"
break;
case 221:
#line 745 "mon_parse.y"
	{ yyval.i = e_disk8_space; }
#line 4040 "mon_parse.c"
break;
case 222:
#line 746 "mon_parse.y"
	{ yyval.i = e_disk9_space; }
#line 4045 "mon_parse.c"
break;
case 223:
#line 747 "mon_parse.y"
	{ yyval.i = e_disk10_space; }
#line 4050 "mon_parse.c"
break;
case 224:
#line 748 "mon_parse.y"
	{ yyval.i = e_disk11_space; }
#line 4055 "mon_parse.c"
break;
case 225:
#line 751 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; if (!CHECK_ADDR(yystack.l_mark[0].i)) return ERR_ADDR_TOO_BIG; }
#line 4060 "mon_parse.c"
break;
case 226:
#line 753 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4065 "mon_parse.c"
break;
case 227:
#line 755 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i + yystack.l_mark[0].i; }
#line 4070 "mon_parse.c"
break;
case 228:
#line 756 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i - yystack.l_mark[0].i; }
#line 4075 "mon_parse.c"
break;
case 229:
#line 757 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-2].i * yystack.l_mark[0].i; }
#line 4080 "mon_parse.c"
break;
case 230:
#line 758 "mon_parse.y"
	{ yyval.i = (yystack.l_mark[0].i) ? (yystack.l_mark[-2].i / yystack.l_mark[0].i) : 1; }
#line 4085 "mon_parse.c"
break;
case 231:
#line 759 "mon_parse.y"
	{ yyval.i = yystack.l_mark[-1].i; }
#line 4090 "mon_parse.c"
break;
case 232:
#line 760 "mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
#line 4095 "mon_parse.c"
break;
case 233:
#line 761 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4100 "mon_parse.c"
break;
case 234:
#line 764 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
#line 4105 "mon_parse.c"
break;
case 235:
#line 765 "mon_parse.y"
	{ yyval.cond_node = 0; }
#line 4110 "mon_parse.c"
break;
case 236:
#line 768 "mon_parse.y"
	{
               yyval.cond_node = new_cond; yyval.cond_node->is_parenthized = FALSE;
               yyval.cond_node->child1 = yystack.l_mark[-2].cond_node; yyval.cond_node->child2 = yystack.l_mark[0].cond_node; yyval.cond_node->operation = yystack.l_mark[-1].cond_op;
           }
#line 4118 "mon_parse.c"
break;
case 237:
#line 773 "mon_parse.y"
	{ return ERR_INCOMPLETE_COND_OP; }
#line 4123 "mon_parse.c"
break;
case 238:
#line 775 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[-1].cond_node; yyval.cond_node->is_parenthized = TRUE; }
#line 4128 "mon_parse.c"
break;
case 239:
#line 777 "mon_parse.y"
	{ return ERR_MISSING_CLOSE_PAREN; }
#line 4133 "mon_parse.c"
break;
case 240:
#line 779 "mon_parse.y"
	{ yyval.cond_node = yystack.l_mark[0].cond_node; }
#line 4138 "mon_parse.c"
break;
case 241:
#line 782 "mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->reg_num = yystack.l_mark[0].i; yyval.cond_node->is_reg = TRUE; yyval.cond_node->banknum=-1;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
#line 4148 "mon_parse.c"
break;
case 242:
#line 788 "mon_parse.y"
	{ yyval.cond_node = new_cond;
                            yyval.cond_node->operation = e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->value = yystack.l_mark[0].i; yyval.cond_node->is_reg = FALSE; yyval.cond_node->banknum=-1;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;
                          }
#line 4158 "mon_parse.c"
break;
case 243:
#line 794 "mon_parse.y"
	{yyval.cond_node=new_cond;
                            yyval.cond_node->operation=e_INV;
                            yyval.cond_node->is_parenthized = FALSE;
                            yyval.cond_node->banknum = mon_banknum_from_bank(e_default_space, yystack.l_mark[-2].str);
                            if (yyval.cond_node->banknum < 0) {
                                return ERR_ILLEGAL_INPUT;
                            }
                            yyval.cond_node->value = yystack.l_mark[0].a; yyval.cond_node->is_reg = FALSE;
                            yyval.cond_node->child1 = NULL; yyval.cond_node->child2 = NULL;  
                        }
#line 4172 "mon_parse.c"
break;
case 246:
#line 810 "mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
#line 4177 "mon_parse.c"
break;
case 247:
#line 811 "mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
#line 4182 "mon_parse.c"
break;
case 250:
#line 818 "mon_parse.y"
	{ mon_add_number_to_buffer(yystack.l_mark[0].i); }
#line 4187 "mon_parse.c"
break;
case 251:
#line 819 "mon_parse.y"
	{ mon_add_number_masked_to_buffer(yystack.l_mark[0].i, 0x00); }
#line 4192 "mon_parse.c"
break;
case 252:
#line 820 "mon_parse.y"
	{ mon_add_string_to_buffer(yystack.l_mark[0].str); }
#line 4197 "mon_parse.c"
break;
case 253:
#line 823 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4202 "mon_parse.c"
break;
case 254:
#line 824 "mon_parse.y"
	{ yyval.i = (monitor_cpu_for_memspace[reg_memspace(yystack.l_mark[0].i)]->mon_register_get_val)(reg_memspace(yystack.l_mark[0].i), reg_regid(yystack.l_mark[0].i)); }
#line 4207 "mon_parse.c"
break;
case 255:
#line 827 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4212 "mon_parse.c"
break;
case 256:
#line 828 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
#line 4217 "mon_parse.c"
break;
case 257:
#line 829 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
#line 4222 "mon_parse.c"
break;
case 258:
#line 830 "mon_parse.y"
	{ yyval.i = (int)strtol(yystack.l_mark[0].str, NULL, 10); }
#line 4227 "mon_parse.c"
break;
case 259:
#line 833 "mon_parse.y"
	{ yyval.i = resolve_datatype(B_NUMBER,yystack.l_mark[0].str); }
#line 4232 "mon_parse.c"
break;
case 260:
#line 834 "mon_parse.y"
	{ yyval.i = resolve_datatype(D_NUMBER,yystack.l_mark[0].str); }
#line 4237 "mon_parse.c"
break;
case 261:
#line 835 "mon_parse.y"
	{ yyval.i = resolve_datatype(O_NUMBER,yystack.l_mark[0].str); }
#line 4242 "mon_parse.c"
break;
case 262:
#line 838 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4247 "mon_parse.c"
break;
case 263:
#line 839 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4252 "mon_parse.c"
break;
case 264:
#line 840 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4257 "mon_parse.c"
break;
case 265:
#line 841 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4262 "mon_parse.c"
break;
case 266:
#line 842 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4267 "mon_parse.c"
break;
case 270:
#line 850 "mon_parse.y"
	{ yyval.i = 0;
                                                if (yystack.l_mark[-1].str) {
                                                    (monitor_cpu_for_memspace[default_memspace]->mon_assemble_instr)(yystack.l_mark[-1].str, yystack.l_mark[0].mode);
                                                } else {
                                                    new_cmd = 1;
                                                    asm_mode = 0;
                                                }
                                                opt_asm = 0;
                                              }
#line 4280 "mon_parse.c"
break;
case 272:
#line 861 "mon_parse.y"
	{ asm_mode = 0; }
#line 4285 "mon_parse.c"
break;
case 273:
#line 864 "mon_parse.y"
	{ if (yystack.l_mark[0].i > 0xff) {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE_16;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } else {
                          yyval.mode.addr_mode = ASM_ADDR_MODE_IMMEDIATE;
                          yyval.mode.param = yystack.l_mark[0].i;
                        } }
#line 4296 "mon_parse.c"
break;
case 274:
#line 871 "mon_parse.y"
	{ if (yystack.l_mark[0].i >= 0x10000) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG;
               yyval.mode.param = yystack.l_mark[0].i;
             } else if (yystack.l_mark[0].i < 0x100) {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE;
               yyval.mode.param = yystack.l_mark[0].i;
             } else {
               yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE;
               yyval.mode.param = yystack.l_mark[0].i;
             }
           }
#line 4311 "mon_parse.c"
break;
case 275:
#line 882 "mon_parse.y"
	{ if (yystack.l_mark[-2].i >= 0x10000) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_LONG_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else if (yystack.l_mark[-2].i < 0x100) { 
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_X;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
#line 4326 "mon_parse.c"
break;
case 276:
#line 893 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ZERO_PAGE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_Y;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          }
                        }
#line 4338 "mon_parse.c"
break;
case 277:
#line 901 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE;
                            yyval.mode.param = yystack.l_mark[-2].i;
                          } else { /* 6809 */
                            yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
                            if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
                                yyval.mode.addr_submode = yystack.l_mark[0].i | (yystack.l_mark[-2].i & 0x1F);
                            } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF8;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
                                yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF16;
                                yyval.mode.param = yystack.l_mark[-2].i;
                            } else {
                                yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
                                mon_out("offset too large even for 16 bits (signed)\n");
                            }
                          }
                        }
#line 4361 "mon_parse.c"
break;
case 278:
#line 920 "mon_parse.y"
	{ if (yystack.l_mark[-2].i < 0x100) {
                            yyval.mode.addr_mode = ASM_ADDR_MODE_DOUBLE;
                            yyval.mode.param = yystack.l_mark[0].i;
                            yyval.mode.addr_submode = yystack.l_mark[-2].i;
                          }
                        }
#line 4371 "mon_parse.c"
break;
case 279:
#line 926 "mon_parse.y"
	{ if (yystack.l_mark[-1].i < 0x100) {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             } else {
                               yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT;
                               yyval.mode.param = yystack.l_mark[-1].i;
                             }
                           }
#line 4383 "mon_parse.c"
break;
case 280:
#line 934 "mon_parse.y"
	{ if (yystack.l_mark[-3].i < 0x100) {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         } else {
                                           yyval.mode.addr_mode = ASM_ADDR_MODE_ABS_INDIRECT_X;
                                           yyval.mode.param = yystack.l_mark[-3].i;
                                         }
                                       }
#line 4395 "mon_parse.c"
break;
case 281:
#line 943 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_STACK_RELATIVE_Y; yyval.mode.param = yystack.l_mark[-5].i; }
#line 4400 "mon_parse.c"
break;
case 282:
#line 945 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_Y; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4405 "mon_parse.c"
break;
case 283:
#line 946 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_BC; }
#line 4410 "mon_parse.c"
break;
case 284:
#line 947 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_DE; }
#line 4415 "mon_parse.c"
break;
case 285:
#line 948 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_HL; }
#line 4420 "mon_parse.c"
break;
case 286:
#line 949 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IX; }
#line 4425 "mon_parse.c"
break;
case 287:
#line 950 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_IY; }
#line 4430 "mon_parse.c"
break;
case 288:
#line 951 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IND_SP; }
#line 4435 "mon_parse.c"
break;
case 289:
#line 953 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_A; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4440 "mon_parse.c"
break;
case 290:
#line 955 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_HL; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4445 "mon_parse.c"
break;
case 291:
#line 957 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IX; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4450 "mon_parse.c"
break;
case 292:
#line 959 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ABSOLUTE_IY; yyval.mode.param = yystack.l_mark[-3].i; }
#line 4455 "mon_parse.c"
break;
case 293:
#line 960 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_IMPLIED; }
#line 4460 "mon_parse.c"
break;
case 294:
#line 961 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_ACCUMULATOR; }
#line 4465 "mon_parse.c"
break;
case 295:
#line 962 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_B; }
#line 4470 "mon_parse.c"
break;
case 296:
#line 963 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_C; }
#line 4475 "mon_parse.c"
break;
case 297:
#line 964 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_D; }
#line 4480 "mon_parse.c"
break;
case 298:
#line 965 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_E; }
#line 4485 "mon_parse.c"
break;
case 299:
#line 966 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_H; }
#line 4490 "mon_parse.c"
break;
case 300:
#line 967 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXH; }
#line 4495 "mon_parse.c"
break;
case 301:
#line 968 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYH; }
#line 4500 "mon_parse.c"
break;
case 302:
#line 969 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_L; }
#line 4505 "mon_parse.c"
break;
case 303:
#line 970 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IXL; }
#line 4510 "mon_parse.c"
break;
case 304:
#line 971 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IYL; }
#line 4515 "mon_parse.c"
break;
case 305:
#line 972 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_AF; }
#line 4520 "mon_parse.c"
break;
case 306:
#line 973 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_BC; }
#line 4525 "mon_parse.c"
break;
case 307:
#line 974 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_DE; }
#line 4530 "mon_parse.c"
break;
case 308:
#line 975 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_HL; }
#line 4535 "mon_parse.c"
break;
case 309:
#line 976 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IX; }
#line 4540 "mon_parse.c"
break;
case 310:
#line 977 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_IY; }
#line 4545 "mon_parse.c"
break;
case 311:
#line 978 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_REG_SP; }
#line 4550 "mon_parse.c"
break;
case 312:
#line 980 "mon_parse.y"
	{ yyval.mode.addr_mode = ASM_ADDR_MODE_DIRECT; yyval.mode.param = yystack.l_mark[0].i; }
#line 4555 "mon_parse.c"
break;
case 313:
#line 981 "mon_parse.y"
	{    /* Clash with addr,x addr,y addr,s modes! */
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-2].i >= -16 && yystack.l_mark[-2].i < 16) {
            yyval.mode.addr_submode = (3 << 5) | (yystack.l_mark[-2].i & 0x1F);
        } else if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = 0x80 | (3 << 5) | ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-2].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4574 "mon_parse.c"
break;
case 314:
#line 996 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
#line 4582 "mon_parse.c"
break;
case 315:
#line 1000 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
#line 4590 "mon_parse.c"
break;
case 316:
#line 1004 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
#line 4598 "mon_parse.c"
break;
case 317:
#line 1008 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
#line 4606 "mon_parse.c"
break;
case 318:
#line 1012 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[0].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
#line 4614 "mon_parse.c"
break;
case 319:
#line 1016 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
#line 4622 "mon_parse.c"
break;
case 320:
#line 1020 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
#line 4630 "mon_parse.c"
break;
case 321:
#line 1024 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
#line 4638 "mon_parse.c"
break;
case 322:
#line 1028 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-2].i;
        if (yystack.l_mark[-2].i >= -128 && yystack.l_mark[-2].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8;
        } else if (yystack.l_mark[-2].i >= -32768 && yystack.l_mark[-2].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4654 "mon_parse.c"
break;
case 323:
#line 1040 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        if (yystack.l_mark[-3].i >= -16 && yystack.l_mark[-3].i < 16) {
            yyval.mode.addr_submode = yystack.l_mark[-3].i & 0x1F;
        } else if (yystack.l_mark[-4].i >= -128 && yystack.l_mark[-4].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF8;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFF16;
            yyval.mode.param = yystack.l_mark[-3].i;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4673 "mon_parse.c"
break;
case 324:
#line 1055 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_INC1;
        }
#line 4681 "mon_parse.c"
break;
case 325:
#line 1059 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-3].i | ASM_ADDR_MODE_INDEXED_INC2;
        }
#line 4689 "mon_parse.c"
break;
case 326:
#line 1063 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC1;
        }
#line 4697 "mon_parse.c"
break;
case 327:
#line 1067 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_DEC2;
        }
#line 4705 "mon_parse.c"
break;
case 328:
#line 1071 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-1].i | ASM_ADDR_MODE_INDEXED_OFF0;
        }
#line 4713 "mon_parse.c"
break;
case 329:
#line 1075 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFB;
        }
#line 4721 "mon_parse.c"
break;
case 330:
#line 1079 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFA;
        }
#line 4729 "mon_parse.c"
break;
case 331:
#line 1083 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | yystack.l_mark[-2].i | ASM_ADDR_MODE_INDEXED_OFFD;
        }
#line 4737 "mon_parse.c"
break;
case 332:
#line 1087 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.param = yystack.l_mark[-3].i;
        if (yystack.l_mark[-3].i >= -128 && yystack.l_mark[-3].i < 128) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC8_IND;
        } else if (yystack.l_mark[-3].i >= -32768 && yystack.l_mark[-3].i < 32768) {
            yyval.mode.addr_submode = ASM_ADDR_MODE_INDEXED_OFFPC16_IND;
        } else {
            yyval.mode.addr_mode = ASM_ADDR_MODE_ILLEGAL;
            mon_out("offset too large even for 16 bits (signed)\n");
        }
    }
#line 4753 "mon_parse.c"
break;
case 333:
#line 1099 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDEXED;
        yyval.mode.addr_submode = 0x80 | ASM_ADDR_MODE_EXTENDED_INDIRECT;
        yyval.mode.param = yystack.l_mark[-1].i;
        }
#line 4762 "mon_parse.c"
break;
case 334:
#line 1104 "mon_parse.y"
	{
        yyval.mode.addr_mode = ASM_ADDR_MODE_INDIRECT_LONG_Y;
        yyval.mode.param = yystack.l_mark[-3].i;
        }
#line 4770 "mon_parse.c"
break;
case 335:
#line 1112 "mon_parse.y"
	{ yyval.i = (0 << 5); printf("reg_x\n"); }
#line 4775 "mon_parse.c"
break;
case 336:
#line 1113 "mon_parse.y"
	{ yyval.i = (1 << 5); printf("reg_y\n"); }
#line 4780 "mon_parse.c"
break;
case 337:
#line 1114 "mon_parse.y"
	{ yyval.i = yystack.l_mark[0].i; }
#line 4785 "mon_parse.c"
break;
case 338:
#line 1115 "mon_parse.y"
	{ yyval.i = (3 << 5); printf("reg_s\n"); }
#line 4790 "mon_parse.c"
break;
case 339:
#line 1119 "mon_parse.y"
	{ yyval.i = (2 << 5); printf("reg_u\n"); }
#line 4795 "mon_parse.c"
break;
#line 4797 "mon_parse.c"
    default:
        break;
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark -= yym;
#endif
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
        {
            fprintf(stderr, "%s[%d]: after reduction, ", YYDEBUGSTR, yydepth);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
            if (!yytrial)
#endif /* YYBTYACC */
                fprintf(stderr, "result is <%s>, ", YYSTYPE_TOSTRING(yystos[YYFINAL], yyval));
#endif
            fprintf(stderr, "shifting from state 0 to final state %d\n", YYFINAL);
        }
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        *++yystack.p_mark = yyloc;
#endif
        if (yychar < 0)
        {
#if YYBTYACC
            do {
            if (yylvp < yylve)
            {
                /* we're currently re-reading tokens */
                yylval = *yylvp++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                yylloc = *yylpp++;
#endif
                yychar = *yylexp++;
                break;
            }
            if (yyps->save)
            {
                /* in trial mode; save scanner results for future parse attempts */
                if (yylvp == yylvlim)
                {   /* Enlarge lexical value queue */
                    size_t p = (size_t) (yylvp - yylvals);
                    size_t s = (size_t) (yylvlim - yylvals);

                    s += YYLVQUEUEGROWTH;
                    if ((yylexemes = (YYINT *)realloc(yylexemes, s * sizeof(YYINT))) == NULL)
                        goto yyenomem;
                    if ((yylvals   = (YYSTYPE *)realloc(yylvals, s * sizeof(YYSTYPE))) == NULL)
                        goto yyenomem;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    if ((yylpsns   = (YYLTYPE *)realloc(yylpsns, s * sizeof(YYLTYPE))) == NULL)
                        goto yyenomem;
#endif
                    yylvp   = yylve = yylvals + p;
                    yylvlim = yylvals + s;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                    yylpp   = yylpe = yylpsns + p;
                    yylplim = yylpsns + s;
#endif
                    yylexp  = yylexemes + p;
                }
                *yylexp = (YYINT) YYLEX;
                *yylvp++ = yylval;
                yylve++;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
                *yylpp++ = yylloc;
                yylpe++;
#endif
                yychar = *yylexp++;
                break;
            }
            /* normal operation, no conflict encountered */
#endif /* YYBTYACC */
            yychar = YYLEX;
#if YYBTYACC
            } while (0);
#endif /* YYBTYACC */
            if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
                fprintf(stderr, "%s[%d]: state %d, reading token %d (%s)\n",
                                YYDEBUGSTR, yydepth, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if (((yyn = yygindex[yym]) != 0) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
    {
        fprintf(stderr, "%s[%d]: after reduction, ", YYDEBUGSTR, yydepth);
#ifdef YYSTYPE_TOSTRING
#if YYBTYACC
        if (!yytrial)
#endif /* YYBTYACC */
            fprintf(stderr, "result is <%s>, ", YYSTYPE_TOSTRING(yystos[yystate], yyval));
#endif
        fprintf(stderr, "shifting from state %d to state %d\n", *yystack.s_mark, yystate);
    }
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    *++yystack.p_mark = yyloc;
#endif
    goto yyloop;
#if YYBTYACC

    /* Reduction declares that this path is valid. Set yypath and do a full parse */
yyvalid:
    if (yypath) YYABORT;
    while (yyps->save)
    {
        YYParseState *save = yyps->save;
        yyps->save = save->save;
        save->save = yypath;
        yypath = save;
    }
#if YYDEBUG
    if (yydebug)
        fprintf(stderr, "%s[%d]: state %d, CONFLICT trial successful, backtracking to state %d, %d tokens\n",
                        YYDEBUGSTR, yydepth, yystate, yypath->state, (int)(yylvp - yylvals - yypath->lexeme));
#endif
    if (yyerrctx)
    {
        yyFreeState(yyerrctx);
        yyerrctx = NULL;
    }
    yylvp          = yylvals + yypath->lexeme;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yylpp          = yylpsns + yypath->lexeme;
#endif
    yylexp         = yylexemes + yypath->lexeme;
    yychar         = YYEMPTY;
    yystack.s_mark = yystack.s_base + (yypath->yystack.s_mark - yypath->yystack.s_base);
    memcpy (yystack.s_base, yypath->yystack.s_base, (size_t) (yystack.s_mark - yystack.s_base + 1) * sizeof(YYINT));
    yystack.l_mark = yystack.l_base + (yypath->yystack.l_mark - yypath->yystack.l_base);
    memcpy (yystack.l_base, yypath->yystack.l_base, (size_t) (yystack.l_mark - yystack.l_base + 1) * sizeof(YYSTYPE));
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
    yystack.p_mark = yystack.p_base + (yypath->yystack.p_mark - yypath->yystack.p_base);
    memcpy (yystack.p_base, yypath->yystack.p_base, (size_t) (yystack.p_mark - yystack.p_base + 1) * sizeof(YYLTYPE));
#endif
    yystate        = yypath->state;
    goto yyloop;
#endif /* YYBTYACC */

yyoverflow:
    YYERROR_CALL("yacc stack overflow");
#if YYBTYACC
    goto yyabort_nomem;
yyenomem:
    YYERROR_CALL("memory exhausted");
yyabort_nomem:
#endif /* YYBTYACC */
    yyresult = 2;
    goto yyreturn;

yyabort:
    yyresult = 1;
    goto yyreturn;

yyaccept:
#if YYBTYACC
    if (yyps->save) goto yyvalid;
#endif /* YYBTYACC */
    yyresult = 0;

yyreturn:
#if defined(YYDESTRUCT_CALL)
    if (yychar != YYEOF && yychar != YYEMPTY)
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        YYDESTRUCT_CALL("cleanup: discarding token", yychar, &yylval, &yylloc);
#else
        YYDESTRUCT_CALL("cleanup: discarding token", yychar, &yylval);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */

    {
        YYSTYPE *pv;
#if defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED)
        YYLTYPE *pp;

        for (pv = yystack.l_base, pp = yystack.p_base; pv <= yystack.l_mark; ++pv, ++pp)
             YYDESTRUCT_CALL("cleanup: discarding state",
                             yystos[*(yystack.s_base + (pv - yystack.l_base))], pv, pp);
#else
        for (pv = yystack.l_base; pv <= yystack.l_mark; ++pv)
             YYDESTRUCT_CALL("cleanup: discarding state",
                             yystos[*(yystack.s_base + (pv - yystack.l_base))], pv);
#endif /* defined(YYLTYPE) || defined(YYLTYPE_IS_DECLARED) */
    }
#endif /* defined(YYDESTRUCT_CALL) */

#if YYBTYACC
    if (yyerrctx)
    {
        yyFreeState(yyerrctx);
        yyerrctx = NULL;
    }
    while (yyps)
    {
        YYParseState *save = yyps;
        yyps = save->save;
        save->save = NULL;
        yyFreeState(save);
    }
    while (yypath)
    {
        YYParseState *save = yypath;
        yypath = save->save;
        save->save = NULL;
        yyFreeState(save);
    }
#endif /* YYBTYACC */
    yyfreestack(&yystack);
    return (yyresult);
}
