# Print GStreamer decoders required by Unreal Engine 4 games.
# USAGE: dependencies_gstreamer_list_unrealengine4 $package
dependencies_gstreamer_list_unrealengine4() {
	local package
	package="$1"

	# Return early if current package should not depend on GStreamer decoders.
	local package_architecture
	package_architecture=$(package_architecture "$package")
	if [ "$package_architecture" = 'all' ]; then
		return 0
	fi

	# Unreal Engine 4 games require specific GStreamer decoders when running through WINE.
	local application_type gstreamer_decoders
	application_type=$(application_default_type)
	case "$application_type" in
		('wine')
			gstreamer_decoders='
			video/quicktime, variant=(string)iso'
		;;
	esac

	printf '%s' "${gstreamer_decoders:-}"
}

