#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Book of Hours expansions:
# - Perpetual Edition
###

script_version=20240531.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='book-of-hours'
GAME_NAME='Book of Hours'

EXPANSION_ID_PERPETUAL='perpetual-edition'
EXPANSION_NAME_PERPETUAL='Perpetual Edition'

# Archives

## Perpetual Edition

ARCHIVE_BASE_PERPETUAL_8_NAME='book_of_hours_perpetual_edition_content_2024_3_e_15_72083.sh'
ARCHIVE_BASE_PERPETUAL_8_MD5='2b21b55d6889a4c18ae57cbb1b22cb04'
ARCHIVE_BASE_PERPETUAL_8_SIZE='75087'
ARCHIVE_BASE_PERPETUAL_8_VERSION='2024.03.e.15-gog72083'

ARCHIVE_BASE_PERPETUAL_7_NAME='book_of_hours_perpetual_edition_content_2024_2_e_11_71531.sh'
ARCHIVE_BASE_PERPETUAL_7_MD5='a120f5371c1297a8ae13095b7ee3ccdb'
ARCHIVE_BASE_PERPETUAL_7_SIZE='75087'
ARCHIVE_BASE_PERPETUAL_7_VERSION='2024.02.e.11-gog71531'

ARCHIVE_BASE_PERPETUAL_6_NAME='book_of_hours_perpetual_edition_content_2023_12_d_12_69519.sh'
ARCHIVE_BASE_PERPETUAL_6_MD5='77796819b6f4a466fed0638fcb685412'
ARCHIVE_BASE_PERPETUAL_6_SIZE='75408'
ARCHIVE_BASE_PERPETUAL_6_VERSION='2023.12.d.12-gog69519'

ARCHIVE_BASE_PERPETUAL_3_NAME='book_of_hours_perpetual_edition_content_2023_11_d_4_69228.sh'
ARCHIVE_BASE_PERPETUAL_3_MD5='d5bb3e49df9b8c142ac25aed53c78d01'
ARCHIVE_BASE_PERPETUAL_3_SIZE='75404'
ARCHIVE_BASE_PERPETUAL_3_VERSION='2023.11.d.4-gog69228'

ARCHIVE_BASE_PERPETUAL_2_NAME='book_of_hours_perpetual_edition_content_2023_10_c_11_68174.sh'
ARCHIVE_BASE_PERPETUAL_2_MD5='0be5366899fdd4f209153a2671ca87ba'
ARCHIVE_BASE_PERPETUAL_2_SIZE='75404'
ARCHIVE_BASE_PERPETUAL_2_VERSION='2023.10.c.11-gog68174'

ARCHIVE_BASE_PERPETUAL_1_NAME='book_of_hours_perpetual_edition_content_2023_9_b_12_67790.sh'
ARCHIVE_BASE_PERPETUAL_1_MD5='a0eafa7c516ad47b0c58e9af037b99b1'
ARCHIVE_BASE_PERPETUAL_1_SIZE='75408'
ARCHIVE_BASE_PERPETUAL_1_VERSION='2023.09.b.12-gog67790'

ARCHIVE_BASE_PERPETUAL_0_NAME='book_of_hours_perpetual_edition_content_2023_8_g_2_67165.sh'
ARCHIVE_BASE_PERPETUAL_0_MD5='c426a4968539633c0d0959744ea3d671'
ARCHIVE_BASE_PERPETUAL_0_SIZE='75408'
ARCHIVE_BASE_PERPETUAL_0_VERSION='2023.08.g.2-gog67165'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES_PERPETUAL='
bh_Data/StreamingAssets/edition/semper.txt'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
