#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Flame in the Flood
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220306.3

# Set game-specific variables

GAME_ID='the-flame-in-the-flood'
GAME_NAME='The Flame in the Flood'

ARCHIVE_BASE_0='setup_the_flame_in_the_flood_1.3.003_(31352).exe'
ARCHIVE_BASE_0_MD5='c58e4985cb0a93a27f6bcd542a313ff1'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='2900000'
ARCHIVE_BASE_0_VERSION='1.3.003-gog31352'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_flame_in_the_flood'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
engine
rivergame.exe'
ARCHIVE_GAME_DATA_FILES='
rivergame'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='rivergame.exe'
APP_MAIN_ICON='rivergame.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID wine"
PKG_BIN_DEPS_ARCH='gst-plugins-base gst-plugins-good gst-libav'
PKG_BIN_DEPS_DEB='gstreamer1.0-plugins-base, gstreamer1.0-plugins-good, gstreamer1.0-libav'
PKG_BIN_DEPS_GENTOO='media-libs/gst-plugins-base media-libs/gst-plugins-good media-plugins/gst-plugins-libav'

# Use persistent storage for user data

APP_WINE_LINK_DIRS='
userdata:users/${USER}/Local Settings/Application Data/RiverGame/Saved
userdata:users/${USER}/AppData/Local/RiverGame/Saved'
CONFIG_DIRS='userdata/Config'
DATA_DIRS='userdata/SaveGames'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'

# Delete temporary directories

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
