#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Regency Solitaire
# send your bug reports to contact@dotslashplay.it
###

script_version=20231001.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='regency-solitaire'
GAME_NAME='Regency Solitaire'

ARCHIVE_BASE_0='RegencySolitaireV117b_1472495785.tar.gz'
ARCHIVE_BASE_0_MD5='15e8377d2cac99a52407cb399bd1ee7c'
ARCHIVE_BASE_0_SIZE='71000'
ARCHIVE_BASE_0_VERSION='1.17b-humble160829'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/regency-solitaire'

ARCHIVE_ICONS_PATH='.'

CONTENT_PATH_DEFAULT='RegencySolitaireV117b'
CONTENT_GAME_BIN_FILES='
RegencySolitaire'
CONTENT_GAME_DATA_FILES='
data'

APP_MAIN_EXE='RegencySolitaire'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libGL.so.1
libGLU.so.1
libm.so.6
libpthread.so.0
libstdc++.so.6'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
ARCHIVE_OPTIONAL_ICONS_0_NAME='regency-solitaire_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_0_MD5='01a7c7b168e2cb315d2058ff5e6a53aa'
ARCHIVE_OPTIONAL_ICONS_0_URL='https://downloads.dotslashplay.it/games/regency-solitaire/'
archive_initialize_optional \
	'ARCHIVE_ICONS' \
	'ARCHIVE_OPTIONAL_ICONS'
## TODO: The library should provide a function to check if a given optional archive has been provided.
if [ -n "$(archive_path 'ARCHIVE_ICONS' 2>/dev/null || true)" ]; then
	archive_extraction 'ARCHIVE_ICONS'
fi

# Include game data

## TODO: The library should provide a function to check if a given optional archive has been provided.
if [ -n "$(archive_path 'ARCHIVE_ICONS' 2>/dev/null || true)" ]; then
	CONTENT_ICONS_DATA_PATH='.'
	CONTENT_ICONS_DATA_FILES='
	16x16
	32x32
	48x48
	256x256'
	content_inclusion 'ICONS_DATA' 'PKG_DATA' "$(path_icons)"
fi
content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
