#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Anna Lea
set -o errexit

###
# Detention
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20221203.1

# Set game-specific variables

GAME_ID='detention'
GAME_NAME='Detention'

ARCHIVE_BASE_0='Detention-linux(7821293f).zip'
ARCHIVE_BASE_0_MD5='44f4a6847260f6ef460b4e44239e1859'
ARCHIVE_BASE_0_TYPE='zip'
ARCHIVE_BASE_0_SIZE='2200000'
ARCHIVE_BASE_0_VERSION='7821293f'
ARCHIVE_BASE_0_URL='https://shop.redcandlegames.com/games/detention'

ARCHIVE_GAME_BIN_PATH='Detention'
ARCHIVE_GAME_BIN_FILES='Detention.x64 Detention_Data/Mono/x86_64 Detention_Data/Plugins/x86_64'

ARCHIVE_GAME_DATA_PATH='Detention'
ARCHIVE_GAME_DATA_FILES='Detention_Data'

APP_MAIN_TYPE='native'
APP_MAIN_EXE='Detention.x64'
APP_MAIN_ICON='Detention_Data/Resources/UnityPlayer.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="${PKG_DATA_ID} glibc libgdk-x11-2.0.so.0 libgdk_pixbuf-2.0.so.0 libglib-2.0.so.0 libgobject-2.0.so.0 libstdc++ libz.so.1"

# Use a per-session dedicated file for logs

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Use a per-session dedicated file for logs
mkdir --parents logs
APP_OPTIONS="${APP_OPTIONS} -logFile ./logs/$(date +%F-%R).log"'

# Load common functions

target_version='2.13'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "${path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Get game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Clean up temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "${PLAYIT_WORKDIR}"

# Print instructions

print_instructions

exit 0
