/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_MemoryConformsToProfile.h"
#include "OpenDRIM_MemoryConformsToProfileAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define SystemMemory_OpenDRIM_MemoryConformsToProfileProviderSetInstance SystemMemory_OpenDRIM_MemoryConformsToProfileProviderModifyInstance
#endif

int SystemMemory_OpenDRIM_MemoryConformsToProfile_init(const CMPIBroker* broker);

int SystemMemory_OpenDRIM_MemoryConformsToProfile_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_MemoryConformsToProfile> instances;
	string errorMessage;
	
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = SystemMemory_OpenDRIM_MemoryConformsToProfile_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_MemoryConformsToProfile> instances;
	string errorMessage;
	
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = SystemMemory_OpenDRIM_MemoryConformsToProfile_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_MemoryConformsToProfile instance;
	SystemMemory_OpenDRIM_MemoryConformsToProfile_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = SystemMemory_OpenDRIM_MemoryConformsToProfile_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_MemoryConformsToProfile newInstance, oldInstance;
	SystemMemory_OpenDRIM_MemoryConformsToProfile_toCPP(_broker, ci, newInstance);
	SystemMemory_OpenDRIM_MemoryConformsToProfile_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_MemoryConformsToProfile instance;
	SystemMemory_OpenDRIM_MemoryConformsToProfile_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = SystemMemory_OpenDRIM_MemoryConformsToProfile_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_MemoryConformsToProfile instance;
	SystemMemory_OpenDRIM_MemoryConformsToProfile_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                     Association Provider Interface                         */
/* ---------------------------------------------------------------------------*/

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderAssociationCleanup(CMPIAssociationMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderAssociatorNames(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* resultClass, const char* role, const char* resultRole) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_associator(_broker, ctx, cop, known, assocClass, resultClass, role, resultRole, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associatedInstances.size(); i++)
		CMReturnObjectPath(rslt, associatedInstances[i].getObjectpath().getHdl());
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderAssociators(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_associator(_broker, ctx, cop, known, assocClass, resultClass, role, resultRole, properties, associatedInstances, leftToRight, errorMessage, "a");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associatedInstances.size(); i++)
		CMReturnInstance(rslt, associatedInstances[i].getHdl());
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderReferenceNames(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* role) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_associator(_broker, ctx, cop, known, assocClass, NULL, role, NULL, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	vector<OpenDRIM_MemoryConformsToProfile> associationInstances;
	if (leftToRight)
		errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_referenceConformantStandardToManagedElement(_broker, ctx, known, associatedInstances, associationInstances, NULL, errorMessage, "rn");
	else
		errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_referenceManagedElementToConformantStandard(_broker, ctx, known, associatedInstances, associationInstances, NULL, errorMessage, "rn");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associationInstances.size(); i++) {
		CMPIObjectPath* op = SystemMemory_OpenDRIM_MemoryConformsToProfile_toCMPIObjectPath(_broker, associationInstances[i]);
		CMReturnObjectPath(rslt, op);
	}
	_L_;
	return rc;
}

CMPIStatus SystemMemory_OpenDRIM_MemoryConformsToProfileProviderReferences(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* role, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_associator(_broker, ctx, cop, known, assocClass, NULL, role, NULL, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	vector<OpenDRIM_MemoryConformsToProfile> associationInstances;
	if (leftToRight)
		errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_referenceConformantStandardToManagedElement(_broker, ctx, known, associatedInstances, associationInstances, properties, errorMessage, "r");
	else
		errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_referenceManagedElementToConformantStandard(_broker, ctx, known, associatedInstances, associationInstances, properties, errorMessage, "r");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associationInstances.size(); i++) {
		CMPIInstance* inst = SystemMemory_OpenDRIM_MemoryConformsToProfile_toCMPIInstance(_broker, associationInstances[i]);
		CMReturnInstance(rslt, inst);
	}
	_L_;
	return rc;
}

/* ---------------------------------------------------------------------------*/
/*                  End Of Association Provider Interface                     */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int SystemMemory_OpenDRIM_MemoryConformsToProfile_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "SystemMemory_OpenDRIM_MemoryConformsToProfile_init FAILED: " + (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int SystemMemory_OpenDRIM_MemoryConformsToProfile_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = SystemMemory_OpenDRIM_MemoryConformsToProfile_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "SystemMemory_OpenDRIM_MemoryConformsToProfile_unload FAILED: " + (string) OpenDRIM_MemoryConformsToProfile_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define SystemMemory_OpenDRIM_MemoryConformsToProfile_INIT if (SystemMemory_OpenDRIM_MemoryConformsToProfile_init(_broker) < 0) return NULL

CMInstanceMIStub(SystemMemory_OpenDRIM_MemoryConformsToProfileProvider, SystemMemory_OpenDRIM_MemoryConformsToProfileProvider, _broker, SystemMemory_OpenDRIM_MemoryConformsToProfile_INIT);
CMAssociationMIStub(SystemMemory_OpenDRIM_MemoryConformsToProfileProvider, SystemMemory_OpenDRIM_MemoryConformsToProfileProvider, _broker, SystemMemory_OpenDRIM_MemoryConformsToProfile_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
