/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.wizards.ContextPropertyStore;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.wizard.AbstractRemoteDebugSession;
import com.nvidia.cuda.ide.remote.internal.wizard.IDebugWizardProperties;
import com.nvidia.cuda.ide.remote.internal.wizard.RemoteConnectMainWizardPage;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.wizard.IWizardPage;

public final class RemoteConnectDebugSession
extends AbstractRemoteDebugSession {
    public static final PropertyDescriptor<Boolean> PROPERTY_DOWNLOAD_FILE = new PropertyDescriptor("download.remote.file", Boolean.class);

    @Override
    public String getName() {
        return "Connect to cuda-gdbserver";
    }

    @Override
    public IWizardPage[] createWizardPages() {
        return new IWizardPage[]{new RemoteConnectMainWizardPage(this.context)};
    }

    @Override
    public String getDescription() {
        return "Connects to a running debug server";
    }

    @Override
    protected void recomputeDefaults(ContextPropertyStore defaultsStore, IProgressMonitor monitor) {
        defaultsStore.setProperty(PROPERTY_DOWNLOAD_FILE, (Object)true);
        IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(PROPERTY_REMOTE_CONNECTION);
        if (connection != null) {
            defaultsStore.setProperty(IDebugWizardProperties.PROPERTY_LAUNCH_CONFIGURATION_NAME, (Object)String.format("Connect to %s on port %d", connection.getName(), this.context.getProperty(PROPERTY_REMOTE_PORT)));
        }
        this.updateContextConnectionProperties();
    }

    @Override
    protected boolean shouldRecomputeDefaults(PropertyDescriptor<?> property) {
        return CoreUtil.isOneOf(property, (Object[])new Object[]{PROPERTY_LOCAL_EXECUTABLE_PATH, PROPERTY_REMOTE_CONNECTION, PROPERTY_DOWNLOAD_FILE});
    }

    @Override
    protected void fillLaunchConfigurationProperties(ILaunchConfigurationWorkingCopy lc, IRemoteConnection connection) {
        ICudaRemoteDebugConstants.ExecutableTransferMode transferMode = (Boolean)this.context.getProperty(PROPERTY_DOWNLOAD_FILE) != false ? ICudaRemoteDebugConstants.ExecutableTransferMode.Download : ICudaRemoteDebugConstants.ExecutableTransferMode.Notransfer;
        lc.setAttribute(ICudaRemoteDebugConstants.ATTRIBUTE_EXECUTABLE_TRANSFER, transferMode.name());
    }

    @Override
    protected void fillExecutableProperties(ILaunchConfigurationWorkingCopy lc) {
        if (!((Boolean)this.context.getProperty(PROPERTY_DOWNLOAD_FILE)).booleanValue()) {
            super.fillExecutableProperties(lc);
        } else {
            lc.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, (String)this.context.getProperty(PROPERTY_REMOTE_EXECUTABLE));
        }
    }

    @Override
    protected String getLaunchConfigurationType() {
        return "com.nvidia.cuda.ide.remote.connectlaunch";
    }

    @Override
    protected void saveDefaults(IRemoteConnection connection) {
    }

    @Override
    public boolean isEditable(PropertyDescriptor<?> property) {
        return true;
    }
}

