/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.common.wizards.ContextPropertyStore;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.wizard.DebugWizardFirstPage;
import com.nvidia.cuda.ide.remote.internal.wizard.IDebugSessionType;
import com.nvidia.cuda.ide.remote.internal.wizard.IDebugWizardProperties;
import com.nvidia.cuda.ide.remote.internal.wizard.LaunchConfigurationPage;
import com.nvidia.cuda.ide.remote.ui.launch.LaunchMode;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.FrameworkUtil;

public final class DebugWizard
extends Wizard {
    private WizardContext context;
    private IWizardPage firstPage;
    private final boolean immediate;
    private IWizardPage lastPage;
    private ILaunchConfiguration launchConfiguration;
    private final LaunchMode mode;
    private final Map<IDebugSessionType, IWizardPage[]> pages = new HashMap<IDebugSessionType, IWizardPage[]>();
    private ISelection selection;
    private IDebugSessionType sessionType = null;

    public DebugWizard(LaunchMode mode, boolean immediate) {
        this.mode = mode;
        this.immediate = immediate;
        this.setWindowTitle(mode.visit(new LaunchMode.Visitor<String>(){

            @Override
            public String debug() {
                return "Debug CUDA Application";
            }

            @Override
            public String profile() {
                return "Profile CUDA Application";
            }

            @Override
            public String run() {
                return "Run CUDA Application";
            }
        }));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        IWizardPage[] defaultPages;
        if (this.sessionType == null) {
            this.firstPage = new DebugWizardFirstPage(this.getContext());
        }
        this.lastPage = new LaunchConfigurationPage(this.getContext(), this.immediate);
        if (this.firstPage != null) {
            defaultPages = new IWizardPage[]{this.firstPage, this.lastPage};
            this.addPage(this.firstPage);
        } else {
            defaultPages = new IWizardPage[]{this.lastPage};
        }
        this.addPage(this.lastPage);
        this.pages.put(null, defaultPages);
        if (this.sessionType != null) {
            this.updateSessionType(this.sessionType, true);
        }
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.firstPage) {
            return false;
        }
        IWizardPage page = this.getStartingPage();
        while (page != null) {
            if (page != this.firstPage && !page.isPageComplete()) {
                return false;
            }
            page = this.getNextPage(page);
        }
        return true;
    }

    private synchronized WizardContext getContext() {
        if (this.context == null) {
            this.context = new WizardContext(this.getContainer());
            ContextPropertyStore defaultsStore = this.context.getPropertiesStore().newDefaultsStore();
            defaultsStore.setProperty(IDebugWizardProperties.PROPERTY_START_IMMEDIATELY, (Object)true);
            defaultsStore.setProperty(IDebugWizardProperties.PROPERTY_OPEN_LC_DIALOG, (Object)true);
            defaultsStore.setProperty(IDebugWizardProperties.PROPERTY_LAUNCH_MODE, (Object)this.mode);
            if (this.selection instanceof IStructuredSelection) {
                this.context.setProperty(IDebugWizardProperties.PROPERTY_SELECTION, (Object)((IStructuredSelection)this.selection));
            }
            if (this.sessionType != null) {
                this.sessionType.init(this.context);
                this.context.setProperty(IDebugWizardProperties.PROPERTY_DEBUG_SESSION_TYPE, (Object)this.sessionType);
            }
            IObservableValue value = this.context.observeProperty(IDebugWizardProperties.PROPERTY_DEBUG_SESSION_TYPE);
            DataBindingContext ctx = new DataBindingContext(SWTObservables.getRealm((Display)this.getContainer().getShell().getDisplay()));
            ctx.bindValue(value, (IObservableValue)new AbstractObservableValue(){

                protected Object doGetValue() {
                    return null;
                }

                protected void doSetValue(Object value) {
                    DebugWizard.this.updateSessionType((IDebugSessionType)value, false);
                }

                public Object getValueType() {
                    return IDebugSessionType.class;
                }
            }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        }
        return this.context;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.lastPage) {
            return null;
        }
        IWizardPage[] wizardPages = this.pages.get(this.getSessionType());
        int i = 0;
        while (i < wizardPages.length - 1) {
            if (page == wizardPages[i]) {
                return wizardPages[i + 1];
            }
            ++i;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.getStartingPage()) {
            return null;
        }
        IWizardPage[] wizardPages = this.pages.get(this.getSessionType());
        int i = 1;
        while (i < wizardPages.length) {
            if (page == wizardPages[i]) {
                return wizardPages[i - 1];
            }
            ++i;
        }
        return null;
    }

    private IDebugSessionType getSessionType() {
        return (IDebugSessionType)this.context.getProperty(IDebugWizardProperties.PROPERTY_DEBUG_SESSION_TYPE);
    }

    public IWizardPage getStartingPage() {
        if (this.firstPage != null) {
            return this.firstPage;
        }
        return this.pages.get(this.sessionType)[0];
    }

    public boolean performFinish() {
        final WizardContext wizardContext = this.getContext();
        IDebugSessionType sessionType = (IDebugSessionType)wizardContext.getProperty(IDebugWizardProperties.PROPERTY_DEBUG_SESSION_TYPE);
        if (sessionType == null) {
            return false;
        }
        try {
            final ILaunchConfiguration configuration = sessionType.createLaunchConfiguration();
            if (configuration != null) {
                if (this.immediate) {
                    this.launchConfiguration = configuration;
                } else {
                    this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DebugWizard.this.performUserAction(wizardContext, configuration);
                        }
                    });
                }
                return true;
            }
            return false;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, FrameworkUtil.getBundle(sessionType.getClass()).getSymbolicName(), "Unable to create a launch configuration", (Throwable)e), 3);
            return false;
        }
    }

    private void performUserAction(WizardContext wizardContext, final ILaunchConfiguration configuration) {
        final LaunchMode launchMode = (LaunchMode)((Object)wizardContext.getProperty(IDebugWizardProperties.PROPERTY_LAUNCH_MODE));
        if (((Boolean)wizardContext.getProperty(IDebugWizardProperties.PROPERTY_START_IMMEDIATELY)).booleanValue()) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            DebugUITools.buildAndLaunch((ILaunchConfiguration)configuration, (String)launchMode.getPlatformString(), (IProgressMonitor)monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                InvocationTargetException t = cause != null && cause instanceof CoreException ? cause : e;
                StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)t, (String)"Launching failed.", (Object[])new Object[0]), 3);
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
        } else if (((Boolean)wizardContext.getProperty(IDebugWizardProperties.PROPERTY_OPEN_LC_DIALOG)).booleanValue()) {
            DebugUITools.openLaunchConfigurationDialog((Shell)SWTUtil.getShell(), (ILaunchConfiguration)configuration, (String)"org.eclipse.debug.ui.launchGroup.debug", null);
        }
    }

    protected final IWizardPage[] preparePageArray(IWizardPage[] sessionPages) {
        int pageCount = sessionPages != null ? sessionPages.length : 0;
        pageCount += this.firstPage != null ? 1 : 0;
        IWizardPage[] array = new IWizardPage[pageCount += this.lastPage != null ? 1 : 0];
        int ind = 0;
        if (this.firstPage != null) {
            array[ind++] = this.firstPage;
        }
        if (!CoreUtil.isNullOrEmpty((Object[])sessionPages)) {
            System.arraycopy(sessionPages, 0, array, ind, sessionPages.length);
        }
        if (this.lastPage != null) {
            array[array.length - 1] = this.lastPage;
        }
        return array;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public void setSessionType(IDebugSessionType sessionType) {
        this.sessionType = sessionType;
    }

    protected void updateSessionType(final IDebugSessionType value, boolean immediate) {
        IWizardPage[] sessionPages;
        if (!this.pages.containsKey(value) && (sessionPages = this.pages.get(value)) == null) {
            try {
                if (!immediate) {
                    this.getContainer().run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            value.setDefaults(monitor);
                        }
                    });
                } else {
                    value.setDefaults((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (InvocationTargetException e) {
                Activator.log(e);
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
            IWizardPage[] iWizardPageArray = sessionPages = value.createWizardPages();
            int n = sessionPages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                this.addPage(page);
                ++n2;
            }
            IWizardPage[] array = this.preparePageArray(sessionPages);
            this.pages.put(value, array);
        }
        if (!immediate) {
            IWizardContainer container = this.getContainer();
            container.updateButtons();
            if (container instanceof IWizardContainer2) {
                ((IWizardContainer2)container).updateSize();
            }
        }
    }
}

