/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.utils.debug.DebugParameterKind;
import org.eclipse.cdt.utils.debug.DebugType;
import org.eclipse.cdt.utils.debug.DebugVariableKind;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.tools.DebugSym;

public class DebugSymsRequestor
implements IDebugEntryRequestor {
    DebugSym currentCU;
    DebugSym currentFunction;
    List<DebugSym> list = new ArrayList<DebugSym>();

    public DebugSym[] getSortedEntries() {
        Object[] syms = this.getEntries();
        Arrays.sort(syms);
        return syms;
    }

    public DebugSym[] getEntries() {
        DebugSym[] syms = new DebugSym[this.list.size()];
        this.list.toArray(syms);
        return syms;
    }

    public DebugSym getEntry(long addr) {
        Object[] entries = this.getSortedEntries();
        int insertion = Arrays.binarySearch(entries, new Long(addr));
        if (insertion >= 0) {
            return entries[insertion];
        }
        if (insertion == -1) {
            return null;
        }
        insertion = -insertion - 1;
        Object entry = entries[insertion - 1];
        if (addr < ((DebugSym)entry).addr + ((DebugSym)entry).size) {
            return entries[insertion - 1];
        }
        return null;
    }

    @Override
    public void enterCompilationUnit(String name, long address) {
        DebugSym sym = new DebugSym();
        sym.name = name;
        sym.addr = address;
        sym.type = "CU";
        sym.filename = name;
        this.currentCU = sym;
        this.list.add(sym);
    }

    @Override
    public void exitCompilationUnit(long address) {
        if (this.currentCU != null) {
            this.currentCU.size = address;
        }
        this.currentCU = null;
    }

    @Override
    public void enterInclude(String name) {
    }

    @Override
    public void exitInclude() {
    }

    @Override
    public void enterFunction(String name, DebugType type, boolean isGlobal, long address) {
        DebugSym sym = new DebugSym();
        sym.name = name;
        sym.addr = address;
        sym.type = "Func";
        if (this.currentCU != null) {
            sym.filename = this.currentCU.filename;
        }
        this.currentFunction = sym;
        this.list.add(sym);
    }

    @Override
    public void exitFunction(long address) {
        if (this.currentFunction != null) {
            this.currentFunction.size = address;
        }
        this.currentFunction = null;
    }

    @Override
    public void enterCodeBlock(long offset) {
    }

    @Override
    public void exitCodeBlock(long offset) {
    }

    @Override
    public void acceptStatement(int line, long address) {
        DebugSym sym = new DebugSym();
        sym.name = "";
        sym.addr = address;
        sym.startLine = line;
        sym.type = "SLINE";
        if (this.currentFunction != null) {
            if (this.currentFunction.startLine == 0) {
                this.currentFunction.startLine = line;
            }
            this.currentFunction.endLine = line;
        }
        if (this.currentCU != null) {
            sym.filename = this.currentCU.filename;
        }
        this.list.add(sym);
    }

    @Override
    public void acceptIntegerConst(String name, int value) {
    }

    @Override
    public void acceptFloatConst(String name, double value) {
    }

    @Override
    public void acceptTypeConst(String name, DebugType type, int value) {
    }

    @Override
    public void acceptParameter(String name, DebugType type, DebugParameterKind kind, long offset) {
        DebugSym sym = new DebugSym();
        sym.name = name;
        sym.addr = offset;
        sym.type = "PARAM";
        if (this.currentCU != null) {
            sym.filename = this.currentCU.filename;
        }
        this.list.add(sym);
    }

    @Override
    public void acceptVariable(String name, DebugType type, DebugVariableKind kind, long address) {
        DebugSym sym = new DebugSym();
        sym.name = name;
        sym.addr = address;
        sym.type = "VAR";
        if (this.currentCU != null) {
            sym.filename = this.currentCU.filename;
        }
        this.list.add(sym);
    }

    @Override
    public void acceptCaughtException(String name, DebugType type, long address) {
    }

    @Override
    public void acceptTypeDef(String name, DebugType type) {
    }
}

