/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;

public class CPPASTCatchHandler
extends ASTAttributeOwner
implements ICPPASTCatchHandler,
IASTAmbiguityParent {
    private boolean isCatchAll;
    private IASTStatement body;
    private IASTDeclaration declaration;
    private IScope scope;

    public CPPASTCatchHandler() {
    }

    public CPPASTCatchHandler(IASTDeclaration declaration, IASTStatement body) {
        this.setCatchBody(body);
        this.setDeclaration(declaration);
    }

    @Override
    public CPPASTCatchHandler copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTCatchHandler copy(IASTNode.CopyStyle style) {
        CPPASTCatchHandler copy = new CPPASTCatchHandler();
        copy.setDeclaration(this.declaration == null ? null : this.declaration.copy(style));
        copy.setCatchBody(this.body == null ? null : this.body.copy(style));
        copy.setIsCatchAll(this.isCatchAll);
        return this.copy(copy, style);
    }

    @Override
    public void setIsCatchAll(boolean isEllipsis) {
        this.assertNotFrozen();
        this.isCatchAll = isEllipsis;
    }

    @Override
    public boolean isCatchAll() {
        return this.isCatchAll;
    }

    @Override
    public void setCatchBody(IASTStatement compoundStatement) {
        this.assertNotFrozen();
        this.body = compoundStatement;
        if (compoundStatement != null) {
            compoundStatement.setParent(this);
            compoundStatement.setPropertyInParent(CATCH_BODY);
        }
    }

    @Override
    public IASTStatement getCatchBody() {
        return this.body;
    }

    @Override
    public void setDeclaration(IASTDeclaration decl) {
        this.assertNotFrozen();
        this.declaration = decl;
        if (decl != null) {
            decl.setParent(this);
            decl.setPropertyInParent(DECLARATION);
        }
    }

    @Override
    public IASTDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.declaration != null && !this.declaration.accept(action)) {
            return false;
        }
        if (this.body != null && !this.body.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.body == child) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.body = (IASTStatement)other;
        }
        if (this.declaration == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.declaration = (IASTDeclaration)other;
        }
    }

    @Override
    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CPPBlockScope(this);
        }
        return this.scope;
    }
}

