/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class MinGW {
    public static final String ENV_MINGW_HOME = "MINGW_HOME";
    public static final String ENV_MSYS_HOME = "MSYS_HOME";
    private static final String ENV_PATH = "PATH";
    private static final boolean isWindowsPlatform = Platform.getOS().equals("win32");
    private static String envPathValueCached = null;
    private static String envMinGWHomeValueCached = null;
    private static String minGWLocation = null;
    private static boolean isMinGWLocationCached = false;
    private static String envMinGWHomeValueCached_msys = null;
    private static String mSysLocation = null;
    private static boolean isMSysLocationCached = false;
    private static final Map<String, String> mingwLocationCache = Collections.synchronizedMap(new WeakHashMap(1));

    private static String findMinGWRoot(String envPathValue, String envMinGWHomeValue) {
        Path installPath;
        IPath mingwBinDir;
        Path mingwBinDir2;
        String rootValue = null;
        if (envMinGWHomeValue != null && !envMinGWHomeValue.isEmpty() && (mingwBinDir2 = new Path(String.valueOf(envMinGWHomeValue) + "\\bin")).toFile().isDirectory()) {
            rootValue = mingwBinDir2.removeLastSegments(1).toOSString();
        }
        if (rootValue == null && (mingwBinDir = (installPath = new Path(Platform.getInstallLocation().getURL().getFile())).append("mingw\\bin")).toFile().isDirectory()) {
            rootValue = mingwBinDir.removeLastSegments(1).toOSString();
        }
        if (rootValue == null) {
            rootValue = MinGW.findMingwInPath(envPathValue);
        }
        if (rootValue == null && (mingwBinDir2 = new Path("C:\\MinGW")).toFile().isDirectory()) {
            rootValue = mingwBinDir2.toOSString();
        }
        return rootValue;
    }

    private static String findMingwInPath(String envPath) {
        String mingwLocation;
        IEnvironmentVariable varPath;
        if (envPath == null && (varPath = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_PATH, null, true)) != null) {
            envPath = varPath.getValue();
        }
        if ((mingwLocation = mingwLocationCache.get(envPath)) == null && !mingwLocationCache.containsKey(envPath)) {
            IPath gccLoc;
            IPath gcc64Loc;
            if ("x86_64".equals(Platform.getOSArch()) && (gcc64Loc = PathUtil.findProgramLocation("x86_64-w64-mingw32-gcc.exe", envPath)) != null) {
                mingwLocation = gcc64Loc.removeLastSegments(2).toOSString();
            }
            if (mingwLocation == null && (gccLoc = PathUtil.findProgramLocation("mingw32-gcc.exe", envPath)) != null) {
                mingwLocation = gccLoc.removeLastSegments(2).toOSString();
            }
            mingwLocationCache.put(envPath, mingwLocation);
        }
        return mingwLocation;
    }

    private static String findMSysRoot(String envMinGWHomeValue) {
        Path defaultMsysBin;
        Path minGwMsysBin;
        String msysHome = null;
        Path installPath = new Path(Platform.getInstallLocation().getURL().getFile());
        IPath installMsysBin = installPath.append("msys\\bin");
        if (installMsysBin.toFile().isDirectory()) {
            msysHome = installMsysBin.removeLastSegments(1).toOSString();
        }
        if (msysHome == null && envMinGWHomeValue != null && !envMinGWHomeValue.isEmpty() && (minGwMsysBin = new Path(String.valueOf(envMinGWHomeValue) + "\\msys\\1.0\\bin")).toFile().isDirectory()) {
            msysHome = minGwMsysBin.removeLastSegments(1).toOSString();
        }
        if (msysHome == null && (minGwMsysBin = new Path("C:\\MinGW\\msys\\1.0\\bin")).toFile().isDirectory()) {
            msysHome = minGwMsysBin.removeLastSegments(1).toOSString();
        }
        if (msysHome == null && (defaultMsysBin = new Path("C:\\msys\\1.0\\bin")).toFile().isDirectory()) {
            msysHome = defaultMsysBin.removeLastSegments(1).toOSString();
        }
        return msysHome;
    }

    public static String getMinGWHome() {
        String envMinGWHomeValue;
        if (!isWindowsPlatform) {
            return null;
        }
        IEnvironmentVariable varPath = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_PATH, null, true);
        String envPathValue = varPath != null ? varPath.getValue() : null;
        IEnvironmentVariable varMinGWHome = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_MINGW_HOME, null, true);
        String string = envMinGWHomeValue = varMinGWHome != null ? varMinGWHome.getValue() : null;
        if (isMinGWLocationCached && CDataUtil.objectsEqual(envPathValue, envPathValueCached) && CDataUtil.objectsEqual(envMinGWHomeValue, envMinGWHomeValueCached)) {
            return minGWLocation;
        }
        minGWLocation = MinGW.findMinGWRoot(envPathValue, envMinGWHomeValue);
        envPathValueCached = envPathValue;
        envMinGWHomeValueCached = envMinGWHomeValue;
        isMinGWLocationCached = true;
        return minGWLocation;
    }

    public static String getMSysHome() {
        String msysHomeValue;
        if (!isWindowsPlatform) {
            return null;
        }
        IEnvironmentVariable varMsysHome = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_MSYS_HOME, null, true);
        String string = msysHomeValue = varMsysHome != null ? varMsysHome.getValue() : null;
        if (msysHomeValue != null) {
            return msysHomeValue;
        }
        String envMinGWHomeValue = MinGW.getMinGWHome();
        if (isMSysLocationCached && CDataUtil.objectsEqual(envMinGWHomeValue, envMinGWHomeValueCached_msys)) {
            return mSysLocation;
        }
        mSysLocation = MinGW.findMSysRoot(envMinGWHomeValue);
        envMinGWHomeValueCached_msys = envMinGWHomeValue;
        isMSysLocationCached = true;
        return mSysLocation;
    }

    public static boolean isAvailable(String envPath) {
        return isWindowsPlatform && MinGW.findMingwInPath(envPath) != null;
    }

    public static boolean isAvailable() {
        return isWindowsPlatform && MinGW.findMingwInPath(null) != null;
    }
}

