/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.git.ui.preferences;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.ptp.internal.rdt.sync.git.core.CommandRunner;
import org.eclipse.ptp.internal.rdt.sync.git.ui.Activator;
import org.eclipse.ptp.internal.rdt.sync.git.ui.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.RecursiveSubMonitor;
import org.eclipse.ptp.rdt.sync.core.exceptions.RemoteExecutionException;
import org.eclipse.ptp.rdt.sync.core.exceptions.RemoteSyncException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.remote.ui.IRemoteUIFileManager;
import org.eclipse.remote.ui.IRemoteUIServices;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SyncGitPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String instanceScopeSyncNode = "org.eclipse.ptp.rdt.sync.core";
    private static final String GIT_LOCATION_NODE_NAME = "git-location";
    Map<Integer, IRemoteConnection> fComboIndexToRemoteConnectionMap = new HashMap<Integer, IRemoteConnection>();
    Map<IRemoteConnection, String> fConnectionNameToGitPathMap = new HashMap<IRemoteConnection, String>();
    IRemoteConnection fSelectedConnection = null;
    String pathWarningMessage = null;
    String pathErrorMessage = null;
    String gitWarningMessage = null;
    String gitErrorMessage = null;
    private Composite composite;
    private Combo fConnectionCombo;
    private Button fUseDefaultGitLocationCheckbox;
    private Text fGitLocationText;
    private Button fBrowseButton;
    private Button fGitValidateButton;
    IRemoteServices remoteServicesProvider = null;
    private CommandRunner.CommandResults remoteCommandResults;

    protected Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.composite.setLayout((Layout)layout);
        this.fConnectionCombo = new Combo(this.composite, 12);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fConnectionCombo.setLayoutData((Object)gd);
        this.fConnectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncGitPreferencePage.this.handleConnectionSelected();
                SyncGitPreferencePage.this.update();
            }
        });
        this.fUseDefaultGitLocationCheckbox = new Button(this.composite, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fUseDefaultGitLocationCheckbox.setLayoutData((Object)gd);
        this.fUseDefaultGitLocationCheckbox.setText(Messages.SyncGitPreferencePage_0);
        this.fUseDefaultGitLocationCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncGitPreferencePage.this.handleCheckDefaultGitLocation();
                SyncGitPreferencePage.this.update();
            }
        });
        this.fGitLocationText = new Text(this.composite, 2052);
        gd = new GridData(768);
        this.fGitLocationText.setLayoutData((Object)gd);
        this.fGitLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SyncGitPreferencePage.this.update();
            }
        });
        this.fBrowseButton = new Button(this.composite, 8);
        this.fBrowseButton.setText(Messages.SyncGitPreferencePage_1);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRemoteUIConnectionManager mgr;
                if (SyncGitPreferencePage.this.fSelectedConnection == null) {
                    return;
                }
                if (!SyncGitPreferencePage.this.fSelectedConnection.isOpen() && (mgr = SyncGitPreferencePage.this.getUIConnectionManager()) != null) {
                    mgr.openConnectionWithProgress(SyncGitPreferencePage.this.fConnectionCombo.getShell(), null, SyncGitPreferencePage.this.fSelectedConnection);
                }
                if (!SyncGitPreferencePage.this.fSelectedConnection.isOpen()) {
                    return;
                }
                IRemoteUIServices remoteUIServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)SyncGitPreferencePage.this.fSelectedConnection.getRemoteServices());
                if (remoteUIServices == null) {
                    return;
                }
                IRemoteUIFileManager fileMgr = remoteUIServices.getUIFileManager();
                if (fileMgr == null) {
                    return;
                }
                fileMgr.setConnection(SyncGitPreferencePage.this.fSelectedConnection);
                String selectedPath = fileMgr.browseFile(SyncGitPreferencePage.this.fGitLocationText.getShell(), String.valueOf(Messages.SyncGitPreferencePage_3) + SyncGitPreferencePage.this.fSelectedConnection.getName() + ")", null, 0);
                if (selectedPath != null) {
                    SyncGitPreferencePage.this.fGitLocationText.setText(selectedPath);
                }
            }
        });
        this.fGitValidateButton = new Button(this.composite, 8);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 131072;
        this.fGitValidateButton.setLayoutData((Object)gd);
        this.fGitValidateButton.setText(Messages.SyncGitPreferencePage_15);
        this.fGitValidateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncGitPreferencePage.this.validateGit();
                SyncGitPreferencePage.this.update();
            }
        });
        this.populateConnectionCombo(this.fConnectionCombo);
        this.handleConnectionSelected();
        return this.composite;
    }

    public void init(IWorkbench arg0) {
    }

    public void update() {
        this.validatePath();
        this.validatePage();
        this.getContainer().updateMessage();
        this.getContainer().updateButtons();
        this.updateApplyButton();
    }

    public void performApply() {
        this.storeConnectionSettings();
        this.saveAllConnectionSettings();
    }

    protected void performDefaults() {
        this.fConnectionNameToGitPathMap.clear();
        this.loadConnectionSettings();
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public String getMessage() {
        if (this.pathWarningMessage != null) {
            return this.pathWarningMessage;
        }
        return this.gitWarningMessage;
    }

    public int getMessageType() {
        return 2;
    }

    public String getErrorMessage() {
        if (this.pathErrorMessage != null) {
            return this.pathErrorMessage;
        }
        return this.gitErrorMessage;
    }

    private void handleConnectionSelected() {
        this.storeConnectionSettings();
        this.clearMessages();
        int sel = this.fConnectionCombo.getSelectionIndex();
        this.fSelectedConnection = sel == -1 ? null : this.fComboIndexToRemoteConnectionMap.get(sel);
        this.loadConnectionSettings();
    }

    private void storeConnectionSettings() {
        if (this.fSelectedConnection == null) {
            return;
        }
        if (this.fUseDefaultGitLocationCheckbox.getSelection()) {
            this.fConnectionNameToGitPathMap.put(this.fSelectedConnection, null);
        } else {
            this.fConnectionNameToGitPathMap.put(this.fSelectedConnection, this.fGitLocationText.getText());
        }
    }

    private void loadConnectionSettings() {
        if (this.fSelectedConnection == null) {
            return;
        }
        String gitBinary = null;
        if (this.fConnectionNameToGitPathMap.containsKey(this.fSelectedConnection)) {
            gitBinary = this.fConnectionNameToGitPathMap.get(this.fSelectedConnection);
        } else {
            IScopeContext context = InstanceScope.INSTANCE;
            IEclipsePreferences prefSyncNode = context.getNode(instanceScopeSyncNode);
            if (prefSyncNode == null) {
                Activator.log(Messages.SyncGitPreferencePage_18);
            } else {
                try {
                    if (prefSyncNode.nodeExists(GIT_LOCATION_NODE_NAME)) {
                        Preferences prefGitNode = prefSyncNode.node(GIT_LOCATION_NODE_NAME);
                        gitBinary = prefGitNode.get(this.fSelectedConnection.getName(), null);
                    }
                }
                catch (BackingStoreException e) {
                    Activator.log(Messages.SyncGitPreferencePage_19, e);
                }
            }
        }
        if (gitBinary == null) {
            this.fUseDefaultGitLocationCheckbox.setSelection(true);
            this.handleCheckDefaultGitLocation();
            this.fGitLocationText.setText("");
        } else {
            this.fUseDefaultGitLocationCheckbox.setSelection(false);
            this.handleCheckDefaultGitLocation();
            this.fGitLocationText.setText(gitBinary);
        }
    }

    private void clearMessages() {
        this.pathWarningMessage = null;
        this.pathErrorMessage = null;
        this.gitWarningMessage = null;
        this.gitErrorMessage = null;
    }

    private void handleCheckDefaultGitLocation() {
        if (this.fUseDefaultGitLocationCheckbox.getSelection()) {
            this.fGitLocationText.setEnabled(false);
            this.fBrowseButton.setEnabled(false);
        } else {
            this.fGitLocationText.setEnabled(true);
            this.fBrowseButton.setEnabled(true);
        }
    }

    private void populateConnectionCombo(Combo connectionCombo) {
        connectionCombo.removeAll();
        IRemoteServices rs = this.getRemoteServicesProvider();
        List connections = rs.getConnectionManager().getConnections();
        this.fComboIndexToRemoteConnectionMap.clear();
        int i = 0;
        while (i < connections.size()) {
            connectionCombo.add(((IRemoteConnection)connections.get(i)).getName(), i);
            this.fComboIndexToRemoteConnectionMap.put(i, (IRemoteConnection)connections.get(i));
            ++i;
        }
        if (connections.size() > 0) {
            connectionCombo.select(0);
        }
    }

    private IRemoteServices getRemoteServicesProvider() {
        if (this.remoteServicesProvider == null) {
            this.remoteServicesProvider = RemoteServices.getRemoteServices((String)"org.eclipse.remote.JSch");
        }
        return this.remoteServicesProvider;
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        IRemoteServices rs = this.getRemoteServicesProvider();
        IRemoteUIConnectionManager connectionManager = RemoteUIServices.getRemoteUIServices((IRemoteServices)rs).getUIConnectionManager();
        return connectionManager;
    }

    private boolean validatePath() {
        this.pathErrorMessage = null;
        this.pathWarningMessage = null;
        if (this.fUseDefaultGitLocationCheckbox.getSelection()) {
            return true;
        }
        Path gitPath = new Path(this.fGitLocationText.getText());
        if (gitPath.isEmpty()) {
            this.pathErrorMessage = Messages.SyncGitPreferencePage_4;
            return false;
        }
        if (!gitPath.isAbsolute()) {
            this.pathErrorMessage = Messages.SyncGitPreferencePage_5;
            return false;
        }
        return true;
    }

    private boolean validateGit() {
        this.gitErrorMessage = null;
        this.gitWarningMessage = null;
        if (!this.validatePath()) {
            return false;
        }
        if (this.fUseDefaultGitLocationCheckbox.getSelection()) {
            this.gitErrorMessage = this.setSystemDefaultGit();
            if (this.gitErrorMessage != null) {
                return false;
            }
        }
        Path gitPath = new Path(this.fGitLocationText.getText());
        List<String> args = Arrays.asList(gitPath.toString(), "--version");
        String errorMessage = null;
        CommandRunner.CommandResults cr = null;
        try {
            cr = this.runRemoteCommand(args, Messages.SyncGitPreferencePage_6);
        }
        catch (RemoteExecutionException e) {
            errorMessage = this.buildErrorMessage(null, Messages.SyncGitPreferencePage_7, e);
        }
        if (errorMessage != null) {
            MessageDialog.openError(null, (String)Messages.SyncGitPreferencePage_8, (String)errorMessage);
            this.gitErrorMessage = Messages.SyncGitPreferencePage_7;
            return false;
        }
        if (cr.getExitCode() == 126) {
            this.gitErrorMessage = Messages.SyncGitPreferencePage_9;
            return false;
        }
        if (cr.getExitCode() == 127) {
            this.gitErrorMessage = Messages.SyncGitPreferencePage_10;
            return false;
        }
        int version = SyncGitPreferencePage.parseGitVersionAsInt(cr.getStdout());
        String versionString = SyncGitPreferencePage.parseGitVersionAsString(cr.getStdout());
        if (cr.getExitCode() != 0 || version == 0) {
            this.gitWarningMessage = Messages.SyncGitPreferencePage_11;
            return true;
        }
        if (version < 10700) {
            this.gitWarningMessage = String.valueOf(Messages.SyncGitPreferencePage_12) + versionString + Messages.SyncGitPreferencePage_13;
        }
        return true;
    }

    private String setSystemDefaultGit() {
        List<String> args = Arrays.asList("which", "git");
        String errorMessage = null;
        CommandRunner.CommandResults cr = null;
        try {
            cr = this.runRemoteCommand(args, Messages.SyncGitPreferencePage_16);
            errorMessage = this.buildErrorMessage(cr, Messages.SyncGitPreferencePage_17, null);
        }
        catch (RemoteExecutionException e) {
            errorMessage = this.buildErrorMessage(null, Messages.SyncGitPreferencePage_17, e);
        }
        if (errorMessage == null) {
            this.fGitLocationText.setText(cr.getStdout().trim());
        } else {
            this.fGitLocationText.setText("");
        }
        return errorMessage;
    }

    private void validatePage() {
        boolean isValid;
        boolean bl = isValid = this.pathErrorMessage == null;
        if (isValid) {
            this.fConnectionCombo.setEnabled(true);
        } else {
            this.fConnectionCombo.setEnabled(false);
        }
    }

    private CommandRunner.CommandResults runRemoteCommand(final List<String> command, final String commandDesc) throws RemoteExecutionException {
        try {
            new ProgressMonitorDialog(this.composite.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    RecursiveSubMonitor progress = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    progress.subTask(commandDesc);
                    try {
                        try {
                            SyncGitPreferencePage.this.remoteCommandResults = CommandRunner.executeRemoteCommand((IRemoteConnection)SyncGitPreferencePage.this.fSelectedConnection, (List)command, null, (IProgressMonitor)progress.newChild(100));
                        }
                        catch (RemoteSyncException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (InterruptedException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (RemoteConnectionException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new RemoteExecutionException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new RemoteExecutionException((Throwable)e);
        }
        return this.remoteCommandResults;
    }

    private String buildErrorMessage(CommandRunner.CommandResults cr, String baseMessage, RemoteExecutionException e) {
        if (cr != null && cr.getExitCode() == 0) {
            return null;
        }
        if (cr != null) {
            return String.valueOf(baseMessage) + ": " + cr.getStderr();
        }
        String errorMessage = baseMessage;
        if (e.getMessage() != null) {
            errorMessage = String.valueOf(errorMessage) + ": " + e.getMessage();
        }
        return errorMessage;
    }

    private void saveAllConnectionSettings() {
        if (this.fConnectionNameToGitPathMap.size() == 0) {
            return;
        }
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences prefSyncNode = context.getNode(instanceScopeSyncNode);
        if (prefSyncNode == null) {
            Activator.log(Messages.SyncGitPreferencePage_20);
            return;
        }
        Preferences prefGitNode = null;
        try {
            if (prefSyncNode.nodeExists(GIT_LOCATION_NODE_NAME)) {
                prefGitNode = prefSyncNode.node(GIT_LOCATION_NODE_NAME);
            }
        }
        catch (BackingStoreException e) {
            Activator.log(Messages.SyncGitPreferencePage_21, e);
        }
        for (Map.Entry<IRemoteConnection, String> entry : this.fConnectionNameToGitPathMap.entrySet()) {
            if (prefGitNode == null) {
                if (entry.getValue() == null) continue;
                prefGitNode = prefSyncNode.node(GIT_LOCATION_NODE_NAME);
            }
            if (entry.getValue() == null) {
                prefGitNode.remove(entry.getKey().getName());
                continue;
            }
            prefGitNode.put(entry.getKey().getName(), entry.getValue());
        }
        try {
            prefSyncNode.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    public static int parseGitVersionAsInt(String versionCommandOutput) {
        Matcher m = Pattern.compile("git version ([0-9]+)\\.([0-9]+)\\.([0-9]+).*").matcher(versionCommandOutput.trim());
        if (m.matches()) {
            return Integer.parseInt(m.group(1)) * 10000 + Integer.parseInt(m.group(2)) * 100 + Integer.parseInt(m.group(3));
        }
        return 0;
    }

    public static String parseGitVersionAsString(String versionCommandOutput) {
        Matcher m = Pattern.compile("git version ([0-9]+\\.[0-9]+\\.[0-9]+).*").matcher(versionCommandOutput.trim());
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }
}

