/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.gnu.IGCCASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.parser.cpp.ICPPASTAttributeSpecifier;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public abstract class ASTAttributeOwner
extends ASTNode
implements IASTAttributeOwner {
    private IASTAttributeSpecifier[] attributeSpecifiers = IASTAttributeSpecifier.EMPTY_ATTRIBUTE_SPECIFIER_ARRAY;

    @Override
    public IASTAttribute[] getAttributes() {
        IASTAttribute[] attributes = IASTAttribute.EMPTY_ATTRIBUTE_ARRAY;
        IASTAttributeSpecifier[] iASTAttributeSpecifierArray = this.getAttributeSpecifiers();
        int n = iASTAttributeSpecifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAttributeSpecifier attributeSpecifier = iASTAttributeSpecifierArray[n2];
            attributes = ArrayUtil.addAll(attributes, attributeSpecifier.getAttributes());
            ++n2;
        }
        return attributes;
    }

    @Override
    @Deprecated
    public void addAttribute(IASTAttribute attribute) {
    }

    @Override
    public IASTAttributeSpecifier[] getAttributeSpecifiers() {
        this.attributeSpecifiers = ArrayUtil.trim(this.attributeSpecifiers);
        return this.attributeSpecifiers;
    }

    @Override
    public void addAttributeSpecifier(IASTAttributeSpecifier attributeSpecifier) {
        this.assertNotFrozen();
        if (attributeSpecifier != null) {
            attributeSpecifier.setParent(this);
            attributeSpecifier.setPropertyInParent(ATTRIBUTE_SPECIFIER);
            this.attributeSpecifiers = ArrayUtil.append(this.attributeSpecifiers, attributeSpecifier);
        }
    }

    @Override
    protected <T extends ASTAttributeOwner> T copy(T copy, IASTNode.CopyStyle style) {
        IASTAttributeSpecifier[] iASTAttributeSpecifierArray = this.getAttributeSpecifiers();
        int n = iASTAttributeSpecifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAttributeSpecifier attributeSpecifier = iASTAttributeSpecifierArray[n2];
            copy.addAttributeSpecifier(attributeSpecifier.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    protected boolean acceptByAttributeSpecifiers(ASTVisitor action) {
        return this.visitAttributes(action, this.attributeSpecifiers);
    }

    private boolean visitAttributes(ASTVisitor action, IASTAttributeSpecifier[] attributeSpecifiers) {
        IASTAttributeSpecifier[] iASTAttributeSpecifierArray = attributeSpecifiers;
        int n = attributeSpecifiers.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAttributeSpecifier attributeSpecifier = iASTAttributeSpecifierArray[n2];
            if (attributeSpecifier == null) break;
            if (!attributeSpecifier.accept(action)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean acceptByGCCAttributeSpecifiers(ASTVisitor action) {
        IASTAttributeSpecifier[] iASTAttributeSpecifierArray = this.attributeSpecifiers;
        int n = this.attributeSpecifiers.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAttributeSpecifier attributeSpecifier = iASTAttributeSpecifierArray[n2];
            if (attributeSpecifier instanceof IGCCASTAttributeSpecifier && !attributeSpecifier.accept(action)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean acceptByCPPAttributeSpecifiers(ASTVisitor action) {
        IASTAttributeSpecifier[] iASTAttributeSpecifierArray = this.attributeSpecifiers;
        int n = this.attributeSpecifiers.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAttributeSpecifier attributeSpecifier = iASTAttributeSpecifierArray[n2];
            if (attributeSpecifier instanceof ICPPASTAttributeSpecifier && !attributeSpecifier.accept(action)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

