/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CGlobalVariable;
import org.eclipse.cdt.debug.internal.core.model.CLocalVariable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CVariableFactory {
    public static CLocalVariable createLocalVariable(CDebugElement parent, ICDIVariableDescriptor cdiVariableObject) {
        return new CLocalVariable(parent, cdiVariableObject);
    }

    public static CLocalVariable createLocalVariableWithError(CDebugElement parent, ICDIVariableDescriptor cdiVariableObject, String message) {
        return new CLocalVariable(parent, cdiVariableObject, message);
    }

    public static IGlobalVariableDescriptor createGlobalVariableDescriptor(final String name, final IPath path) {
        return new IGlobalVariableDescriptor(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public IPath getPath() {
                return path != null ? path : new Path("");
            }

            public String toString() {
                return MessageFormat.format((String)"{0}::{1}", (Object[])new String[]{this.getPath().toOSString(), this.getName()});
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof IGlobalVariableDescriptor)) {
                    return false;
                }
                IGlobalVariableDescriptor d = (IGlobalVariableDescriptor)obj;
                return this.getName().compareTo(d.getName()) == 0 && this.getPath().equals((Object)d.getPath());
            }
        };
    }

    public static IGlobalVariableDescriptor createGlobalVariableDescriptor(IVariable var) {
        Path path = new Path("");
        ICElement parent = var.getParent();
        if (parent instanceof IBinaryModule) {
            path = ((IBinaryModule)parent).getPath();
        }
        return CVariableFactory.createGlobalVariableDescriptor(var.getElementName(), (IPath)path);
    }

    public static IGlobalVariableDescriptor createGlobalVariableDescriptor(IBinaryParser.ISymbol symbol) {
        return CVariableFactory.createGlobalVariableDescriptor(symbol.getName(), symbol.getFilename());
    }

    public static CGlobalVariable createGlobalVariable(CDebugElement parent, IGlobalVariableDescriptor descriptor, ICDIVariableDescriptor cdiVariableObject) {
        return new CGlobalVariable(parent, descriptor, cdiVariableObject);
    }
}

