/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ide;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import com.nvidia.viper.FileUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.ide.Activator;
import com.nvidia.viper.ide.launch.LaunchConfigurationAdapter;
import com.nvidia.viper.ide.launch.LaunchConfigurationEditorInput;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.SessionEditorInput;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public final class ViperIDEUtil {
    public static ILaunchConfiguration createLaunchConfiguration(Executable executable) {
        try {
            String name;
            boolean createlc;
            String lcName = executable.getLaunchConfigurationName();
            if (lcName == null) {
                lcName = ViperIDEUtil.generateNewUniqueLCName(executable.getFilename());
            }
            if (lcName != null && (createlc = ViperIDEUtil.runOnDisplayThread(new Callable<Boolean>(name = lcName){
                private final /* synthetic */ String val$name;
                {
                    this.val$name = string;
                }

                @Override
                public Boolean call() throws Exception {
                    return ViperIDEUtil.shouldCreateLaunchConfiguration(this.val$name);
                }
            }).booleanValue())) {
                return ViperIDEUtil.setupLaunchConfiguration(name, executable);
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
        return null;
    }

    private static ILaunchConfigurationWorkingCopy createLocalLaunchConfiguration(String name, ILaunchManager manager, Executable executable) throws CoreException {
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.cdt.launch.applicationLaunchType");
        ILaunchConfigurationWorkingCopy lc = type.newInstance(null, name);
        lc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", executable.getFilename());
        return lc;
    }

    private static ILaunchConfigurationWorkingCopy createRemoteLaunchConfiguration(String name, ILaunchManager manager, Executable executable) throws CoreException {
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.cdt.launch.remoteApplicationLaunchType");
        ILaunchConfigurationWorkingCopy lc = type.newInstance(null, name);
        lc.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, executable.getConnectionName());
        lc.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, executable.getFilename());
        lc.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, true);
        lc.setAttribute(ICudaRemoteDebugConstants.ATTRIBUTE_EXECUTABLE_TRANSFER, ICudaRemoteDebugConstants.ExecutableTransferMode.Download.name());
        return lc;
    }

    private static Session tryLoadSession(File file) throws ViperException {
        Session session;
        if (!file.exists()) {
            return null;
        }
        try {
            session = FileUtils.loadSession((File)file);
        }
        catch (ViperException e) {
            if (!SAXParseException.class.equals(e.getCause().getClass())) {
                throw e;
            }
            Activator.log(2, e, "Hit file format exception while loading the file %s, recreating it from scratch", file);
            session = null;
        }
        return session;
    }

    public static Session createSession(LaunchConfigurationAdapter launchConfiguration) throws CoreException {
        Executable executable = launchConfiguration.createExecutable();
        File file = new File(launchConfiguration.getSessionFileName());
        try {
            Session session = ViperIDEUtil.tryLoadSession(file);
            if (session == null) {
                session = ViperIDEUtil.newSession(executable.getLaunchConfigurationName(), file);
            }
            session.setExecutable(executable);
            session.setFile((Object)file);
            return session;
        }
        catch (ViperException e) {
            throw CoreUtil.coreException((Throwable)e, (String)"Unable to create session file %s", (Object[])new Object[]{file});
        }
    }

    public static String generateNewUniqueLCName(String filename) {
        File file;
        if (filename != null && filename.trim().length() > 0 && (file = new File(filename.trim())).isFile()) {
            String name;
            String tname = name = file.getName();
            int i = 1;
            while (LaunchConfigurationAdapter.getLaunchConfigurationAdapter(tname, true) != null && LaunchConfigurationAdapter.getLaunchConfigurationAdapter(tname, false) != null) {
                tname = String.format("%s (%d)", name, i++);
            }
            return tname;
        }
        return null;
    }

    public static Session getSessionFromEditorInput(IEditorInput input) throws PartInitException, CoreException {
        if (input instanceof SessionEditorInput) {
            return ((SessionEditorInput)input).getSession();
        }
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            return ViperIDEUtil.loadSession(file.getContents(), file);
        }
        if (input instanceof FileStoreEditorInput) {
            URI uri = ((FileStoreEditorInput)input).getURI();
            IFileStore store = EFS.getStore((URI)uri);
            return ViperIDEUtil.loadSession(store.openInputStream(0, (IProgressMonitor)new NullProgressMonitor()), uri);
        }
        if (input instanceof LaunchConfigurationEditorInput) {
            LaunchConfigurationEditorInput viperEditorInput = (LaunchConfigurationEditorInput)input;
            Session session = viperEditorInput.getSession();
            if (session == null) {
                LaunchConfigurationAdapter launchConfiguration = LaunchConfigurationAdapter.getLaunchConfigurationAdapter(input.getName(), viperEditorInput.isRemote());
                if (launchConfiguration != null) {
                    return ViperIDEUtil.createSession(launchConfiguration);
                }
                throw new PartInitException(String.format("Launch configuration %s does not exist", input.getName()));
            }
            return session;
        }
        return null;
    }

    public static boolean isRemote(Session session) {
        try {
            return !FileSystem.getFilesystem((Session)session).isLocal();
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            return false;
        }
    }

    public static boolean isRemoteLaunch(ILaunchConfiguration configuration) throws CoreException {
        if (configuration != null) {
            String identifier = configuration.getType().getIdentifier();
            return "org.eclipse.cdt.launch.remoteApplicationLaunchType".equals(identifier);
        }
        return false;
    }

    private static Session loadSession(InputStream contents, Object source) throws PartInitException {
        try {
            DocumentBuilder docReader = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docReader.parse(contents);
            contents.close();
            Session session = new Session(doc.getDocumentElement());
            session.setFile(source);
            session.setDirty(false);
            return session;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PartInitException("Unable to parse document", (Throwable)e);
        }
    }

    private static Session newSession(String name, File file) throws ViperException {
        Session session = new Session();
        session.setExpert(new Expert());
        session.setAnalysis(new Analysis());
        session.setName(name);
        session.setExpertSystem(new ExpertSystem(session));
        FileUtils.saveSession((File)file, (Session)session);
        return session;
    }

    private static <T> T runOnDisplayThread(final Callable<T> task) throws Exception {
        if (Display.getCurrent() != null) {
            try {
                return task.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        final AtomicReference ref = new AtomicReference();
        final AtomicReference e = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ref.set(task.call());
                }
                catch (Exception ex) {
                    e.set(ex);
                }
            }
        });
        if (e.get() != null) {
            throw (Exception)e.get();
        }
        return (T)ref.get();
    }

    private static ILaunchConfiguration setupLaunchConfiguration(String name, Executable executable) throws CoreException {
        ILaunchConfigurationWorkingCopy lc;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        try {
            lc = FileSystem.getFilesystem((String)executable.getConnectionName()).isLocal() ? ViperIDEUtil.createLocalLaunchConfiguration(name, manager, executable) : ViperIDEUtil.createRemoteLaunchConfiguration(name, manager, executable);
        }
        catch (ConnectionNotFoundException e) {
            throw CoreUtil.coreException((Throwable)e);
        }
        lc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", executable.getWorkingDir());
        lc.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", executable.getArgs());
        Map env = executable.getEnv();
        lc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, env);
        lc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
        lc.setAttribute("nvvp.startProfiling", executable.isProfileOnStart());
        lc.setAttribute("nvvp.concurrentProfiling", executable.isConcurrentKernel());
        lc.setAttribute("nvvp.apiTraceProfiling", executable.isApiTrace());
        lc.setAttribute("nvvp.environmentProfiling", executable.isEnvironmentProfiling());
        lc.setAttribute("nvvp.uvmProfiling", executable.isUvmProfiling());
        lc.setAttribute("nvvp.appReplay", executable.isApplicationReplay());
        lc.setAttribute("nvvp.timeout", executable.getTimeOut());
        lc.setAttribute("nvvp.multiProcess", executable.getMultiProcessOrdinal());
        lc.setAttribute("nvvp.openaccProfiling", executable.isOpenAccProfiling());
        lc.setAttribute("nvvp.devicebuffersize", executable.getDeviceBuffersize());
        lc.setAttribute("nvvp.cdpbuffersize", executable.getCDPBuffersize());
        executable.setLaunchConfigurationName(name);
        return lc.doSave();
    }

    protected static boolean shouldCreateLaunchConfiguration(String lcName) {
        String message = String.format("Launch configuration %s used to run profiling session does not exist. Do you want to restore it using information stored in the session document?", lcName);
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"NVIDIA Visual Profiler", (String)message);
    }

    private ViperIDEUtil() {
    }
}

