/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.TargetBuild;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class BuildTargetAction
extends SelectionListenerAction {
    private final Shell shell;

    public BuildTargetAction(Shell shell) {
        super(MakeUIPlugin.getResourceString("BuildTargetAction.label"));
        this.shell = shell;
        this.setToolTipText(MakeUIPlugin.getResourceString("BuildTargetAction.tooltip"));
        this.setDisabledImageDescriptor(MakeUIImages.getImageDescriptor("icons/dtool16/target_build.png"));
        this.setImageDescriptor(MakeUIImages.getImageDescriptor("icons/etool16/target_build.png"));
        this.setEnabled(false);
    }

    public void run() {
        if (this.canBuild()) {
            IMakeTarget[] targets = this.getSelectedElements().toArray(new IMakeTarget[0]);
            TargetBuild.buildTargets(this.shell, targets);
            IContainer container = targets[targets.length - 1].getContainer();
            try {
                container.setSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTarget"), (Object)targets[targets.length - 1].getName());
            }
            catch (CoreException coreException) {}
            try {
                IPath path = container.getProjectRelativePath();
                container.getProject().setSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTargetContainer"), (Object)path.toString());
            }
            catch (CoreException coreException) {}
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.canBuild();
    }

    private boolean canBuild() {
        List<?> elements = this.getSelectedElements();
        for (Object element : elements) {
            if (element instanceof IMakeTarget) continue;
            return false;
        }
        return elements.size() > 0;
    }

    private List<?> getSelectedElements() {
        return this.getStructuredSelection().toList();
    }
}

