/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.net.URISyntaxException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.SimpleConfigurePushDialog;
import org.eclipse.egit.ui.internal.repository.tree.PushNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushConfiguredRemoteCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode<?>> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        RemoteConfig config = this.getRemoteConfig(node);
        if (config == null) {
            MessageDialog.openInformation((Shell)this.getShell(event), (String)UIText.SimplePushActionHandler_NothingToPushDialogTitle, (String)UIText.SimplePushActionHandler_NothingToPushDialogMessage);
            return null;
        }
        new PushOperationUI(node.getRepository(), config.getName(), false).start();
        return null;
    }

    public boolean isEnabled() {
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes().get(0);
        return this.getRemoteConfig(node) != null;
    }

    private RemoteConfig getRemoteConfig(RepositoryTreeNode node) {
        if (node instanceof RepositoryNode) {
            return SimpleConfigurePushDialog.getConfiguredRemote(node.getRepository());
        }
        if (node instanceof RemoteNode || node instanceof PushNode) {
            RemoteNode remoteNode = node instanceof PushNode ? (RemoteNode)node.getParent() : (RemoteNode)node;
            try {
                boolean pushConfigured;
                RemoteConfig config = new RemoteConfig((Config)remoteNode.getRepository().getConfig(), (String)remoteNode.getObject());
                boolean fetchConfigured = !config.getFetchRefSpecs().isEmpty();
                boolean bl = pushConfigured = !config.getPushRefSpecs().isEmpty();
                if (fetchConfigured || pushConfigured) {
                    return config;
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return null;
    }
}

