/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RenameBranchDialog
extends AbstractBranchSelectionDialog {
    public RenameBranchDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo, 70);
    }

    private InputDialog getRefNameInputDialog(String prompt, String refPrefix, String initialValue) {
        InputDialog branchNameDialog = new InputDialog(this.getShell(), UIText.RenameBranchDialog_RenameBranchDialogNewNameInputWindowTitle, prompt, initialValue, ValidationUtils.getRefNameInputValidator(this.repo, refPrefix, true));
        branchNameDialog.setBlockOnOpen(true);
        return branchNameDialog;
    }

    protected void okPressed() {
        String refPrefix;
        String refName = this.refNameFromDialog();
        if (refName.startsWith("refs/heads/")) {
            refPrefix = "refs/heads/";
        } else if (refName.startsWith("refs/remotes/")) {
            refPrefix = "refs/remotes/";
        } else if (refName.startsWith("refs/tags/")) {
            refPrefix = "refs/tags/";
        } else {
            return;
        }
        String branchName = refName.substring(refPrefix.length());
        InputDialog labelDialog = this.getRefNameInputDialog(NLS.bind((String)UIText.RenameBranchDialog_NewNameInputDialogPrompt, (Object)branchName, (Object)refPrefix), refPrefix, branchName);
        if (labelDialog.open() == 0) {
            String newRefName = String.valueOf(refPrefix) + labelDialog.getValue();
            try {
                new Git(this.repo).branchRename().setOldName(refName).setNewName(labelDialog.getValue()).call();
                this.branchTree.refresh();
                this.markRef(newRefName);
            }
            catch (Throwable e1) {
                this.reportError(e1, UIText.RenameBranchDialog_RenameErrorMessage, refName, newRefName, e1.getMessage());
            }
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.RenameBranchDialog_RenameButtonLabel);
        this.getButton(0).setEnabled(!this.branchTree.getSelection().isEmpty());
    }

    protected String getMessageText() {
        return UIText.RenameBranchDialog_DialogMessage;
    }

    protected void createCustomArea(Composite parent) {
    }

    protected String getTitle() {
        return UIText.RenameBranchDialog_DialogTitle;
    }

    protected String getWindowTitle() {
        return UIText.RenameBranchDialog_WindowTitle;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    private void reportError(Throwable e, String message, Object ... args) {
        String msg = NLS.bind((String)message, (Object[])args);
        Activator.handleError(msg, e, true);
    }

    protected void refNameSelected(String refName) {
        boolean tagSelected = refName != null && refName.startsWith("refs/tags/");
        boolean branchSelected = refName != null && (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/"));
        this.getButton(0).setEnabled(branchSelected || tagSelected);
    }
}

