/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.chart.AbstractOccupancyChart;

public final class SharedMemoryBoundOccupancyChart
extends AbstractOccupancyChart {
    private final String[] points;
    private final Double[] warpsActual;
    private final Double[] warpsTheoretical;
    private final int allocSize;

    private int getMemAllocUnitSize(int computeMajor) {
        switch (computeMajor) {
            case 2: 
            case 3: {
                return 128;
            }
            case 5: 
            case 6: 
            case 7: {
                return 256;
            }
        }
        ViperExceptionHandler.logError("Unknown compute capability: Can't fetch shared memory allocation unit size");
        return -1;
    }

    public SharedMemoryBoundOccupancyChart(TimelineIntervalKernel kernel, OccupancyCalculator calculator, boolean highlight) throws ViperException {
        super(calculator.getDeviceTimeline().getMaxWarpsPerMultiprocessor(), highlight);
        this.allocSize = this.getMemAllocUnitSize(calculator.getDeviceTimeline().getComputeCapabilityMajor());
        this.points = new String[OccupancyCalculator.getMaxSharedMemoryPerMultiprocessor(calculator.getDeviceTimeline()) / this.allocSize + 1];
        this.warpsActual = new Double[this.points.length];
        this.warpsTheoretical = new Double[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            Double warps = calculator.getWarpsPerSMForSharedMemoryUsage(i * this.allocSize).doubleValue();
            this.points[i] = String.format("%dk", i * this.allocSize / 1024);
            this.warpsActual[i] = null;
            this.warpsTheoretical[i] = warps;
            ++i;
        }
        int sharedMemoryUsed = (kernel.getStaticSharedMemory() + kernel.getDynamicSharedMemory()) / this.allocSize;
        this.warpsActual[sharedMemoryUsed] = this.warpsTheoretical[sharedMemoryUsed];
    }

    public String[] getLabels() {
        return this.points;
    }

    public String getTitle() {
        return ViperMessages.Chart_Shared_Memory_Title;
    }

    @Override
    public String getXAxisTitle() {
        return ViperMessages.Chart_Shared_Memory_XAxis;
    }

    @Override
    public String getYAxisTitle() {
        return null;
    }

    @Override
    public Integer getVerticalLineStep() {
        return 1024 / this.allocSize;
    }

    @Override
    public boolean isZeroBased() {
        return true;
    }

    @Override
    protected Double[] getActualPlotData() {
        return this.warpsActual;
    }

    @Override
    protected Double[] getTheoreticalPlotData() {
        return this.warpsTheoretical;
    }
}

