/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultPCSampling;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.chart.ui.ChartCanvas;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.editor.SourceSassEditorInput;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import com.nvidia.viper.ui.chart.KernelPCSamplingStallReasonChart;
import java.text.Collator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PCSamplingResultControl
extends AnalysisResultControl {
    private IEditorPart editor = null;
    private static String CUDA_FUNCTIONS_COLUMN_HEADER = "CUDA functions";
    private static String SOURCE_FILE_COLUMN_HEADER = "Source file";
    private static String KERNEL_SAMPLES_PERCENT_HEADER = "% of samples";
    private static String SOURCE_FILE_SAMPLES_PERCENT_HEADER = "% of samples in file";
    private static String LATENCY_PERCENT_HEADER = "% of latency samples";
    private static String ISSUE_PIPELINE_BUSY_HEADER = "% of issue pipeline busy samples";
    private static String INST_ISSUED_HEADER = "% of inst issued samples";
    private static String CUDA_FUNCTIONS_COLUMN_TOOLTIP = "CUDA functions executed for the kernel launch";
    private static String KERNEL_SAMPLES_COUNT_TOOLTIP = "The total number of samples taken during the kernel launch";
    private static String SAMPLES_PERCENT_TOOLTIP = "The percentage of samples for this CUDA function w.r.t total samples";
    private static String LATENCY_SAMPLES_PERCENT_TOOLTIP = "The percentage of latency samples w.r.t total samples. Latency samples indicate that no instruction was issued in that cycle from the warp scheduler from where the warp was sampled.";
    private static String ISSUE_PIPELINE_BUSY_TOOLTIP = "The percentage of samples w.r.t total samples when the warp was ready to issue an instruction but could not as the warp scheduler was busy";
    private static String INST_ISSUED_TOOLTIP = "The percentage of samples when instruction was issued";
    private static String SOURCE_FILES_COLUMN_TOOLTIP = "The source files for the kernel launch";
    private static String SOURCE_FILES_SAMPLES_COUNT_TOOLTIP = "The total number of samples in this source file w.r.t total samples";

    public PCSamplingResultControl(Composite parent, AnalysisResult result, Session session) {
        super(parent, result, session);
        this.activeSession.addPropertyChangeListener(new ISessionPropertyChangeListener(){

            @Override
            public void propertyChange(IModel model, String propertyName) {
                if ("session:timelinereset".equals(propertyName) && PCSamplingResultControl.this.editor != null) {
                    PCSamplingResultControl.this.editor.getSite().getPage().closeEditor(PCSamplingResultControl.this.editor, false);
                }
            }
        });
    }

    @Override
    protected boolean allowsSelection() {
        return false;
    }

    @Override
    protected boolean hasExtension() {
        return true;
    }

    @Override
    protected boolean showResultDesc() {
        return false;
    }

    @Override
    protected void createExtension(Composite parent) {
        if (!this.getSourceLevelResult().hasOnlyNullResults()) {
            this.createFunctionTable(parent);
            this.createFileTable(parent);
            this.createCharts(parent);
        }
        Label desc = new Label(parent, 64);
        GridData dgd = new GridData(4, 128, true, false);
        dgd.horizontalSpan = 2;
        dgd.widthHint = 400;
        desc.setLayoutData((Object)dgd);
        desc.setText(this.result.getDescription(ResultOutput.UI));
        this.addSelectListener((Control)desc);
        Link more = new Link(parent, 0);
        more.setLayoutData((Object)new GridData(131072, 1024, false, true));
        more.setText("<a>More...</a>");
        more.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViperHelp.displayHelp(ViperHelp.PC_SAMPLING_OPTIMIZATIONS);
            }
        });
    }

    private int getMajorComputeCapability() {
        TimelineIntervalKernel kernel = this.getSourceLevelResult().getKernel();
        return kernel.getMajorComputeCapability();
    }

    private void fillTableRow(Table table, TableColumns tableColumns, String name, AnalysisResultPCSampling samplingResult) {
        TableItem tableItem = new TableItem(table, 4);
        int i = 0;
        while (i < table.getColumnCount()) {
            AbstractColumnListener listener = tableColumns.getTableColumnListener(i);
            String textItem = listener.getTextItem(this.activeSession, samplingResult, tableColumns.tableType, name);
            tableItem.setText(i, textItem);
            ++i;
        }
    }

    private void createFunctionTable(Composite parent) {
        final AnalysisResultPCSampling samplingResult = this.getSourceLevelResult();
        String[] funcNameList = samplingResult.getFunctionNameList(this.activeSession);
        if (funcNameList != null && funcNameList.length > 0) {
            int major = this.getMajorComputeCapability();
            TableColumns tableColumns = TableColumns.getTableColumns(major, TableType.CUDA_FUNCTIONS);
            Table tableFunctions = this.createTable(parent, tableColumns);
            String[] stringArray = funcNameList;
            int n = funcNameList.length;
            int n2 = 0;
            while (n2 < n) {
                String funcName = stringArray[n2];
                this.fillTableRow(tableFunctions, tableColumns, funcName, samplingResult);
                ++n2;
            }
            this.updateColumns(tableFunctions);
            tableColumns.sortDefaultColumn(1024);
            tableFunctions.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.item != null) {
                        String funcName = ((TableItem)e.item).getText(0);
                        SourceSassModel model = new SourceSassModel(PCSamplingResultControl.this.activeSession, PCSamplingResultControl.this.getSourceLevelResult(), samplingResult.getFunctionId(funcName, PCSamplingResultControl.this.activeSession));
                        PCSamplingResultControl.this.openEditor(model);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void updateColumns(Table table) {
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            table.setSortColumn(column);
            ++n2;
        }
    }

    private Table createTable(Composite parent, TableColumns tableColumn) {
        Table table = new Table(parent, 2560);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, false));
        int i = 0;
        while (i < tableColumn.getNumColumns()) {
            TableColumn column = new TableColumn(table, 4);
            column.setText(tableColumn.getTableColumnHeader(i));
            column.setToolTipText(tableColumn.getTableColumnTooltip(i));
            AbstractColumnListener listener = tableColumn.getTableColumnListener(i);
            listener.setTable(table);
            listener.setTableColumn(column);
            column.addListener(13, (Listener)listener);
            ++i;
        }
        return table;
    }

    private void createFileTable(Composite parent) {
        final AnalysisResultPCSampling samplingResult = this.getSourceLevelResult();
        String[] srcFileNameList = samplingResult.getSourceFileNameList(this.activeSession);
        if (srcFileNameList != null && srcFileNameList.length > 0) {
            int major = this.getMajorComputeCapability();
            TableColumns tableColumns = TableColumns.getTableColumns(major, TableType.SOURCE_FILE);
            Table tableFile = this.createTable(parent, tableColumns);
            String[] stringArray = srcFileNameList;
            int n = srcFileNameList.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                this.fillTableRow(tableFile, tableColumns, filename, samplingResult);
                ++n2;
            }
            this.updateColumns(tableFile);
            tableColumns.sortDefaultColumn(1024);
            tableFile.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.item != null) {
                        String fileName = ((TableItem)e.item).getText(0);
                        SourceSassModel model = new SourceSassModel(PCSamplingResultControl.this.activeSession, PCSamplingResultControl.this.getSourceLevelResult(), fileName, samplingResult.getFileLineNumber(fileName, PCSamplingResultControl.this.activeSession));
                        PCSamplingResultControl.this.openEditor(model);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    @Override
    public boolean grabsVerticalSpace() {
        return false;
    }

    private void createCharts(Composite parent) {
        AnalysisResultPCSampling pcSamplingResult = this.getSourceLevelResult();
        String[] funcs = pcSamplingResult.getFunctionNameList(this.activeSession);
        if (funcs != null && funcs.length > 0) {
            ChartCanvas canvas = new ChartCanvas(parent, 0);
            canvas.setChart((IViperChart)new KernelPCSamplingStallReasonChart(pcSamplingResult));
            canvas.setLayoutData((Object)new GridData(16384, 128, true, false));
        }
    }

    private AnalysisResultPCSampling getSourceLevelResult() {
        return (AnalysisResultPCSampling)this.result;
    }

    private void openEditor(SourceSassModel model) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            this.editor = activePage.openEditor((IEditorInput)new SourceSassEditorInput(model), "com.nvidia.viper.sourcesasseditor");
        }
        catch (PartInitException e1) {
            ViperExceptionHandler.handle(ViperMessages.Pc_Sampling_Failed_Title, ViperMessages.Pc_Sampling_Failed_Message, new ViperException(e1));
        }
    }

    static /* synthetic */ String access$0() {
        return CUDA_FUNCTIONS_COLUMN_HEADER;
    }

    static /* synthetic */ String access$1() {
        return KERNEL_SAMPLES_PERCENT_HEADER;
    }

    static /* synthetic */ String access$2() {
        return LATENCY_PERCENT_HEADER;
    }

    static /* synthetic */ String access$3() {
        return ISSUE_PIPELINE_BUSY_HEADER;
    }

    static /* synthetic */ String access$4() {
        return INST_ISSUED_HEADER;
    }

    static /* synthetic */ String access$5() {
        return CUDA_FUNCTIONS_COLUMN_TOOLTIP;
    }

    static /* synthetic */ String access$6() {
        return KERNEL_SAMPLES_COUNT_TOOLTIP;
    }

    static /* synthetic */ String access$7() {
        return SAMPLES_PERCENT_TOOLTIP;
    }

    static /* synthetic */ String access$8() {
        return LATENCY_SAMPLES_PERCENT_TOOLTIP;
    }

    static /* synthetic */ String access$9() {
        return ISSUE_PIPELINE_BUSY_TOOLTIP;
    }

    static /* synthetic */ String access$10() {
        return INST_ISSUED_TOOLTIP;
    }

    static /* synthetic */ String access$11() {
        return SOURCE_FILE_COLUMN_HEADER;
    }

    static /* synthetic */ String access$12() {
        return SOURCE_FILE_SAMPLES_PERCENT_HEADER;
    }

    static /* synthetic */ String access$13() {
        return SOURCE_FILES_COLUMN_TOOLTIP;
    }

    static /* synthetic */ String access$14() {
        return SOURCE_FILES_SAMPLES_COUNT_TOOLTIP;
    }

    private static abstract class AbstractColumnListener
    implements Listener {
        protected Table table;
        protected TableColumn tableColumn;

        private AbstractColumnListener() {
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public void setTableColumn(TableColumn tableColumn) {
            this.tableColumn = tableColumn;
        }

        public void handleEvent(Event event) {
            int dir = this.table.getSortDirection();
            dir = this.table.getSortColumn() == this.tableColumn ? (dir == 128 ? 1024 : 128) : 1024;
            this.sortColumn(dir);
            this.table.setSortDirection(dir);
            this.table.setSortColumn(this.tableColumn);
        }

        protected void sortColumn(int dir) {
            int numColumns = this.table.getColumnCount();
            TableItem[] items = this.table.getItems();
            int columnIndex = this.table.indexOf(this.tableColumn);
            int i = 1;
            while (i < items.length) {
                double value1 = Double.parseDouble(items[i].getText(columnIndex).replaceAll("%", ""));
                int j = 0;
                while (j < i) {
                    double value2 = Double.parseDouble(items[j].getText(columnIndex).replaceAll("%", ""));
                    if (value1 > value2 && dir == 1024 || value1 < value2 && dir == 128) {
                        String[] values = new String[numColumns];
                        int index = 0;
                        while (index < numColumns) {
                            values[index] = items[i].getText(index);
                            items[i].setText(index, items[j].getText(index));
                            ++index;
                        }
                        items[j].setText(values);
                    }
                    ++j;
                }
                ++i;
            }
        }

        protected abstract String getTextItem(Session var1, AnalysisResultPCSampling var2, TableType var3, String var4);
    }

    private static final class InstIssuedSampleColumnListener
    extends AbstractColumnListener {
        private InstIssuedSampleColumnListener() {
        }

        @Override
        protected String getTextItem(Session activeSession, AnalysisResultPCSampling samplingResult, TableType tableType, String name) {
            Long instIssuedSamples = TableType.CUDA_FUNCTIONS == tableType ? Long.valueOf(samplingResult.getInstIssuedSampleCount(samplingResult.getFunctionId(name, activeSession), activeSession)) : Long.valueOf(samplingResult.getInstIssuedSampleCount(name, activeSession));
            double percentInstIssuedSamples = instIssuedSamples != null ? 100.0 * (double)instIssuedSamples.longValue() / samplingResult.getTotalSamples(activeSession) : 0.0;
            return String.format("%.2f %%", percentInstIssuedSamples);
        }
    }

    private static final class IssuePipeBusySampleColumnListener
    extends AbstractColumnListener {
        private IssuePipeBusySampleColumnListener() {
        }

        @Override
        protected String getTextItem(Session activeSession, AnalysisResultPCSampling samplingResult, TableType tableType, String name) {
            Long issuePipelineBusySamples = TableType.CUDA_FUNCTIONS == tableType ? Long.valueOf(samplingResult.getIssuePipeBusySampleCount(samplingResult.getFunctionId(name, activeSession), activeSession)) : Long.valueOf(samplingResult.getIssuePipeBusySampleCount(name, activeSession));
            double percentIssuePipelineBusySamples = issuePipelineBusySamples != null ? 100.0 * (double)issuePipelineBusySamples.longValue() / samplingResult.getTotalSamples(activeSession) : 0.0;
            return String.format("%.2f %%", percentIssuePipelineBusySamples);
        }
    }

    private static final class LatencySampleColumnListener
    extends AbstractColumnListener {
        private LatencySampleColumnListener() {
        }

        @Override
        protected String getTextItem(Session activeSession, AnalysisResultPCSampling samplingResult, TableType tableType, String name) {
            Long latencySamples = TableType.CUDA_FUNCTIONS == tableType ? Long.valueOf(samplingResult.getLatencySampleCount(samplingResult.getFunctionId(name, activeSession), activeSession)) : Long.valueOf(samplingResult.getLatencySampleCount(name, activeSession));
            double percentLatencySamples = latencySamples != null ? 100.0 * (double)latencySamples.longValue() / samplingResult.getTotalSamples(activeSession) : 0.0;
            return String.format("%.2f %%", percentLatencySamples);
        }
    }

    private static final class NameColumnListener
    extends AbstractColumnListener {
        private NameColumnListener() {
        }

        @Override
        protected void sortColumn(int dir) {
            int numColumns = this.table.getColumnCount();
            TableItem[] items = this.table.getItems();
            Collator collator = Collator.getInstance(Locale.getDefault());
            int i = 1;
            while (i < items.length) {
                String value1 = items[i].getText(0);
                int j = 0;
                while (j < i) {
                    String value2 = items[j].getText(0);
                    if (collator.compare(value1, value2) < 0 && dir == 128 || collator.compare(value1, value2) > 0 && dir == 1024) {
                        String[] values = new String[numColumns];
                        int index = 0;
                        while (index < numColumns) {
                            values[index] = items[i].getText(index);
                            items[i].setText(index, items[j].getText(index));
                            ++index;
                        }
                        items[j].setText(values);
                    }
                    ++j;
                }
                ++i;
            }
        }

        @Override
        protected String getTextItem(Session activeSession, AnalysisResultPCSampling samplingResult, TableType tableType, String name) {
            return name;
        }
    }

    private static final class PercentColumnListener
    extends AbstractColumnListener {
        private PercentColumnListener() {
        }

        @Override
        protected String getTextItem(Session activeSession, AnalysisResultPCSampling samplingResult, TableType tableType, String name) {
            Long samples = TableType.CUDA_FUNCTIONS == tableType ? Long.valueOf(samplingResult.getSampleCount(samplingResult.getFunctionId(name, activeSession), activeSession)) : Long.valueOf(samplingResult.getSampleCount(name, activeSession));
            double percentSamples = samples != null ? 100.0 * (double)samples.longValue() / samplingResult.getTotalSamples(activeSession) : 0.0;
            return String.format("%.2f %%", percentSamples);
        }
    }

    private static final class SampleColumnListener
    extends AbstractColumnListener {
        private SampleColumnListener() {
        }

        @Override
        protected String getTextItem(Session activeSession, AnalysisResultPCSampling samplingResult, TableType tableType, String name) {
            Long samples = TableType.CUDA_FUNCTIONS == tableType ? Long.valueOf(samplingResult.getSampleCount(samplingResult.getFunctionId(name, activeSession), activeSession)) : Long.valueOf(samplingResult.getSampleCount(name, activeSession));
            return samples != null ? samples.toString() : "0";
        }
    }

    private static enum TableColumns {
        PASCAL_FUNCTIONS(Arrays.asList(6, 7), TableType.CUDA_FUNCTIONS, Arrays.asList(PCSamplingResultControl.access$0(), ViperMessages.Total_Samples_Title, PCSamplingResultControl.access$1(), PCSamplingResultControl.access$2(), PCSamplingResultControl.access$3(), PCSamplingResultControl.access$4()), Arrays.asList(PCSamplingResultControl.access$5(), PCSamplingResultControl.access$6(), PCSamplingResultControl.access$7(), PCSamplingResultControl.access$8(), PCSamplingResultControl.access$9(), PCSamplingResultControl.access$10()), Arrays.asList(new NameColumnListener(), new SampleColumnListener(), new PercentColumnListener(), new LatencySampleColumnListener(), new IssuePipeBusySampleColumnListener(), new InstIssuedSampleColumnListener()), 1),
        PASCAL_SOURCE_FILES(Arrays.asList(6, 7), TableType.SOURCE_FILE, Arrays.asList(PCSamplingResultControl.access$11(), ViperMessages.Total_Samples_Title, PCSamplingResultControl.access$12(), PCSamplingResultControl.access$2(), PCSamplingResultControl.access$3(), PCSamplingResultControl.access$4()), Arrays.asList(PCSamplingResultControl.access$13(), PCSamplingResultControl.access$14(), PCSamplingResultControl.access$7(), PCSamplingResultControl.access$8(), PCSamplingResultControl.access$9(), PCSamplingResultControl.access$10()), Arrays.asList(new NameColumnListener(), new SampleColumnListener(), new PercentColumnListener(), new LatencySampleColumnListener(), new IssuePipeBusySampleColumnListener(), new InstIssuedSampleColumnListener()), 1),
        MAXWELL_FUNCTIONS(Arrays.asList(5), TableType.CUDA_FUNCTIONS, Arrays.asList(PCSamplingResultControl.access$0(), ViperMessages.Total_Samples_Title, PCSamplingResultControl.access$1()), Arrays.asList(PCSamplingResultControl.access$5(), PCSamplingResultControl.access$6(), PCSamplingResultControl.access$7()), Arrays.asList(new NameColumnListener(), new SampleColumnListener(), new PercentColumnListener()), 1),
        MAXWELL_SOURCE_FILES(Arrays.asList(5), TableType.SOURCE_FILE, Arrays.asList(PCSamplingResultControl.access$11(), ViperMessages.Total_Samples_Title, PCSamplingResultControl.access$12()), Arrays.asList(PCSamplingResultControl.access$13(), PCSamplingResultControl.access$14(), PCSamplingResultControl.access$7()), Arrays.asList(new NameColumnListener(), new SampleColumnListener(), new PercentColumnListener()), 1);

        private List<Integer> computeMajorList;
        private TableType tableType;
        private List<String> columnHeaders;
        private List<String> columnTooltips;
        private List<AbstractColumnListener> columnListeners;
        private int defaultSortIndex;
        private static Map<Integer, Map<TableType, TableColumns>> tableColumnsMap;

        static {
            tableColumnsMap = new HashMap<Integer, Map<TableType, TableColumns>>();
            TableColumns[] tableColumnsArray = TableColumns.values();
            int n = tableColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumns column = tableColumnsArray[n2];
                for (int major : column.computeMajorList) {
                    Map<Object, Object> columnsMap;
                    if (tableColumnsMap.containsKey(major)) {
                        columnsMap = tableColumnsMap.get(major);
                        columnsMap.put((Object)column.tableType, (Object)column);
                        continue;
                    }
                    columnsMap = new HashMap<TableType, TableColumns>();
                    columnsMap.put((Object)column.tableType, (Object)column);
                    tableColumnsMap.put(major, columnsMap);
                }
                ++n2;
            }
        }

        private TableColumns(List<Integer> computeMajorList, TableType tableType, List<String> columnHeaders, List<String> columnToolTips, List<AbstractColumnListener> columnListeners, int defaultSortIndex) {
            this.computeMajorList = computeMajorList;
            this.tableType = tableType;
            this.columnHeaders = columnHeaders;
            this.columnListeners = columnListeners;
            this.columnTooltips = columnToolTips;
            this.defaultSortIndex = defaultSortIndex;
        }

        private String getTableColumnHeader(int index) {
            if (index < this.columnHeaders.size()) {
                return this.columnHeaders.get(index);
            }
            return null;
        }

        private String getTableColumnTooltip(int index) {
            if (index < this.columnTooltips.size()) {
                return this.columnTooltips.get(index);
            }
            return null;
        }

        private AbstractColumnListener getTableColumnListener(int index) {
            if (index < this.columnListeners.size()) {
                return this.columnListeners.get(index);
            }
            return null;
        }

        private int getNumColumns() {
            return this.columnHeaders.size();
        }

        private void sortDefaultColumn(int dir) {
            if (this.defaultSortIndex < this.columnListeners.size()) {
                AbstractColumnListener listener = this.columnListeners.get(this.defaultSortIndex);
                listener.sortColumn(dir);
            }
        }

        private static TableColumns getTableColumns(int major, TableType tableType) {
            Map<TableType, TableColumns> columnsMap = tableColumnsMap.get(major);
            if (columnsMap != null) {
                return columnsMap.get((Object)tableType);
            }
            return null;
        }
    }

    private static enum TableType {
        CUDA_FUNCTIONS,
        SOURCE_FILE;

    }
}

