/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineTreeContentProvider;
import com.nvidia.viper.ui.ExecutableOptionsPropertyControl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class TimelineOptionsControl
extends Composite {
    private Session session;
    private List<ITimelineOptionListener> listeners = new ArrayList<ITimelineOptionListener>();
    private CheckboxTreeViewer treeView;
    private CLabel noteLabel;
    private GridData noteLabelData;
    private TimeRangeControl rangeControl;

    public TimelineOptionsControl(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createControls();
    }

    private void enableSubTimelines(TimelineKind kind, boolean check) {
        Object[] children = kind.getChildren();
        if (children != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                TimelineKind child = (TimelineKind)((Object)object);
                this.enableSubTimelines(child, check);
                ++n2;
            }
        } else if (this.session != null) {
            this.session.enableTimeline(kind, check);
        }
        this.treeItemStateChanged(kind);
    }

    private void treeItemStateChanged(TimelineKind kind) {
        this.treeView.update((Object)kind, null);
        Image image = !this.treeView.getChecked((Object)kind) ? kind.getImage() : null;
        String message = !this.treeView.getChecked((Object)kind) ? kind.getTooltip() : null;
        this.setNote(message, image);
    }

    private void enableParents(TimelineKind kind, boolean checked) {
        TimelineKind parent = (TimelineKind)((Object)kind.getParents());
        if (parent != null) {
            Object[] objectArray = parent.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                TimelineKind tlk = (TimelineKind)((Object)child);
                if (this.treeView.getChecked((Object)tlk) != checked) {
                    return;
                }
                ++n2;
            }
            this.treeView.setChecked((Object)parent, checked);
            this.enableParents(parent, checked);
            this.treeItemStateChanged(kind);
        }
    }

    private void createControls() {
        this.rangeControl = new TimeRangeControl(this, 0);
        this.rangeControl.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label label = new Label((Composite)this, 0);
        label.setText(ViperMessages.TimelineOptions_EnableTimelines_Label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.treeView = new CheckboxTreeViewer((Composite)this);
        this.treeView.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeView.setContentProvider((IContentProvider)new TimelineTreeContentProvider());
        this.treeView.setInput((Object)"root");
        this.treeView.setSubtreeChecked((Object)TimelineKind.ROOT, true);
        this.treeView.expandToLevel((Object)TimelineKind.ROOT, 2);
        this.treeView.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                TimelineOptionsControl.this.treeView.setSubtreeChecked(element, event.getChecked());
                if (element instanceof TimelineKind) {
                    TimelineKind tlKind = (TimelineKind)((Object)element);
                    TimelineOptionsControl.this.enableSubTimelines(tlKind, event.getChecked());
                    TimelineOptionsControl.this.enableParents(tlKind, event.getChecked());
                    Object[] checked = TimelineOptionsControl.this.treeView.getCheckedElements();
                    if (checked != null && checked.length > 0) {
                        TimelineOptionsControl.this.firePageComplete(true, null);
                    } else {
                        TimelineOptionsControl.this.firePageComplete(false, ViperMessages.TimelineOptions_TimelineTree_Empty_Error);
                    }
                }
            }
        });
        this.treeView.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeView);
        this.noteLabel = new CLabel((Composite)this, 0);
        this.noteLabelData = new GridData(4, 0x1000000, true, false);
        this.noteLabel.setLayoutData((Object)this.noteLabelData);
        this.noteLabelData.exclude = true;
    }

    public void setInput(Session session) {
        this.session = session;
    }

    public void init(Session session) {
        if (session == null) {
            return;
        }
        this.rangeControl.enableTimeRange.setSelection(session.isEnableTimeRange());
        this.rangeControl.enable(session.isEnableTimeRange());
        String str = session.getTimelineStart() == -1L ? "" : String.valueOf(session.getTimelineStart() / 1000000L);
        this.rangeControl.textStart.setText(str);
        str = session.getTimelineEnd() == -1L ? "" : String.valueOf(session.getTimelineEnd() / 1000000L);
        this.rangeControl.textEnd.setText(str);
        Set<TimelineKind> disabled = session.getDisabledTimeline();
        if (disabled != null) {
            for (TimelineKind kind : disabled) {
                this.treeView.setChecked((Object)kind, false);
            }
        } else {
            this.treeView.setSubtreeChecked((Object)TimelineKind.ROOT, true);
        }
    }

    public void updateTimelineOptions(Session session) {
        TreeItem[] items;
        if (session == null) {
            return;
        }
        boolean selection = this.rangeControl.enableTimeRange.getSelection();
        session.setEnableTimeRange(selection);
        if (selection) {
            session.setTimelineStart(Long.parseLong(this.rangeControl.textStart.getText()));
            session.setTimelineEnd(Long.parseLong(this.rangeControl.textEnd.getText()));
        }
        TreeItem[] treeItemArray = items = this.treeView.getTree().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.updateDisabledTimelines(item.getData(), session);
            ++n2;
        }
    }

    private void updateDisabledTimelines(Object element, Session session) {
        if (element instanceof TimelineKind) {
            TimelineKind kind = (TimelineKind)((Object)element);
            Object[] children = kind.getChildren();
            if (children != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    this.updateDisabledTimelines(child, session);
                    ++n2;
                }
            } else {
                session.enableTimeline(kind, this.treeView.getChecked(element));
            }
        }
    }

    private void firePageComplete(boolean complete, String message) {
        for (ITimelineOptionListener listener : this.listeners) {
            listener.firePageComplete(complete, message);
        }
    }

    public void addListener(ITimelineOptionListener listener) {
        this.listeners.add(listener);
    }

    public void setNote(String message, Image image) {
        this.noteLabel.setText(message);
        this.noteLabel.setImage(image);
        this.noteLabelData.exclude = message == null || message.isEmpty();
        this.noteLabel.layout();
        Composite parent = this.noteLabel.getParent();
        while (parent != null) {
            parent.layout();
            parent = parent.getParent();
        }
    }

    public static interface ITimelineOptionListener {
        public void firePageComplete(boolean var1, String var2);
    }

    private class TimeRangeControl
    extends Composite {
        protected Text textStart;
        protected Text textEnd;
        protected Button enableTimeRange;

        public TimeRangeControl(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(5, false));
            this.setLayoutData(new GridData(4, 4, true, true));
            this.createControl();
        }

        private void createControl() {
            this.enableTimeRange = new Button((Composite)this, 32);
            this.enableTimeRange.setText(ViperMessages.TimelineOptions_TimeRange_Label);
            this.enableTimeRange.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 5, 1));
            this.enableTimeRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TimeRangeControl.this.enable(TimeRangeControl.this.enableTimeRange.getSelection());
                }
            });
            Label label = new Label((Composite)this, 0);
            label.setText("Start time ");
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.textStart = new Text((Composite)this, 2048);
            this.textStart.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.textStart.addVerifyListener((VerifyListener)new ExecutableOptionsPropertyControl.NumberVerifyListener());
            this.textStart.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TimeRangeControl.this.verifyStartEnd();
                    if (TimelineOptionsControl.this.session != null) {
                        String str = TimeRangeControl.this.textStart.getText();
                        if (str.isEmpty()) {
                            TimelineOptionsControl.this.session.setTimelineStart(-1L);
                        } else {
                            TimelineOptionsControl.this.session.setTimelineStart(Long.parseLong(str));
                        }
                    }
                }
            });
            label = new Label((Composite)this, 0);
            label.setText("ms to End time");
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.textEnd = new Text((Composite)this, 2048);
            this.textEnd.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.textEnd.addVerifyListener((VerifyListener)new ExecutableOptionsPropertyControl.NumberVerifyListener());
            this.textEnd.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TimeRangeControl.this.verifyStartEnd();
                    if (TimelineOptionsControl.this.session != null) {
                        String str = TimeRangeControl.this.textEnd.getText();
                        if (str.isEmpty()) {
                            TimelineOptionsControl.this.session.setTimelineEnd(-1L);
                        } else {
                            TimelineOptionsControl.this.session.setTimelineEnd(Long.parseLong(str));
                        }
                    }
                }
            });
            label = new Label((Composite)this, 0);
            label.setText("ms");
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.enable(this.enableTimeRange.getSelection());
        }

        public void enable(boolean enabled) {
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (!(child instanceof Button)) {
                    child.setEnabled(enabled);
                }
                ++n2;
            }
            if (!enabled) {
                TimelineOptionsControl.this.firePageComplete(true, null);
            } else {
                this.verifyStartEnd();
            }
            if (TimelineOptionsControl.this.session != null) {
                TimelineOptionsControl.this.session.setEnableTimeRange(enabled);
            }
        }

        private void verifyStartEnd() {
            String strStart = this.textStart.getText();
            String strEnd = this.textEnd.getText();
            if (strStart.isEmpty() || strEnd.isEmpty()) {
                TimelineOptionsControl.this.firePageComplete(false, ViperMessages.TimelineOptions_TimeRange_Empty_Error);
            } else if (Long.parseLong(strStart) >= Long.parseLong(strEnd)) {
                TimelineOptionsControl.this.firePageComplete(false, ViperMessages.TimelineOptions_TimeRange_StartGreaterThanEnd_Error);
            } else {
                TimelineOptionsControl.this.firePageComplete(true, null);
            }
        }
    }

    private class TreeLabelProvider
    extends CellLabelProvider
    implements ILabelProvider {
        private TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (!TimelineOptionsControl.this.treeView.getChecked(element) && element instanceof TimelineKind) {
                return ((TimelineKind)((Object)element)).getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TimelineKind) {
                return ((TimelineKind)((Object)element)).getName();
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }

        public String getToolTipText(Object element) {
            if (!TimelineOptionsControl.this.treeView.getChecked(element) && element instanceof TimelineKind) {
                return ((TimelineKind)((Object)element)).getTooltip();
            }
            return super.getToolTipText(element);
        }

        public Image getToolTipImage(Object object) {
            return this.getImage(object);
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 10);
        }
    }
}

