/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.parts;

import com.nvidia.viper.model.VerticalRuler;
import com.nvidia.viper.parts.VerticalRulerEditPart;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.swt.graphics.Cursor;

public class VerticalRulerResizeDragTracker
extends SimpleDragTracker {
    protected static final int DRAG_THRESHOLD = 3;
    private VerticalRulerEditPart source;
    private VerticalRuler ruler;
    private int minWidth;

    public VerticalRulerResizeDragTracker(VerticalRulerEditPart source, VerticalRuler ruler, int minWidth) {
        this.source = source;
        this.ruler = ruler;
        this.minWidth = minWidth;
    }

    protected boolean movedPastThreshold() {
        return Math.abs(this.getLocation().x - this.getStartLocation().x) > 3;
    }

    protected void eraseSourceFeedback() {
    }

    protected void showSourceFeedback() {
        Point loc = this.getLocation();
        this.source.getFigure().translateToRelative((Translatable)loc);
        if (loc.x > this.minWidth) {
            this.ruler.setWidth(loc.x);
        }
    }

    protected void performDrag() {
        this.source.refreshVisuals();
    }

    protected Cursor getDefaultCursor() {
        return Cursors.SIZEWE;
    }

    protected String getDebugName() {
        return "Vertical Ruler Resizing";
    }

    protected String getCommandName() {
        return "Resize";
    }
}

