/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import com.nvidia.viper.ViperExceptionHandler;
import java.util.HashMap;
import java.util.Map;

public enum CuptiMetricValueUtilizationLevel {
    CUPTI_METRIC_VALUE_UTILIZATION_IDLE(0),
    CUPTI_METRIC_VALUE_UTILIZATION_1(1),
    CUPTI_METRIC_VALUE_UTILIZATION_LOW(2),
    CUPTI_METRIC_VALUE_UTILIZATION_3(3),
    CUPTI_METRIC_VALUE_UTILIZATION_4(4),
    CUPTI_METRIC_VALUE_UTILIZATION_MID(5),
    CUPTI_METRIC_VALUE_UTILIZATION_6(6),
    CUPTI_METRIC_VALUE_UTILIZATION_7(7),
    CUPTI_METRIC_VALUE_UTILIZATION_HIGH(8),
    CUPTI_METRIC_VALUE_UTILIZATION_9(9),
    CUPTI_METRIC_VALUE_UTILIZATION_MAX(10);

    private int code;
    private static Map<Integer, CuptiMetricValueUtilizationLevel> codeMap;

    static {
        codeMap = new HashMap<Integer, CuptiMetricValueUtilizationLevel>();
        CuptiMetricValueUtilizationLevel[] cuptiMetricValueUtilizationLevelArray = CuptiMetricValueUtilizationLevel.values();
        int n = cuptiMetricValueUtilizationLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiMetricValueUtilizationLevel res = cuptiMetricValueUtilizationLevelArray[n2];
            codeMap.put(res.getCode(), res);
            ++n2;
        }
    }

    private CuptiMetricValueUtilizationLevel(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isCuptiEnum() {
        switch (this) {
            case CUPTI_METRIC_VALUE_UTILIZATION_IDLE: 
            case CUPTI_METRIC_VALUE_UTILIZATION_LOW: 
            case CUPTI_METRIC_VALUE_UTILIZATION_MID: 
            case CUPTI_METRIC_VALUE_UTILIZATION_HIGH: 
            case CUPTI_METRIC_VALUE_UTILIZATION_MAX: {
                return true;
            }
        }
        return false;
    }

    public static CuptiMetricValueUtilizationLevel valueForPercent(double levelPercent) {
        if (levelPercent > 0.9) {
            return CUPTI_METRIC_VALUE_UTILIZATION_MAX;
        }
        if (levelPercent > 0.8) {
            return CUPTI_METRIC_VALUE_UTILIZATION_9;
        }
        if (levelPercent > 0.7) {
            return CUPTI_METRIC_VALUE_UTILIZATION_HIGH;
        }
        if (levelPercent > 0.6) {
            return CUPTI_METRIC_VALUE_UTILIZATION_7;
        }
        if (levelPercent > 0.5) {
            return CUPTI_METRIC_VALUE_UTILIZATION_6;
        }
        if (levelPercent > 0.4) {
            return CUPTI_METRIC_VALUE_UTILIZATION_MID;
        }
        if (levelPercent > 0.3) {
            return CUPTI_METRIC_VALUE_UTILIZATION_4;
        }
        if (levelPercent > 0.2) {
            return CUPTI_METRIC_VALUE_UTILIZATION_3;
        }
        if (levelPercent > 0.1) {
            return CUPTI_METRIC_VALUE_UTILIZATION_LOW;
        }
        if (levelPercent > 0.0) {
            return CUPTI_METRIC_VALUE_UTILIZATION_1;
        }
        return CUPTI_METRIC_VALUE_UTILIZATION_IDLE;
    }

    public double getEquivalentUtilizationPercent() {
        switch (this) {
            case CUPTI_METRIC_VALUE_UTILIZATION_IDLE: {
                return 0.0;
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_1: {
                return 0.05;
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_LOW: {
                return 0.15;
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_3: {
                return 0.25;
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_4: {
                return 0.35;
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_MID: {
                return 0.45;
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_6: {
                return 0.55;
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_7: {
                return 0.65;
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_HIGH: {
                return 0.75;
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_9: {
                return 0.85;
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_MAX: {
                return 0.95;
            }
        }
        ViperExceptionHandler.logError("unexpected utilization value: " + (Object)((Object)this));
        return 0.0;
    }

    public String toString() {
        switch (this) {
            case CUPTI_METRIC_VALUE_UTILIZATION_IDLE: {
                return "Idle";
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_1: 
            case CUPTI_METRIC_VALUE_UTILIZATION_LOW: 
            case CUPTI_METRIC_VALUE_UTILIZATION_3: {
                return "Low (" + this.code + ")";
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_4: 
            case CUPTI_METRIC_VALUE_UTILIZATION_MID: 
            case CUPTI_METRIC_VALUE_UTILIZATION_6: {
                return "Mid (" + this.code + ")";
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_7: 
            case CUPTI_METRIC_VALUE_UTILIZATION_HIGH: 
            case CUPTI_METRIC_VALUE_UTILIZATION_9: {
                return "High (" + this.code + ")";
            }
            case CUPTI_METRIC_VALUE_UTILIZATION_MAX: {
                return "Max";
            }
        }
        return "<unknown>";
    }

    public static CuptiMetricValueUtilizationLevel valueOf(String string) {
        return Enum.valueOf(CuptiMetricValueUtilizationLevel.class, string);
    }
}

