/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.activity.PThreadActivityKind;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeChiron;

public class PThreadActivity
implements ICuptiActivity {
    protected int kind;
    public long id;
    private long publicId;
    public int pid;
    public int tid;
    public int otherTid;
    public long mutex;
    public long cond;
    public long start;
    public long end;

    public PThreadActivity() {
        this.kind = PThreadActivityKind.PTHREAD_ACTIVITY_KIND_INVALID.getCode();
    }

    public PThreadActivity(PThreadActivityKind kind, long id, int pid, int tid, long start, long end, int otherTid, long mutex, long cond) {
        this.kind = kind.getCode();
        this.id = id;
        this.publicId = id;
        this.pid = pid;
        this.tid = tid;
        this.start = start;
        this.end = end;
        this.otherTid = otherTid;
        this.mutex = mutex;
        this.cond = cond;
    }

    public PThreadActivityKind getPThreadKind() {
        return PThreadActivityKind.valueOf(this.kind);
    }

    @Override
    public int getKindCode() {
        return this.kind;
    }

    public String getName() {
        switch (PThreadActivityKind.valueOf(this.kind)) {
            case PTHREAD_ACTIVITY_KIND_ENTER: {
                return "pthread_enter";
            }
            case PTHREAD_ACTIVITY_KIND_EXIT: {
                return "pthread_exit";
            }
            case PTHREAD_ACTIVITY_KIND_CREATE: {
                return "pthread_create";
            }
            case PTHREAD_ACTIVITY_KIND_JOIN: {
                return "pthread_join";
            }
            case PTHREAD_ACTIVITY_KIND_MUTEX_LOCK: {
                return "pthread_mutex_lock";
            }
            case PTHREAD_ACTIVITY_KIND_MUTEX_UNLOCK: {
                return "pthread_mutex_unlock";
            }
            case PTHREAD_ACTIVITY_KIND_COND_BROADCAST: {
                return "pthread_cond_broadcast";
            }
            case PTHREAD_ACTIVITY_KIND_COND_SIGNAL: {
                return "pthread_cond_signal";
            }
            case PTHREAD_ACTIVITY_KIND_COND_TIMEDWAIT: {
                return "pthread_timedwait";
            }
            case PTHREAD_ACTIVITY_KIND_COND_WAIT: {
                return "pthread_cond_wait";
            }
        }
        return "<unknown>";
    }

    @Override
    public boolean isValid() {
        return this.kind != PThreadActivityKind.PTHREAD_ACTIVITY_KIND_INVALID.getCode();
    }

    @Override
    public CuptiActivityKind getKind() {
        return CuptiActivityKind.CUPTI_ACTIVITY_KIND_PTHREAD;
    }

    @Override
    public long getID() {
        return this.publicId;
    }

    @Override
    public void setID(long id) {
        this.publicId = id;
    }

    @Override
    public void appendToPDM(long pdm) throws CuptiException {
        throw new CuptiException("Not applicable");
    }

    public void appendToPDM(String pdmFilename) throws ViperException {
        if (!NativeChiron.appendActivity(pdmFilename, this.id, this.kind, this.pid, this.tid, this.start, this.end, this.otherTid, this.mutex, this.cond)) {
            throw new ViperException("Failed to append pthread activity to database");
        }
    }
}

