/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public final class SourceHeaderPartnerFinder {
    private SourceHeaderPartnerFinder() {
    }

    private static IFile findInContainer(IContainer container, final String basename) {
        final IFile[] result = new IFile[1];
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (result[0] != null) {
                    return false;
                }
                if (!proxy.isAccessible()) {
                    return false;
                }
                if (proxy.getType() == 1 && proxy.getName().equals(basename)) {
                    result[0] = (IFile)proxy.requestResource();
                    return false;
                }
                return true;
            }
        };
        try {
            container.accept(visitor, 0);
        }
        catch (CoreException coreException) {}
        return result[0];
    }

    private static IContentType[] getPartnerContentTypes(String contentTypeId) {
        IContentTypeManager mgr = Platform.getContentTypeManager();
        if (contentTypeId.equals("org.eclipse.cdt.core.cHeader")) {
            return new IContentType[]{mgr.getContentType("org.eclipse.cdt.core.cSource"), mgr.getContentType("org.eclipse.cdt.core.cxxSource")};
        }
        if (contentTypeId.equals("org.eclipse.cdt.core.cSource")) {
            return new IContentType[]{mgr.getContentType("org.eclipse.cdt.core.cHeader"), mgr.getContentType("org.eclipse.cdt.core.cxxHeader")};
        }
        if (contentTypeId.equals("org.eclipse.cdt.core.cxxHeader")) {
            return new IContentType[]{mgr.getContentType("org.eclipse.cdt.core.cxxSource"), mgr.getContentType("org.eclipse.cdt.core.cSource")};
        }
        if (contentTypeId.equals("org.eclipse.cdt.core.cxxSource")) {
            return new IContentType[]{mgr.getContentType("org.eclipse.cdt.core.cxxHeader"), mgr.getContentType("org.eclipse.cdt.core.cHeader")};
        }
        return new IContentType[0];
    }

    private static ITranslationUnit getPartnerFileFromFilename(ITranslationUnit tu) {
        IPath sourceFileLocation = tu.getLocation();
        if (sourceFileLocation == null) {
            return null;
        }
        IPath partnerBasePath = sourceFileLocation.removeFileExtension();
        IContentType[] contentTypes = SourceHeaderPartnerFinder.getPartnerContentTypes(tu.getContentTypeId());
        HashSet<String> extensionsTried = new HashSet<String>();
        int j = 0;
        while (j < contentTypes.length) {
            IContentType contentType = contentTypes[j];
            String[] partnerExtensions = contentType.getFileSpecs(8);
            int i = 0;
            while (i < partnerExtensions.length) {
                String ext = partnerExtensions[i];
                if (extensionsTried.add(ext)) {
                    ITranslationUnit partnerUnit;
                    String partnerFileBasename = partnerBasePath.addFileExtension(ext).lastSegment();
                    IFile partnerFile = null;
                    IResource resource = tu.getResource();
                    IContainer container = resource != null ? resource.getParent() : null;
                    while (container != null && partnerFile == null && !(container instanceof IWorkspaceRoot)) {
                        partnerFile = SourceHeaderPartnerFinder.findInContainer(container, partnerFileBasename);
                        container = container.getParent();
                    }
                    if (partnerFile != null && (partnerUnit = (ITranslationUnit)CoreModel.getDefault().create(partnerFile)) != null) {
                        return partnerUnit;
                    }
                    if (resource == null) {
                        IPath partnerFileLoation = partnerBasePath.removeLastSegments(1).append(partnerFileBasename);
                        ITranslationUnit partnerUnit2 = CoreModel.getDefault().createTranslationUnitFrom(tu.getCProject(), partnerFileLoation);
                        if (partnerUnit2 != null) {
                            return partnerUnit2;
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        return null;
    }

    public static ITranslationUnit getPartnerTranslationUnit(ITranslationUnit tu) {
        ITranslationUnit partnerUnit = SourceHeaderPartnerFinder.getPartnerFileFromFilename(tu);
        if (partnerUnit == null) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            PartnerFileComputer computer = new PartnerFileComputer();
            ASTProvider.getASTProvider().runOnAST((ICElement)tu, ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)monitor, computer);
            partnerUnit = SourceHeaderPartnerFinder.createTranslationUnit(computer.getPartnerFileLocation(), tu.getCProject());
        }
        return partnerUnit;
    }

    public static ITranslationUnit getPartnerTranslationUnit(ITranslationUnit tu, CRefactoringContext refactoringContext) throws CoreException {
        ITranslationUnit partnerUnit = SourceHeaderPartnerFinder.getPartnerFileFromFilename(tu);
        if (partnerUnit == null) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IASTTranslationUnit ast = refactoringContext.getAST(tu, (IProgressMonitor)monitor);
            PartnerFileVisitor visitor = new PartnerFileVisitor();
            ast.accept((ASTVisitor)visitor);
            partnerUnit = SourceHeaderPartnerFinder.createTranslationUnit(visitor.getPartnerFileLocation(), tu.getCProject());
        }
        return partnerUnit;
    }

    private static ITranslationUnit createTranslationUnit(IPath partnerFileLoation, ICProject project) {
        ITranslationUnit partnerUnit = null;
        if (partnerFileLoation != null && (partnerUnit = (ITranslationUnit)CoreModel.getDefault().create(partnerFileLoation)) == null) {
            partnerUnit = CoreModel.getDefault().createTranslationUnitFrom(project, partnerFileLoation);
        }
        return partnerUnit;
    }

    private static class Counter {
        public int fCount;

        private Counter() {
        }
    }

    private static class PartnerFileComputer
    implements ASTCache.ASTRunnable {
        PartnerFileVisitor fVisitor = null;

        private PartnerFileComputer() {
        }

        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
            if (ast != null && ast.getIndex() != null) {
                this.fVisitor = new PartnerFileVisitor();
                ast.accept((ASTVisitor)this.fVisitor);
            }
            return Status.OK_STATUS;
        }

        public IPath getPartnerFileLocation() {
            if (this.fVisitor != null) {
                return this.fVisitor.getPartnerFileLocation();
            }
            return null;
        }
    }

    private static class PartnerFileVisitor
    extends ASTVisitor {
        private static final int CONFIDENCE_LIMIT = 15;
        private static final int SUSPECT_LIMIT = 15;
        private IIndex fIndex;
        private IPath fFilePath;
        private Map<IPath, Counter> fMap;
        private int fConfidence;
        private int fSuspect;
        private IPath fFavoriteLocation;

        public PartnerFileVisitor() {
            this.shouldVisitDeclarators = true;
            this.shouldVisitTranslationUnit = true;
            this.fMap = new HashMap<IPath, Counter>();
        }

        public int visit(IASTTranslationUnit tu) {
            this.fIndex = tu.getIndex();
            if (this.fIndex == null) {
                return 2;
            }
            this.fFilePath = Path.fromOSString((String)tu.getFilePath());
            return super.visit(tu);
        }

        public IPath getPartnerFileLocation() {
            return this.fFavoriteLocation;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int visit(IASTDeclarator declarator) {
            if (!(declarator instanceof IASTFunctionDeclarator)) return 1;
            IASTName name = declarator.getName();
            if (name == null) return 1;
            if (declarator.getNestedDeclarator() != null) return 1;
            IBinding binding = name.resolveBinding();
            if (binding == null) return 1;
            if (binding instanceof IProblemBinding) return 1;
            boolean isDefinition = name.isDefinition();
            try {
                IIndexName[] partnerNames = isDefinition ? this.fIndex.findNames(binding, 9) : this.fIndex.findNames(binding, 10);
                if (partnerNames.length == 0) {
                    ++this.fSuspect;
                    if (this.fSuspect == 15) {
                        this.fFavoriteLocation = null;
                        return 2;
                    }
                }
                int i = 0;
                while (true) {
                    IPath partnerFileLocation;
                    if (i >= partnerNames.length) {
                        return 1;
                    }
                    IIndexName partnerName = partnerNames[i];
                    IASTFileLocation partnerLocation = partnerName.getFileLocation();
                    if (partnerLocation != null && !this.fFilePath.equals((Object)(partnerFileLocation = Path.fromOSString((String)partnerLocation.getFileName())))) {
                        this.addPotentialPartnerFileLocation(partnerFileLocation);
                        if (this.fConfidence == 15) {
                            return 2;
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException exc) {
                CUIPlugin.log(exc.getStatus());
            }
            return 1;
        }

        private void addPotentialPartnerFileLocation(IPath partnerFileLocation) {
            Counter counter = this.fMap.get(partnerFileLocation);
            if (counter == null) {
                counter = new Counter();
                this.fMap.put(partnerFileLocation, counter);
            }
            ++counter.fCount;
            if (counter.fCount > this.fConfidence) {
                this.fConfidence = counter.fCount;
                this.fFavoriteLocation = partnerFileLocation;
            }
        }
    }
}

