/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.register;

import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.update.AbstractCachingVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.update.UserEditEvent;

public class RegisterCellModifier
extends WatchExpressionCellModifier {
    private AbstractCachingVMProvider fProvider;
    private SyncRegisterDataAccess fDataAccess = null;
    protected String formatInEditing;

    public RegisterCellModifier(AbstractCachingVMProvider provider, SyncRegisterDataAccess access) {
        this.fProvider = provider;
        this.fDataAccess = access;
    }

    public SyncRegisterDataAccess getRegisterDataAccess() {
        return this.fDataAccess;
    }

    protected IRegisters.IRegisterDMContext getRegisterDMC(Object element) {
        if (element instanceof IDMVMContext) {
            IDMContext dmc = ((IDMVMContext)element).getDMContext();
            return (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IRegisterDMContext.class);
        }
        return null;
    }

    @Override
    public boolean canModify(Object element, String property) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(property)) {
            if (this.getRegisterDMC(element) == null) {
                return false;
            }
            IRegisters.IRegisterDMData regData = this.fDataAccess.readRegister(element);
            return regData == null || regData.isWriteable();
        }
        return super.canModify(element, property);
    }

    @Override
    public Object getValue(Object element, String property) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(property)) {
            String formatId = null;
            formatId = element instanceof IVMContext ? this.queryFormat((IVMContext)element) : "NATURAL.Format";
            this.formatInEditing = formatId;
            String value = this.fDataAccess.getFormattedRegisterValue(element, formatId);
            if (value == null) {
                return "...";
            }
            return value;
        }
        return super.getValue(element, property);
    }

    @Override
    public void modify(Object element, String property, Object value) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(property)) {
            if (value instanceof String) {
                String formatId = this.formatInEditing;
                if (element instanceof IVMContext) {
                    if (formatId == null) {
                        formatId = this.queryFormat((IVMContext)element);
                    }
                } else {
                    formatId = "NATURAL.Format";
                }
                this.fDataAccess.writeRegister(element, (String)value, formatId);
                this.fProvider.handleEvent(new UserEditEvent(element));
            }
        } else {
            super.modify(element, property, value);
        }
    }
}

