/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.launch;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractExecutionContextVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.ExecutionContextLabelText;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.MessagesForLaunchVM;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.StateChangedEvent;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;

public abstract class AbstractContainerVMNode
extends AbstractExecutionContextVMNode
implements IElementLabelProvider,
IElementPropertiesProvider {
    private IElementLabelProvider fLabelProvider = this.createLabelProvider();

    public AbstractContainerVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IContainerDMContext.class);
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new ExecutionContextLabelText(MessagesForLaunchVM.AbstractContainerVMNode_No_columns__text_format, new String[]{"name_known", "name", "id_known", "id"}), new LabelText(MessagesForLaunchVM.AbstractContainerVMNode_No_columns__Error__label, new String[0]), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_SUSPENDED")){
            {
                this.setPropertyNames(new String[]{"is_suspended"});
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                return Boolean.TRUE.equals(properties.get("is_suspended"));
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET"))}));
        return provider;
    }

    public void update(ILabelUpdate[] updates) {
        this.fLabelProvider.update(updates);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(final IPropertiesUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        AbstractContainerVMNode.this.updatePropertiesInSessionThread(updates);
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException v0) {
                var5_2 = updates;
                var4_3 = updates.length;
                var3_4 = 0;
                ** while (var3_4 < var4_3)
            }
lbl-1000:
            // 1 sources

            {
                update = var5_2[var3_4];
                this.handleFailedUpdate(update);
                ++var3_4;
                continue;
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IRunControl service = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            if (service == null) {
                this.handleFailedUpdate(update);
            } else {
                IRunControl.IExecutionDMContext dmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
                if (dmc == null) {
                    this.handleFailedUpdate(update);
                } else {
                    update.setProperty("is_suspended", service.isSuspended(dmc));
                    update.setProperty("is_stepping", service.isStepping(dmc));
                    service.getExecutionData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRunControl.IExecutionDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                        @Override
                        protected void handleSuccess() {
                            AbstractContainerVMNode.this.fillExecutionDataProperties(update, (IRunControl.IExecutionDMData)this.getData());
                            update.done();
                        }
                    });
                }
            }
            ++n2;
        }
    }

    protected void fillExecutionDataProperties(IPropertiesUpdate update, IRunControl.IExecutionDMData data) {
        String details;
        IRunControl.StateChangeReason reason = data.getStateChangeReason();
        if (reason != null) {
            update.setProperty("state_change_reason", data.getStateChangeReason().name());
        }
        if (data instanceof IRunControl.IExecutionDMData2 && (details = ((IRunControl.IExecutionDMData2)data).getDetails()) != null) {
            update.setProperty("state_change_details", details);
        }
    }

    @Override
    public void getContextsForEvent(VMDelta parentDelta, Object e, final DataRequestMonitor<IVMContext[]> rm) {
        if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            this.getContainerVMCForModelProxyInstallEvent(parentDelta, new DataRequestMonitor<VMContextInfo>(this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        rm.setData((Object)new IVMContext[]{((VMContextInfo)this.getData()).fVMContext});
                    } else {
                        rm.setData((Object)new IVMContext[0]);
                    }
                    rm.done();
                }
            });
        } else {
            super.getContextsForEvent(parentDelta, e, rm);
        }
    }

    private void getContainerVMCForModelProxyInstallEvent(VMDelta parentDelta, final DataRequestMonitor<VMContextInfo> rm) {
        this.getVMProvider().updateNode((IVMNode)this, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            protected void handleSuccess() {
                try {
                    AbstractContainerVMNode.this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IRunControl runControl = (IRunControl)AbstractContainerVMNode.this.getServicesTracker().getService(IRunControl.class);
                            if (runControl != null) {
                                int vmcIdx = -1;
                                int suspendedVmcIdx = -1;
                                int i = 0;
                                while (i < ((List)this.getData()).size()) {
                                    IDMVMContext vmc;
                                    IRunControl.IContainerDMContext containerDmc;
                                    if (((List)this.getData()).get(i) instanceof IDMVMContext && (containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)(vmc = (IDMVMContext)((List)this.getData()).get(i)).getDMContext(), IRunControl.IContainerDMContext.class)) != null) {
                                        int n = vmcIdx = vmcIdx < 0 ? i : vmcIdx;
                                        if (runControl.isSuspended((IRunControl.IExecutionDMContext)containerDmc)) {
                                            suspendedVmcIdx = suspendedVmcIdx < 0 ? i : suspendedVmcIdx;
                                        }
                                    }
                                    ++i;
                                }
                                if (suspendedVmcIdx >= 0) {
                                    rm.setData((Object)new VMContextInfo((IVMContext)((List)this.getData()).get(suspendedVmcIdx), suspendedVmcIdx, true));
                                } else if (vmcIdx >= 0) {
                                    rm.setData((Object)new VMContextInfo((IVMContext)((List)this.getData()).get(vmcIdx), vmcIdx, false));
                                } else {
                                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "No container available", null));
                                }
                                rm.done();
                            } else {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "No container available", null));
                                rm.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "", null));
                    rm.done();
                }
            }
        }));
    }

    @Override
    public int getDeltaFlags(Object e) {
        IDMContext dmc;
        IDMContext iDMContext = dmc = e instanceof IDMEvent ? ((IDMEvent)e).getDMContext() : null;
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            if (((IRunControl.IContainerResumedDMEvent)e).getReason() != IRunControl.StateChangeReason.STEP) {
                return 1024;
            }
        } else {
            if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
                return 0;
            }
            if (e instanceof SteppingController.SteppingTimedOutEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    return 1024;
                }
            } else {
                if (e instanceof IRunControl.IExitedDMEvent) {
                    return 1024;
                }
                if (e instanceof IRunControl.IStartedDMEvent) {
                    if (dmc instanceof IRunControl.IContainerDMContext) {
                        return 0x300000;
                    }
                    return 1024;
                }
                if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
                    return 0x300000;
                }
                if (e instanceof StateChangedEvent) {
                    return 2048;
                }
                if (e instanceof FullStackRefreshEvent && ((FullStackRefreshEvent)((Object)e)).getTriggeringEvent() instanceof IRunControl.IContainerSuspendedDMEvent) {
                    return 1024;
                }
            }
        }
        return 0;
    }

    @Override
    public void buildDelta(Object e, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor requestMonitor) {
        IDMContext dmc;
        IDMContext iDMContext = dmc = e instanceof IDMEvent ? ((IDMEvent)e).getDMContext() : null;
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            if (((IRunControl.IContainerResumedDMEvent)e).getReason() != IRunControl.StateChangeReason.STEP) {
                parentDelta.addNode(this.createVMContext(((IDMEvent)e).getDMContext()), 1024);
            }
        } else if (!(e instanceof IRunControl.IContainerSuspendedDMEvent)) {
            if (e instanceof SteppingController.SteppingTimedOutEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    parentDelta.addNode(this.createVMContext(dmc), 1024);
                }
            } else if (e instanceof IRunControl.IExitedDMEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    parentDelta.setFlags(parentDelta.getFlags() | 0x400);
                } else {
                    IRunControl.IContainerDMContext containerCtx = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
                    if (containerCtx != null) {
                        parentDelta.addNode(this.createVMContext((IDMContext)containerCtx), 1024);
                    }
                }
            } else if (e instanceof IRunControl.IStartedDMEvent) {
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    parentDelta.addNode(this.createVMContext(dmc), 0x300000);
                } else {
                    IRunControl.IContainerDMContext containerCtx = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
                    if (containerCtx != null) {
                        parentDelta.addNode(this.createVMContext((IDMContext)containerCtx), 1024);
                    }
                }
            } else {
                FullStackRefreshEvent refreshEvent;
                if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
                    this.getContainerVMCForModelProxyInstallEvent(parentDelta, new DataRequestMonitor<VMContextInfo>(this.getExecutor(), requestMonitor){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                parentDelta.addNode((Object)((VMContextInfo)this.getData()).fVMContext, nodeOffset + ((VMContextInfo)this.getData()).fIndex, 0x100000 | (((VMContextInfo)this.getData()).fIsSuspended ? 0 : 0x200000));
                            }
                            requestMonitor.done();
                        }
                    });
                    return;
                }
                if (e instanceof StateChangedEvent) {
                    if (dmc instanceof IRunControl.IContainerDMContext) {
                        parentDelta.addNode(this.createVMContext(dmc), 2048);
                    }
                } else if (e instanceof FullStackRefreshEvent && (refreshEvent = (FullStackRefreshEvent)((Object)e)).getTriggeringEvent() instanceof IRunControl.IContainerSuspendedDMEvent) {
                    IRunControl.IContainerSuspendedDMEvent containerTriggerEvent = (IRunControl.IContainerSuspendedDMEvent)refreshEvent.getTriggeringEvent();
                    this.buildDeltaForFullStackRefreshEvent((IRunControl.IContainerDMContext)refreshEvent.getDMContext(), containerTriggerEvent.getTriggeringContexts(), parentDelta, nodeOffset, requestMonitor);
                    return;
                }
            }
        }
        requestMonitor.done();
    }

    protected void buildDeltaForFullStackRefreshEvent(final IRunControl.IContainerDMContext containerCtx, final IRunControl.IExecutionDMContext[] triggeringCtxs, final VMDelta parentDelta, int nodeOffset, final RequestMonitor rm) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRunControl runControlService = (IRunControl)AbstractContainerVMNode.this.getServicesTracker().getService(IRunControl.class);
                    if (runControlService == null) {
                        rm.done();
                        return;
                    }
                    boolean isStepping = false;
                    IRunControl.IExecutionDMContext[] iExecutionDMContextArray = triggeringCtxs;
                    int n = triggeringCtxs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRunControl.IExecutionDMContext triggeringCtx = iExecutionDMContextArray[n2];
                        if (runControlService.isStepping(triggeringCtx)) {
                            isStepping = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!isStepping) {
                        parentDelta.addNode(AbstractContainerVMNode.this.createVMContext((IDMContext)containerCtx), 1024);
                    }
                    rm.done();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            rm.done();
        }
    }

    private static class VMContextInfo {
        final IVMContext fVMContext;
        final int fIndex;
        final boolean fIsSuspended;

        VMContextInfo(IVMContext vmContext, int index, boolean isSuspended) {
            this.fVMContext = vmContext;
            this.fIndex = index;
            this.fIsSuspended = isSuspended;
        }
    }
}

