/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expert;

import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.TimeFormatter;
import com.nvidia.viper.ViperComputeDictionary;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import com.nvidia.viper.expert.EventTableLabelProvider;
import com.nvidia.viper.jni.CuptiMetricValueKind;
import com.nvidia.viper.jni.CuptiMetricValueUtilizationLevel;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.ExpertData;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalMemcpy;
import com.nvidia.viper.model.TimelineIntervalMemset;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EventTableColumnProvider {
    private TableViewer tableViewer;
    private ExpertData eti;
    private Vector<ColumnData> columnData;
    private Map<com.nvidia.viper.model.Event, ColumnData> eventColumnMap;
    private Map<Metric, ColumnData> metricColumnMap;
    private NumberFormat activeNumberFormatter;
    private NumberFormat activePercentFormatter;
    private static NumberFormat groupNumberFormatter;
    private static NumberFormat nonGroupNumberFormatter;
    private static NumberFormat groupPercentFormatter;
    private static NumberFormat nonGroupPercentFormatter;
    private boolean suppressPersist = false;
    private CuptiActivityComputeApiKind computeKind;

    static {
        nonGroupNumberFormatter = NumberFormat.getInstance();
        nonGroupNumberFormatter.setMaximumFractionDigits(3);
        nonGroupNumberFormatter.setGroupingUsed(false);
        groupNumberFormatter = NumberFormat.getInstance();
        groupNumberFormatter.setMaximumFractionDigits(3);
        groupNumberFormatter.setGroupingUsed(true);
        nonGroupPercentFormatter = NumberFormat.getPercentInstance();
        nonGroupPercentFormatter.setMaximumFractionDigits(1);
        nonGroupPercentFormatter.setGroupingUsed(false);
        groupPercentFormatter = NumberFormat.getPercentInstance();
        groupPercentFormatter.setMaximumFractionDigits(1);
        groupPercentFormatter.setGroupingUsed(true);
    }

    public EventTableColumnProvider(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.columnData = new Vector(32);
        this.eventColumnMap = new HashMap<com.nvidia.viper.model.Event, ColumnData>();
        this.metricColumnMap = new HashMap<Metric, ColumnData>();
        this.activeNumberFormatter = nonGroupNumberFormatter;
        this.activePercentFormatter = nonGroupPercentFormatter;
        this.computeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        this.columnData.add(new ColumnData(ColumnKind.NAME));
        this.columnData.add(new ColumnData(ColumnKind.INVOCATIONS));
        this.columnData.add(new ColumnData(ColumnKind.START_TIME));
        this.columnData.add(new ColumnData(ColumnKind.DURATION));
        this.columnData.add(new ColumnData(ColumnKind.AVG_DURATION));
        this.columnData.add(new ColumnData(ColumnKind.GRID_SIZE));
        this.columnData.add(new ColumnData(ColumnKind.BLOCK_SIZE));
        this.columnData.add(new ColumnData(ColumnKind.REGS_PER_THREAD));
        this.columnData.add(new ColumnData(ColumnKind.STAT_SHARED_MEM));
        this.columnData.add(new ColumnData(ColumnKind.DYNA_SHARED_MEM));
        this.columnData.add(new ColumnData(ColumnKind.AVG_DYNA_SHARED_MEM));
        this.columnData.add(new ColumnData(ColumnKind.BYTE_SIZE));
        this.columnData.add(new ColumnData(ColumnKind.THROUGHPUT));
        if (!"win32".equals(Platform.getOS())) {
            this.columnData.add(new ColumnData(ColumnKind.EMPTY));
        }
    }

    public void setShowNumberSeparators(boolean show) {
        this.activeNumberFormatter = show ? groupNumberFormatter : nonGroupNumberFormatter;
        this.activePercentFormatter = show ? groupPercentFormatter : nonGroupPercentFormatter;
        this.tableViewer.refresh();
    }

    public void setInput(ExpertData eti) {
        this.eti = eti;
        this.tableViewer.getTable().setSortColumn(null);
        HashSet<ColumnKind> columnKinds = new HashSet<ColumnKind>();
        HashSet<ColumnData> columnEvents = new HashSet<ColumnData>();
        HashSet<ColumnData> columnMetrics = new HashSet<ColumnData>();
        if (eti != null) {
            columnKinds.add(ColumnKind.NAME);
            if (ExpertData.Mode.INTERVAL.equals((Object)eti.getMode())) {
                columnKinds.add(ColumnKind.START_TIME);
                columnKinds.add(ColumnKind.DURATION);
                if (eti.hasIntervalKind(TimelineIntervalKind.MEMCPY_DTOD) || eti.hasIntervalKind(TimelineIntervalKind.MEMCPY_DTOH) || eti.hasIntervalKind(TimelineIntervalKind.MEMCPY_HTOD) || eti.hasIntervalKind(TimelineIntervalKind.MEMCPY_PTOP) || eti.hasIntervalKind(TimelineIntervalKind.MEMSET)) {
                    columnKinds.add(ColumnKind.BYTE_SIZE);
                    columnKinds.add(ColumnKind.THROUGHPUT);
                }
            } else {
                columnKinds.add(ColumnKind.INVOCATIONS);
                columnKinds.add(ColumnKind.AVG_DURATION);
            }
            if (eti.hasIntervalKind(TimelineIntervalKind.KERNEL)) {
                ColumnData cd;
                if (ExpertData.Mode.INTERVAL.equals((Object)eti.getMode())) {
                    columnKinds.add(ColumnKind.GRID_SIZE);
                    columnKinds.add(ColumnKind.BLOCK_SIZE);
                    columnKinds.add(ColumnKind.REGS_PER_THREAD);
                    columnKinds.add(ColumnKind.STAT_SHARED_MEM);
                    columnKinds.add(ColumnKind.DYNA_SHARED_MEM);
                } else {
                    columnKinds.add(ColumnKind.REGS_PER_THREAD);
                    columnKinds.add(ColumnKind.STAT_SHARED_MEM);
                    columnKinds.add(ColumnKind.AVG_DYNA_SHARED_MEM);
                }
                for (Metric metric : eti.getMetrics()) {
                    cd = this.metricColumnMap.get(metric);
                    if (cd == null) {
                        cd = new ColumnData(metric);
                        this.metricColumnMap.put(metric, cd);
                        this.columnData.add(cd);
                    }
                    columnMetrics.add(cd);
                }
                for (com.nvidia.viper.model.Event event : eti.getEvents()) {
                    cd = this.eventColumnMap.get(event);
                    if (cd == null) {
                        cd = new ColumnData(event);
                        this.eventColumnMap.put(event, cd);
                        this.columnData.add(cd);
                    }
                    columnEvents.add(cd);
                }
            }
            if (!"win32".equals(Platform.getOS())) {
                columnKinds.add(ColumnKind.EMPTY);
            }
        }
        try {
            this.suppressPersist = true;
            Expert expert = null;
            if (eti != null) {
                expert = eti.getSession().getExpert();
            }
            for (ColumnData data : this.columnData) {
                if (columnEvents.contains(data) || columnMetrics.contains(data) || columnKinds.contains((Object)data.kind)) {
                    data.addTableColumn();
                } else {
                    data.removeTableColumn();
                }
                if (expert == null) continue;
                data.restoreProperties(expert.getColumnProperties(data.kind.name(), data.getPersistedLabel()));
            }
            if (!this.restoreColumnOrder()) {
                this.restoreColumnOrder(this.columnData);
            }
        }
        catch (Throwable throwable) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EventTableColumnProvider.this.suppressPersist = false;
                }
            });
            throw throwable;
        }
        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * Unable to fully structure code
     */
    protected void persistColumnOrder() {
        block8: {
            if (this.suppressPersist || this.tableViewer.getTable() == null || this.eti == null || (expert = (session = this.eti.getSession()).getExpert()) == null) break block8;
            persistedOrder = expert.getColumnOrder();
            if (persistedOrder == null || persistedOrder.getSize() == 0) {
                persistedOrder = new Expert.ColumnOrder();
                for (ColumnData data : this.columnData) {
                    persistedOrder.add(ColumnData.access$1(data).name(), data.getPersistedLabel());
                }
            }
            currentColumns = this.tableViewer.getTable().getColumns();
            currentColumnOrder = this.tableViewer.getTable().getColumnOrder();
            currentIdOrder = new Vector<Expert.ColumnId>(currentColumnOrder.length);
            currentIdSet = new HashSet<Expert.ColumnId>();
            var11_8 = currentColumnOrder;
            var10_9 = currentColumnOrder.length;
            var9_11 = 0;
            while (var9_11 < var10_9) {
                i = var11_8[var9_11];
                data = this.getDataForColumn(currentColumns[i]);
                if (data != null) {
                    id = new Expert.ColumnId(ColumnData.access$1(data).name(), data.getPersistedLabel());
                    currentIdOrder.add(id);
                    currentIdSet.add(id);
                }
                ++var9_11;
            }
            currentIdx = 0;
            newColumnOrder = new Expert.ColumnOrder();
            var11_8 = persistedOrder.ids.iterator();
            block2: while (var11_8.hasNext()) {
                id = (Expert.ColumnId)var11_8.next();
                if (currentIdSet.contains(id)) ** GOTO lbl39
                newColumnOrder.add(id);
                continue;
lbl-1000:
                // 1 sources

                {
                    newColumnOrder.add((Expert.ColumnId)currentIdOrder.get(currentIdx));
                    if (id.equals(currentIdOrder.get(currentIdx))) {
                        ++currentIdx;
                        continue block2;
                    }
                    ++currentIdx;
lbl39:
                    // 2 sources

                    ** while (currentIdx < currentIdOrder.size())
                }
lbl40:
                // 1 sources

            }
            while (currentIdx < currentIdOrder.size()) {
                newColumnOrder.add((Expert.ColumnId)currentIdOrder.get(currentIdx));
                ++currentIdx;
            }
            expert.setColumnOrder(newColumnOrder);
        }
    }

    protected boolean restoreColumnOrder() {
        Session session;
        Expert expert;
        if (this.tableViewer.getTable() != null && this.eti != null && (expert = (session = this.eti.getSession()).getExpert()) != null) {
            try {
                Expert.ColumnOrder columnOrder = expert.getColumnOrder();
                Vector<ColumnData> orderedData = new Vector<ColumnData>();
                int i = 0;
                while (i < columnOrder.getSize()) {
                    String label;
                    ColumnKind kind = ColumnKind.valueOf(columnOrder.getKind(i));
                    ColumnData data = this.getDataForColumn(kind, label = columnOrder.getLabel(i));
                    if (data != null) {
                        orderedData.add(data);
                    }
                    ++i;
                }
                this.restoreColumnOrder(orderedData);
                return true;
            }
            catch (Exception e) {
                ViperExceptionHandler.logError("failed to restore column order", e);
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void restoreColumnOrder(Vector<ColumnData> datas) {
        block11: {
            if (this.tableViewer.getTable() == null) break block11;
            try {
                orderedIdx = new HashSet<Integer>();
                columns = this.tableViewer.getTable().getColumns();
                order = new int[columns.length];
                orderIdx = 0;
                block2: for (ColumnData data : datas) {
                    if (orderIdx >= order.length) break;
                    if (ColumnKind.EMPTY.equals((Object)ColumnData.access$1(data))) continue;
                    cidx = 0;
                    while (cidx < columns.length) {
                        if (columns[cidx] == ColumnData.access$0(data)) {
                            order[orderIdx++] = cidx;
                            orderedIdx.add(cidx);
                            continue block2;
                        }
                        ++cidx;
                    }
                }
                emptyColumnIdx = -1;
                emptyColumnData = this.getDataForColumn(ColumnKind.EMPTY, null);
                if (emptyColumnData != null) {
                    cidx = 0;
                    while (cidx < columns.length) {
                        if (columns[cidx] == ColumnData.access$0(emptyColumnData)) {
                            emptyColumnIdx = cidx;
                        }
                        ++cidx;
                    }
                }
                fillIdx = 0;
                ** GOTO lbl36
                {
                    ++fillIdx;
                    do {
                        if (orderedIdx.contains(fillIdx) || fillIdx == emptyColumnIdx) continue block5;
                        order[orderIdx] = fillIdx++;
                        ++orderIdx;
lbl36:
                        // 2 sources

                    } while (orderIdx < order.length);
                }
                if (emptyColumnIdx >= 0) {
                    order[order.length - 1] = emptyColumnIdx;
                }
                this.tableViewer.getTable().setColumnOrder(order);
            }
            catch (Exception e) {
                ViperExceptionHandler.logError("failed to restore column order from column data", e);
            }
        }
    }

    protected ColumnData getDataForColumn(ColumnKind kind, String label) {
        for (ColumnData data : this.columnData) {
            if (!data.kind.equals((Object)kind)) continue;
            if (!ColumnKind.EVENT.equals((Object)kind) && !ColumnKind.METRIC.equals((Object)kind)) {
                return data;
            }
            if (data.event != null && data.event.getName().equals(label)) {
                return data;
            }
            if (data.metric == null || !data.metric.getName().equals(label)) continue;
            return data;
        }
        return null;
    }

    protected ColumnData getDataForColumn(TableColumn tableColumn) {
        for (ColumnData data : this.columnData) {
            if (data.tableColumn != tableColumn) continue;
            return data;
        }
        return null;
    }

    public void getCsv(OutputStream os) throws IOException {
        if (this.tableViewer.getTable() != null) {
            TableColumn[] columns2 = this.tableViewer.getTable().getColumns();
            int[] order = this.tableViewer.getTable().getColumnOrder();
            ArrayList<ColumnData> datas = new ArrayList<ColumnData>();
            Object object = order;
            int n = order.length;
            int n2 = 0;
            while (n2 < n) {
                int idx = object[n2];
                ColumnData data = this.getDataForColumn(columns2[idx]);
                if (data != null && !ColumnKind.EMPTY.equals((Object)data.kind)) {
                    datas.add(data);
                }
                ++n2;
            }
            StringBuffer sbuf = new StringBuffer(1024);
            boolean first = true;
            object = datas.iterator();
            while (object.hasNext()) {
                ColumnData data = (ColumnData)object.next();
                if (!first) {
                    sbuf.append(',');
                }
                sbuf.append(data.getCsvLabel(this.computeKind));
                first = false;
            }
            sbuf.append("\n");
            os.write(sbuf.toString().getBytes());
            Object[] objectArray = this.eti.getDisplayResults();
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object result = objectArray[n4];
                sbuf.delete(0, sbuf.length());
                first = true;
                for (ColumnData data : datas) {
                    if (!first) {
                        sbuf.append(',');
                    }
                    if (result instanceof ITimelineInterval) {
                        sbuf.append(data.getText((ITimelineInterval)result, true));
                    } else if (result instanceof ExpertData.KernelAggregate) {
                        sbuf.append(data.getText((ExpertData.KernelAggregate)result, true));
                    }
                    first = false;
                }
                sbuf.append("\n");
                os.write(sbuf.toString().getBytes());
                ++n4;
            }
        }
    }

    public class ColumnData {
        public static final String NA_VALUE_CELL_LABEL = "n/a";
        public static final String OVERFLOW_VALUE_CELL_LABEL = "overflow";
        public static final String INVALID_VALUE_CELL_LABEL = "invalid";
        private ColumnKind kind;
        private com.nvidia.viper.model.Event event;
        private Metric metric;
        private Expert.ColumnProperties columnProperties;
        private TableColumn tableColumn;

        protected ColumnData(ColumnKind kind) {
            this.kind = kind;
            this.event = null;
            this.metric = null;
        }

        protected ColumnData(com.nvidia.viper.model.Event event) {
            this(ColumnKind.EVENT);
            this.event = event;
        }

        protected ColumnData(Metric metric) {
            this(ColumnKind.METRIC);
            this.metric = metric;
        }

        protected void restoreProperties(Expert.ColumnProperties columnProperties) {
            this.columnProperties = columnProperties;
            if (this.tableColumn != null) {
                Integer width = columnProperties.getWidth();
                if (width == null || ColumnKind.EMPTY.equals((Object)this.kind)) {
                    this.tableColumn.pack();
                } else {
                    this.tableColumn.setWidth(width.intValue());
                }
            }
        }

        protected void persistProperties() {
            if (!EventTableColumnProvider.this.suppressPersist && this.tableColumn != null && this.columnProperties != null && !ColumnKind.EMPTY.equals((Object)this.kind)) {
                Expert expert;
                this.columnProperties.setWidth(this.tableColumn.getWidth());
                if (EventTableColumnProvider.this.eti != null && (expert = EventTableColumnProvider.this.eti.getSession().getExpert()) != null) {
                    expert.setColumnProperties(this.kind.name(), this.getPersistedLabel(), this.columnProperties);
                }
            }
        }

        protected String getLabel(CuptiActivityComputeApiKind computeKind) {
            if (ColumnKind.EVENT.equals((Object)this.kind)) {
                return this.event.getShortDesc();
            }
            if (ColumnKind.METRIC.equals((Object)this.kind)) {
                return this.metric.getShortDesc();
            }
            return this.kind.getLabel(computeKind);
        }

        protected String getToolTip(CuptiActivityComputeApiKind computeKind) {
            if (ColumnKind.EVENT.equals((Object)this.kind)) {
                return this.event.getLongDesc();
            }
            if (ColumnKind.METRIC.equals((Object)this.kind)) {
                return this.metric.getLongDesc();
            }
            return this.kind.getTooltip(computeKind);
        }

        protected String getCsvLabel(CuptiActivityComputeApiKind computeKind) {
            if (ColumnKind.EVENT.equals((Object)this.kind)) {
                return this.event.getShortDesc();
            }
            if (ColumnKind.METRIC.equals((Object)this.kind)) {
                if (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_PERCENT.equals((Object)this.metric.getValueKind())) {
                    return String.valueOf(this.metric.getShortDesc()) + "(%)";
                }
                if (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_THROUGHPUT.equals((Object)this.metric.getValueKind())) {
                    return String.valueOf(this.metric.getShortDesc()) + "(bytes/sec)";
                }
                return this.metric.getShortDesc();
            }
            return this.kind.getCsvLabel(computeKind);
        }

        protected String getPersistedLabel() {
            if (ColumnKind.EVENT.equals((Object)this.kind)) {
                return this.event.getName();
            }
            if (ColumnKind.METRIC.equals((Object)this.kind)) {
                return this.metric.getName();
            }
            return null;
        }

        protected void addTableColumn() {
            if (this.tableColumn == null) {
                final Table table = EventTableColumnProvider.this.tableViewer.getTable();
                TableViewerColumn columnViewer = new TableViewerColumn(EventTableColumnProvider.this.tableViewer, 0);
                columnViewer.setLabelProvider((CellLabelProvider)new EventTableLabelProvider(table, this.kind));
                this.tableColumn = columnViewer.getColumn();
                this.tableColumn.setAlignment(this.kind.getAlignment());
                this.tableColumn.setData((Object)this);
                this.tableColumn.setText(this.getLabel(EventTableColumnProvider.this.computeKind));
                this.tableColumn.setToolTipText(this.getToolTip(EventTableColumnProvider.this.computeKind));
                this.tableColumn.setMoveable(!ColumnKind.EMPTY.equals((Object)this.kind));
                if (this.kind.getWidth() == null || ColumnKind.EMPTY.equals((Object)this.kind)) {
                    this.tableColumn.pack();
                } else {
                    this.tableColumn.setWidth(this.kind.getWidth().intValue());
                }
                this.tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int dir = table.getSortDirection();
                        dir = table.getSortColumn() == ColumnData.this.tableColumn ? (dir == 128 ? 1024 : 128) : 1024;
                        EventTableColumnProvider.this.eti.sortDisplayResults(ColumnData.this.kind.getComparator(dir, ColumnData.this, EventTableColumnProvider.this.eti.getSession()));
                        table.setSortDirection(dir);
                        table.setSortColumn(ColumnData.this.tableColumn);
                        EventTableColumnProvider.this.tableViewer.refresh();
                    }
                });
                this.tableColumn.addListener(10, new Listener(){

                    public void handleEvent(Event event) {
                        EventTableColumnProvider.this.persistColumnOrder();
                    }
                });
                this.tableColumn.addListener(11, new Listener(){

                    public void handleEvent(Event event) {
                        ColumnData.this.persistProperties();
                    }
                });
            } else {
                this.tableColumn.setText(this.getLabel(EventTableColumnProvider.this.computeKind));
                this.tableColumn.setToolTipText(this.getToolTip(EventTableColumnProvider.this.computeKind));
            }
        }

        protected void removeTableColumn() {
            if (this.tableColumn != null) {
                this.tableColumn.setData(null);
                this.tableColumn.dispose();
                this.tableColumn = null;
            }
        }

        public String getText(ITimelineInterval interval, boolean formatForCsv) {
            String NA = formatForCsv ? "" : NA_VALUE_CELL_LABEL;
            String OVERFLOW = formatForCsv ? "" : OVERFLOW_VALUE_CELL_LABEL;
            String INVALID = formatForCsv ? "" : INVALID_VALUE_CELL_LABEL;
            NumberFormat numberFormatter = formatForCsv ? nonGroupNumberFormatter : EventTableColumnProvider.this.activeNumberFormatter;
            NumberFormat percentFormatter = formatForCsv ? nonGroupPercentFormatter : EventTableColumnProvider.this.activePercentFormatter;
            switch (this.kind) {
                case NAME: {
                    if (formatForCsv) {
                        return "\"" + interval.getDisplayName() + "\"";
                    }
                    return interval.getDisplayName();
                }
                case START_TIME: {
                    if (formatForCsv) {
                        return String.valueOf(interval.getStart());
                    }
                    return new TimeFormatter().format(interval.getStart());
                }
                case DURATION: {
                    if (formatForCsv) {
                        return String.valueOf(interval.getDuration());
                    }
                    return new TimeFormatter().format(interval.getDuration());
                }
                case GRID_SIZE: {
                    if (!(interval instanceof TimelineIntervalKernel)) {
                        return formatForCsv ? ",," : NA;
                    }
                    Integer[] grid = ((TimelineIntervalKernel)interval).getGrid();
                    if (grid == null) {
                        return formatForCsv ? ",," : NA;
                    }
                    return String.valueOf(formatForCsv ? "" : "[") + (grid[0] == null ? NA : grid[0]) + "," + (grid[1] == null ? NA : grid[1]) + "," + (grid[2] == null ? NA : grid[2]) + (formatForCsv ? "" : "]");
                }
                case BLOCK_SIZE: {
                    if (!(interval instanceof TimelineIntervalKernel)) {
                        return formatForCsv ? ",," : NA;
                    }
                    Integer[] block = ((TimelineIntervalKernel)interval).getBlock();
                    if (block == null) {
                        return formatForCsv ? ",," : NA;
                    }
                    return String.valueOf(formatForCsv ? "" : "[") + (block[0] == null ? NA : block[0]) + "," + (block[1] == null ? NA : block[1]) + "," + (block[2] == null ? NA : block[2]) + (formatForCsv ? "" : "]");
                }
                case REGS_PER_THREAD: {
                    if (!(interval instanceof TimelineIntervalKernel)) {
                        return NA;
                    }
                    Integer regPerThread = ((TimelineIntervalKernel)interval).getRegistersPerThread();
                    return regPerThread == null ? NA : numberFormatter.format(regPerThread);
                }
                case STAT_SHARED_MEM: {
                    if (!(interval instanceof TimelineIntervalKernel)) {
                        return NA;
                    }
                    Integer statMem = ((TimelineIntervalKernel)interval).getStaticSharedMemory();
                    return statMem == null ? NA : numberFormatter.format(statMem);
                }
                case DYNA_SHARED_MEM: {
                    if (!(interval instanceof TimelineIntervalKernel)) {
                        return NA;
                    }
                    Integer dynaMem = ((TimelineIntervalKernel)interval).getDynamicSharedMemory();
                    return dynaMem == null ? NA : numberFormatter.format(dynaMem);
                }
                case BYTE_SIZE: {
                    long byteSize = -1L;
                    if (interval instanceof TimelineIntervalMemcpy) {
                        byteSize = ((TimelineIntervalMemcpy)interval).getBytes();
                    } else if (interval instanceof TimelineIntervalMemset) {
                        byteSize = ((TimelineIntervalMemset)interval).getBytes();
                    }
                    if (byteSize < 0L) {
                        return NA;
                    }
                    if (formatForCsv) {
                        return String.valueOf(byteSize);
                    }
                    return new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(byteSize);
                }
                case THROUGHPUT: {
                    long bw = -1L;
                    if (interval instanceof TimelineIntervalMemcpy) {
                        bw = ((TimelineIntervalMemcpy)interval).getThroughput();
                    } else if (interval instanceof TimelineIntervalMemset) {
                        bw = ((TimelineIntervalMemset)interval).getThroughput();
                    }
                    if (bw < 0L) {
                        return NA;
                    }
                    if (formatForCsv) {
                        return String.valueOf(bw);
                    }
                    return new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(bw);
                }
                case EVENT: {
                    Long value = interval.getEventValue(this.event);
                    if (value == null) {
                        return NA;
                    }
                    return value < 0L ? OVERFLOW : numberFormatter.format(value);
                }
                case METRIC: {
                    if (interval.isAggregateMetricOverflow(this.metric)) {
                        return OVERFLOW;
                    }
                    if (interval.isAggregateMetricInvalid(this.metric)) {
                        return INVALID;
                    }
                    Number value = interval.getAggregateMetricValue(this.metric);
                    if (value == null) {
                        return NA;
                    }
                    if (!formatForCsv) {
                        if (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_PERCENT.equals((Object)this.metric.getValueKind())) {
                            return percentFormatter.format(value.doubleValue() / 100.0);
                        }
                        if (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_THROUGHPUT.equals((Object)this.metric.getValueKind())) {
                            return new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(value.longValue());
                        }
                    }
                    if (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_UTILIZATION_LEVEL.equals((Object)this.metric.getValueKind())) {
                        return CuptiMetricValueUtilizationLevel.valueOf(value.intValue()).toString();
                    }
                    return numberFormatter.format(value);
                }
            }
            return null;
        }

        public String getText(ExpertData.KernelAggregate result, boolean formatForCsv) {
            String NA = formatForCsv ? "" : NA_VALUE_CELL_LABEL;
            String OVERFLOW = formatForCsv ? "" : OVERFLOW_VALUE_CELL_LABEL;
            NumberFormat numberFormatter = formatForCsv ? nonGroupNumberFormatter : EventTableColumnProvider.this.activeNumberFormatter;
            NumberFormat percentFormatter = formatForCsv ? nonGroupPercentFormatter : EventTableColumnProvider.this.activePercentFormatter;
            switch (this.kind) {
                case NAME: {
                    if (formatForCsv) {
                        return "\"" + result.getName() + "\"";
                    }
                    return result.getName();
                }
                case REGS_PER_THREAD: {
                    Integer regPerThread = result.getRegistersPerThread();
                    return regPerThread == null ? NA : numberFormatter.format(regPerThread);
                }
                case STAT_SHARED_MEM: {
                    Integer statMem = result.getStaticSharedMemory();
                    return statMem == null ? NA : numberFormatter.format(statMem);
                }
                case INVOCATIONS: {
                    if (formatForCsv) {
                        return String.valueOf(result.getNumIntervals());
                    }
                    return Integer.toString(result.getNumIntervals());
                }
                case AVG_DURATION: {
                    if (formatForCsv) {
                        return String.valueOf(result.getAverageDuration());
                    }
                    return new TimeFormatter().format(result.getAverageDuration());
                }
                case AVG_DYNA_SHARED_MEM: {
                    Integer dynaMem = result.getAverageDynamicSharedMemory();
                    return dynaMem == null ? NA : numberFormatter.format(dynaMem);
                }
                case EVENT: {
                    Long value = result.getAverageEventValue(this.event);
                    if (value == null) {
                        return NA;
                    }
                    return value < 0L ? OVERFLOW : numberFormatter.format(value);
                }
                case METRIC: {
                    Number value = result.getAverageMetricValue(this.metric);
                    if (value == null) {
                        return NA;
                    }
                    if (!formatForCsv) {
                        if (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_PERCENT.equals((Object)this.metric.getValueKind())) {
                            return percentFormatter.format(value.doubleValue() / 100.0);
                        }
                        if (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_THROUGHPUT.equals((Object)this.metric.getValueKind())) {
                            return new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(value.longValue());
                        }
                    }
                    if (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_UTILIZATION_LEVEL.equals((Object)this.metric.getValueKind())) {
                        CuptiMetricValueUtilizationLevel level = CuptiMetricValueUtilizationLevel.valueOf(value.intValue());
                        return level != null ? level.toString() : INVALID_VALUE_CELL_LABEL;
                    }
                    return numberFormatter.format(value);
                }
            }
            return null;
        }
    }

    public static enum ColumnKind {
        NAME("Name", "Name", null, 150, 16384),
        START_TIME("Start Time", "Start Time(ns)", null, null, 131072),
        DURATION("Duration", "Duration(ns)", null, null, 131072),
        INVOCATIONS("Invocations", "Invocations", "The total number of kernel invocations", null, 131072),
        AVG_DURATION("Avg. Duration", "Avg. Duration(ns)", null, null, 131072),
        GRID_SIZE(ViperComputeDictionary.E_TABLE_COL_GRID.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_GRID_CSV.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_GRID_TIP.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), null, 131072),
        BLOCK_SIZE(ViperComputeDictionary.E_TABLE_COL_BLOCK.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_BLOCK_CSV.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_BLOCK_TIP.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), null, 131072),
        STAT_SHARED_MEM(ViperComputeDictionary.E_TABLE_COL_STAT_SMEM.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_STAT_SMEM_CSV.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_STAT_SMEM_TIP.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), null, 131072),
        DYNA_SHARED_MEM(ViperComputeDictionary.E_TABLE_COL_DYNA_SMEM.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_DYNA_SMEM_CSV.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_DYNA_SMEM_TIP.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), null, 131072),
        AVG_DYNA_SHARED_MEM(ViperComputeDictionary.E_TABLE_COL_AVG_DYNA_SMEM.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_AVG_DYNA_SMEM_CSV.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_AVG_DYNA_SMEM_TIP.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), null, 131072),
        REGS_PER_THREAD("Regs", ViperComputeDictionary.E_TABLE_COL_REGS_CSV.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), ViperComputeDictionary.E_TABLE_COL_REGS_TIP.getLabel(CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA), null, 131072),
        BYTE_SIZE("Size", "Size(bytes)", null, null, 131072),
        THROUGHPUT("Throughput", "Throughput(bytes/sec)", null, null, 131072),
        EVENT("Event", "Event", null, null, 131072),
        METRIC("Metric", "Metric", null, null, 131072),
        EMPTY("", "", null, null, 131072);

        private String cudaLabel;
        private String csvCudaLabel;
        private String cudaTooltip;
        private Integer width;
        private int alignment;

        private ColumnKind(String cudaLabel, String csvCudaLabel, String cudaTooltip, Integer width, int alignment) {
            this.cudaLabel = cudaLabel;
            this.csvCudaLabel = csvCudaLabel;
            this.cudaTooltip = cudaTooltip;
            this.width = width;
            this.alignment = alignment;
        }

        public String getLabel(CuptiActivityComputeApiKind computeKind) {
            return this.cudaLabel;
        }

        public String getCsvLabel(CuptiActivityComputeApiKind computeKind) {
            return this.csvCudaLabel;
        }

        public String getTooltip(CuptiActivityComputeApiKind computeKind) {
            return this.cudaTooltip;
        }

        public Integer getWidth() {
            return this.width;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public Comparator<Object> getComparator(final int dir, ColumnData columnData, final Session session) {
            switch (this) {
                case NAME: {
                    return new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            int r = 0;
                            if (o1 instanceof Long && o2 instanceof Long) {
                                ITimelineInterval i1 = session.loadInterval((Long)o1, false);
                                ITimelineInterval i2 = session.loadInterval((Long)o2, false);
                                r = i1.getDisplayName().compareTo(i2.getDisplayName());
                            } else if (o1 instanceof ExpertData.KernelAggregate && o2 instanceof ExpertData.KernelAggregate) {
                                r = ((ExpertData.KernelAggregate)o1).getName().compareTo(((ExpertData.KernelAggregate)o2).getName());
                            }
                            return dir == 1024 ? -r : r;
                        }
                    };
                }
                case START_TIME: {
                    return new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            long c = 0L;
                            if (o1 instanceof Long && o2 instanceof Long) {
                                ITimelineInterval i1 = session.loadInterval((Long)o1, false);
                                ITimelineInterval i2 = session.loadInterval((Long)o2, false);
                                c = i1.getStart() - i2.getStart();
                            }
                            int r = c < 0L ? -1 : (c > 0L ? 1 : 0);
                            return dir == 1024 ? -r : r;
                        }
                    };
                }
                case INVOCATIONS: {
                    return new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            int c = 0;
                            if (o1 instanceof ExpertData.KernelAggregate && o2 instanceof ExpertData.KernelAggregate) {
                                c = ((ExpertData.KernelAggregate)o1).getNumIntervals() - ((ExpertData.KernelAggregate)o2).getNumIntervals();
                            }
                            int r = c < 0 ? -1 : (c > 0 ? 1 : 0);
                            return dir == 1024 ? -r : r;
                        }
                    };
                }
                case DURATION: 
                case AVG_DURATION: {
                    return new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            long c = 0L;
                            if (o1 instanceof Long && o2 instanceof Long) {
                                ITimelineInterval i1 = session.loadInterval((Long)o1, false);
                                ITimelineInterval i2 = session.loadInterval((Long)o2, false);
                                c = i1.getDuration() - i2.getDuration();
                            } else if (o1 instanceof ExpertData.KernelAggregate && o2 instanceof ExpertData.KernelAggregate) {
                                c = ((ExpertData.KernelAggregate)o1).getAverageDuration() - ((ExpertData.KernelAggregate)o2).getAverageDuration();
                            }
                            int r = c < 0L ? -1 : (c > 0L ? 1 : 0);
                            return dir == 1024 ? -r : r;
                        }
                    };
                }
                case REGS_PER_THREAD: {
                    return this.getComparatorForRegsPerThread(dir, session);
                }
                case STAT_SHARED_MEM: {
                    return this.getComparatorForStatSharedMem(dir, session);
                }
                case DYNA_SHARED_MEM: 
                case AVG_DYNA_SHARED_MEM: {
                    return this.getComparatorForDynaSharedMem(dir, session);
                }
                case GRID_SIZE: {
                    return this.getComparatorForGrid(dir, session);
                }
                case BLOCK_SIZE: {
                    return this.getComparatorForBlock(dir, session);
                }
                case BYTE_SIZE: {
                    return this.getComparatorForByteSize(dir, session);
                }
                case THROUGHPUT: {
                    return this.getComparatorForThroughput(dir, session);
                }
                case EVENT: {
                    return this.getComparatorForEvent(columnData.event, dir, session);
                }
                case METRIC: {
                    return this.getComparatorForMetric(columnData.metric, dir, session);
                }
            }
            return null;
        }

        protected Comparator<Object> getComparatorForRegsPerThread(final int dir, final Session session) {
            return new Comparator<Object>(){

                private int getRegsPerThread(ITimelineInterval interval) {
                    if (!(interval instanceof TimelineIntervalKernel)) {
                        return 0;
                    }
                    Integer rpt = ((TimelineIntervalKernel)interval).getRegistersPerThread();
                    if (rpt == null) {
                        return 0;
                    }
                    return rpt;
                }

                @Override
                public int compare(Object o1, Object o2) {
                    long c = 0L;
                    if (o1 instanceof Long && o2 instanceof Long) {
                        ITimelineInterval i1 = session.loadInterval((Long)o1, false);
                        ITimelineInterval i2 = session.loadInterval((Long)o2, false);
                        c = this.getRegsPerThread(i1) - this.getRegsPerThread(i2);
                    } else if (o1 instanceof ExpertData.KernelAggregate && o2 instanceof ExpertData.KernelAggregate) {
                        Integer reg1 = ((ExpertData.KernelAggregate)o1).getRegistersPerThread();
                        Integer reg2 = ((ExpertData.KernelAggregate)o2).getRegistersPerThread();
                        if (reg1 == null) {
                            reg1 = 0;
                        }
                        if (reg2 == null) {
                            reg2 = 0;
                        }
                        c = reg1 - reg2;
                    }
                    int r = c < 0L ? -1 : (c > 0L ? 1 : 0);
                    return dir == 1024 ? -r : r;
                }
            };
        }

        protected Comparator<Object> getComparatorForStatSharedMem(final int dir, final Session session) {
            return new Comparator<Object>(){

                private int getStaticSharedMemory(ITimelineInterval interval) {
                    if (!(interval instanceof TimelineIntervalKernel)) {
                        return 0;
                    }
                    Integer rpt = ((TimelineIntervalKernel)interval).getStaticSharedMemory();
                    if (rpt == null) {
                        return 0;
                    }
                    return rpt;
                }

                @Override
                public int compare(Object o1, Object o2) {
                    long c = 0L;
                    if (o1 instanceof Long && o2 instanceof Long) {
                        ITimelineInterval i1 = session.loadInterval((Long)o1, false);
                        ITimelineInterval i2 = session.loadInterval((Long)o2, false);
                        c = this.getStaticSharedMemory(i1) - this.getStaticSharedMemory(i2);
                    } else if (o1 instanceof ExpertData.KernelAggregate && o2 instanceof ExpertData.KernelAggregate) {
                        Integer ss1 = ((ExpertData.KernelAggregate)o1).getStaticSharedMemory();
                        Integer ss2 = ((ExpertData.KernelAggregate)o2).getStaticSharedMemory();
                        if (ss1 == null) {
                            ss1 = 0;
                        }
                        if (ss2 == null) {
                            ss2 = 0;
                        }
                        c = ss1 - ss2;
                    }
                    int r = c < 0L ? -1 : (c > 0L ? 1 : 0);
                    return dir == 1024 ? -r : r;
                }
            };
        }

        protected Comparator<Object> getComparatorForDynaSharedMem(final int dir, final Session session) {
            return new Comparator<Object>(){

                private int getDynamicSharedMemory(ITimelineInterval interval) {
                    if (!(interval instanceof TimelineIntervalKernel)) {
                        return 0;
                    }
                    Integer rpt = ((TimelineIntervalKernel)interval).getDynamicSharedMemory();
                    if (rpt == null) {
                        return 0;
                    }
                    return rpt;
                }

                @Override
                public int compare(Object o1, Object o2) {
                    long c = 0L;
                    if (o1 instanceof Long && o2 instanceof Long) {
                        ITimelineInterval i1 = session.loadInterval((Long)o1, false);
                        ITimelineInterval i2 = session.loadInterval((Long)o2, false);
                        c = this.getDynamicSharedMemory(i1) - this.getDynamicSharedMemory(i2);
                    } else if (o1 instanceof ExpertData.KernelAggregate && o2 instanceof ExpertData.KernelAggregate) {
                        Integer ds1 = ((ExpertData.KernelAggregate)o1).getAverageDynamicSharedMemory();
                        Integer ds2 = ((ExpertData.KernelAggregate)o2).getAverageDynamicSharedMemory();
                        if (ds1 == null) {
                            ds1 = 0;
                        }
                        if (ds2 == null) {
                            ds2 = 0;
                        }
                        c = ds1 - ds2;
                    }
                    int r = c < 0L ? -1 : (c > 0L ? 1 : 0);
                    return dir == 1024 ? -r : r;
                }
            };
        }

        protected Comparator<Object> getComparatorForByteSize(final int dir, final Session session) {
            return new Comparator<Object>(){

                private long getByteSize(ITimelineInterval interval) {
                    long byteSize = 0L;
                    if (interval instanceof TimelineIntervalMemcpy) {
                        byteSize = ((TimelineIntervalMemcpy)interval).getBytes();
                    } else if (interval instanceof TimelineIntervalMemset) {
                        byteSize = ((TimelineIntervalMemset)interval).getBytes();
                    }
                    return byteSize;
                }

                @Override
                public int compare(Object o1, Object o2) {
                    long c = 0L;
                    if (o1 instanceof Long && o2 instanceof Long) {
                        ITimelineInterval i1 = session.loadInterval((Long)o1, false);
                        ITimelineInterval i2 = session.loadInterval((Long)o2, false);
                        c = this.getByteSize(i1) - this.getByteSize(i2);
                    }
                    int r = c < 0L ? -1 : (c > 0L ? 1 : 0);
                    return dir == 1024 ? -r : r;
                }
            };
        }

        protected Comparator<Object> getComparatorForThroughput(final int dir, final Session session) {
            return new Comparator<Object>(){

                private long getThroughput(ITimelineInterval interval) {
                    long bw = 0L;
                    if (interval instanceof TimelineIntervalMemcpy) {
                        bw = ((TimelineIntervalMemcpy)interval).getThroughput();
                    } else if (interval instanceof TimelineIntervalMemset) {
                        bw = ((TimelineIntervalMemset)interval).getThroughput();
                    }
                    return bw;
                }

                @Override
                public int compare(Object o1, Object o2) {
                    long c = 0L;
                    if (o1 instanceof Long && o2 instanceof Long) {
                        ITimelineInterval i1 = session.loadInterval((Long)o1, false);
                        ITimelineInterval i2 = session.loadInterval((Long)o2, false);
                        c = this.getThroughput(i1) - this.getThroughput(i2);
                    }
                    int r = c < 0L ? -1 : (c > 0L ? 1 : 0);
                    return dir == 1024 ? -r : r;
                }
            };
        }

        protected Comparator<Object> getComparatorForGrid(final int dir, final Session session) {
            return new Comparator<Object>(){

                private long getGridProduct(ITimelineInterval interval) {
                    if (!(interval instanceof TimelineIntervalKernel)) {
                        return 0L;
                    }
                    return ((TimelineIntervalKernel)interval).getBlocksPerGrid();
                }

                @Override
                public int compare(Object o1, Object o2) {
                    long c = 0L;
                    if (o1 instanceof Long && o2 instanceof Long) {
                        ITimelineInterval i1 = session.loadInterval((Long)o1, false);
                        ITimelineInterval i2 = session.loadInterval((Long)o2, false);
                        c = this.getGridProduct(i1) - this.getGridProduct(i2);
                    }
                    int r = c < 0L ? -1 : (c > 0L ? 1 : 0);
                    return dir == 1024 ? -r : r;
                }
            };
        }

        protected Comparator<Object> getComparatorForBlock(final int dir, final Session session) {
            return new Comparator<Object>(){

                private int getBlockProduct(ITimelineInterval interval) {
                    if (!(interval instanceof TimelineIntervalKernel)) {
                        return 0;
                    }
                    return ((TimelineIntervalKernel)interval).getThreadsPerBlock();
                }

                @Override
                public int compare(Object o1, Object o2) {
                    long c = 0L;
                    if (o1 instanceof Long && o2 instanceof Long) {
                        ITimelineInterval i1 = session.loadInterval((Long)o1, false);
                        ITimelineInterval i2 = session.loadInterval((Long)o2, false);
                        c = this.getBlockProduct(i1) - this.getBlockProduct(i2);
                    }
                    int r = c < 0L ? -1 : (c > 0L ? 1 : 0);
                    return dir == 1024 ? -r : r;
                }
            };
        }

        protected Comparator<Object> getComparatorForEvent(final com.nvidia.viper.model.Event event, final int dir, final Session session) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    long c;
                    Long v1 = null;
                    Long v2 = null;
                    if (o1 instanceof Long && o2 instanceof Long) {
                        ITimelineInterval i1 = session.loadInterval((Long)o1, true);
                        ITimelineInterval i2 = session.loadInterval((Long)o2, true);
                        v1 = i1.getEventValue(event);
                        v2 = i2.getEventValue(event);
                    } else if (o1 instanceof ExpertData.KernelAggregate && o2 instanceof ExpertData.KernelAggregate) {
                        v1 = ((ExpertData.KernelAggregate)o1).getAverageEventValue(event);
                        v2 = ((ExpertData.KernelAggregate)o2).getAverageEventValue(event);
                    }
                    if (v1 == null) {
                        v1 = 0L;
                    }
                    if (v2 == null) {
                        v2 = 0L;
                    }
                    int r = (c = v1 - v2) < 0L ? -1 : (c > 0L ? 1 : 0);
                    return dir == 1024 ? -r : r;
                }
            };
        }

        protected Comparator<Object> getComparatorForMetric(final Metric metric, final int dir, final Session session) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Number v1 = null;
                    Number v2 = null;
                    if (o1 instanceof Long && o2 instanceof Long) {
                        ITimelineInterval i1 = session.loadInterval((Long)o1, true);
                        ITimelineInterval i2 = session.loadInterval((Long)o2, true);
                        v1 = i1.getAggregateMetricValue(metric);
                        v2 = i2.getAggregateMetricValue(metric);
                    } else if (o1 instanceof ExpertData.KernelAggregate && o2 instanceof ExpertData.KernelAggregate) {
                        v1 = ((ExpertData.KernelAggregate)o1).getAverageMetricValue(metric);
                        v2 = ((ExpertData.KernelAggregate)o2).getAverageMetricValue(metric);
                    }
                    int r = 0;
                    if (v1 == null && v2 == null) {
                        r = 0;
                    } else if (v1 == null) {
                        r = -1;
                    } else if (v2 == null) {
                        r = 1;
                    } else if (v1 instanceof Long) {
                        long c = v1.longValue() - v2.longValue();
                        r = c < 0L ? -1 : (c > 0L ? 1 : 0);
                    } else if (v1 instanceof Double) {
                        double c = v1.doubleValue() - v2.doubleValue();
                        r = c < 0.0 ? -1 : (c > 0.0 ? 1 : 0);
                    }
                    return dir == 1024 ? -r : r;
                }
            };
        }
    }
}

