/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.activity.CuptiActivityPCSamplingStallReason;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.editor.RulerColumnBase;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class StallReasonChartColumn
extends RulerColumnBase {
    public static final int DEFAULT_WIDTH = 110;
    private static final int BAR_HMARGIN = 5;
    private static final int BAR_VMARGIN = 2;
    public static final String COLUMN_HEADER = "Warp State";

    public StallReasonChartColumn() {
        this(110);
    }

    public StallReasonChartColumn(int width) {
        this.setWidth(width);
    }

    private double getSampleRatio(int lineNumber, CuptiActivityPCSamplingStallReason reason, int factor) {
        long numSamples = this.viewer.getNumSamples(lineNumber);
        if (numSamples > 0L) {
            return (double)this.viewer.getNumSamples(lineNumber, reason) * (double)factor / (double)numSamples;
        }
        return 0.0;
    }

    @Override
    public int getColumnIndex() {
        return 6;
    }

    @Override
    protected String getToolTipText(int lineNumber) {
        String tooltipStr = "";
        DecimalFormat oneDecimalPrecision = new DecimalFormat("###.#");
        String tooltipFormat = "%s = %d (%s%%)\n";
        final class MyEntry<K, V>
        implements Map.Entry<K, V> {
            private final K key;
            private V value;

            public MyEntry(K key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                V oldValue = this.value;
                this.value = value;
                return oldValue;
            }
        }
        ArrayList<MyEntry<CuptiActivityPCSamplingStallReason, Long>> reasonValueList = new ArrayList<MyEntry<CuptiActivityPCSamplingStallReason, Long>>();
        if (this.viewer != null && this.viewer.getNumSamples(lineNumber) > 0L) {
            CuptiActivityPCSamplingStallReason[] cuptiActivityPCSamplingStallReasonArray = CuptiActivityPCSamplingStallReason.values();
            int n = cuptiActivityPCSamplingStallReasonArray.length;
            int n2 = 0;
            while (n2 < n) {
                CuptiActivityPCSamplingStallReason cuptiActivityPCSamplingStallReason = cuptiActivityPCSamplingStallReasonArray[n2];
                reasonValueList.add(new MyEntry<CuptiActivityPCSamplingStallReason, Long>(cuptiActivityPCSamplingStallReason, this.viewer.getNumSamples(lineNumber, cuptiActivityPCSamplingStallReason)));
                ++n2;
            }
            Collections.sort(reasonValueList, new Comparator<Map.Entry<CuptiActivityPCSamplingStallReason, Long>>(){

                @Override
                public int compare(Map.Entry<CuptiActivityPCSamplingStallReason, Long> o1, Map.Entry<CuptiActivityPCSamplingStallReason, Long> o2) {
                    if (o2.getValue() > o1.getValue()) {
                        return 1;
                    }
                    if (o2.getValue() < o1.getValue()) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (Map.Entry entry : reasonValueList) {
                double samplesPercent = this.getSampleRatio(lineNumber, (CuptiActivityPCSamplingStallReason)((Object)entry.getKey()), 100);
                String samplePercent = oneDecimalPrecision.format(samplesPercent);
                if (!(samplesPercent > 0.0)) continue;
                tooltipStr = String.valueOf(tooltipStr) + String.format(tooltipFormat, ((CuptiActivityPCSamplingStallReason)((Object)entry.getKey())).getName(), entry.getValue(), samplePercent);
            }
            if (!tooltipStr.isEmpty()) {
                tooltipStr = "Total Sample Count = " + this.viewer.getNumSamples(lineNumber) + "\n" + tooltipStr;
                tooltipStr = tooltipStr.substring(0, tooltipStr.length() - 1);
            }
        }
        return tooltipStr.isEmpty() ? null : tooltipStr;
    }

    @Override
    protected void updateColumn() {
        this.redraw();
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        super.paintLine(gc, modelLine, widgetLine, linePixel, lineHeight);
        if (this.viewer != null && this.viewer.getNumSamples(widgetLine) > 0L) {
            int barBorderY = linePixel + 2;
            int maxWidth = this.getWidth() - 10;
            int height = lineHeight - 4;
            int barWidth = this.getRelativeWidth(widgetLine, maxWidth);
            int totalWidth = 0;
            if (barWidth > 0) {
                CuptiActivityPCSamplingStallReason[] cuptiActivityPCSamplingStallReasonArray = CuptiActivityPCSamplingStallReason.values();
                int n = cuptiActivityPCSamplingStallReasonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CuptiActivityPCSamplingStallReason res = cuptiActivityPCSamplingStallReasonArray[n2];
                    int sampleWidth = (int)this.getSampleRatio(widgetLine, res, barWidth);
                    Color color = res.getColor();
                    if (color != null) {
                        gc.setBackground(res.getColor());
                        gc.fillRectangle(5 + totalWidth, barBorderY, sampleWidth, height);
                        totalWidth += sampleWidth;
                    }
                    ++n2;
                }
            }
            gc.setForeground(ViperColors.COLOR_EXEC_COUNT_BACKGROUND);
            gc.drawRectangle(4, barBorderY - 1, maxWidth, height);
            this.drawMarkerAtEnd(widgetLine, gc, this.viewer, this.getWidth() - 1, lineHeight + linePixel, this.getWidth() - 1, barBorderY);
        }
    }

    private int getRelativeWidth(int widgetLine, int maxWidth) {
        return (int)((double)this.viewer.getNumSamples(widgetLine) * (double)maxWidth / (double)this.viewer.getMaxNumSamples());
    }

    @Override
    protected boolean isHotspotPresent() {
        return AnalysisResultSourceLevelKind.PC_SAMPLING_KIND.equals((Object)this.viewer.getCurrentAnnotationKind());
    }
}

