/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.GDBTypeParser;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.MIExpressions;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetAttributes;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetChildCount;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetChildren;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetValue;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetVar;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIDataEvaluateExpression;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetAttributesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetChildCountInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetChildrenInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetValueInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetVarInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDisplayHint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVar;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarAssignInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarChange;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarCreateInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarEvaluateExpressionInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarInfoPathExpressionInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarListChildrenInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarSetFormatInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarShowAttributesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarUpdateInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MIVariableManager
implements ICommandControl {
    private GDBTypeParser fGDBTypeParser = null;
    private final DsfSession fSession;
    private final ICommandControl fCommandControl;
    private CommandFactory fCommandFactory;
    private final IStack fStackService;
    private IExpressions fExpressionService;
    private final List<ICommandListener> fCommandProcessors = new ArrayList<ICommandListener>();
    private final LRUVariableCache lruVariableList;
    private final LinkedList<MIRootVariableObject> updatedRootList = new LinkedList();

    protected MIVariableObject createVariableObject(VariableObjectId id, MIVariableObject parentObj) {
        return new MIVariableObject(id, parentObj);
    }

    protected MIVariableObject createVariableObject(VariableObjectId id, MIVariableObject parentObj, boolean needsCreation) {
        return new MIVariableObject(id, parentObj, needsCreation);
    }

    protected MIRootVariableObject createRootVariableObject(VariableObjectId id) {
        return new MIRootVariableObject(id);
    }

    protected VariableObjectId createVariableObjectId() {
        return new VariableObjectId();
    }

    public MIVariableManager(DsfSession session, DsfServicesTracker tracker) {
        this.fSession = session;
        this.lruVariableList = new LRUVariableCache();
        this.fCommandControl = (ICommandControl)tracker.getService(ICommandControl.class);
        this.fStackService = (IStack)tracker.getService(IStack.class);
        this.fExpressionService = (IExpressions)tracker.getService(IExpressions.class);
        this.fCommandFactory = ((IMICommandControl)tracker.getService(IMICommandControl.class)).getCommandFactory();
        this.fSession.addServiceEventListener((Object)this, null);
    }

    public void dispose() {
        this.fSession.removeServiceEventListener((Object)this);
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    protected ICommandControl getCommandControl() {
        return this.fCommandControl;
    }

    protected void rootVariableUpdated(MIRootVariableObject rootObj) {
        this.updatedRootList.add(rootObj);
    }

    protected Map<VariableObjectId, MIVariableObject> getLRUCache() {
        return this.lruVariableList;
    }

    private GDBTypeParser getGDBTypeParser() {
        if (this.fGDBTypeParser == null) {
            this.fGDBTypeParser = this.createGDBTypeParser();
        }
        return this.fGDBTypeParser;
    }

    private void getVariable(final IExpressions.IExpressionDMContext exprCtx, DataRequestMonitor<MIVariableObject> rm) {
        final VariableObjectId id = this.createVariableObjectId();
        id.generateId(exprCtx, new RequestMonitor((Executor)this.fSession.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                MIVariableManager.this.getVariable(id, exprCtx, (DataRequestMonitor<MIVariableObject>)this.val$rm);
            }
        });
    }

    private void getVariable(final VariableObjectId id, final IExpressions.IExpressionDMContext exprCtx, final DataRequestMonitor<MIVariableObject> rm) {
        final MIVariableObject varObj = this.lruVariableList.get(id);
        if (varObj == null) {
            this.createVariable(id, exprCtx, rm);
        } else {
            varObj.update(new DataRequestMonitor<Boolean>((Executor)this.fSession.getExecutor(), rm){

                protected void handleSuccess() {
                    boolean shouldCreateNew = (Boolean)this.getData();
                    if (varObj.isOutOfScope()) {
                        if (shouldCreateNew) {
                            MIVariableManager.this.createVariable(id, exprCtx, (DataRequestMonitor<MIVariableObject>)rm);
                        } else {
                            MIVariableManager.this.getVariable(id, exprCtx, (DataRequestMonitor<MIVariableObject>)rm);
                        }
                    } else {
                        MIExpressions.ExpressionInfo varExprInfo;
                        MIExpressions.MIExpressionDMC miExprCtx = (MIExpressions.MIExpressionDMC)exprCtx;
                        MIExpressions.ExpressionInfo ctxExprInfo = miExprCtx.getExpressionInfo();
                        if (ctxExprInfo != (varExprInfo = varObj.getExpressionInfo())) {
                            miExprCtx.setExpressionInfo(new MIExpressions.ExpressionInfo(miExprCtx.getExpression(), miExprCtx.getRelativeExpression(), varExprInfo.isDynamic(), varExprInfo.getParent(), varExprInfo.getIndexInParentExpression()));
                        }
                        rm.setData((Object)varObj);
                        rm.done();
                    }
                }
            });
        }
    }

    private void createVariable(final VariableObjectId id, IExpressions.IExpressionDMContext exprCtx, final DataRequestMonitor<MIVariableObject> rm) {
        final MIExpressions.MIExpressionDMC miExprCtx = (MIExpressions.MIExpressionDMC)exprCtx;
        MIExpressions.ExpressionInfo parentInfo = miExprCtx.getExpressionInfo().getParent();
        if (parentInfo != null && miExprCtx.getExpressionInfo().hasDynamicAncestor()) {
            final MIVariableObject newVarObj = this.createVariableObject(id, null, true);
            this.lruVariableList.put(id, newVarObj);
            MIExpressions.MIExpressionDMC parentExprCtx = this.createExpressionCtx(exprCtx, parentInfo);
            this.getVariable(parentExprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        MIVariableObject parentObj = (MIVariableObject)this.getData();
                        newVarObj.setParent(parentObj);
                        newVarObj.create(miExprCtx, new RequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)rm){

                            protected void handleCompleted() {
                                if (this.isSuccess()) {
                                    rm.setData((Object)newVarObj);
                                    newVarObj.creationCompleted(true);
                                } else {
                                    MIVariableManager.this.lruVariableList.remove(id);
                                    newVarObj.creationCompleted(false);
                                    rm.setStatus(this.getStatus());
                                }
                                rm.done();
                            }
                        });
                    } else {
                        MIVariableManager.this.lruVariableList.remove(id);
                        newVarObj.creationCompleted(false);
                        rm.setStatus(this.getStatus());
                        rm.done();
                    }
                }
            });
            return;
        }
        final MIRootVariableObject newVarObj = this.createRootVariableObject(id);
        this.lruVariableList.put(id, newVarObj);
        newVarObj.create(exprCtx, new RequestMonitor((Executor)this.fSession.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm, id){
            private final /* synthetic */ DataRequestMonitor val$rm;
            private final /* synthetic */ VariableObjectId val$id;
            {
                this.val$rm = dataRequestMonitor;
                this.val$id = variableObjectId;
                super($anonymous0, $anonymous1);
            }

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIVariableManager.this.rootVariableUpdated(newVarObj);
                    newVarObj.creationCompleted(true);
                    this.val$rm.setData((Object)newVarObj);
                    this.val$rm.done();
                } else {
                    MIVariableManager.this.lruVariableList.remove(this.val$id);
                    newVarObj.creationCompleted(false);
                    this.val$rm.setStatus(this.getStatus());
                    this.val$rm.done();
                }
            }
        });
    }

    private MIExpressions.MIExpressionDMC createExpressionCtx(IExpressions.IExpressionDMContext frameCtxProvider, MIExpressions.ExpressionInfo exprInfo) {
        IStack.IFrameDMContext frameCtx = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)frameCtxProvider, IStack.IFrameDMContext.class);
        MIExpressions.MIExpressionDMC exprCtx = new MIExpressions.MIExpressionDMC(frameCtxProvider.getSessionId(), exprInfo, frameCtx);
        return exprCtx;
    }

    public void writeValue(IExpressions.IExpressionDMContext ctx, final String expressionValue, final String formatId, final RequestMonitor rm) {
        this.getVariable(ctx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), rm){

            protected void handleSuccess() {
                ((MIVariableObject)this.getData()).writeValue(expressionValue, formatId, rm);
            }
        });
    }

    public <V extends ICommandResult> ICommandToken queueCommand(final ICommand<V> command, DataRequestMonitor<V> rm) {
        final ICommandToken token = new ICommandToken(){

            public ICommand<? extends ICommandResult> getCommand() {
                return command;
            }
        };
        this.processCommandSent(token);
        if (command instanceof ExprMetaGetVar) {
            final DataRequestMonitor<V> drm = rm;
            final MIExpressions.MIExpressionDMC exprCtx = (MIExpressions.MIExpressionDMC)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), drm){

                protected void handleSuccess() {
                    final MIVariableObject varObj = (MIVariableObject)this.getData();
                    if (varObj.isDynamic() && varObj.getNumChildrenHint() == 0 && varObj.hasMore()) {
                        varObj.getChildrenCount(exprCtx, 1, new DataRequestMonitor<ChildrenCountInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)drm){

                            protected void handleSuccess() {
                                drm.setData((Object)new ExprMetaGetVarInfo(exprCtx.getRelativeExpression(), varObj.isSafeToAskForAllChildren(), ((ChildrenCountInfo)this.getData()).getChildrenCount(), varObj.getType(), varObj.getGDBType(), !varObj.isComplex(), varObj.getDisplayHint().isCollectionHint()));
                                drm.done();
                                MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                            }
                        });
                    } else {
                        drm.setData((Object)new ExprMetaGetVarInfo(exprCtx.getRelativeExpression(), varObj.isSafeToAskForAllChildren(), varObj.getNumChildrenHint(), varObj.getType(), varObj.getGDBType(), !varObj.isComplex(), varObj.getDisplayHint().isCollectionHint()));
                        drm.done();
                        MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                    }
                }
            });
        } else if (command instanceof ExprMetaGetAttributes) {
            final DataRequestMonitor<V> drm = rm;
            IExpressions.IExpressionDMContext exprCtx = (IExpressions.IExpressionDMContext)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), drm){

                protected void handleSuccess() {
                    ((MIVariableObject)this.getData()).getAttributes((DataRequestMonitor<Boolean>)((DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            drm.setData((Object)new ExprMetaGetAttributesInfo((Boolean)this.getData()));
                            drm.done();
                            MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                        }
                    }));
                }
            });
        } else if (command instanceof ExprMetaGetValue) {
            final DataRequestMonitor<V> drm = rm;
            final IFormattedValues.FormattedValueDMContext valueCtx = (IFormattedValues.FormattedValueDMContext)command.getContext();
            IExpressions.IExpressionDMContext exprCtx = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)valueCtx, IExpressions.IExpressionDMContext.class);
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), drm){

                protected void handleSuccess() {
                    ((MIVariableObject)this.getData()).getValue(valueCtx, new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            drm.setData((Object)new ExprMetaGetValueInfo(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue()));
                            drm.done();
                            MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                        }
                    });
                }
            });
        } else if (command instanceof ExprMetaGetChildren) {
            final DataRequestMonitor<V> drm = rm;
            final MIExpressions.MIExpressionDMC exprCtx = (MIExpressions.MIExpressionDMC)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), drm){

                protected void handleSuccess() {
                    ((MIVariableObject)this.getData()).getChildren(exprCtx, ((ExprMetaGetChildren)command).getNumChildLimit(), (DataRequestMonitor<ChildrenInfo>)((DataRequestMonitor)new DataRequestMonitor<ChildrenInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            drm.setData((Object)new ExprMetaGetChildrenInfo(((ChildrenInfo)this.getData()).getChildren()));
                            drm.done();
                            MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                        }
                    }));
                }
            });
        } else if (command instanceof ExprMetaGetChildCount) {
            final DataRequestMonitor<V> drm = rm;
            final MIExpressions.MIExpressionDMC exprCtx = (MIExpressions.MIExpressionDMC)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), drm){

                protected void handleSuccess() {
                    ((MIVariableObject)this.getData()).getChildrenCount(exprCtx, ((ExprMetaGetChildCount)command).getNumChildLimit(), new DataRequestMonitor<ChildrenCountInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            drm.setData((Object)new ExprMetaGetChildCountInfo(((ChildrenCountInfo)this.getData()).getChildrenCount()));
                            drm.done();
                            MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                        }
                    });
                }
            });
        } else if (command instanceof MIDataEvaluateExpression) {
            this.fCommandControl.queueCommand(command, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unexpected Expression Meta command", null));
            rm.done();
        }
        return token;
    }

    public void removeCommand(ICommandToken token) {
        assert (false);
    }

    public void addCommandListener(ICommandListener processor) {
        this.fCommandProcessors.add(processor);
    }

    public void removeCommandListener(ICommandListener processor) {
        this.fCommandProcessors.remove(processor);
    }

    public void addEventListener(IEventListener processor) {
    }

    public void removeEventListener(IEventListener processor) {
    }

    private void processCommandSent(ICommandToken token) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandSent(token);
        }
    }

    private void processCommandDone(ICommandToken token, ICommandResult result) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandDone(token, result);
        }
    }

    public void markAllOutOfDate() {
        MIRootVariableObject root;
        while ((root = this.updatedRootList.poll()) != null) {
            root.setOutOfDate(true);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.markAllOutOfDate();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMemory.IMemoryChangedEvent e) {
        this.markAllOutOfDate();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        Iterator iterator = this.lruVariableList.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    protected boolean needFixForGDBBug320277() {
        return true;
    }

    protected GDBTypeParser createGDBTypeParser() {
        return new GDBTypeParser();
    }

    protected static class ChildrenCountInfo {
        private final int childrenCount;
        private final boolean hasMore;

        public ChildrenCountInfo(int childrenCount, boolean hasMore) {
            this.childrenCount = childrenCount;
            this.hasMore = hasMore;
        }

        public int getChildrenCount() {
            return this.childrenCount;
        }

        public boolean hasMore() {
            return this.hasMore;
        }
    }

    protected static class ChildrenInfo {
        private final MIExpressions.ExpressionInfo[] children;
        private final boolean hasMore;

        public ChildrenInfo(MIExpressions.ExpressionInfo[] children, boolean hasMore) {
            this.children = children;
            this.hasMore = hasMore;
        }

        public MIExpressions.ExpressionInfo[] getChildren() {
            return this.children;
        }

        public boolean hasMore() {
            return this.hasMore;
        }
    }

    private class LRUVariableCache
    extends LinkedHashMap<VariableObjectId, MIVariableObject> {
        public static final long serialVersionUID = 0L;
        private static final int MAX_VARIABLE_LIST = 1000;

        public LRUVariableCache() {
            super(0, 0.75f, true);
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<VariableObjectId, MIVariableObject> eldest) {
            return false;
        }

        @Override
        public MIVariableObject get(Object key) {
            Map.Entry eldest;
            MIVariableObject varObj = (MIVariableObject)super.get(key);
            this.touchAncestors(varObj);
            if (this.size() > 1000 && !((MIVariableObject)(eldest = this.entrySet().iterator().next()).getValue()).equals(varObj) && ((MIVariableObject)eldest.getValue()).currentState == 0) {
                this.remove(eldest.getKey());
            }
            return varObj;
        }

        private void touchAncestors(MIVariableObject varObj) {
            while (varObj != null) {
                if ((varObj = varObj.getParent()) == null) continue;
                super.get(varObj.getInternalId());
            }
        }

        @Override
        public MIVariableObject put(VariableObjectId key, MIVariableObject varObj) {
            MIVariableObject retVal = super.put(key, varObj);
            this.touchAncestors(varObj);
            return retVal;
        }

        @Override
        public MIVariableObject remove(Object key) {
            MIVariableObject varObj = (MIVariableObject)super.remove(key);
            if (varObj != null) {
                varObj.deleteInGdb();
            }
            return varObj;
        }
    }

    public class MIRootVariableObject
    extends MIVariableObject {
        private ICommandControlService.ICommandControlDMContext fControlContext;
        private boolean fOutOfDate;
        private Map<String, MIVariableObject> modifiableDescendants;

        public MIRootVariableObject(VariableObjectId id) {
            super(id, null);
            this.fControlContext = null;
            this.fOutOfDate = false;
            this.currentState = 10;
            this.modifiableDescendants = new HashMap<String, MIVariableObject>();
        }

        public ICommandControlService.ICommandControlDMContext getControlDMContext() {
            return this.fControlContext;
        }

        public boolean isUpdating() {
            return this.currentState == 1;
        }

        public void setOutOfDate(boolean outOfDate) {
            this.fOutOfDate = outOfDate;
        }

        public boolean getOutOfDate() {
            return this.fOutOfDate;
        }

        public void addModifiableDescendant(String gdbName, MIVariableObject descendant) {
            this.modifiableDescendants.put(gdbName, descendant);
        }

        public void removeModifiableDescendant(String gdbName) {
            this.modifiableDescendants.remove(gdbName);
        }

        public void processChanges(MIVarChange[] updates, RequestMonitor rm) {
            CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), rm);
            countingRm.setDoneCount(updates.length);
            MIVarChange[] mIVarChangeArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                MIVarChange update = mIVarChangeArray[n2];
                MIVariableObject descendant = this.modifiableDescendants.get(update.getVarName());
                if (descendant != null) {
                    descendant.processChange(update, (RequestMonitor)countingRm);
                } else {
                    countingRm.done();
                }
                ++n2;
            }
        }

        @Override
        public void create(final IExpressions.IExpressionDMContext exprCtx, final RequestMonitor rm) {
            if (this.currentState == 10) {
                this.currentState = 11;
                this.fControlContext = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)exprCtx, ICommandControlService.ICommandControlDMContext.class);
                MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarCreate(exprCtx, exprCtx.getExpression()), (DataRequestMonitor)new DataRequestMonitor<MIVarCreateInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            MIRootVariableObject.this.setGdbName(((MIVarCreateInfo)this.getData()).getName());
                            MIRootVariableObject.this.setDisplayHint(((MIVarCreateInfo)this.getData()).getDisplayHint());
                            MIExpressions.MIExpressionDMC miExprCtx = (MIExpressions.MIExpressionDMC)exprCtx;
                            MIExpressions.ExpressionInfo localExprInfo = miExprCtx.getExpressionInfo();
                            localExprInfo.setDynamic(((MIVarCreateInfo)this.getData()).isDynamic());
                            MIRootVariableObject.this.setExpressionData(localExprInfo, ((MIVarCreateInfo)this.getData()).getType(), ((MIVarCreateInfo)this.getData()).getNumChildren(), ((MIVarCreateInfo)this.getData()).hasMore());
                            if (((MIVarCreateInfo)this.getData()).getValue() != null && !MIRootVariableObject.this.isArray()) {
                                MIRootVariableObject.this.setValue(MIRootVariableObject.this.getCurrentFormat(), ((MIVarCreateInfo)this.getData()).getValue());
                            }
                            if (MIRootVariableObject.this.isModifiable()) {
                                MIRootVariableObject.this.addModifiableDescendant(((MIVarCreateInfo)this.getData()).getName(), MIRootVariableObject.this);
                            }
                            if (localExprInfo.isDynamic() && localExprInfo.getChildCountLimit() != -1) {
                                MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarSetUpdateRange(MIRootVariableObject.this.getRootToUpdate().getControlDMContext(), MIRootVariableObject.this.getGdbName(), 0, localExprInfo.getChildCountLimit()), new DataRequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), rm));
                            } else {
                                rm.done();
                            }
                        } else {
                            rm.setStatus(this.getStatus());
                            rm.done();
                        }
                    }
                });
            } else assert (false);
        }

        @Override
        public void update(final DataRequestMonitor<Boolean> rm) {
            if (this.isOutOfScope()) {
                rm.setData((Object)false);
                rm.done();
            } else if (this.currentState != 0) {
                this.updatesPending.add(rm);
            } else if (!this.getOutOfDate()) {
                rm.setData((Object)false);
                rm.done();
            } else {
                this.currentState = 1;
                MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarUpdate(this.getRootToUpdate().getControlDMContext(), this.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<MIVarUpdateInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            MIRootVariableObject.this.setOutOfDate(false);
                            MIVarChange[] changes = ((MIVarUpdateInfo)this.getData()).getMIVarChanges();
                            if (changes.length > 0 && !changes[0].isInScope()) {
                                MIRootVariableObject.this.currentState = 0;
                                MIRootVariableObject.this.outOfScope = true;
                                MIVariableManager.this.lruVariableList.remove(MIRootVariableObject.this.getInternalId());
                                rm.setData((Object)true);
                                rm.done();
                                while (MIRootVariableObject.this.updatesPending.size() > 0) {
                                    DataRequestMonitor pendingRm = (DataRequestMonitor)MIRootVariableObject.this.updatesPending.poll();
                                    pendingRm.setData((Object)false);
                                    pendingRm.done();
                                }
                            } else {
                                MIRootVariableObject.this.processChanges(changes, new RequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)rm){

                                    protected void handleCompleted() {
                                        (this).MIRootVariableObject.this.currentState = 0;
                                        MIVariableManager.this.rootVariableUpdated(MIRootVariableObject.this);
                                        if (this.isSuccess()) {
                                            rm.setData((Object)false);
                                        } else {
                                            rm.setStatus(this.getStatus());
                                        }
                                        rm.done();
                                        while ((this).MIRootVariableObject.this.updatesPending.size() > 0) {
                                            DataRequestMonitor pendingRm = (DataRequestMonitor)(this).MIRootVariableObject.this.updatesPending.poll();
                                            if (this.isSuccess()) {
                                                pendingRm.setData((Object)false);
                                            } else {
                                                pendingRm.setStatus(this.getStatus());
                                            }
                                            pendingRm.done();
                                        }
                                    }
                                });
                            }
                        } else {
                            MIRootVariableObject.this.currentState = 0;
                            rm.setData((Object)false);
                            rm.done();
                            while (MIRootVariableObject.this.updatesPending.size() > 0) {
                                DataRequestMonitor pendingRm = (DataRequestMonitor)MIRootVariableObject.this.updatesPending.poll();
                                pendingRm.setStatus(this.getStatus());
                                pendingRm.done();
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void deleteInGdb() {
            if (this.getGdbName() != null) {
                MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarDelete(this.getRootToUpdate().getControlDMContext(), this.getGdbName()), new DataRequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), null));
                this.setGdbName(null);
            }
            super.deleteInGdb();
        }
    }

    public class MIVariableObject {
        protected static final int STATE_READY = 0;
        protected static final int STATE_UPDATING = 1;
        protected static final int STATE_NOT_CREATED = 10;
        protected static final int STATE_CREATING = 11;
        protected static final int STATE_CREATION_FAILED = 12;
        protected int currentState;
        private boolean locked = false;
        private final VariableObjectId internalId;
        private String gdbName = null;
        private String format = "NATURAL.Format";
        private MIExpressions.ExpressionInfo exprInfo;
        private String type = null;
        private GDBTypeParser.GDBType gdbType;
        private int numChildrenHint = 0;
        private Boolean editable = null;
        private Map<String, String> valueMap = null;
        private LinkedList<RequestMonitor> operationsPending;
        protected LinkedList<DataRequestMonitor<Boolean>> updatesPending;
        protected LinkedList<DataRequestMonitor<ChildrenInfo>> fetchChildrenPending;
        private MIExpressions.ExpressionInfo[] children = null;
        private List<MIExpressions.ExpressionInfo> fakeChildren = new ArrayList<MIExpressions.ExpressionInfo>(3);
        private boolean hasMore = false;
        private MIDisplayHint displayHint = MIDisplayHint.NONE;
        private MIVariableObject parent = null;
        private MIRootVariableObject rootToUpdate = null;
        protected boolean outOfScope = false;
        private boolean fetchingChildren = false;
        private boolean hasCastToBaseClassWorkaround = false;

        public MIVariableObject(VariableObjectId id, MIVariableObject parentObj) {
            this(id, parentObj, false);
        }

        public MIVariableObject(VariableObjectId id, MIVariableObject parentObj, boolean needsCreation) {
            this.currentState = needsCreation ? 10 : 0;
            this.operationsPending = new LinkedList();
            this.updatesPending = new LinkedList();
            this.fetchChildrenPending = new LinkedList();
            this.internalId = id;
            this.setParent(parentObj);
            this.valueMap = new HashMap<String, String>();
            this.resetValues();
        }

        public VariableObjectId getInternalId() {
            return this.internalId;
        }

        public String getGdbName() {
            return this.gdbName;
        }

        public String getCurrentFormat() {
            return this.format;
        }

        public MIVariableObject getParent() {
            return this.parent;
        }

        public MIRootVariableObject getRootToUpdate() {
            return this.rootToUpdate;
        }

        public String getExpression() {
            return this.exprInfo.getFullExpr();
        }

        public String getType() {
            return this.type;
        }

        public MIExpressions.ExpressionInfo getExpressionInfo() {
            return this.exprInfo;
        }

        public boolean isDynamic() {
            return this.exprInfo.isDynamic();
        }

        public boolean hasMore() {
            return this.hasMore;
        }

        public MIDisplayHint getDisplayHint() {
            return this.displayHint;
        }

        public void setDisplayHint(MIDisplayHint displayHint) {
            this.displayHint = displayHint;
        }

        public boolean hasChildren() {
            return this.getNumChildrenHint() != 0 || this.hasMore();
        }

        public GDBTypeParser.GDBType getGDBType() {
            return this.gdbType;
        }

        public int getNumChildrenHint() {
            return this.numChildrenHint;
        }

        public boolean isNumChildrenHintTrustworthy() {
            return this.getNumChildrenHint() == 0 && !this.hasMore() || this.isArray();
        }

        public String getValue(String format) {
            return this.valueMap.get(format);
        }

        public MIExpressions.ExpressionInfo[] getChildren() {
            return this.children;
        }

        public boolean isArray() {
            return this.getGDBType() == null ? false : this.getGDBType().getType() == 3;
        }

        public boolean isPointer() {
            return this.getGDBType() == null ? false : this.getGDBType().getType() == 1;
        }

        public boolean isMethod() {
            return this.getGDBType() == null ? false : this.getGDBType().getType() == 4;
        }

        public boolean isComplex() {
            return this.getGDBType() == null ? false : this.getGDBType().getType() != 1 && this.getGDBType().getType() != 2 && (this.getNumChildrenHint() > 0 || this.hasMore() || this.getDisplayHint().isCollectionHint());
        }

        public boolean isSafeToAskForAllChildren() {
            boolean isDynamicButSafe;
            MIDisplayHint.GdbDisplayHint displayHint = this.getDisplayHint().getGdbDisplayHint();
            boolean bl = isDynamicButSafe = displayHint == MIDisplayHint.GdbDisplayHint.GDB_DISPLAY_HINT_STRING || displayHint == MIDisplayHint.GdbDisplayHint.GDB_DISPLAY_HINT_NONE;
            return !this.isDynamic() || isDynamicButSafe;
        }

        public void setGdbName(String n) {
            this.gdbName = n;
        }

        public void setCurrentFormat(String f) {
            this.format = f;
        }

        @Deprecated
        public void setExpressionData(String fullExpression, String t, int num) {
            new MIExpressions.ExpressionInfo(fullExpression, fullExpression);
        }

        public void setExpressionData(MIExpressions.ExpressionInfo info, String typeName, int num, boolean hasMore) {
            this.exprInfo = info;
            this.setType(typeName);
            this.numChildrenHint = num;
            this.hasMore = hasMore;
        }

        public void setType(String newTypeName) {
            this.type = newTypeName;
            this.gdbType = MIVariableManager.this.getGDBTypeParser().parse(newTypeName);
        }

        public void setValue(String format, String val) {
            this.valueMap.put(format, val);
        }

        public void resetValues(String valueInCurrentFormat) {
            this.resetValues();
            this.setValue(this.getCurrentFormat(), valueInCurrentFormat);
        }

        public void resetValues() {
            this.valueMap.put("NATURAL.Format", null);
            this.valueMap.put("BINARY.Format", null);
            this.valueMap.put("HEX.Format", null);
            this.valueMap.put("OCTAL.Format", null);
            this.valueMap.put("DECIMAL.Format", null);
        }

        public void setChildren(MIExpressions.ExpressionInfo[] c) {
            this.children = c;
            if (this.children != null) {
                this.numChildrenHint = this.children.length;
            }
            if (this.children != null) {
                MIExpressions.ExpressionInfo[] expressionInfoArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    MIExpressions.ExpressionInfo child = expressionInfoArray[n2];
                    assert (child != null);
                    ++n2;
                }
            }
        }

        public void addChildren(MIExpressions.ExpressionInfo[] newChildren) {
            if (this.children == null) {
                this.children = new MIExpressions.ExpressionInfo[newChildren.length];
                System.arraycopy(newChildren, 0, this.children, 0, newChildren.length);
            } else {
                MIExpressions.ExpressionInfo[] oldChildren = this.children;
                this.children = new MIExpressions.ExpressionInfo[this.children.length + newChildren.length];
                System.arraycopy(oldChildren, 0, this.children, 0, oldChildren.length);
                System.arraycopy(newChildren, 0, this.children, oldChildren.length, newChildren.length);
            }
            this.numChildrenHint = this.children.length;
            MIExpressions.ExpressionInfo[] expressionInfoArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                MIExpressions.ExpressionInfo child = expressionInfoArray[n2];
                assert (child != null);
                ++n2;
            }
        }

        protected void addChildren(MIExpressions.ExpressionInfo[][] newChildren) {
            int requiredSize = 0;
            MIExpressions.ExpressionInfo[][] expressionInfoArray = newChildren;
            int n = newChildren.length;
            int n2 = 0;
            while (n2 < n) {
                MIExpressions.ExpressionInfo[] subArray = expressionInfoArray[n2];
                requiredSize += subArray.length;
                ++n2;
            }
            MIExpressions.ExpressionInfo[] plainChildren = new MIExpressions.ExpressionInfo[requiredSize];
            int i = 0;
            MIExpressions.ExpressionInfo[][] expressionInfoArray2 = newChildren;
            int n3 = newChildren.length;
            int n4 = 0;
            while (n4 < n3) {
                MIExpressions.ExpressionInfo[] subArray = expressionInfoArray2[n4];
                System.arraycopy(subArray, 0, plainChildren, i, subArray.length);
                i += subArray.length;
                ++n4;
            }
            this.addChildren(plainChildren);
        }

        public void shrinkChildrenTo(int newNumChildren) {
            if (this.children != null) {
                MIExpressions.ExpressionInfo[] oldChildren = this.children;
                int i = oldChildren.length - 1;
                while (i >= newNumChildren) {
                    String childFullExpression = this.children[i].getFullExpr();
                    VariableObjectId childId = new VariableObjectId();
                    childId.generateId(childFullExpression, this.getInternalId());
                    MIVariableManager.this.lruVariableList.remove(childId);
                    --i;
                }
                this.children = new MIExpressions.ExpressionInfo[newNumChildren];
                System.arraycopy(oldChildren, 0, this.children, 0, newNumChildren);
            }
            this.numChildrenHint = newNumChildren;
        }

        public void cleanupChild(MIExpressions.ExpressionInfo child) {
            String childFullExpression = child.getFullExpr();
            VariableObjectId childId = new VariableObjectId();
            childId.generateId(childFullExpression, this.getInternalId());
            MIVariableObject varobjOfChild = MIVariableManager.this.lruVariableList.remove(childId);
            if (varobjOfChild != null) {
                this.getRootToUpdate().removeModifiableDescendant(varobjOfChild.getGdbName());
                varobjOfChild.cleanupChildren();
            }
        }

        public void cleanupChildren() {
            this.hasMore = false;
            if (this.children != null) {
                MIExpressions.ExpressionInfo[] expressionInfoArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    MIExpressions.ExpressionInfo child = expressionInfoArray[n2];
                    this.cleanupChild(child);
                    ++n2;
                }
                this.children = null;
                this.numChildrenHint = 0;
            }
            for (MIExpressions.ExpressionInfo fakeChild : this.fakeChildren) {
                this.cleanupChild(fakeChild);
            }
            this.fakeChildren.clear();
        }

        public void setParent(MIVariableObject p) {
            this.parent = p;
            this.rootToUpdate = p == null ? (this instanceof MIRootVariableObject ? (MIRootVariableObject)this : null) : p.getRootToUpdate();
        }

        public void executeWhenNotUpdating(RequestMonitor rm) {
            this.getRootToUpdate().executeWhenNotUpdating(rm);
        }

        private void lock() {
            this.locked = true;
        }

        private void unlock() {
            this.locked = false;
            while (this.operationsPending.size() > 0) {
                this.operationsPending.poll().done();
            }
        }

        public boolean isOutOfScope() {
            return this.outOfScope;
        }

        protected void creationCompleted(boolean success) {
            if (success) {
                this.currentState = 0;
                while (this.updatesPending.size() > 0) {
                    DataRequestMonitor<Boolean> rm = this.updatesPending.poll();
                    rm.setData((Object)false);
                    rm.done();
                }
            } else {
                this.currentState = 12;
                while (this.updatesPending.size() > 0) {
                    RequestMonitor rm = (RequestMonitor)this.updatesPending.poll();
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unable to create variable object", null));
                    rm.done();
                }
            }
        }

        public void update(final DataRequestMonitor<Boolean> rm) {
            if (this.isOutOfScope()) {
                rm.setData((Object)false);
                rm.done();
            } else if (this.currentState != 0) {
                this.updatesPending.add(rm);
            } else {
                this.currentState = 1;
                this.getRootToUpdate().update(new DataRequestMonitor<Boolean>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleCompleted() {
                        MIVariableObject.this.currentState = 0;
                        if (this.isSuccess()) {
                            MIVariableObject.this.outOfScope = MIVariableObject.this.getRootToUpdate().isOutOfScope();
                            rm.setData((Object)MIVariableObject.this.outOfScope);
                            rm.done();
                            while (MIVariableObject.this.updatesPending.size() > 0) {
                                DataRequestMonitor<Boolean> pendingRm = MIVariableObject.this.updatesPending.poll();
                                pendingRm.setData((Object)false);
                                pendingRm.done();
                            }
                        } else {
                            rm.setStatus(this.getStatus());
                            rm.done();
                            while (MIVariableObject.this.updatesPending.size() > 0) {
                                DataRequestMonitor<Boolean> pendingRm = MIVariableObject.this.updatesPending.poll();
                                pendingRm.setStatus(this.getStatus());
                                pendingRm.done();
                            }
                        }
                    }
                });
            }
        }

        protected void processChange(final MIVarChange update, final RequestMonitor rm) {
            if (update.isChanged()) {
                this.setType(update.getNewType());
                this.cleanupChildren();
                this.editable = null;
                this.updateLimit(-1);
            }
            this.setDisplayHint(update.getDisplayHint());
            this.exprInfo.setDynamic(update.isDynamic());
            MIVar[] newChildren = update.getNewChildren();
            final boolean addNewChildren = this.children != null;
            final MIExpressions.ExpressionInfo[] addedChildren = addNewChildren && newChildren != null ? new MIExpressions.ExpressionInfo[newChildren.length] : null;
            final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        rm.setStatus(this.getStatus());
                    } else {
                        if (update.numChildrenChanged()) {
                            if (MIVariableObject.this.children != null) {
                                if (MIVariableObject.this.children.length > update.getNewNumChildren()) {
                                    MIVariableObject.this.shrinkChildrenTo(update.getNewNumChildren());
                                }
                            } else {
                                MIVariableObject.this.numChildrenHint = update.getNewNumChildren();
                            }
                            if (addedChildren != null && addedChildren.length != 0) {
                                MIVariableObject.this.addChildren(addedChildren);
                            }
                        }
                        if (!$assertionsDisabled && MIVariableObject.this.children != null && MIVariableObject.this.children.length != MIVariableObject.this.numChildrenHint) {
                            throw new AssertionError();
                        }
                        MIVariableObject.this.hasMore = update.hasMore();
                        if (MIVariableObject.this.hasMore() && MIVariableObject.this.numChildrenHint == 0) {
                            MIVariableObject.this.setChildren(null);
                        }
                        MIVariableObject.this.resetValues(update.getValue());
                    }
                    rm.done();
                }
            };
            int pendingVariableCreationCount = 0;
            if (newChildren != null && newChildren.length != 0) {
                int i = update.getNewNumChildren() - newChildren.length;
                int arrayPosition = 0;
                MIVar[] mIVarArray = newChildren;
                int n = newChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    final MIVar newChild = mIVarArray[n2];
                    final String childFullExpression = this.buildChildExpression(this.getExpression(), newChild.getExp());
                    final VariableObjectId childId = new VariableObjectId();
                    childId.generateId(childFullExpression, this.getInternalId());
                    MIVariableObject childVar = MIVariableManager.this.lruVariableList.get(childId);
                    if (childVar != null) {
                        if (childVar.currentState == 11 || childVar.currentState == 10) {
                            ++pendingVariableCreationCount;
                            final int insertPosition = arrayPosition;
                            final MIVariableObject monitoredVar = childVar;
                            final int indexInParent = i;
                            childVar.updatesPending.add(new DataRequestMonitor<Boolean>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)countingRm){

                                protected void handleCompleted() {
                                    if (this.isSuccess()) {
                                        if (addNewChildren && addedChildren != null) {
                                            addedChildren[insertPosition] = monitoredVar.exprInfo;
                                        }
                                    } else {
                                        MIVariableObject newVar = MIVariableObject.this.createChild(childId, childFullExpression, indexInParent, newChild);
                                        if (addNewChildren && addedChildren != null) {
                                            addedChildren[insertPosition] = newVar.exprInfo;
                                        }
                                    }
                                    countingRm.done();
                                }
                            });
                        } else if (childVar.currentState == 12) {
                            childVar = null;
                        } else if (childVar.getRootToUpdate().isOutOfScope()) {
                            childVar.deleteInGdb();
                            childVar = null;
                        }
                    }
                    if (childVar == null) {
                        childVar = this.createChild(childId, childFullExpression, i, newChild);
                        if (addNewChildren && addedChildren != null) {
                            addedChildren[arrayPosition] = childVar.exprInfo;
                        }
                    }
                    ++i;
                    ++arrayPosition;
                    ++n2;
                }
            }
            countingRm.setDoneCount(pendingVariableCreationCount);
        }

        public void deleteInGdb() {
        }

        private void getAttributes(final DataRequestMonitor<Boolean> rm) {
            if (this.editable != null) {
                rm.setData((Object)this.editable);
                rm.done();
            } else if (this.isComplex()) {
                this.editable = false;
                rm.setData((Object)this.editable);
                rm.done();
            } else {
                MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarShowAttributes(this.getRootToUpdate().getControlDMContext(), this.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<MIVarShowAttributesInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleSuccess() {
                        MIVariableObject.this.editable = ((MIVarShowAttributesInfo)this.getData()).isEditable();
                        rm.setData((Object)MIVariableObject.this.editable);
                        rm.done();
                    }
                });
            }
        }

        protected void getValue(final IFormattedValues.FormattedValueDMContext dmc, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
            String value = this.getValue(dmc.getFormatID());
            if (value != null) {
                rm.setData((Object)new IFormattedValues.FormattedValueDMData(value));
                rm.done();
                return;
            }
            if (this.isComplex() && !this.isDynamic()) {
                if (this.isArray()) {
                    IExpressions.IExpressionDMContext exprCxt = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IExpressions.IExpressionDMContext.class);
                    IExpressions.IExpressionDMContext addrCxt = MIVariableManager.this.fExpressionService.createExpression((IDMContext)exprCxt, "&(" + exprCxt.getExpression() + ")");
                    final IFormattedValues.FormattedValueDMContext formatCxt = new IFormattedValues.FormattedValueDMContext(MIVariableManager.this.fSession.getId(), (IDMContext)addrCxt, dmc.getFormatID());
                    MIVariableManager.this.getVariable(addrCxt, (DataRequestMonitor<MIVariableObject>)((DataRequestMonitor)new DataRequestMonitor<MIVariableObject>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                        protected void handleSuccess() {
                            ((MIVariableObject)this.getData()).getValue(formatCxt, (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)rm);
                        }
                    }));
                } else {
                    String complexValue = "{...}";
                    this.setValue(dmc.getFormatID(), complexValue);
                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(complexValue));
                    rm.done();
                }
                return;
            }
            if (this.locked) {
                this.operationsPending.add(new RequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
                    private final /* synthetic */ DataRequestMonitor val$rm;
                    {
                        this.val$rm = dataRequestMonitor;
                        super($anonymous0, $anonymous1);
                    }

                    protected void handleSuccess() {
                        MIVariableObject.this.getValue(dmc, (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)this.val$rm);
                    }
                });
            } else {
                this.lock();
                if (dmc.getFormatID().equals(this.getCurrentFormat())) {
                    this.evaluate(rm);
                } else {
                    MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarSetFormat(this.getRootToUpdate().getControlDMContext(), this.getGdbName(), dmc.getFormatID()), (DataRequestMonitor)new DataRequestMonitor<MIVarSetFormatInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                MIVariableObject.this.setCurrentFormat(dmc.getFormatID());
                                if (((MIVarSetFormatInfo)this.getData()).getValue() != null) {
                                    MIVariableObject.this.setValue(dmc.getFormatID(), ((MIVarSetFormatInfo)this.getData()).getValue());
                                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(((MIVarSetFormatInfo)this.getData()).getValue()));
                                    rm.done();
                                    MIVariableObject.this.resetFormatToNatural();
                                } else {
                                    MIVariableObject.this.evaluate((DataRequestMonitor<IFormattedValues.FormattedValueDMData>)rm);
                                }
                            } else {
                                rm.setStatus(this.getStatus());
                                rm.done();
                                MIVariableObject.this.unlock();
                            }
                        }
                    });
                }
            }
        }

        private void evaluate(final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
            MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarEvaluateExpression(this.getRootToUpdate().getControlDMContext(), this.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<MIVarEvaluateExpressionInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        MIVariableObject.this.setValue(MIVariableObject.this.getCurrentFormat(), ((MIVarEvaluateExpressionInfo)this.getData()).getValue());
                        rm.setData((Object)new IFormattedValues.FormattedValueDMData(((MIVarEvaluateExpressionInfo)this.getData()).getValue()));
                        rm.done();
                    } else {
                        rm.setStatus(this.getStatus());
                        rm.done();
                    }
                    MIVariableObject.this.resetFormatToNatural();
                }
            });
        }

        private void resetFormatToNatural() {
            if (!this.getCurrentFormat().equals("NATURAL.Format")) {
                MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarSetFormat(this.getRootToUpdate().getControlDMContext(), this.getGdbName(), "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<MIVarSetFormatInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            MIVariableObject.this.setCurrentFormat("NATURAL.Format");
                        }
                        MIVariableObject.this.unlock();
                    }
                });
            } else {
                this.unlock();
            }
        }

        private void getChildren(final IExpressions.IExpressionDMContext exprDmc, final int clientNumChildrenLimit, final DataRequestMonitor<ChildrenInfo> rm) {
            if (this.fetchingChildren) {
                this.fetchChildrenPending.add(new DataRequestMonitor<ChildrenInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleSuccess() {
                        ChildrenInfo info = (ChildrenInfo)this.getData();
                        int numChildren = info.getChildren().length;
                        if (!info.hasMore() || numChildren >= clientNumChildrenLimit) {
                            rm.setData((Object)((ChildrenInfo)this.getData()));
                            rm.done();
                        } else {
                            MIVariableObject.this.getChildren(exprDmc, clientNumChildrenLimit, (DataRequestMonitor<ChildrenInfo>)rm);
                        }
                    }
                });
            } else {
                this.fetchingChildren = true;
                this.fetchChildren(exprDmc, clientNumChildrenLimit, new DataRequestMonitor<ChildrenInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleCompleted() {
                        MIVariableObject.this.fetchingChildren = false;
                        if (this.isSuccess()) {
                            rm.setData((Object)((ChildrenInfo)this.getData()));
                            rm.done();
                            while (MIVariableObject.this.fetchChildrenPending.size() > 0) {
                                DataRequestMonitor<ChildrenInfo> pendingRm = MIVariableObject.this.fetchChildrenPending.poll();
                                pendingRm.setData((Object)((ChildrenInfo)this.getData()));
                                pendingRm.done();
                            }
                        } else {
                            rm.setStatus(this.getStatus());
                            rm.done();
                            while (MIVariableObject.this.fetchChildrenPending.size() > 0) {
                                DataRequestMonitor<ChildrenInfo> pendingRm = MIVariableObject.this.fetchChildrenPending.poll();
                                pendingRm.setStatus(this.getStatus());
                                pendingRm.done();
                            }
                        }
                    }
                });
            }
        }

        protected void fetchChildren(final IExpressions.IExpressionDMContext exprDmc, int clientNumChildrenLimit, final DataRequestMonitor<ChildrenInfo> rm) {
            int newNumChildrenLimit = clientNumChildrenLimit != -1 ? clientNumChildrenLimit : 1;
            boolean addChildren = this.requiresAdditionalChildren(newNumChildrenLimit);
            MIExpressions.ExpressionInfo[] childrenArray = this.getChildren();
            if (childrenArray != null && !addChildren) {
                rm.setData((Object)new ChildrenInfo(childrenArray, this.hasMore));
                rm.done();
                return;
            }
            if (!this.hasChildren()) {
                this.setChildren(new MIExpressions.ExpressionInfo[0]);
                rm.setData((Object)new ChildrenInfo(this.getChildren(), this.hasMore));
                rm.done();
                return;
            }
            if (this.isArray()) {
                MIExpressions.ExpressionInfo[] childrenOfArray = new MIExpressions.ExpressionInfo[this.getNumChildrenHint()];
                String exprName = exprDmc.getExpression();
                int castingIndex = 0;
                if (exprDmc instanceof IExpressions2.ICastedExpressionDMContext) {
                    castingIndex = ((IExpressions2.ICastedExpressionDMContext)exprDmc).getCastInfo().getArrayStartIndex();
                }
                if (exprDmc instanceof IExpressions.IIndexedPartitionDMContext) {
                    castingIndex = ((IExpressions.IIndexedPartitionDMContext)exprDmc).getIndex();
                }
                int i = 0;
                while (i < childrenOfArray.length) {
                    String fullExpr = String.valueOf(exprName) + "[" + i + "]";
                    String relExpr = exprDmc instanceof MIExpressions.MIExpressionDMC ? ((MIExpressions.MIExpressionDMC)exprDmc).getRelativeExpression() : exprDmc.getExpression();
                    relExpr = String.valueOf(relExpr) + "[" + (castingIndex + i) + "]";
                    childrenOfArray[i] = new MIExpressions.ExpressionInfo(fullExpr, relExpr, false, this.exprInfo, i);
                    ++i;
                }
                this.setChildren(childrenOfArray);
                this.hasMore = false;
                rm.setData((Object)new ChildrenInfo(this.getChildren(), this.hasMore));
                rm.done();
                return;
            }
            final int from = addChildren && this.children != null ? this.getNumChildrenHint() : 0;
            final int to = Math.max(newNumChildrenLimit, this.exprInfo.getChildCountLimit());
            ICommand<MIVarListChildrenInfo> varListChildren = this.isSafeToAskForAllChildren() ? MIVariableManager.this.fCommandFactory.createMIVarListChildren(this.getRootToUpdate().getControlDMContext(), this.getGdbName()) : MIVariableManager.this.fCommandFactory.createMIVarListChildren(this.getRootToUpdate().getControlDMContext(), this.getGdbName(), from, to);
            MIVariableManager.this.fCommandControl.queueCommand(varListChildren, (DataRequestMonitor)new DataRequestMonitor<MIVarListChildrenInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleSuccess() {
                    MIVar[] children = ((MIVarListChildrenInfo)this.getData()).getMIVars();
                    final boolean localHasMore = ((MIVarListChildrenInfo)this.getData()).hasMore();
                    final MIExpressions.ExpressionInfo[][] realChildren = new MIExpressions.ExpressionInfo[children.length][];
                    final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            MIVariableObject.this.addChildren(realChildren);
                            MIVariableObject.this.hasMore = localHasMore;
                            rm.setData((Object)new ChildrenInfo(MIVariableObject.this.getChildren(), MIVariableObject.this.hasMore));
                            int updateLimit = MIVariableObject.this.updateLimit(to);
                            if (!MIVariableObject.this.isSafeToAskForAllChildren()) {
                                MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarSetUpdateRange(MIVariableObject.this.getRootToUpdate().getControlDMContext(), MIVariableObject.this.getGdbName(), 0, updateLimit), new DataRequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)rm));
                            } else {
                                rm.done();
                            }
                        }
                    };
                    int numSubRequests = 0;
                    int i = 0;
                    while (i < children.length) {
                        final MIVar child = children[i];
                        final int indexInParent = from + i;
                        final int arrayPosition = i;
                        ++numSubRequests;
                        class ChildFullExpressionInfo {
                            private String childFullExpression;
                            private boolean childHasCastToBaseClassWorkaround;

                            public ChildFullExpressionInfo(String path) {
                                this(path, false);
                            }

                            public ChildFullExpressionInfo(String path, boolean hasWorkaround) {
                                this.childFullExpression = path == null ? "" : path;
                                this.childHasCastToBaseClassWorkaround = hasWorkaround;
                            }

                            public String getChildPath() {
                                return this.childFullExpression;
                            }

                            public boolean getChildHasCastToBaseClassWorkaround() {
                                return this.childHasCastToBaseClassWorkaround;
                            }
                        }
                        DataRequestMonitor<ChildFullExpressionInfo> childPathRm = new DataRequestMonitor<ChildFullExpressionInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)countingRm){

                            protected void handleSuccess() {
                                String childPath = ((ChildFullExpressionInfo)this.getData()).getChildPath();
                                final boolean childHasCastToBaseClassWorkaround = MIVariableObject.this.hasCastToBaseClassWorkaround || ((ChildFullExpressionInfo)this.getData()).getChildHasCastToBaseClassWorkaround();
                                final boolean fakeChild = childPath.length() == 0;
                                final String childFullExpression = fakeChild ? child.getVarName() : childPath;
                                final VariableObjectId childId = new VariableObjectId();
                                childId.generateId(childFullExpression, MIVariableObject.this.getInternalId());
                                MIVariableObject childVar = MIVariableManager.this.lruVariableList.get(childId);
                                if (childVar != null) {
                                    if (childVar.currentState == 11 || childVar.currentState == 10) {
                                        final MIVariableObject monitoredVar = childVar;
                                        childVar.updatesPending.add(new DataRequestMonitor<Boolean>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)countingRm){

                                            protected void handleCompleted() {
                                                MIVariableObject var = monitoredVar;
                                                if (!this.isSuccess()) {
                                                    var = MIVariableObject.this.createChild(childId, childFullExpression, indexInParent, child);
                                                }
                                                var.hasCastToBaseClassWorkaround = childHasCastToBaseClassWorkaround;
                                                if (fakeChild) {
                                                    if (!this.isSuccess()) {
                                                        MIVariableObject.this.fakeChildren.add(var.exprInfo);
                                                    }
                                                    MIVariableObject.this.addRealChildrenOfFake(var, exprDmc, realChildren, arrayPosition, (RequestMonitor)countingRm);
                                                } else {
                                                    realChildren[arrayPosition] = new MIExpressions.ExpressionInfo[]{var.exprInfo};
                                                    countingRm.done();
                                                }
                                            }
                                        });
                                    } else if (childVar.currentState == 12) {
                                        childVar = null;
                                    } else if (childVar.getRootToUpdate().isOutOfScope()) {
                                        childVar.deleteInGdb();
                                        childVar = null;
                                    } else {
                                        childVar.hasCastToBaseClassWorkaround = childHasCastToBaseClassWorkaround;
                                        if (fakeChild) {
                                            MIVariableObject.this.addRealChildrenOfFake(childVar, exprDmc, realChildren, arrayPosition, (RequestMonitor)countingRm);
                                        } else {
                                            MIExpressions.ExpressionInfo oldInfo = childVar.getExpressionInfo();
                                            realChildren[arrayPosition] = new MIExpressions.ExpressionInfo[]{new MIExpressions.ExpressionInfo(oldInfo.getFullExpr(), child.getExp(), oldInfo.isDynamic(), oldInfo.getParent(), oldInfo.getIndexInParentExpression())};
                                            countingRm.done();
                                        }
                                    }
                                }
                                if (childVar == null) {
                                    childVar = MIVariableObject.this.createChild(childId, childFullExpression, indexInParent, child);
                                    childVar.hasCastToBaseClassWorkaround = childHasCastToBaseClassWorkaround;
                                    if (fakeChild) {
                                        MIVariableObject.this.fakeChildren.add(childVar.exprInfo);
                                        MIVariableObject.this.addRealChildrenOfFake(childVar, exprDmc, realChildren, arrayPosition, (RequestMonitor)countingRm);
                                    } else {
                                        realChildren[arrayPosition] = new MIExpressions.ExpressionInfo[]{childVar.exprInfo};
                                        countingRm.done();
                                    }
                                }
                            }
                        };
                        if (MIVariableObject.this.isAccessQualifier(child.getExp())) {
                            childPathRm.setData((Object)new ChildFullExpressionInfo(""));
                            childPathRm.done();
                        } else if (MIVariableObject.this.isDynamic() || MIVariableObject.this.exprInfo.hasDynamicAncestor()) {
                            childPathRm.setData((Object)new ChildFullExpressionInfo(MIVariableObject.this.buildChildExpression(exprDmc.getExpression(), child.getExp())));
                            childPathRm.done();
                        } else if (MIVariableObject.this.hasCastToBaseClassWorkaround) {
                            childPathRm.setData((Object)new ChildFullExpressionInfo(MIVariableObject.this.buildChildExpression(exprDmc.getExpression(), child.getExp())));
                            childPathRm.done();
                        } else {
                            MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarInfoPathExpression(MIVariableObject.this.getRootToUpdate().getControlDMContext(), child.getVarName()), (DataRequestMonitor)new DataRequestMonitor<MIVarInfoPathExpressionInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)childPathRm, (DataRequestMonitor)childPathRm){
                                private final /* synthetic */ DataRequestMonitor val$childPathRm;
                                {
                                    this.val$childPathRm = dataRequestMonitor;
                                    super($anonymous0, $anonymous1);
                                }

                                protected void handleCompleted() {
                                    if (this.isSuccess()) {
                                        final String expression = ((MIVarInfoPathExpressionInfo)this.getData()).getFullExpression();
                                        if (MIVariableManager.this.needFixForGDBBug320277() && child.getExp().equals(child.getType()) && !MIVariableObject.this.isAccessQualifier(MIVariableObject.this.getExpressionInfo().getRelExpr())) {
                                            IExpressions.IExpressionDMContext exprDmcMIData = MIVariableManager.this.fExpressionService.createExpression((IDMContext)exprDmc, expression);
                                            MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIDataEvaluateExpression(exprDmcMIData), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)this.val$childPathRm){

                                                protected void handleCompleted() {
                                                    if (this.isSuccess()) {
                                                        val$childPathRm.setData((Object)new ChildFullExpressionInfo(expression));
                                                        val$childPathRm.done();
                                                    } else {
                                                        val$childPathRm.setData((Object)new ChildFullExpressionInfo(MIVariableObject.this.buildDerivedChildExpression(exprDmc.getExpression(), child.getExp()), true));
                                                        val$childPathRm.done();
                                                    }
                                                }
                                            });
                                        } else {
                                            this.val$childPathRm.setData((Object)new ChildFullExpressionInfo(expression));
                                            this.val$childPathRm.done();
                                        }
                                    } else {
                                        this.val$childPathRm.setData((Object)new ChildFullExpressionInfo(MIVariableObject.this.buildChildExpression(exprDmc.getExpression(), child.getExp())));
                                        this.val$childPathRm.done();
                                    }
                                }
                            });
                        }
                        ++i;
                    }
                    countingRm.setDoneCount(numSubRequests);
                }
            });
        }

        protected MIVariableObject createChild(VariableObjectId childId, String childFullExpression, int indexInParent, MIVar childData) {
            MIVariableObject var = MIVariableManager.this.createVariableObject(childId, this);
            MIExpressions.ExpressionInfo childInfo = new MIExpressions.ExpressionInfo(childFullExpression, childData.getExp(), childData.isDynamic(), this.exprInfo, indexInParent);
            var.initFrom(childData, childInfo);
            return var;
        }

        protected boolean requiresAdditionalChildren(int clientLimit) {
            return !this.isSafeToAskForAllChildren() && this.exprInfo.getChildCountLimit() < this.calculateNewLimit(clientLimit);
        }

        protected int updateLimit(int newLimit) {
            this.exprInfo.setChildCountLimit(this.calculateNewLimit(newLimit));
            return this.exprInfo.getChildCountLimit();
        }

        private int calculateNewLimit(int clientLimit) {
            int limit = this.exprInfo.getChildCountLimit();
            if (!this.isSafeToAskForAllChildren() && clientLimit != -1) {
                if (limit == -1) {
                    return clientLimit;
                }
                if (limit < clientLimit) {
                    return clientLimit;
                }
            }
            return limit;
        }

        private void addRealChildrenOfFake(MIVariableObject fakeChild, IExpressions.IExpressionDMContext frameCtxProvider, final MIExpressions.ExpressionInfo[][] realChildren, final int position, final RequestMonitor rm) {
            MIExpressions.MIExpressionDMC fakeExprCtx = MIVariableManager.this.createExpressionCtx(frameCtxProvider, fakeChild.exprInfo);
            fakeChild.getChildren(fakeExprCtx, -1, new DataRequestMonitor<ChildrenInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        realChildren[position] = ((ChildrenInfo)this.getData()).getChildren();
                        if (!$assertionsDisabled && ((ChildrenInfo)this.getData()).hasMore()) {
                            throw new AssertionError();
                        }
                    }
                    rm.done();
                }
            });
        }

        private String buildDerivedChildExpression(String parentExp, String childExpr) {
            String childNameForCast = childExpr.contains("::") ? "'" + childExpr + "'" : childExpr;
            String childFullExpression = this.isPointer() ? "*(struct " + childNameForCast + "*)(" + parentExp + ")" : "(struct " + childNameForCast + ")" + parentExp;
            return childFullExpression;
        }

        private String buildChildExpression(String parentExp, String childExp) {
            if (this.isAccessQualifier(this.exprInfo.getRelExpr())) {
                parentExp = this.getParent().getExpression();
            }
            String childFullExpression = !this.isDynamic() && !this.exprInfo.hasDynamicAncestor() && this.isPointer() ? "*(" + parentExp + ")" : "(" + parentExp + ")." + childExp;
            return childFullExpression;
        }

        protected void getChildrenCount(IExpressions.IExpressionDMContext exprDmc, int numChildrenLimit, final DataRequestMonitor<ChildrenCountInfo> rm) {
            if (this.isNumChildrenHintTrustworthy()) {
                rm.setData((Object)new ChildrenCountInfo(this.getNumChildrenHint(), this.hasMore()));
                rm.done();
                return;
            }
            this.getChildren(exprDmc, numChildrenLimit, new DataRequestMonitor<ChildrenInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)new ChildrenCountInfo(((ChildrenInfo)this.getData()).getChildren().length, ((ChildrenInfo)this.getData()).hasMore()));
                    rm.done();
                }
            });
        }

        private void writeValue(String value, String formatId, final RequestMonitor rm) {
            if (this.isComplex()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Cannot change the value of a complex expression", null));
                rm.done();
                return;
            }
            if (formatId.equals("HEX.Format")) {
                if (!value.startsWith("0x")) {
                    value = "0x" + value;
                }
            } else if (formatId.equals("OCTAL.Format")) {
                if (!value.startsWith("0")) {
                    value = "0" + value;
                }
            } else if (formatId.equals("BINARY.Format")) {
                if (value.startsWith("0b")) {
                    value = value.substring(2, value.length());
                }
                try {
                    value = new BigInteger(value, 2).toString();
                }
                catch (NumberFormatException e) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid binary number: " + value, (Throwable)e));
                    rm.done();
                    return;
                }
                formatId = "DECIMAL.Format";
            } else if (!formatId.equals("DECIMAL.Format") && !formatId.equals("NATURAL.Format")) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unknown format: " + formatId, null));
                rm.done();
                return;
            }
            if (value.equals(this.getValue(formatId))) {
                rm.setStatus((IStatus)new Status(2, "org.eclipse.cdt.dsf.gdb", 10003, "Setting to the same value of: " + value, null));
                rm.done();
                return;
            }
            MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarAssign(this.getRootToUpdate().getControlDMContext(), this.getGdbName(), value), (DataRequestMonitor)new DataRequestMonitor<MIVarAssignInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleSuccess() {
                    MIVariableManager.this.markAllOutOfDate();
                    rm.done();
                }
            });
        }

        private boolean isAccessQualifier(String str) {
            return str.equals("private") || str.equals("public") || str.equals("protected");
        }

        public boolean isModifiable() {
            return !this.isComplex() || this.isDynamic();
        }

        public void create(IExpressions.IExpressionDMContext exprCtx, final RequestMonitor rm) {
            if (this.currentState == 10) {
                this.currentState = 11;
                final MIExpressions.MIExpressionDMC miExprCtx = (MIExpressions.MIExpressionDMC)exprCtx;
                int indexInParent = miExprCtx.getExpressionInfo().getIndexInParentExpression();
                MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarListChildren(this.getParent().getRootToUpdate().getControlDMContext(), this.getParent().getGdbName(), indexInParent, indexInParent + 1), (DataRequestMonitor)new DataRequestMonitor<MIVarListChildrenInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleSuccess() {
                        if (((MIVarListChildrenInfo)this.getData()).getMIVars().length == 1) {
                            MIVar miVar = ((MIVarListChildrenInfo)this.getData()).getMIVars()[0];
                            MIExpressions.ExpressionInfo localExprInfo = miExprCtx.getExpressionInfo();
                            localExprInfo.setDynamic(miVar.isDynamic());
                            MIVariableObject.this.initFrom(miVar, localExprInfo);
                            if (MIVariableObject.this.exprInfo.isDynamic() && MIVariableObject.this.exprInfo.getChildCountLimit() != -1) {
                                MIVariableManager.this.fCommandControl.queueCommand(MIVariableManager.this.fCommandFactory.createMIVarSetUpdateRange(MIVariableObject.this.getRootToUpdate().getControlDMContext(), MIVariableObject.this.getGdbName(), 0, MIVariableObject.this.exprInfo.getChildCountLimit()), new DataRequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), rm));
                            } else {
                                rm.done();
                            }
                        } else {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unexpected return on -var-list-children", null));
                            rm.done();
                        }
                    }
                });
            } else assert (false);
        }

        private void initFrom(MIVar miVar, MIExpressions.ExpressionInfo newExprInfo) {
            boolean newHasMore = miVar.hasMore() || miVar.isDynamic() && miVar.getNumChild() == 0;
            this.setGdbName(miVar.getVarName());
            this.setDisplayHint(miVar.getDisplayHint());
            this.setExpressionData(newExprInfo, miVar.getType(), miVar.getNumChild(), newHasMore);
            MIVariableManager.this.lruVariableList.put(this.getInternalId(), this);
            if (this.isModifiable()) {
                this.getRootToUpdate().addModifiableDescendant(miVar.getVarName(), this);
            }
        }
    }

    public class VariableObjectId {
        String fExpression = null;
        IRunControl.IExecutionDMContext fExecContext = null;
        Integer fFrameId = null;

        public boolean equals(Object other) {
            if (other instanceof VariableObjectId) {
                VariableObjectId otherId = (VariableObjectId)other;
                return (this.fExpression == null ? otherId.fExpression == null : this.fExpression.equals(otherId.fExpression)) && (this.fExecContext == null ? otherId.fExecContext == null : this.fExecContext.equals(otherId.fExecContext)) && (this.fFrameId == null ? otherId.fFrameId == null : this.fFrameId.equals(otherId.fFrameId));
            }
            return false;
        }

        public int hashCode() {
            return (this.fExpression == null ? 0 : this.fExpression.hashCode()) + (this.fExecContext == null ? 0 : this.fExecContext.hashCode()) + (this.fFrameId == null ? 0 : this.fFrameId.hashCode());
        }

        public void generateId(IExpressions.IExpressionDMContext exprCtx, final RequestMonitor rm) {
            this.fExpression = exprCtx.getExpression();
            this.fExecContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)exprCtx, IRunControl.IExecutionDMContext.class);
            if (this.fExecContext == null) {
                rm.done();
                return;
            }
            final IStack.IFrameDMContext frameCtx = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)exprCtx, IStack.IFrameDMContext.class);
            if (frameCtx == null) {
                rm.done();
                return;
            }
            MIVariableManager.this.fStackService.getStackDepth((IDMContext)this.fExecContext, 0, (DataRequestMonitor)new DataRequestMonitor<Integer>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleSuccess() {
                    VariableObjectId.this.fFrameId = new Integer((Integer)this.getData() - frameCtx.getLevel());
                    rm.done();
                }
            });
        }

        public void generateId(String childFullExp, VariableObjectId parentId) {
            this.fExecContext = parentId.fExecContext;
            this.fFrameId = parentId.fFrameId;
            this.fExpression = childFullExp;
        }
    }
}

