/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.DisconnectOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ReconcileProjectOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ShareProjectOperation;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionWizardPage;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.ccvs.ui.wizards.ConfigurationWizardAutoconnectPage;
import org.eclipse.team.internal.ccvs.ui.wizards.ConfigurationWizardMainPage;
import org.eclipse.team.internal.ccvs.ui.wizards.ICVSWizard;
import org.eclipse.team.internal.ccvs.ui.wizards.ModuleSelectionPage;
import org.eclipse.team.internal.ccvs.ui.wizards.NewLocationWizard;
import org.eclipse.team.internal.ccvs.ui.wizards.RepositorySelectionPage;
import org.eclipse.team.internal.ccvs.ui.wizards.SharingWizardSyncPage;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IWorkbench;

public class SharingWizard
extends Wizard
implements IConfigurationWizard,
ICVSWizard {
    private IProject project;
    private ConfigurationWizardAutoconnectPage autoconnectPage;
    private RepositorySelectionPage locationPage;
    private ConfigurationWizardMainPage createLocationPage;
    private ModuleSelectionPage modulePage;
    private TagSelectionWizardPage tagPage;
    private SharingWizardSyncPage syncPage;
    private ICVSRepositoryLocation location;
    private boolean isNewLocation;
    private ICVSRemoteFolder existingRemote;
    private ICVSRemoteFolder remoteFolder;

    public SharingWizard() {
        IDialogSettings cvsSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = cvsSettings.getSection("SharingWizard");
        if (section == null) {
            section = cvsSettings.addNewSection("SharingWizard");
        }
        this.setDialogSettings(section);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(CVSUIMessages.SharingWizard_title);
    }

    public void addPages() {
        ImageDescriptor sharingImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.png");
        boolean autoconnect = false;
        if (this.doesCVSDirectoryExist()) {
            this.autoconnectPage = new ConfigurationWizardAutoconnectPage("autoconnectPage", CVSUIMessages.SharingWizard_autoConnectTitle, sharingImage);
            if (this.autoconnectPage.setProject(this.project)) {
                this.autoconnectPage.setDescription(CVSUIMessages.SharingWizard_autoConnectTitleDescription);
                this.addPage((IWizardPage)this.autoconnectPage);
                autoconnect = true;
            }
        }
        if (!autoconnect) {
            ICVSRepositoryLocation[] locations = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations();
            if (locations.length > 0) {
                this.locationPage = new RepositorySelectionPage("importPage", CVSUIMessages.SharingWizard_importTitle, sharingImage);
                this.locationPage.setDescription(CVSUIMessages.SharingWizard_importTitleDescription);
                this.addPage((IWizardPage)this.locationPage);
            }
            this.createLocationPage = new ConfigurationWizardMainPage("createLocationPage", CVSUIMessages.SharingWizard_enterInformation, sharingImage);
            this.createLocationPage.setDescription(CVSUIMessages.SharingWizard_enterInformationDescription);
            this.createLocationPage.setCVSWizard(this);
            this.createLocationPage.setDialogSettings(NewLocationWizard.getLocationDialogSettings());
            this.addPage((IWizardPage)this.createLocationPage);
            this.modulePage = new ModuleSelectionPage("modulePage", CVSUIMessages.SharingWizard_enterModuleName, sharingImage);
            this.modulePage.setDescription(CVSUIMessages.SharingWizard_enterModuleNameDescription);
            this.modulePage.setCVSWizard(this);
            this.modulePage.setProject(this.project);
            this.modulePage.setHelpContxtId("org.eclipse.team.cvs.ui.sharing_module_page_context");
            this.addPage((IWizardPage)this.modulePage);
            this.addTagPage(sharingImage);
            this.addSyncPage(sharingImage);
        }
    }

    private void addTagPage(ImageDescriptor sharingImage) {
        this.tagPage = new TagSelectionWizardPage("tagPage", CVSUIMessages.SharingWizard_selectTagTitle, sharingImage, CVSUIMessages.SharingWizard_selectTag, TagSource.EMPTY, 5);
        this.tagPage.setCVSWizard(this);
        this.tagPage.setHelpContxtId("org.eclipse.team.cvs.ui.sharing_tag_selection_page_context");
        this.addPage((IWizardPage)this.tagPage);
    }

    private void addSyncPage(ImageDescriptor sharingImage) {
        this.syncPage = new SharingWizardSyncPage("syncPagePage", CVSUIMessages.SharingWizard_23, sharingImage, CVSUIMessages.SharingWizard_24);
        this.syncPage.setProject(this.project);
        this.syncPage.setCVSWizard(this);
        this.addPage((IWizardPage)this.syncPage);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page == this.autoconnectPage || page == this.syncPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return this.getNextPage(page, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IWizardPage getNextPage(IWizardPage page, boolean aboutToShow) {
        if (page == this.autoconnectPage) {
            return null;
        }
        if (page == this.locationPage) {
            if (this.locationPage.getLocation() == null) {
                return this.createLocationPage;
            }
            if (!aboutToShow) return this.modulePage;
            try {
                this.modulePage.setLocation(this.getLocation());
                return this.modulePage;
            }
            catch (TeamException e1) {
                CVSUIPlugin.log((CoreException)((Object)e1));
            }
            return this.modulePage;
        }
        if (page == this.createLocationPage) {
            if (!aboutToShow) return this.modulePage;
            try {
                this.modulePage.setLocation(this.getLocation());
                return this.modulePage;
            }
            catch (TeamException e1) {
                CVSUIPlugin.log((CoreException)((Object)e1));
            }
            return this.modulePage;
        }
        try {
            if (page != this.modulePage) {
                if (page != this.tagPage) return null;
                if (!aboutToShow) return this.syncPage;
                this.remoteFolder = null;
                this.getRemoteFolder();
                this.populateSyncPage(true);
                return this.syncPage;
            }
            if (!aboutToShow) return this.syncPage;
            this.remoteFolder = null;
            this.getRemoteFolder();
            if (this.exists(this.remoteFolder)) {
                this.prepareTagPage(this.remoteFolder);
                return this.tagPage;
            }
            try {
                this.populateSyncPage(false);
                return this.syncPage;
            }
            catch (InvocationTargetException e) {
                CVSUIPlugin.openError(this.getShell(), null, null, e);
                if (RepositoryProvider.isShared((IProject)this.project)) return this.syncPage;
                return null;
            }
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e);
            return null;
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    public boolean performFinish() {
        final boolean[] result = new boolean[]{true};
        if (this.isAutoconnect()) {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            try {
                                result[0] = SharingWizard.this.autoconnectCVSProject(monitor);
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
            catch (InvocationTargetException e) {
                CVSUIPlugin.openError(this.getContainer().getShell(), null, null, e);
                result[0] = false;
            }
        }
        if (result[0] && this.isNewLocation) {
            KnownRepositories.getInstance().addRepository(this.location, true);
        }
        final Shell parentShell = this.getShell().getParent().getShell();
        if (this.getContainer().getCurrentPage() == this.syncPage) {
            this.syncPage.saveSettings();
            if (this.syncPage.commitChanges()) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            CommitWizard.run(null, parentShell, new IResource[]{SharingWizard.this.syncPage.getProject()});
                        }
                        catch (CVSException e) {
                            CVSUIPlugin.log((CoreException)((Object)e));
                        }
                    }
                });
            }
        }
        return result[0];
    }

    public boolean performCancel() {
        ICVSRepositoryLocation location;
        boolean disposeLocation = this.isNewLocation;
        try {
            location = this.getLocation();
        }
        catch (TeamException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return true;
        }
        if (location == null) {
            return true;
        }
        if (this.getContainer().getCurrentPage() == this.syncPage && RepositoryProvider.getProvider((IProject)this.project) != null) {
            if (this.promptToKeepMapping()) {
                disposeLocation = false;
                if (this.isNewLocation) {
                    KnownRepositories.getInstance().addRepository(location, true);
                }
            } else {
                try {
                    this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            new DisconnectOperation(null, new IProject[]{SharingWizard.this.project}, true).run(monitor);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.log(4, e.getMessage(), e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (disposeLocation) {
            KnownRepositories.getInstance().disposeRepository(location);
        }
        return super.performCancel();
    }

    private boolean promptToKeepMapping() {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)CVSUIMessages.SharingWizard_26, (String)NLS.bind((String)CVSUIMessages.SharingWizard_27, (Object[])new String[]{this.project.getName()}));
    }

    private void reconcileProject(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        new ReconcileProjectOperation(this.getShell(), this.project, this.getRemoteFolder()).run(monitor);
    }

    private ICVSRepositoryLocation getLocation() throws TeamException {
        ICVSRepositoryLocation newLocation;
        if (this.autoconnectPage != null) {
            return this.recordLocation(this.autoconnectPage.getLocation());
        }
        if (this.locationPage != null && (newLocation = this.locationPage.getLocation()) != null) {
            return this.recordLocation(newLocation);
        }
        final ICVSRepositoryLocation[] locations = new ICVSRepositoryLocation[1];
        final CVSException[] exception = new CVSException[1];
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    locations[0] = SharingWizard.this.createLocationPage.getLocation();
                }
                catch (CVSException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        return this.recordLocation(locations[0]);
    }

    private ICVSRepositoryLocation recordLocation(ICVSRepositoryLocation newLocation) {
        if (newLocation == null) {
            return this.location;
        }
        if (this.location == null || !newLocation.equals(this.location)) {
            if (this.location != null && this.isNewLocation) {
                KnownRepositories.getInstance().disposeRepository(this.location);
            }
            this.location = newLocation;
            boolean bl = this.isNewLocation = !KnownRepositories.getInstance().isKnownRepository(newLocation.getLocation(false));
            if (this.isNewLocation) {
                this.location = KnownRepositories.getInstance().addRepository(this.location, false);
            }
        }
        return this.location;
    }

    public void init(IWorkbench workbench, IProject project) {
        this.project = project;
    }

    private boolean doesCVSDirectoryExist() {
        Shell shell = null;
        if (this.getContainer() != null) {
            shell = this.getContainer().getShell();
        }
        final boolean[] isCVSFolder = new boolean[1];
        try {
            CVSUIPlugin.runWithRefresh(shell, new IResource[]{this.project}, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)SharingWizard.this.project);
                        FolderSyncInfo info = folder.getFolderSyncInfo();
                        isCVSFolder[0] = info != null;
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, null);
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(shell, null, null, e);
        }
        catch (InterruptedException interruptedException) {}
        return isCVSFolder[0];
    }

    boolean isAutoconnect() {
        return this.autoconnectPage != null && this.doesCVSDirectoryExist();
    }

    boolean autoconnectCVSProject(IProgressMonitor monitor) throws TeamException {
        try {
            FolderSyncInfo info;
            block9: {
                monitor.beginTask(null, 100);
                info = this.autoconnectPage.getFolderSyncInfo();
                if (info == null) {
                    return false;
                }
                ICVSRepositoryLocation location = this.getLocation();
                boolean validate = this.autoconnectPage.getValidate();
                if (validate) {
                    try {
                        location.validateConnection(Policy.subMonitorFor(monitor, 50));
                    }
                    catch (TeamException e) {
                        final boolean[] keep = new boolean[1];
                        this.getShell().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                keep[0] = MessageDialog.openQuestion((Shell)SharingWizard.this.getContainer().getShell(), (String)CVSUIMessages.SharingWizard_validationFailedTitle, (String)NLS.bind((String)CVSUIMessages.SharingWizard_validationFailedText, (Object[])new Object[]{e.getStatus().getMessage()}));
                            }
                        });
                        if (keep[0]) break block9;
                        monitor.done();
                        return false;
                    }
                }
            }
            CVSWorkspaceRoot.setSharing((IProject)this.project, (FolderSyncInfo)info, (IProgressMonitor)Policy.subMonitorFor(monitor, 50));
            return true;
        }
        finally {
            monitor.done();
        }
    }

    private boolean shareProject(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(null, 100);
        ICVSRepositoryLocation location = null;
        try {
            location = this.getLocation();
            location.validateConnection(Policy.subMonitorFor(monitor, 50));
        }
        catch (TeamException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e, 1);
            if (this.isNewLocation && location != null) {
                location.flushUserInfo();
            }
            return false;
        }
        ShareProjectOperation op = new ShareProjectOperation(null, location, this.project, this.getRemoteFolder().getRepositoryRelativePath());
        op.setShell(this.getShell());
        op.run(Policy.subMonitorFor(monitor, 50));
        return true;
    }

    private CVSTag getTag() {
        if (this.tagPage == null || this.tagPage.getSelectedTag() == null) {
            return CVSTag.DEFAULT;
        }
        return this.tagPage.getSelectedTag();
    }

    private ICVSRemoteFolder getRemoteFolder() {
        if (this.remoteFolder == null) {
            ICVSRemoteFolder folder = this.modulePage.getSelectedModule();
            this.remoteFolder = (ICVSRemoteFolder)folder.forTag(this.getTag());
        }
        return this.remoteFolder;
    }

    private boolean exists(ICVSRemoteFolder folder, IProgressMonitor monitor) throws TeamException {
        if (this.existingRemote != null && this.existingRemote.equals((Object)folder)) {
            return true;
        }
        if (folder.exists(monitor)) {
            this.existingRemote = folder;
            return true;
        }
        this.existingRemote = null;
        return false;
    }

    private boolean exists(final ICVSRemoteFolder folder) throws InvocationTargetException, InterruptedException {
        final boolean[] result = new boolean[1];
        this.getContainer().run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    result[0] = SharingWizard.this.exists(folder, monitor);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        return result[0];
    }

    private void populateSyncPage(final boolean exists) throws InvocationTargetException, InterruptedException {
        this.getContainer().run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(null, -1);
                if (exists) {
                    SharingWizard.this.reconcileProject(Policy.subMonitorFor(monitor, 50));
                } else {
                    SharingWizard.this.shareProject(Policy.subMonitorFor(monitor, 50));
                }
                try {
                    SharingWizard.this.getParticipant().getContext().refresh(Utils.getResourceMappings((Object[])new IProject[]{SharingWizard.this.project}), Policy.subMonitorFor(monitor, 50));
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                monitor.done();
            }
        });
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.syncPage) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    private void prepareTagPage(ICVSRemoteFolder remote) {
        this.tagPage.setTagSource(TagSource.create(remote));
        this.tagPage.setDescription(NLS.bind((String)CVSUIMessages.SharingWizard_25, (Object[])new String[]{remote.getRepositoryRelativePath()}));
    }

    private ModelSynchronizeParticipant getParticipant() {
        return this.syncPage.getParticipant();
    }
}

