/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.samples;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.project.DeclareCudaModulesProcess;
import com.nvidia.cuda.ide.samples.InstantiateCudaSampleRunnable;
import com.nvidia.cuda.ide.samples.SampleImportPage;
import com.nvidia.cuda.ide.wizard.samples.ProjectSample;
import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public final class SamplesImportWizard
extends BasicNewResourceWizard {
    private final ProjectSample sample;
    private final SampleImportPage page;
    private final int defaultPhysical;
    private final int defaultVirtual;

    public SamplesImportWizard(String projectName, ProjectSample sample, int defaultVirtual, int defaultPhysical) {
        this.sample = sample;
        this.defaultPhysical = defaultPhysical;
        this.defaultVirtual = defaultVirtual;
        this.page = new SampleImportPage(projectName, sample, defaultVirtual, defaultPhysical);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Import CUDA SDK Sample");
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            URI uri = this.page.useDefaults() ? null : this.page.getLocationURI();
            String name = this.page.getProjectName();
            String sourceFolder = this.page.getSourceFolder();
            int ptxArch = this.page.getVirtualArchitecturesForAllConfigurations();
            int sassArch = this.page.getPhysicalArchitecturesForAllConfigurations();
            boolean useDeviceLinking = Boolean.TRUE.equals(this.page.isDeviceLinking());
            boolean buildProject = this.page.shouldBuild();
            InstantiateCudaSampleRunnable process = new InstantiateCudaSampleRunnable(this.sample, name, uri, sourceFolder, ptxArch, sassArch, useDeviceLinking, buildProject, false);
            this.getContainer().run(true, true, (IRunnableWithProgress)process);
            DeclareCudaModulesProcess.savePreferences(SamplesImportWizard.nullIfSame(ptxArch, this.defaultVirtual), SamplesImportWizard.nullIfSame(sassArch, this.defaultPhysical), this.sample.supportedLinkMode() == null ? Boolean.valueOf(useDeviceLinking) : null);
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            preferenceStore.setValue("newproject.source.location", sourceFolder);
            preferenceStore.setValue("newproject.build", buildProject);
            return true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.cuda.ide.build", String.format("Importing CUDA sample %s failed", this.sample.getName()), (Throwable)e), 3);
            return false;
        }
    }

    private static Integer nullIfSame(int actual, int def) {
        if (def == actual) {
            return null;
        }
        return actual;
    }
}

