/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.AbstractMultiModule;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.MultiCubin;
import com.nvidia.cuda.ide.build.ui.ArchitecturesSelector;
import com.nvidia.cuda.ide.build.ui.ModuleFiles;
import com.nvidia.cuda.ide.build.ui.MultiModuleView;
import com.nvidia.cuda.ide.build.util.SwtUtil;
import com.nvidia.cuda.ide.wizard.LinkerToggle;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public final class ModuleEditorPane
extends Composite {
    private static final String PHYSICAL_ARCHITECTURE = "Device code:";
    private final ComboViewer architectures;
    private final Label archLabel;
    private final CLabel compatabilityLabel;
    private final Button cubin;
    private final Button fatbin;
    private final Composite fatbinArch;
    private final ArchitecturesSelector fatbinSelector = new ArchitecturesSelector();
    private final Text fileName;
    private boolean ignoreSelectionEvent = false;
    private MultiCubin module;
    private final Button ptx;
    private ModuleFiles files;
    private Label sourceFileLabel;
    private Text sourceFileName;
    private Button browseForSource;
    private Composite filesPane;
    private ControlDecoration sourceFileMarker;
    private LinkerToggle linker;

    public ModuleEditorPane(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblFileName = new Label((Composite)this, 0);
        lblFileName.setText("File name:");
        this.fileName = new Text((Composite)this, 2048);
        this.fileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModuleEditorPane.this.updateName();
            }
        });
        this.fileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblModuleType = new Label((Composite)this, 0);
        lblModuleType.setText("Module type:");
        GC gc = new GC((Drawable)lblModuleType);
        FontMetrics fontMetrics = gc.getFontMetrics();
        GridData gd_lblModuleType = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblModuleType.widthHint = lblModuleType.computeSize((int)(fontMetrics.getAverageCharWidth() * 15), (int)-1).x;
        lblModuleType.setLayoutData((Object)gd_lblModuleType);
        gc.dispose();
        Composite composite_1 = new Composite((Composite)this, 0);
        composite_1.setLayout((Layout)new RowLayout(256));
        composite_1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.ptx = new Button(composite_1, 16);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModuleEditorPane.this.toggleType();
            }
        };
        this.ptx.setData((Object)ICudaModule.Type.ptx);
        this.ptx.addSelectionListener((SelectionListener)listener);
        this.ptx.setText("PTX");
        this.cubin = new Button(composite_1, 16);
        this.cubin.setData((Object)ICudaModule.Type.cubin);
        this.cubin.addSelectionListener((SelectionListener)listener);
        this.cubin.setText("CUBIN");
        this.fatbin = new Button(composite_1, 16);
        this.fatbin.setData((Object)ICudaModule.Type.fatbin);
        this.fatbin.addSelectionListener((SelectionListener)listener);
        this.fatbin.setText("Fatbin");
        this.filesPane = new Composite((Composite)this, 0);
        this.filesPane.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).grab(true, true).create());
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.filesPane.setLayout((Layout)layout);
        this.files = new ModuleFiles(this.filesPane);
        this.sourceFileLabel = new Label((Composite)this, 0);
        this.sourceFileLabel.setText("Source file:");
        this.sourceFileName = new Text((Composite)this, 2048);
        this.sourceFileName.setLayoutData((Object)new GridData(768));
        this.sourceFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ModuleEditorPane.this.module != null) {
                    ModuleEditorPane.this.setSourceFile(ModuleEditorPane.this.sourceFileName.getText());
                }
            }
        });
        this.browseForSource = new Button((Composite)this, 0);
        this.browseForSource.setText("Browse...");
        this.browseForSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ModuleEditorPane.this.module != null) {
                    ModuleEditorPane.this.browse();
                }
            }
        });
        this.linker = new LinkerToggle(this, 3, true);
        this.archLabel = new Label((Composite)this, 0);
        this.archLabel.setText(PHYSICAL_ARCHITECTURE);
        this.archLabel.setLayoutData((Object)new GridData());
        this.architectures = new ComboViewer((Composite)this, 8);
        this.architectures.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!ModuleEditorPane.this.ignoreSelectionEvent && !event.getSelection().isEmpty()) {
                    ModuleEditorPane.this.selectArch((IStructuredSelection)event.getSelection());
                }
            }
        });
        Combo combo = this.architectures.getCombo();
        GridData gd_combo = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_combo.widthHint = 75;
        combo.setLayoutData((Object)gd_combo);
        this.fatbinArch = new Composite((Composite)this, 0);
        GridData gd_fatbinArch = new GridData(4, 0x1000000, true, false, 3, 1);
        this.fatbinArch.setLayoutData((Object)gd_fatbinArch);
        GridLayout gl_fatbinArch = new GridLayout(Architecture.count(), true);
        gl_fatbinArch.marginWidth = 0;
        gl_fatbinArch.marginHeight = 0;
        this.fatbinArch.setLayout((Layout)gl_fatbinArch);
        this.fatbinSelector.createControls(this.fatbinArch, Architecture.count(), false);
        this.compatabilityLabel = new CLabel((Composite)this, 0);
        this.compatabilityLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.compatabilityLabel.setText("");
        this.architectures.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.architectures.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Architecture)element).getLabel();
            }
        });
        this.architectures.setInput((Object)Architecture.all());
    }

    protected void browse() {
        IFile file = MultiModuleView.getNewModuleSourceFile(this.module.getParentConfiguration(), this.module.getSingleSourceFile());
        if (file != null) {
            String path = file.getProjectRelativePath().toOSString();
            this.sourceFileName.setText(path);
            this.setSourceFile(path);
        }
    }

    private void checkAndGray(Button button, boolean isSingleType, ICudaModule.Type type) {
        Object buttonType = button.getData();
        button.setSelection(isSingleType && buttonType == type);
    }

    public void refreshArchitectureCompatibilityLabel(AbstractMultiModule module) {
        Collection<ICudaModule.Type> types = module.getTypesFromConfigurations();
        if (types.size() == 1) {
            MultiModuleView.findCompatibleDevices(this.compatabilityLabel, module, types.iterator().next());
        }
    }

    protected void selectArch(IStructuredSelection selection) {
        boolean isPtx;
        Architecture arch = (Architecture)selection.getFirstElement();
        boolean bl = isPtx = this.module.getTypesFromConfigurations().iterator().next() == ICudaModule.Type.ptx;
        if (isPtx) {
            this.module.setVirtualArchitectures(arch.getBit());
            this.module.setPhysicalArchitectures(0);
        } else {
            this.module.setPhysicalArchitectures(arch.getBit());
            this.module.setVirtualArchitectures(0);
        }
        this.refreshArchitectureCompatibilityLabel(this.module);
    }

    private void selectModule() {
        this.setModule(this.module);
    }

    private void setEnabledDetails(boolean enabled) {
        this.fileName.setEnabled(enabled);
        this.ptx.setEnabled(enabled);
        this.cubin.setEnabled(enabled);
        this.architectures.getControl().setEnabled(enabled);
        this.linker.setEnabled(enabled);
        this.files.setEnabled(enabled);
        this.sourceFileName.setEnabled(enabled);
        this.browseForSource.setEnabled(enabled);
    }

    protected void setModule(MultiCubin module) {
        this.module = module;
        this.setEnabledDetails(module != null);
        this.linker.setModule(module);
        if (module == null) {
            this.fileName.setText("");
            this.ptx.setSelection(false);
            this.cubin.setSelection(false);
            this.fatbin.setSelection(false);
            this.architectures.setSelection((ISelection)StructuredSelection.EMPTY);
            this.showCubinArchitectures(true, false);
            this.showSourceControls(false);
            this.sourceFileName.setText("");
        } else {
            this.fileName.setText(module.getPath().toOSString());
            Collection<ICudaModule.Type> types = module.getTypesFromConfigurations();
            boolean isSingleType = types.size() == 1;
            ICudaModule.Type type = isSingleType ? types.iterator().next() : null;
            this.checkAndGray(this.ptx, isSingleType, type);
            this.checkAndGray(this.cubin, isSingleType, type);
            this.checkAndGray(this.fatbin, isSingleType, type);
            if (isSingleType && type == ICudaModule.Type.fatbin) {
                this.showCubinArchitectures(true, false);
                this.fatbinSelector.setModule(module);
            } else {
                this.showCubinArchitectures(false, !isSingleType);
                this.showPtxCubinInfo(module, type);
            }
            Boolean separateCompile = module.isDeviceLinking();
            this.ptx.setEnabled(separateCompile != null && separateCompile == false);
            this.refreshArchitectureCompatibilityLabel(module);
            this.showSourceControls(separateCompile == null || separateCompile != false);
            if (separateCompile != null && !separateCompile.booleanValue()) {
                IFile file = module.getSingleSourceFile();
                if (file != null) {
                    this.sourceFileName.setText(file.getProjectRelativePath().toOSString());
                } else {
                    this.sourceFileName.setText("");
                }
            } else {
                this.files.setModule(module);
                this.files.refresh();
            }
        }
        this.layout();
    }

    protected void setSourceFile(String text) {
        IProject project = this.module.getParentConfiguration().getProject();
        IFile file = text == null || text.trim().length() == 0 ? null : project.getFile(text);
        if (this.sourceFileMarker != null) {
            this.sourceFileMarker.hide();
            this.sourceFileMarker.dispose();
            this.sourceFileMarker = null;
        }
        if (file != null && file.exists()) {
            try {
                this.module.include(file);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.cuda.ide.build", "Cannot set source file", (Throwable)e), 3);
            }
        } else {
            this.sourceFileMarker = new ControlDecoration((Control)this.sourceFileName, 16384);
            FieldDecoration decoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.sourceFileMarker.setImage(decoration.getImage());
            this.sourceFileMarker.setDescriptionText(String.format("File %s was not found in project %s", text, project.getName()));
        }
    }

    private void showCubinArchitectures(boolean fatbin, boolean hide) {
        SwtUtil.setHidden((Control)this.fatbinArch, !fatbin || hide);
        SwtUtil.setHidden((Control)this.archLabel, fatbin || hide);
        SwtUtil.setHidden(this.architectures.getControl(), fatbin || hide);
    }

    private void showPtxCubinInfo(AbstractMultiModule module, ICudaModule.Type type) {
        boolean isPtx;
        if (type == ICudaModule.Type.cubin) {
            this.archLabel.setText(PHYSICAL_ARCHITECTURE);
            this.archLabel.getParent().layout(true);
        } else {
            this.archLabel.setText("PTX code:");
        }
        boolean bl = isPtx = module.getTypesFromConfigurations().iterator().next() == ICudaModule.Type.ptx;
        int arch = isPtx ? (module.getVirtualArchitecturesForSomeConfigurations() == 0 ? CoreUtil.getLowestSetBit((int)module.getVirtualArchitecturesForAllConfigurations()) : 0) : (module.getPhysicalArchitecturesForSomeConfigurations() == 0 ? CoreUtil.getLowestSetBit((int)module.getPhysicalArchitecturesForAllConfigurations()) : 0);
        this.ignoreSelectionEvent = true;
        this.architectures.setSelection((ISelection)(arch == 0 ? StructuredSelection.EMPTY : new StructuredSelection((Object)Architecture.decode(arch)[0])));
        this.ignoreSelectionEvent = false;
    }

    private void showSourceControls(boolean separateCompilation) {
        SwtUtil.setHidden((Control)this.sourceFileLabel, separateCompilation);
        SwtUtil.setHidden((Control)this.sourceFileName, separateCompilation);
        SwtUtil.setHidden((Control)this.browseForSource, separateCompilation);
        SwtUtil.setHidden((Control)this.filesPane, !separateCompilation);
    }

    protected void toggleType() {
        ICudaModule.Type type = this.ptx.getSelection() ? ICudaModule.Type.ptx : (this.cubin.getSelection() ? ICudaModule.Type.cubin : ICudaModule.Type.fatbin);
        this.showCubinArchitectures(type == ICudaModule.Type.fatbin, false);
        this.module.setType(type);
        IPath name = this.module.getPath();
        String fileExtension = name.getFileExtension();
        ICudaModule.Type[] typeArray = ICudaModule.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICudaModule.Type t = typeArray[n2];
            if (t != type && t.name().equalsIgnoreCase(fileExtension)) {
                this.module.setPath(name.removeFileExtension().addFileExtension(type.name()));
                break;
            }
            ++n2;
        }
        this.selectModule();
    }

    protected void updateName() {
        String text = this.fileName.getText();
        if (this.module != null) {
            this.module.setPath((IPath)new Path(text));
        }
    }
}

