/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.mi;

import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIDataListRegisterValues;

public final class CudaMIDataListRegisterValues
extends MIDataListRegisterValues {
    int[] regnums;
    int fFmt;

    public CudaMIDataListRegisterValues(IMIExecutionDMContext ctx, int fmt) {
        this(ctx, fmt, null);
    }

    public CudaMIDataListRegisterValues(IMIExecutionDMContext ctx, int fmt, int[] regnos) {
        super(ctx, fmt, regnos);
        this.regnums = regnos;
        String format = "x";
        switch (fmt) {
            case 5: {
                format = "N";
                break;
            }
            case 4: {
                format = "r";
                break;
            }
            case 3: {
                format = "d";
                break;
            }
            case 2: {
                format = "t";
                break;
            }
            case 1: {
                format = "o";
                break;
            }
            case 0: {
                format = "x";
                break;
            }
            default: {
                format = "x";
            }
        }
        this.fFmt = fmt;
        this.setOptions(new String[]{format});
        if (regnos != null && regnos.length > 0) {
            String[] array = new String[regnos.length];
            int i = 0;
            while (i < regnos.length) {
                array[i] = Integer.toString(regnos[i]);
                ++i;
            }
            this.setParameters(array);
        }
    }

    public CudaMIDataListRegisterValues coalesceWith(ICommand<? extends ICommandResult> command) {
        CudaMIDataListRegisterValues cmd;
        block12: {
            block11: {
                block10: {
                    if (command instanceof CudaMIDataListRegisterValues) break block10;
                    return null;
                }
                cmd = (CudaMIDataListRegisterValues)command;
                if (this.getContext().equals(cmd.getContext())) break block11;
                return null;
            }
            if (this.fFmt == cmd.fFmt) break block12;
            return null;
        }
        try {
            int[] newregnos = new int[this.regnums.length + cmd.regnums.length];
            int idx = 0;
            while (idx < this.regnums.length) {
                newregnos[idx] = this.regnums[idx];
                ++idx;
            }
            int curloc = this.regnums.length;
            int ndx = 0;
            while (ndx < cmd.regnums.length) {
                int curnum = cmd.regnums[ndx];
                int ldx = 0;
                while (ldx < this.regnums.length) {
                    if (newregnos[ldx] == curnum) break;
                    ++ldx;
                }
                if (ldx == this.regnums.length) {
                    newregnos[curloc] = curnum;
                    ++curloc;
                }
                ++ndx;
            }
            int[] finalregnums = new int[curloc];
            int fdx = 0;
            while (fdx < curloc) {
                finalregnums[fdx] = newregnos[fdx];
                ++fdx;
            }
            return new CudaMIDataListRegisterValues((IMIExecutionDMContext)this.getContext(), this.fFmt, finalregnums);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

