/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions.breakpoints;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.ui.breakpoints.AbstractToggleBreakpointAdapter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleTracepointAdapter
extends AbstractToggleBreakpointAdapter {
    @Override
    protected ICLineBreakpoint findLineBreakpoint(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        return CDIDebugModel.lineBreakpointExists((String)sourceHandle, (IResource)resource, (int)lineNumber);
    }

    @Override
    protected void createLineBreakpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        if (interactive) {
            ICLineBreakpoint lineBp = CDIDebugModel.createBlankLineTracepoint();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            CDIDebugModel.setLineBreakpointAttributes(attributes, (String)sourceHandle, (Integer)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"");
            this.openBreakpointPropertiesDialog((ICBreakpoint)lineBp, part, resource, attributes);
        } else {
            CDIDebugModel.createLineTracepoint((String)sourceHandle, (IResource)resource, (int)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }

    @Override
    protected ICFunctionBreakpoint findFunctionBreakpoint(String sourceHandle, IResource resource, String functionName) throws CoreException {
        return CDIDebugModel.functionBreakpointExists((String)sourceHandle, (IResource)resource, (String)functionName);
    }

    @Override
    protected void createFunctionBreakpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, String functionName, int charStart, int charEnd, int lineNumber) throws CoreException {
        if (interactive) {
            ICFunctionBreakpoint bp = CDIDebugModel.createBlankFunctionTracepoint();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            CDIDebugModel.setFunctionBreakpointAttributes(attributes, (String)sourceHandle, (int)this.getBreakpointType(), (String)functionName, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)true, (int)0, (String)"");
            this.openBreakpointPropertiesDialog((ICBreakpoint)bp, part, resource, attributes);
        } else {
            CDIDebugModel.createFunctionTracepoint((String)sourceHandle, (IResource)resource, (int)this.getBreakpointType(), (String)functionName, (int)charStart, (int)charEnd, (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }

    @Override
    protected ICWatchpoint findWatchpoint(String sourceHandle, IResource resource, String expression) throws CoreException {
        return null;
    }

    @Override
    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    @Override
    protected void createWatchpoint(boolean interactive, IWorkbenchPart part, String sourceHandle, IResource resource, int charStart, int charEnd, int lineNumber, String expression, String memorySpace, String range) throws CoreException {
    }

    @Override
    public boolean canCreateEventBreakpointsInteractive(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    @Override
    protected void createEventBreakpoint(boolean interactive, IWorkbenchPart part, IResource resource, String type, String arg) throws CoreException {
    }

    protected int getBreakpointType() {
        return 0;
    }
}

