/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.internal.importexport.IRemoteImportExportConstants;

public class RemoteImportExportDescriptionFilesViewerFilter
extends ViewerFilter {
    public static final int IMPORT_EXPORT = 0;
    public static final int IMPORT_ONLY = 1;
    public static final int EXPORT_ONLY = 2;
    private int mode;

    public RemoteImportExportDescriptionFilesViewerFilter(int mode) {
        Assert.isLegal((mode == 0 || mode == 1 || mode == 2 ? 1 : 0) != 0);
        this.mode = mode;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            if (resource.getType() == 1) {
                String extension = resource.getFileExtension();
                if (extension == null || extension.equals("")) {
                    return false;
                }
                switch (this.mode) {
                    case 0: {
                        return this.contains(IRemoteImportExportConstants.REMOTE_IMPORT_DESCRIPTION_FILE_EXTENSIONS, extension) || this.contains(IRemoteImportExportConstants.REMOTE_EXPORT_DESCRIPTION_FILE_EXTENSIONS, extension);
                    }
                    case 1: {
                        return this.contains(IRemoteImportExportConstants.REMOTE_IMPORT_DESCRIPTION_FILE_EXTENSIONS, extension);
                    }
                    case 2: {
                        return this.contains(IRemoteImportExportConstants.REMOTE_EXPORT_DESCRIPTION_FILE_EXTENSIONS, extension);
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean contains(String[] extensions, String extension) {
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].equals(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

