########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Tuesday 07 February 2006 17:06:32 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/WebServices/Examples/msms_net.py,v 1.2 2006/02/08 17:36:26 sargis Exp $
#
# $Id: msms_net.py,v 1.2 2006/02/08 17:36:26 sargis Exp $
#

from traceback import print_exc

## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

from WebServices.VisionInterface.WSNodes import wslib
masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from MolKit.VisionInterface.MolKitNodes import molkitlib
masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:

    ## saving node Pmv Viewer ##
    from Pmv.VisionInterface.PmvNodes import PmvViewer
    Pmv_Viewer_0 = PmvViewer(viewer=masterNet.editor.vf.GUI.VIEWER, constrkw = {'viewer': 'masterNet.editor.vf.GUI.VIEWER'}, name='Pmv Viewer', library=pmvlib)
    masterNet.addNode(Pmv_Viewer_0,67,184)
except:
    print "WARNING: failed to restore PmvViewer named Pmv Viewer in network masterNet"
    print_exc()
    Pmv_Viewer_0=None
try:

    import WebServices
    path = WebServices.__path__[0]
    import os
    path = path + os.sep + 'Examples' + os.sep + 'HIS.pdb'
    mol = masterNet.editor.vf.loadMoleculeIfNeeded(path)
    from Pmv.VisionInterface.PmvNodes import PmvMolecule
    HIS_1 = PmvMolecule(molecule=masterNet.editor.vf.expandNodes("HIS")[0], constrkw = {'molecule': 'masterNet.editor.vf.expandNodes("HIS")[0]'}, name='HIS', library=pmvlib)
    masterNet.addNode(HIS_1,69,17)
except:
    print "WARNING: failed to restore PmvMolecule named HIS in network masterNet"
    print_exc()
    HIS_1=None
try:

    ## saving node MSMS@mgldev.scripps ##
    from WebServices.VisionInterface.msms_ws import msms_wsMacroNode
    MSMS_mgldev_scripps_10 = msms_wsMacroNode(host='http://mgldev.scripps.edu/services', constrkw = {'host': "'http://mgldev.scripps.edu/services'"}, name='MSMS@mgldev.scripps', library=wslib)
    masterNet.addNode(MSMS_mgldev_scripps_10,67,90)
    MSMS_WS_17 = MSMS_mgldev_scripps_10.macroNetwork.nodes[6]
    apply(MSMS_WS_17.inputPortByName['density'].createWidget, (), {'descr':{'initialValue': 1.0, 'min': 1.0, 'labelGridCfg': {'column': 0, 'row': 3}, 'master': 'ParamPanel', 'increment': 0.10000000000000001, 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 3}, 'labelCfg': {'text': 'density'}, 'class': 'NEDial', 'oneTurn': 10}})
    apply(MSMS_WS_17.inputPortByName['probe_radius'].createWidget, (), {'descr':{'initialValue': 1.5, 'min': 0.5, 'labelGridCfg': {'column': 0, 'row': 5}, 'master': 'ParamPanel', 'increment': 0.10000000000000001, 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'probe radius'}, 'class': 'NEDial', 'oneTurn': 10}})
    apply(MSMS_WS_17.inputPortByName['allComp'].createWidget, (), {'descr':{'initialValue': 0, 'labelGridCfg': {'column': 0, 'row': 7}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'all components'}, 'class': 'NECheckButton'}})

    ## saving connections for network MSMS@mgldev.scripps ##
    MSMS_mgldev_scripps_10.macroNetwork.freeze()
    MSMS_mgldev_scripps_10.macroNetwork.unfreeze()
    MSMS_mgldev_scripps_10.shrink()
except:
    print "WARNING: failed to restore msms_wsMacroNode named MSMS@mgldev.scripps in network masterNet"
    print_exc()
    MSMS_mgldev_scripps_10=None
masterNet.freeze()

## saving connections for network msms ##
if HIS_1 is not None and MSMS_mgldev_scripps_10 is not None:
    masterNet.connectNodes(
        HIS_1, MSMS_mgldev_scripps_10, "Molecule", "Assign Radii_molecules", blocking=True)
if MSMS_mgldev_scripps_10 is not None and Pmv_Viewer_0 is not None:
    masterNet.connectNodes(
        MSMS_mgldev_scripps_10, Pmv_Viewer_0, "IndexedPolygons_indexedPolygons", "geometries", blocking=True)
masterNet.unfreeze()
