struct X86_OPCODE {
	UINT8 opcode;
	UINT32 flags;
	void (*handler16)(i386_state *cpustate);
	void (*handler32)(i386_state *cpustate);
};

#define OP_I386         0x1
#define OP_FPU          0x2
#define OP_I486         0x4
#define OP_PENTIUM      0x8
#define OP_MMX          0x10
#define OP_PPRO         0x20
#define OP_SSE          0x40
#define OP_SSE2         0x80
#define OP_SSE3         0x100
#define OP_CYRIX        0x8000
#define OP_2BYTE        0x80000000
#define OP_3BYTE66      0x40000000
#define OP_3BYTEF2      0x20000000
#define OP_3BYTEF3      0x10000000

static const X86_OPCODE x86_opcode_table[] =
{
//  Opcode      Flags                       16-bit handler                  32-bit handler
	{ 0x00,     OP_I386,                    I386OP(add_rm8_r8),             I386OP(add_rm8_r8),         },
	{ 0x01,     OP_I386,                    I386OP(add_rm16_r16),           I386OP(add_rm32_r32),       },
	{ 0x02,     OP_I386,                    I386OP(add_r8_rm8),             I386OP(add_r8_rm8),         },
	{ 0x03,     OP_I386,                    I386OP(add_r16_rm16),           I386OP(add_r32_rm32),       },
	{ 0x04,     OP_I386,                    I386OP(add_al_i8),              I386OP(add_al_i8),          },
	{ 0x05,     OP_I386,                    I386OP(add_ax_i16),             I386OP(add_eax_i32),        },
	{ 0x06,     OP_I386,                    I386OP(push_es16),              I386OP(push_es32),          },
	{ 0x07,     OP_I386,                    I386OP(pop_es16),               I386OP(pop_es32),           },
	{ 0x08,     OP_I386,                    I386OP(or_rm8_r8),              I386OP(or_rm8_r8),          },
	{ 0x09,     OP_I386,                    I386OP(or_rm16_r16),            I386OP(or_rm32_r32),        },
	{ 0x0A,     OP_I386,                    I386OP(or_r8_rm8),              I386OP(or_r8_rm8),          },
	{ 0x0B,     OP_I386,                    I386OP(or_r16_rm16),            I386OP(or_r32_rm32),        },
	{ 0x0C,     OP_I386,                    I386OP(or_al_i8),               I386OP(or_al_i8),           },
	{ 0x0D,     OP_I386,                    I386OP(or_ax_i16),              I386OP(or_eax_i32),         },
	{ 0x0E,     OP_I386,                    I386OP(push_cs16),              I386OP(push_cs32),          },
	{ 0x0F,     OP_I386,                    I386OP(decode_two_byte),        I386OP(decode_two_byte),    },
	{ 0x10,     OP_I386,                    I386OP(adc_rm8_r8),             I386OP(adc_rm8_r8),         },
	{ 0x11,     OP_I386,                    I386OP(adc_rm16_r16),           I386OP(adc_rm32_r32),       },
	{ 0x12,     OP_I386,                    I386OP(adc_r8_rm8),             I386OP(adc_r8_rm8),         },
	{ 0x13,     OP_I386,                    I386OP(adc_r16_rm16),           I386OP(adc_r32_rm32),       },
	{ 0x14,     OP_I386,                    I386OP(adc_al_i8),              I386OP(adc_al_i8),          },
	{ 0x15,     OP_I386,                    I386OP(adc_ax_i16),             I386OP(adc_eax_i32),        },
	{ 0x16,     OP_I386,                    I386OP(push_ss16),              I386OP(push_ss32),          },
	{ 0x17,     OP_I386,                    I386OP(pop_ss16),               I386OP(pop_ss32),           },
	{ 0x18,     OP_I386,                    I386OP(sbb_rm8_r8),             I386OP(sbb_rm8_r8),         },
	{ 0x19,     OP_I386,                    I386OP(sbb_rm16_r16),           I386OP(sbb_rm32_r32),       },
	{ 0x1A,     OP_I386,                    I386OP(sbb_r8_rm8),             I386OP(sbb_r8_rm8),         },
	{ 0x1B,     OP_I386,                    I386OP(sbb_r16_rm16),           I386OP(sbb_r32_rm32),       },
	{ 0x1C,     OP_I386,                    I386OP(sbb_al_i8),              I386OP(sbb_al_i8),          },
	{ 0x1D,     OP_I386,                    I386OP(sbb_ax_i16),             I386OP(sbb_eax_i32),        },
	{ 0x1E,     OP_I386,                    I386OP(push_ds16),              I386OP(push_ds32),          },
	{ 0x1F,     OP_I386,                    I386OP(pop_ds16),               I386OP(pop_ds32),           },
	{ 0x20,     OP_I386,                    I386OP(and_rm8_r8),             I386OP(and_rm8_r8),         },
	{ 0x21,     OP_I386,                    I386OP(and_rm16_r16),           I386OP(and_rm32_r32),       },
	{ 0x22,     OP_I386,                    I386OP(and_r8_rm8),             I386OP(and_r8_rm8),         },
	{ 0x23,     OP_I386,                    I386OP(and_r16_rm16),           I386OP(and_r32_rm32),       },
	{ 0x24,     OP_I386,                    I386OP(and_al_i8),              I386OP(and_al_i8),          },
	{ 0x25,     OP_I386,                    I386OP(and_ax_i16),             I386OP(and_eax_i32),        },
	{ 0x26,     OP_I386,                    I386OP(segment_ES),             I386OP(segment_ES),         },
	{ 0x27,     OP_I386,                    I386OP(daa),                    I386OP(daa),                },
	{ 0x28,     OP_I386,                    I386OP(sub_rm8_r8),             I386OP(sub_rm8_r8),         },
	{ 0x29,     OP_I386,                    I386OP(sub_rm16_r16),           I386OP(sub_rm32_r32),       },
	{ 0x2A,     OP_I386,                    I386OP(sub_r8_rm8),             I386OP(sub_r8_rm8),         },
	{ 0x2B,     OP_I386,                    I386OP(sub_r16_rm16),           I386OP(sub_r32_rm32),       },
	{ 0x2C,     OP_I386,                    I386OP(sub_al_i8),              I386OP(sub_al_i8),          },
	{ 0x2D,     OP_I386,                    I386OP(sub_ax_i16),             I386OP(sub_eax_i32),        },
	{ 0x2E,     OP_I386,                    I386OP(segment_CS),             I386OP(segment_CS),         },
	{ 0x2F,     OP_I386,                    I386OP(das),                    I386OP(das),                },
	{ 0x30,     OP_I386,                    I386OP(xor_rm8_r8),             I386OP(xor_rm8_r8),         },
	{ 0x31,     OP_I386,                    I386OP(xor_rm16_r16),           I386OP(xor_rm32_r32),       },
	{ 0x32,     OP_I386,                    I386OP(xor_r8_rm8),             I386OP(xor_r8_rm8),         },
	{ 0x33,     OP_I386,                    I386OP(xor_r16_rm16),           I386OP(xor_r32_rm32),       },
	{ 0x34,     OP_I386,                    I386OP(xor_al_i8),              I386OP(xor_al_i8),          },
	{ 0x35,     OP_I386,                    I386OP(xor_ax_i16),             I386OP(xor_eax_i32),        },
	{ 0x36,     OP_I386,                    I386OP(segment_SS),             I386OP(segment_SS),         },
	{ 0x37,     OP_I386,                    I386OP(aaa),                    I386OP(aaa),                },
	{ 0x38,     OP_I386,                    I386OP(cmp_rm8_r8),             I386OP(cmp_rm8_r8),         },
	{ 0x39,     OP_I386,                    I386OP(cmp_rm16_r16),           I386OP(cmp_rm32_r32),       },
	{ 0x3A,     OP_I386,                    I386OP(cmp_r8_rm8),             I386OP(cmp_r8_rm8),         },
	{ 0x3B,     OP_I386,                    I386OP(cmp_r16_rm16),           I386OP(cmp_r32_rm32),       },
	{ 0x3C,     OP_I386,                    I386OP(cmp_al_i8),              I386OP(cmp_al_i8),          },
	{ 0x3D,     OP_I386,                    I386OP(cmp_ax_i16),             I386OP(cmp_eax_i32),        },
	{ 0x3E,     OP_I386,                    I386OP(segment_DS),             I386OP(segment_DS),         },
	{ 0x3F,     OP_I386,                    I386OP(aas),                    I386OP(aas),                },
	{ 0x40,     OP_I386,                    I386OP(inc_ax),                 I386OP(inc_eax),            },
	{ 0x41,     OP_I386,                    I386OP(inc_cx),                 I386OP(inc_ecx),            },
	{ 0x42,     OP_I386,                    I386OP(inc_dx),                 I386OP(inc_edx),            },
	{ 0x43,     OP_I386,                    I386OP(inc_bx),                 I386OP(inc_ebx),            },
	{ 0x44,     OP_I386,                    I386OP(inc_sp),                 I386OP(inc_esp),            },
	{ 0x45,     OP_I386,                    I386OP(inc_bp),                 I386OP(inc_ebp),            },
	{ 0x46,     OP_I386,                    I386OP(inc_si),                 I386OP(inc_esi),            },
	{ 0x47,     OP_I386,                    I386OP(inc_di),                 I386OP(inc_edi),            },
	{ 0x48,     OP_I386,                    I386OP(dec_ax),                 I386OP(dec_eax),            },
	{ 0x49,     OP_I386,                    I386OP(dec_cx),                 I386OP(dec_ecx),            },
	{ 0x4A,     OP_I386,                    I386OP(dec_dx),                 I386OP(dec_edx),            },
	{ 0x4B,     OP_I386,                    I386OP(dec_bx),                 I386OP(dec_ebx),            },
	{ 0x4C,     OP_I386,                    I386OP(dec_sp),                 I386OP(dec_esp),            },
	{ 0x4D,     OP_I386,                    I386OP(dec_bp),                 I386OP(dec_ebp),            },
	{ 0x4E,     OP_I386,                    I386OP(dec_si),                 I386OP(dec_esi),            },
	{ 0x4F,     OP_I386,                    I386OP(dec_di),                 I386OP(dec_edi),            },
	{ 0x50,     OP_I386,                    I386OP(push_ax),                I386OP(push_eax),           },
	{ 0x51,     OP_I386,                    I386OP(push_cx),                I386OP(push_ecx),           },
	{ 0x52,     OP_I386,                    I386OP(push_dx),                I386OP(push_edx),           },
	{ 0x53,     OP_I386,                    I386OP(push_bx),                I386OP(push_ebx),           },
	{ 0x54,     OP_I386,                    I386OP(push_sp),                I386OP(push_esp),           },
	{ 0x55,     OP_I386,                    I386OP(push_bp),                I386OP(push_ebp),           },
	{ 0x56,     OP_I386,                    I386OP(push_si),                I386OP(push_esi),           },
	{ 0x57,     OP_I386,                    I386OP(push_di),                I386OP(push_edi),           },
	{ 0x58,     OP_I386,                    I386OP(pop_ax),                 I386OP(pop_eax),            },
	{ 0x59,     OP_I386,                    I386OP(pop_cx),                 I386OP(pop_ecx),            },
	{ 0x5A,     OP_I386,                    I386OP(pop_dx),                 I386OP(pop_edx),            },
	{ 0x5B,     OP_I386,                    I386OP(pop_bx),                 I386OP(pop_ebx),            },
	{ 0x5C,     OP_I386,                    I386OP(pop_sp),                 I386OP(pop_esp),            },
	{ 0x5D,     OP_I386,                    I386OP(pop_bp),                 I386OP(pop_ebp),            },
	{ 0x5E,     OP_I386,                    I386OP(pop_si),                 I386OP(pop_esi),            },
	{ 0x5F,     OP_I386,                    I386OP(pop_di),                 I386OP(pop_edi),            },
	{ 0x60,     OP_I386,                    I386OP(pusha),                  I386OP(pushad),             },
	{ 0x61,     OP_I386,                    I386OP(popa),                   I386OP(popad),              },
	{ 0x62,     OP_I386,                    I386OP(bound_r16_m16_m16),      I386OP(bound_r32_m32_m32),  },
	{ 0x63,     OP_I386,                    I386OP(arpl),                   I386OP(arpl),               },
	{ 0x64,     OP_I386,                    I386OP(segment_FS),             I386OP(segment_FS),         },
	{ 0x65,     OP_I386,                    I386OP(segment_GS),             I386OP(segment_GS),         },
	{ 0x66,     OP_I386,                    I386OP(operand_size),           I386OP(operand_size),       },
	{ 0x67,     OP_I386,                    I386OP(address_size),           I386OP(address_size),       },
	{ 0x68,     OP_I386,                    I386OP(push_i16),               I386OP(push_i32),           },
	{ 0x69,     OP_I386,                    I386OP(imul_r16_rm16_i16),      I386OP(imul_r32_rm32_i32),  },
	{ 0x6A,     OP_I386,                    I386OP(push_i8),                I386OP(push_i8),            },
	{ 0x6B,     OP_I386,                    I386OP(imul_r16_rm16_i8),       I386OP(imul_r32_rm32_i8),   },
	{ 0x6C,     OP_I386,                    I386OP(insb),                   I386OP(insb),               },
	{ 0x6D,     OP_I386,                    I386OP(insw),                   I386OP(insd),               },
	{ 0x6E,     OP_I386,                    I386OP(outsb),                  I386OP(outsb),              },
	{ 0x6F,     OP_I386,                    I386OP(outsw),                  I386OP(outsd),              },
	{ 0x70,     OP_I386,                    I386OP(jo_rel8),                I386OP(jo_rel8),            },
	{ 0x71,     OP_I386,                    I386OP(jno_rel8),               I386OP(jno_rel8),           },
	{ 0x72,     OP_I386,                    I386OP(jc_rel8),                I386OP(jc_rel8),            },
	{ 0x73,     OP_I386,                    I386OP(jnc_rel8),               I386OP(jnc_rel8),           },
	{ 0x74,     OP_I386,                    I386OP(jz_rel8),                I386OP(jz_rel8),            },
	{ 0x75,     OP_I386,                    I386OP(jnz_rel8),               I386OP(jnz_rel8),           },
	{ 0x76,     OP_I386,                    I386OP(jbe_rel8),               I386OP(jbe_rel8),           },
	{ 0x77,     OP_I386,                    I386OP(ja_rel8),                I386OP(ja_rel8),            },
	{ 0x78,     OP_I386,                    I386OP(js_rel8),                I386OP(js_rel8),            },
	{ 0x79,     OP_I386,                    I386OP(jns_rel8),               I386OP(jns_rel8),           },
	{ 0x7A,     OP_I386,                    I386OP(jp_rel8),                I386OP(jp_rel8),            },
	{ 0x7B,     OP_I386,                    I386OP(jnp_rel8),               I386OP(jnp_rel8),           },
	{ 0x7C,     OP_I386,                    I386OP(jl_rel8),                I386OP(jl_rel8),            },
	{ 0x7D,     OP_I386,                    I386OP(jge_rel8),               I386OP(jge_rel8),           },
	{ 0x7E,     OP_I386,                    I386OP(jle_rel8),               I386OP(jle_rel8),           },
	{ 0x7F,     OP_I386,                    I386OP(jg_rel8),                I386OP(jg_rel8),            },
	{ 0x80,     OP_I386,                    I386OP(group80_8),              I386OP(group80_8),          },
	{ 0x81,     OP_I386,                    I386OP(group81_16),             I386OP(group81_32),         },
	{ 0x82,     OP_I386,                    I386OP(group80_8),              I386OP(group80_8),          },
	{ 0x83,     OP_I386,                    I386OP(group83_16),             I386OP(group83_32),         },
	{ 0x84,     OP_I386,                    I386OP(test_rm8_r8),            I386OP(test_rm8_r8),        },
	{ 0x85,     OP_I386,                    I386OP(test_rm16_r16),          I386OP(test_rm32_r32),      },
	{ 0x86,     OP_I386,                    I386OP(xchg_r8_rm8),            I386OP(xchg_r8_rm8),        },
	{ 0x87,     OP_I386,                    I386OP(xchg_r16_rm16),          I386OP(xchg_r32_rm32),      },
	{ 0x88,     OP_I386,                    I386OP(mov_rm8_r8),             I386OP(mov_rm8_r8),         },
	{ 0x89,     OP_I386,                    I386OP(mov_rm16_r16),           I386OP(mov_rm32_r32),       },
	{ 0x8A,     OP_I386,                    I386OP(mov_r8_rm8),             I386OP(mov_r8_rm8),         },
	{ 0x8B,     OP_I386,                    I386OP(mov_r16_rm16),           I386OP(mov_r32_rm32),       },
	{ 0x8C,     OP_I386,                    I386OP(mov_rm16_sreg),          I386OP(mov_rm16_sreg),      },
	{ 0x8D,     OP_I386,                    I386OP(lea16),                  I386OP(lea32),              },
	{ 0x8E,     OP_I386,                    I386OP(mov_sreg_rm16),          I386OP(mov_sreg_rm16),      },
	{ 0x8F,     OP_I386,                    I386OP(pop_rm16),               I386OP(pop_rm32),           },
	{ 0x90,     OP_I386,                    I386OP(nop),                    I386OP(nop),                },
	{ 0x91,     OP_I386,                    I386OP(xchg_ax_cx),             I386OP(xchg_eax_ecx),       },
	{ 0x92,     OP_I386,                    I386OP(xchg_ax_dx),             I386OP(xchg_eax_edx),       },
	{ 0x93,     OP_I386,                    I386OP(xchg_ax_bx),             I386OP(xchg_eax_ebx),       },
	{ 0x94,     OP_I386,                    I386OP(xchg_ax_sp),             I386OP(xchg_eax_esp),       },
	{ 0x95,     OP_I386,                    I386OP(xchg_ax_bp),             I386OP(xchg_eax_ebp),       },
	{ 0x96,     OP_I386,                    I386OP(xchg_ax_si),             I386OP(xchg_eax_esi),       },
	{ 0x97,     OP_I386,                    I386OP(xchg_ax_di),             I386OP(xchg_eax_edi),       },
	{ 0x98,     OP_I386,                    I386OP(cbw),                    I386OP(cwde),               },
	{ 0x99,     OP_I386,                    I386OP(cwd),                    I386OP(cdq),                },
	{ 0x9A,     OP_I386,                    I386OP(call_abs16),             I386OP(call_abs32),         },
	{ 0x9B,     OP_I386,                    I386OP(wait),                   I386OP(wait),               },
	{ 0x9C,     OP_I386,                    I386OP(pushf),                  I386OP(pushfd),             },
	{ 0x9D,     OP_I386,                    I386OP(popf),                   I386OP(popfd),              },
	{ 0x9E,     OP_I386,                    I386OP(sahf),                   I386OP(sahf),               },
	{ 0x9F,     OP_I386,                    I386OP(lahf),                   I386OP(lahf),               },
	{ 0xA0,     OP_I386,                    I386OP(mov_al_m8),              I386OP(mov_al_m8),          },
	{ 0xA1,     OP_I386,                    I386OP(mov_ax_m16),             I386OP(mov_eax_m32),        },
	{ 0xA2,     OP_I386,                    I386OP(mov_m8_al),              I386OP(mov_m8_al),          },
	{ 0xA3,     OP_I386,                    I386OP(mov_m16_ax),             I386OP(mov_m32_eax),        },
	{ 0xA4,     OP_I386,                    I386OP(movsb),                  I386OP(movsb),              },
	{ 0xA5,     OP_I386,                    I386OP(movsw),                  I386OP(movsd),              },
	{ 0xA6,     OP_I386,                    I386OP(cmpsb),                  I386OP(cmpsb),              },
	{ 0xA7,     OP_I386,                    I386OP(cmpsw),                  I386OP(cmpsd),              },
	{ 0xA8,     OP_I386,                    I386OP(test_al_i8),             I386OP(test_al_i8),         },
	{ 0xA9,     OP_I386,                    I386OP(test_ax_i16),            I386OP(test_eax_i32),       },
	{ 0xAA,     OP_I386,                    I386OP(stosb),                  I386OP(stosb),              },
	{ 0xAB,     OP_I386,                    I386OP(stosw),                  I386OP(stosd),              },
	{ 0xAC,     OP_I386,                    I386OP(lodsb),                  I386OP(lodsb),              },
	{ 0xAD,     OP_I386,                    I386OP(lodsw),                  I386OP(lodsd),              },
	{ 0xAE,     OP_I386,                    I386OP(scasb),                  I386OP(scasb),              },
	{ 0xAF,     OP_I386,                    I386OP(scasw),                  I386OP(scasd),              },
	{ 0xB0,     OP_I386,                    I386OP(mov_al_i8),              I386OP(mov_al_i8),          },
	{ 0xB1,     OP_I386,                    I386OP(mov_cl_i8),              I386OP(mov_cl_i8),          },
	{ 0xB2,     OP_I386,                    I386OP(mov_dl_i8),              I386OP(mov_dl_i8),          },
	{ 0xB3,     OP_I386,                    I386OP(mov_bl_i8),              I386OP(mov_bl_i8),          },
	{ 0xB4,     OP_I386,                    I386OP(mov_ah_i8),              I386OP(mov_ah_i8),          },
	{ 0xB5,     OP_I386,                    I386OP(mov_ch_i8),              I386OP(mov_ch_i8),          },
	{ 0xB6,     OP_I386,                    I386OP(mov_dh_i8),              I386OP(mov_dh_i8),          },
	{ 0xB7,     OP_I386,                    I386OP(mov_bh_i8),              I386OP(mov_bh_i8),          },
	{ 0xB8,     OP_I386,                    I386OP(mov_ax_i16),             I386OP(mov_eax_i32),        },
	{ 0xB9,     OP_I386,                    I386OP(mov_cx_i16),             I386OP(mov_ecx_i32),        },
	{ 0xBA,     OP_I386,                    I386OP(mov_dx_i16),             I386OP(mov_edx_i32),        },
	{ 0xBB,     OP_I386,                    I386OP(mov_bx_i16),             I386OP(mov_ebx_i32),        },
	{ 0xBC,     OP_I386,                    I386OP(mov_sp_i16),             I386OP(mov_esp_i32),        },
	{ 0xBD,     OP_I386,                    I386OP(mov_bp_i16),             I386OP(mov_ebp_i32),        },
	{ 0xBE,     OP_I386,                    I386OP(mov_si_i16),             I386OP(mov_esi_i32),        },
	{ 0xBF,     OP_I386,                    I386OP(mov_di_i16),             I386OP(mov_edi_i32),        },
	{ 0xC0,     OP_I386,                    I386OP(groupC0_8),              I386OP(groupC0_8),          },
	{ 0xC1,     OP_I386,                    I386OP(groupC1_16),             I386OP(groupC1_32),         },
	{ 0xC2,     OP_I386,                    I386OP(ret_near16_i16),         I386OP(ret_near32_i16),     },
	{ 0xC3,     OP_I386,                    I386OP(ret_near16),             I386OP(ret_near32),         },
	{ 0xC4,     OP_I386,                    I386OP(les16),                  I386OP(les32),              },
	{ 0xC5,     OP_I386,                    I386OP(lds16),                  I386OP(lds32),              },
	{ 0xC6,     OP_I386,                    I386OP(mov_rm8_i8),             I386OP(mov_rm8_i8),         },
	{ 0xC7,     OP_I386,                    I386OP(mov_rm16_i16),           I386OP(mov_rm32_i32),       },
	{ 0xC8,     OP_I386,                    I386OP(enter16),                I386OP(enter32),            },
	{ 0xC9,     OP_I386,                    I386OP(leave16),                I386OP(leave32),            },
	{ 0xCA,     OP_I386,                    I386OP(retf_i16),               I386OP(retf_i32),           },
	{ 0xCB,     OP_I386,                    I386OP(retf16),                 I386OP(retf32),             },
	{ 0xCC,     OP_I386,                    I386OP(int3),                   I386OP(int3),               },
	{ 0xCD,     OP_I386,                    I386OP(int),                    I386OP(int),                },
	{ 0xCE,     OP_I386,                    I386OP(into),                   I386OP(into),               },
	{ 0xCF,     OP_I386,                    I386OP(iret16),                 I386OP(iret32),             },
	{ 0xD0,     OP_I386,                    I386OP(groupD0_8),              I386OP(groupD0_8),          },
	{ 0xD1,     OP_I386,                    I386OP(groupD1_16),             I386OP(groupD1_32),         },
	{ 0xD2,     OP_I386,                    I386OP(groupD2_8),              I386OP(groupD2_8),          },
	{ 0xD3,     OP_I386,                    I386OP(groupD3_16),             I386OP(groupD3_32),         },
	{ 0xD4,     OP_I386,                    I386OP(aam),                    I386OP(aam),                },
	{ 0xD5,     OP_I386,                    I386OP(aad),                    I386OP(aad),                },
	{ 0xD6,     OP_I386,                    I386OP(setalc),                 I386OP(setalc),             },
	{ 0xD7,     OP_I386,                    I386OP(xlat),                   I386OP(xlat),               },
	{ 0xD8,     OP_I386,                    I386OP(escape),                 I386OP(escape),             },
	{ 0xD9,     OP_I386,                    I386OP(escape),                 I386OP(escape),             },
	{ 0xDA,     OP_I386,                    I386OP(escape),                 I386OP(escape),             },
	{ 0xDB,     OP_I386,                    I386OP(escape),                 I386OP(escape),             },
	{ 0xDC,     OP_I386,                    I386OP(escape),                 I386OP(escape),             },
	{ 0xDD,     OP_I386,                    I386OP(escape),                 I386OP(escape),             },
	{ 0xDE,     OP_I386,                    I386OP(escape),                 I386OP(escape),             },
	{ 0xDF,     OP_I386,                    I386OP(escape),                 I386OP(escape),             },
	{ 0xD8,     OP_FPU,                     I386OP(x87_group_d8),           I386OP(x87_group_d8),       },
	{ 0xD9,     OP_FPU,                     I386OP(x87_group_d9),           I386OP(x87_group_d9),       },
	{ 0xDA,     OP_FPU,                     I386OP(x87_group_da),           I386OP(x87_group_da),       },
	{ 0xDB,     OP_FPU,                     I386OP(x87_group_db),           I386OP(x87_group_db),       },
	{ 0xDC,     OP_FPU,                     I386OP(x87_group_dc),           I386OP(x87_group_dc),       },
	{ 0xDD,     OP_FPU,                     I386OP(x87_group_dd),           I386OP(x87_group_dd),       },
	{ 0xDE,     OP_FPU,                     I386OP(x87_group_de),           I386OP(x87_group_de),       },
	{ 0xDF,     OP_FPU,                     I386OP(x87_group_df),           I386OP(x87_group_df),       },
	{ 0xE0,     OP_I386,                    I386OP(loopne16),               I386OP(loopne32),           },
	{ 0xE1,     OP_I386,                    I386OP(loopz16),                I386OP(loopz32),            },
	{ 0xE2,     OP_I386,                    I386OP(loop16),                 I386OP(loop32),             },
	{ 0xE3,     OP_I386,                    I386OP(jcxz16),                 I386OP(jcxz32),             },
	{ 0xE4,     OP_I386,                    I386OP(in_al_i8),               I386OP(in_al_i8),           },
	{ 0xE5,     OP_I386,                    I386OP(in_ax_i8),               I386OP(in_eax_i8),          },
	{ 0xE6,     OP_I386,                    I386OP(out_al_i8),              I386OP(out_al_i8),          },
	{ 0xE7,     OP_I386,                    I386OP(out_ax_i8),              I386OP(out_eax_i8),         },
	{ 0xE8,     OP_I386,                    I386OP(call_rel16),             I386OP(call_rel32),         },
	{ 0xE9,     OP_I386,                    I386OP(jmp_rel16),              I386OP(jmp_rel32),          },
	{ 0xEA,     OP_I386,                    I386OP(jmp_abs16),              I386OP(jmp_abs32),          },
	{ 0xEB,     OP_I386,                    I386OP(jmp_rel8),               I386OP(jmp_rel8),           },
	{ 0xEC,     OP_I386,                    I386OP(in_al_dx),               I386OP(in_al_dx),           },
	{ 0xED,     OP_I386,                    I386OP(in_ax_dx),               I386OP(in_eax_dx),          },
	{ 0xEE,     OP_I386,                    I386OP(out_al_dx),              I386OP(out_al_dx),          },
	{ 0xEF,     OP_I386,                    I386OP(out_ax_dx),              I386OP(out_eax_dx),         },
	{ 0xF0,     OP_I386,                    I386OP(lock),                   I386OP(lock),               },
	{ 0xF1,     OP_I386,                    I386OP(invalid),                I386OP(invalid),            },
	{ 0xF2,     OP_I386,                    I386OP(repne),                  I386OP(repne),              },
	{ 0xF3,     OP_I386,                    I386OP(rep),                    I386OP(rep),                },
	{ 0xF4,     OP_I386,                    I386OP(hlt),                    I386OP(hlt),                },
	{ 0xF5,     OP_I386,                    I386OP(cmc),                    I386OP(cmc),                },
	{ 0xF6,     OP_I386,                    I386OP(groupF6_8),              I386OP(groupF6_8),          },
	{ 0xF7,     OP_I386,                    I386OP(groupF7_16),             I386OP(groupF7_32),         },
	{ 0xF8,     OP_I386,                    I386OP(clc),                    I386OP(clc),                },
	{ 0xF9,     OP_I386,                    I386OP(stc),                    I386OP(stc),                },
	{ 0xFA,     OP_I386,                    I386OP(cli),                    I386OP(cli),                },
	{ 0xFB,     OP_I386,                    I386OP(sti),                    I386OP(sti),                },
	{ 0xFC,     OP_I386,                    I386OP(cld),                    I386OP(cld),                },
	{ 0xFD,     OP_I386,                    I386OP(std),                    I386OP(std),                },
	{ 0xFE,     OP_I386,                    I386OP(groupFE_8),              I386OP(groupFE_8),          },
	{ 0xFF,     OP_I386,                    I386OP(groupFF_16),             I386OP(groupFF_32),         },
	/* 0F ?? */
	{ 0x00,     OP_2BYTE|OP_I386,           I386OP(group0F00_16),           I386OP(group0F00_32),       },
	{ 0x01,     OP_2BYTE|OP_I386,           I386OP(group0F01_16),           I386OP(group0F01_32),       },
	{ 0x01,     OP_2BYTE|OP_I486,           I486OP(group0F01_16),           I486OP(group0F01_32),       },
	{ 0x02,     OP_2BYTE|OP_I386,           I386OP(lar_r16_rm16),           I386OP(lar_r32_rm32),       },
	{ 0x03,     OP_2BYTE|OP_I386,           I386OP(lsl_r16_rm16),           I386OP(lsl_r32_rm32),       },
	{ 0x06,     OP_2BYTE|OP_I386,           I386OP(clts),                   I386OP(clts),               },
	{ 0x07,     OP_2BYTE|OP_I386,           I386OP(loadall),                I386OP(loadall),            },
	{ 0x08,     OP_2BYTE|OP_I486,           I486OP(invd),                   I486OP(invd),               },
	{ 0x09,     OP_2BYTE|OP_I486,           I486OP(wbinvd),                 I486OP(wbinvd),             },
	{ 0x0B,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(ud2),                 PENTIUMOP(ud2),             },
	{ 0x10,     OP_2BYTE|OP_SSE,            SSEOP(movups_r128_rm128),       SSEOP(movups_r128_rm128),   },
	{ 0x11,     OP_2BYTE|OP_SSE,            SSEOP(movups_rm128_r128),       SSEOP(movups_rm128_r128),   },
	{ 0x12,     OP_2BYTE|OP_SSE,            SSEOP(movlps_r128_m64),         SSEOP(movlps_r128_m64),     },
	{ 0x13,     OP_2BYTE|OP_SSE,            SSEOP(movlps_m64_r128),         SSEOP(movlps_m64_r128),     },
	{ 0x14,     OP_2BYTE|OP_SSE,            SSEOP(unpcklps_r128_rm128),     SSEOP(unpcklps_r128_rm128), },
	{ 0x15,     OP_2BYTE|OP_SSE,            SSEOP(unpckhps_r128_rm128),     SSEOP(unpckhps_r128_rm128), },
	{ 0x16,     OP_2BYTE|OP_SSE,            SSEOP(movhps_r128_m64),         SSEOP(movhps_r128_m64),     },
	{ 0x17,     OP_2BYTE|OP_SSE,            SSEOP(movhps_m64_r128),         SSEOP(movhps_m64_r128),     },
	{ 0x18,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(prefetch_m8),         PENTIUMOP(prefetch_m8),     },
	{ 0x20,     OP_2BYTE|OP_I386,           I386OP(mov_r32_cr),             I386OP(mov_r32_cr),         },
	{ 0x21,     OP_2BYTE|OP_I386,           I386OP(mov_r32_dr),             I386OP(mov_r32_dr),         },
	{ 0x22,     OP_2BYTE|OP_I386,           I386OP(mov_cr_r32),             I386OP(mov_cr_r32),         },
	{ 0x22,     OP_2BYTE|OP_I486,           I486OP(mov_cr_r32),             I486OP(mov_cr_r32),         },
	{ 0x23,     OP_2BYTE|OP_I386,           I386OP(mov_dr_r32),             I386OP(mov_dr_r32),         },
	{ 0x24,     OP_2BYTE|OP_I386,           I386OP(mov_r32_tr),             I386OP(mov_r32_tr),         },
	{ 0x26,     OP_2BYTE|OP_I386,           I386OP(mov_tr_r32),             I386OP(mov_tr_r32),         },
	{ 0x28,     OP_2BYTE|OP_SSE,            SSEOP(movaps_r128_rm128),       SSEOP(movaps_r128_rm128),   },
	{ 0x29,     OP_2BYTE|OP_SSE,            SSEOP(movaps_rm128_r128),       SSEOP(movaps_rm128_r128),   },
	{ 0x2a,     OP_2BYTE|OP_SSE,            SSEOP(cvtpi2ps_r128_rm64),      SSEOP(cvtpi2ps_r128_rm64),  },
	{ 0x2b,     OP_2BYTE|OP_SSE,            SSEOP(movntps_m128_r128),       SSEOP(movntps_m128_r128),   },
	{ 0x2c,     OP_2BYTE|OP_SSE,            SSEOP(cvttps2pi_r64_r128m64),   SSEOP(cvttps2pi_r64_r128m64),},
	{ 0x2d,     OP_2BYTE|OP_SSE,            SSEOP(cvtps2pi_r64_r128m64),    SSEOP(cvtps2pi_r64_r128m64),},
	{ 0x2e,     OP_2BYTE|OP_SSE,            SSEOP(ucomiss_r128_r128m32),    SSEOP(ucomiss_r128_r128m32),},
	{ 0x2f,     OP_2BYTE|OP_SSE,            SSEOP(comiss_r128_r128m32),     SSEOP(comiss_r128_r128m32), },
	{ 0x30,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(wrmsr),               PENTIUMOP(wrmsr),           },
	{ 0x31,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(rdtsc),               PENTIUMOP(rdtsc),           },
	{ 0x32,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(rdmsr),               PENTIUMOP(rdmsr),           },
	{ 0x40,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovo_r16_rm16),      PENTIUMOP(cmovo_r32_rm32),  },
	{ 0x41,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovno_r16_rm16),     PENTIUMOP(cmovno_r32_rm32), },
	{ 0x42,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovb_r16_rm16),      PENTIUMOP(cmovb_r32_rm32),  },
	{ 0x43,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovae_r16_rm16),     PENTIUMOP(cmovae_r32_rm32), },
	{ 0x44,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmove_r16_rm16),      PENTIUMOP(cmove_r32_rm32),  },
	{ 0x45,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovne_r16_rm16),     PENTIUMOP(cmovne_r32_rm32), },
	{ 0x46,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovbe_r16_rm16),     PENTIUMOP(cmovbe_r32_rm32), },
	{ 0x47,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmova_r16_rm16),      PENTIUMOP(cmova_r32_rm32),  },
	{ 0x48,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovs_r16_rm16),      PENTIUMOP(cmovs_r32_rm32),  },
	{ 0x49,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovns_r16_rm16),     PENTIUMOP(cmovns_r32_rm32), },
	{ 0x4a,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovp_r16_rm16),      PENTIUMOP(cmovp_r32_rm32),  },
	{ 0x4b,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovnp_r16_rm16),     PENTIUMOP(cmovnp_r32_rm32), },
	{ 0x4c,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovl_r16_rm16),      PENTIUMOP(cmovl_r32_rm32),  },
	{ 0x4d,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovge_r16_rm16),     PENTIUMOP(cmovge_r32_rm32), },
	{ 0x4e,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovle_r16_rm16),     PENTIUMOP(cmovle_r32_rm32), },
	{ 0x4f,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmovg_r16_rm16),      PENTIUMOP(cmovg_r32_rm32),  },
	{ 0x50,     OP_2BYTE|OP_SSE,            SSEOP(movmskps_r16_r128),       SSEOP(movmskps_r32_r128),   },
	{ 0x51,     OP_2BYTE|OP_SSE,            SSEOP(sqrtps_r128_rm128),       SSEOP(sqrtps_r128_rm128),   },
	{ 0x52,     OP_2BYTE|OP_SSE,            SSEOP(rsqrtps_r128_rm128),      SSEOP(rsqrtps_r128_rm128),  },
	{ 0x53,     OP_2BYTE|OP_SSE,            SSEOP(rcpps_r128_rm128),        SSEOP(rcpps_r128_rm128),    },
	{ 0x54,     OP_2BYTE|OP_SSE,            SSEOP(andps_r128_rm128),        SSEOP(andps_r128_rm128),    },
	{ 0x55,     OP_2BYTE|OP_SSE,            SSEOP(andnps_r128_rm128),       SSEOP(andnps_r128_rm128),   },
	{ 0x56,     OP_2BYTE|OP_SSE,            SSEOP(orps_r128_rm128),         SSEOP(orps_r128_rm128),     },
	{ 0x57,     OP_2BYTE|OP_SSE,            SSEOP(xorps),                   SSEOP(xorps),               },
	{ 0x58,     OP_2BYTE|OP_SSE,            SSEOP(addps),                   SSEOP(addps),               },
	{ 0x59,     OP_2BYTE|OP_SSE,            SSEOP(mulps),                   SSEOP(mulps),               },
	{ 0x5a,     OP_2BYTE|OP_SSE,            SSEOP(cvtps2pd_r128_r128m64),   SSEOP(cvtps2pd_r128_r128m64),},
	{ 0x5b,     OP_2BYTE|OP_SSE,            SSEOP(cvtdq2ps_r128_rm128),     SSEOP(cvtdq2ps_r128_rm128), },
	{ 0x5c,     OP_2BYTE|OP_SSE,            SSEOP(subps),                   SSEOP(subps),               },
	{ 0x5d,     OP_2BYTE|OP_SSE,            SSEOP(minps),                   SSEOP(minps),               },
	{ 0x5e,     OP_2BYTE|OP_SSE,            SSEOP(divps),                   SSEOP(divps),               },
	{ 0x5f,     OP_2BYTE|OP_SSE,            SSEOP(maxps),                   SSEOP(maxps),               },
	{ 0x60,     OP_2BYTE|OP_MMX,            MMXOP(punpcklbw_r64_r64m32),    MMXOP(punpcklbw_r64_r64m32),},
	{ 0x61,     OP_2BYTE|OP_MMX,            MMXOP(punpcklwd_r64_r64m32),    MMXOP(punpcklwd_r64_r64m32),},
	{ 0x62,     OP_2BYTE|OP_MMX,            MMXOP(punpckldq_r64_r64m32),    MMXOP(punpckldq_r64_r64m32),},
	{ 0x63,     OP_2BYTE|OP_MMX,            MMXOP(packsswb_r64_rm64),       MMXOP(packsswb_r64_rm64),   },
	{ 0x64,     OP_2BYTE|OP_MMX,            MMXOP(pcmpgtb_r64_rm64),        MMXOP(pcmpgtb_r64_rm64),    },
	{ 0x65,     OP_2BYTE|OP_MMX,            MMXOP(pcmpgtw_r64_rm64),        MMXOP(pcmpgtw_r64_rm64),    },
	{ 0x66,     OP_2BYTE|OP_MMX,            MMXOP(pcmpgtd_r64_rm64),        MMXOP(pcmpgtd_r64_rm64),    },
	{ 0x67,     OP_2BYTE|OP_MMX,            MMXOP(packuswb_r64_rm64),       MMXOP(packuswb_r64_rm64),   },
	{ 0x68,     OP_2BYTE|OP_MMX,            MMXOP(punpckhbw_r64_rm64),      MMXOP(punpckhbw_r64_rm64),  },
	{ 0x69,     OP_2BYTE|OP_MMX,            MMXOP(punpckhwd_r64_rm64),      MMXOP(punpckhwd_r64_rm64),  },
	{ 0x6a,     OP_2BYTE|OP_MMX,            MMXOP(punpckhdq_r64_rm64),      MMXOP(punpckhdq_r64_rm64),  },
	{ 0x6b,     OP_2BYTE|OP_MMX,            MMXOP(packssdw_r64_rm64),       MMXOP(packssdw_r64_rm64),   },
	{ 0x6e,     OP_2BYTE|OP_MMX,            MMXOP(movd_r64_rm32),           MMXOP(movd_r64_rm32),       },
	{ 0x6f,     OP_2BYTE|OP_MMX,            MMXOP(movq_r64_rm64),           MMXOP(movq_r64_rm64),       },
	{ 0x70,     OP_2BYTE|OP_MMX,            MMXOP(pshufw_r64_rm64_i8),      MMXOP(pshufw_r64_rm64_i8),  },
	{ 0x71,     OP_2BYTE|OP_MMX,            MMXOP(group_0f71),              MMXOP(group_0f71),          },
	{ 0x72,     OP_2BYTE|OP_MMX,            MMXOP(group_0f72),              MMXOP(group_0f72),          },
	{ 0x73,     OP_2BYTE|OP_MMX,            MMXOP(group_0f73),              MMXOP(group_0f73),          },
	{ 0x74,     OP_2BYTE|OP_CYRIX,          I386OP(cyrix_unknown),          I386OP(cyrix_unknown),      },
	{ 0x74,     OP_2BYTE|OP_MMX,            MMXOP(pcmpeqb_r64_rm64),        MMXOP(pcmpeqb_r64_rm64),    },
	{ 0x75,     OP_2BYTE|OP_MMX,            MMXOP(pcmpeqw_r64_rm64),        MMXOP(pcmpeqw_r64_rm64),    },
	{ 0x76,     OP_2BYTE|OP_MMX,            MMXOP(pcmpeqd_r64_rm64),        MMXOP(pcmpeqd_r64_rm64),    },
	{ 0x77,     OP_2BYTE|OP_MMX,            MMXOP(emms),                    MMXOP(emms),                },
	{ 0x7e,     OP_2BYTE|OP_MMX,            MMXOP(movd_rm32_r64),           MMXOP(movd_rm32_r64),       },
	{ 0x7f,     OP_2BYTE|OP_MMX,            MMXOP(movq_rm64_r64),           MMXOP(movq_rm64_r64),       },
	{ 0x80,     OP_2BYTE|OP_I386,           I386OP(jo_rel16),               I386OP(jo_rel32),           },
	{ 0x81,     OP_2BYTE|OP_I386,           I386OP(jno_rel16),              I386OP(jno_rel32),          },
	{ 0x82,     OP_2BYTE|OP_I386,           I386OP(jc_rel16),               I386OP(jc_rel32),           },
	{ 0x83,     OP_2BYTE|OP_I386,           I386OP(jnc_rel16),              I386OP(jnc_rel32),          },
	{ 0x84,     OP_2BYTE|OP_I386,           I386OP(jz_rel16),               I386OP(jz_rel32),           },
	{ 0x85,     OP_2BYTE|OP_I386,           I386OP(jnz_rel16),              I386OP(jnz_rel32),          },
	{ 0x86,     OP_2BYTE|OP_I386,           I386OP(jbe_rel16),              I386OP(jbe_rel32),          },
	{ 0x87,     OP_2BYTE|OP_I386,           I386OP(ja_rel16),               I386OP(ja_rel32),           },
	{ 0x88,     OP_2BYTE|OP_I386,           I386OP(js_rel16),               I386OP(js_rel32),           },
	{ 0x89,     OP_2BYTE|OP_I386,           I386OP(jns_rel16),              I386OP(jns_rel32),          },
	{ 0x8A,     OP_2BYTE|OP_I386,           I386OP(jp_rel16),               I386OP(jp_rel32),           },
	{ 0x8B,     OP_2BYTE|OP_I386,           I386OP(jnp_rel16),              I386OP(jnp_rel32),          },
	{ 0x8C,     OP_2BYTE|OP_I386,           I386OP(jl_rel16),               I386OP(jl_rel32),           },
	{ 0x8D,     OP_2BYTE|OP_I386,           I386OP(jge_rel16),              I386OP(jge_rel32),          },
	{ 0x8E,     OP_2BYTE|OP_I386,           I386OP(jle_rel16),              I386OP(jle_rel32),          },
	{ 0x8F,     OP_2BYTE|OP_I386,           I386OP(jg_rel16),               I386OP(jg_rel32),           },
	{ 0x90,     OP_2BYTE|OP_I386,           I386OP(seto_rm8),               I386OP(seto_rm8),           },
	{ 0x91,     OP_2BYTE|OP_I386,           I386OP(setno_rm8),              I386OP(setno_rm8),          },
	{ 0x92,     OP_2BYTE|OP_I386,           I386OP(setc_rm8),               I386OP(setc_rm8),           },
	{ 0x93,     OP_2BYTE|OP_I386,           I386OP(setnc_rm8),              I386OP(setnc_rm8),          },
	{ 0x94,     OP_2BYTE|OP_I386,           I386OP(setz_rm8),               I386OP(setz_rm8),           },
	{ 0x95,     OP_2BYTE|OP_I386,           I386OP(setnz_rm8),              I386OP(setnz_rm8),          },
	{ 0x96,     OP_2BYTE|OP_I386,           I386OP(setbe_rm8),              I386OP(setbe_rm8),          },
	{ 0x97,     OP_2BYTE|OP_I386,           I386OP(seta_rm8),               I386OP(seta_rm8),           },
	{ 0x98,     OP_2BYTE|OP_I386,           I386OP(sets_rm8),               I386OP(sets_rm8),           },
	{ 0x99,     OP_2BYTE|OP_I386,           I386OP(setns_rm8),              I386OP(setns_rm8),          },
	{ 0x9A,     OP_2BYTE|OP_I386,           I386OP(setp_rm8),               I386OP(setp_rm8),           },
	{ 0x9B,     OP_2BYTE|OP_I386,           I386OP(setnp_rm8),              I386OP(setnp_rm8),          },
	{ 0x9C,     OP_2BYTE|OP_I386,           I386OP(setl_rm8),               I386OP(setl_rm8),           },
	{ 0x9D,     OP_2BYTE|OP_I386,           I386OP(setge_rm8),              I386OP(setge_rm8),          },
	{ 0x9E,     OP_2BYTE|OP_I386,           I386OP(setle_rm8),              I386OP(setle_rm8),          },
	{ 0x9F,     OP_2BYTE|OP_I386,           I386OP(setg_rm8),               I386OP(setg_rm8),           },
	{ 0xA0,     OP_2BYTE|OP_I386,           I386OP(push_fs16),              I386OP(push_fs32),          },
	{ 0xA1,     OP_2BYTE|OP_I386,           I386OP(pop_fs16),               I386OP(pop_fs32),           },
	{ 0xA2,     OP_2BYTE|OP_I486,           I486OP(cpuid),                  I486OP(cpuid),              },
	{ 0xA3,     OP_2BYTE|OP_I386,           I386OP(bt_rm16_r16),            I386OP(bt_rm32_r32),        },
	{ 0xA4,     OP_2BYTE|OP_I386,           I386OP(shld16_i8),              I386OP(shld32_i8),          },
	{ 0xA5,     OP_2BYTE|OP_I386,           I386OP(shld16_cl),              I386OP(shld32_cl),          },
	{ 0xA8,     OP_2BYTE|OP_I386,           I386OP(push_gs16),              I386OP(push_gs32),          },
	{ 0xA9,     OP_2BYTE|OP_I386,           I386OP(pop_gs16),               I386OP(pop_gs32),           },
	{ 0xAA,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(rsm),                 PENTIUMOP(rsm),             },
	{ 0xAB,     OP_2BYTE|OP_I386,           I386OP(bts_rm16_r16),           I386OP(bts_rm32_r32),       },
	{ 0xAC,     OP_2BYTE|OP_I386,           I386OP(shrd16_i8),              I386OP(shrd32_i8),          },
	{ 0xAD,     OP_2BYTE|OP_I386,           I386OP(shrd16_cl),              I386OP(shrd32_cl),          },
	{ 0xAE,     OP_2BYTE|OP_SSE,            SSEOP(sse_group0fae),           SSEOP(sse_group0fae),       },
	{ 0xAF,     OP_2BYTE|OP_I386,           I386OP(imul_r16_rm16),          I386OP(imul_r32_rm32),      },
	{ 0xB0,     OP_2BYTE|OP_I486,           I486OP(cmpxchg_rm8_r8),         I486OP(cmpxchg_rm8_r8),     },
	{ 0xB1,     OP_2BYTE|OP_I486,           I486OP(cmpxchg_rm16_r16),       I486OP(cmpxchg_rm32_r32),   },
	{ 0xB2,     OP_2BYTE|OP_I386,           I386OP(lss16),                  I386OP(lss32),              },
	{ 0xB3,     OP_2BYTE|OP_I386,           I386OP(btr_rm16_r16),           I386OP(btr_rm32_r32),       },
	{ 0xB4,     OP_2BYTE|OP_I386,           I386OP(lfs16),                  I386OP(lfs32),              },
	{ 0xB5,     OP_2BYTE|OP_I386,           I386OP(lgs16),                  I386OP(lgs32),              },
	{ 0xB6,     OP_2BYTE|OP_I386,           I386OP(movzx_r16_rm8),          I386OP(movzx_r32_rm8),      },
	{ 0xB7,     OP_2BYTE|OP_I386,           I386OP(invalid),                I386OP(movzx_r32_rm16),     },
	{ 0xBA,     OP_2BYTE|OP_I386,           I386OP(group0FBA_16),           I386OP(group0FBA_32),       },
	{ 0xBB,     OP_2BYTE|OP_I386,           I386OP(btc_rm16_r16),           I386OP(btc_rm32_r32),       },
	{ 0xBC,     OP_2BYTE|OP_I386,           I386OP(bsf_r16_rm16),           I386OP(bsf_r32_rm32),       },
	{ 0xBD,     OP_2BYTE|OP_I386,           I386OP(bsr_r16_rm16),           I386OP(bsr_r32_rm32),       },
	{ 0xBE,     OP_2BYTE|OP_I386,           I386OP(movsx_r16_rm8),          I386OP(movsx_r32_rm8),      },
	{ 0xBF,     OP_2BYTE|OP_I386,           I386OP(invalid),                I386OP(movsx_r32_rm16),     },
	{ 0xC0,     OP_2BYTE|OP_I486,           I486OP(xadd_rm8_r8),            I486OP(xadd_rm8_r8),        },
	{ 0xC1,     OP_2BYTE|OP_I486,           I486OP(xadd_rm16_r16),          I486OP(xadd_rm32_r32),      },
	{ 0xC2,     OP_2BYTE|OP_SSE,            SSEOP(cmpps_r128_rm128_i8),     SSEOP(cmpps_r128_rm128_i8), },
	{ 0xC3,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(movnti_m16_r16),      PENTIUMOP(movnti_m32_r32),  },
	{ 0xC4,     OP_2BYTE|OP_SSE,            SSEOP(pinsrw_r64_r16m16_i8),    SSEOP(pinsrw_r64_r32m16_i8),},
	{ 0xC5,     OP_2BYTE|OP_SSE,            SSEOP(pextrw_r16_r64_i8),       SSEOP(pextrw_r32_r64_i8),   },
	{ 0xC6,     OP_2BYTE|OP_SSE,            SSEOP(shufps),                  SSEOP(shufps),              },
	{ 0xC7,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(cmpxchg8b_m64),       PENTIUMOP(cmpxchg8b_m64),   },
	{ 0xC8,     OP_2BYTE|OP_I486,           I486OP(bswap_eax),              I486OP(bswap_eax),          },
	{ 0xC9,     OP_2BYTE|OP_I486,           I486OP(bswap_ecx),              I486OP(bswap_ecx),          },
	{ 0xCA,     OP_2BYTE|OP_I486,           I486OP(bswap_edx),              I486OP(bswap_edx),          },
	{ 0xCB,     OP_2BYTE|OP_I486,           I486OP(bswap_ebx),              I486OP(bswap_ebx),          },
	{ 0xCC,     OP_2BYTE|OP_I486,           I486OP(bswap_esp),              I486OP(bswap_esp),          },
	{ 0xCD,     OP_2BYTE|OP_I486,           I486OP(bswap_ebp),              I486OP(bswap_ebp),          },
	{ 0xCE,     OP_2BYTE|OP_I486,           I486OP(bswap_esi),              I486OP(bswap_esi),          },
	{ 0xCF,     OP_2BYTE|OP_I486,           I486OP(bswap_edi),              I486OP(bswap_edi),          },
	{ 0xD1,     OP_2BYTE|OP_MMX,            MMXOP(psrlw_r64_rm64),          MMXOP(psrlw_r64_rm64),      },
	{ 0xD2,     OP_2BYTE|OP_MMX,            MMXOP(psrld_r64_rm64),          MMXOP(psrld_r64_rm64),      },
	{ 0xD3,     OP_2BYTE|OP_MMX,            MMXOP(psrlq_r64_rm64),          MMXOP(psrlq_r64_rm64),      },
	{ 0xD4,     OP_2BYTE|OP_MMX,            MMXOP(paddq_r64_rm64),          MMXOP(paddq_r64_rm64),      },
	{ 0xD5,     OP_2BYTE|OP_MMX,            MMXOP(pmullw_r64_rm64),         MMXOP(pmullw_r64_rm64),     },
	{ 0xD7,     OP_2BYTE|OP_SSE,            SSEOP(pmovmskb_r16_r64),        SSEOP(pmovmskb_r32_r64),    },
	{ 0xD8,     OP_2BYTE|OP_MMX,            MMXOP(psubusb_r64_rm64),        MMXOP(psubusb_r64_rm64),    },
	{ 0xD9,     OP_2BYTE|OP_MMX,            MMXOP(psubusw_r64_rm64),        MMXOP(psubusw_r64_rm64),    },
	{ 0xDA,     OP_2BYTE|OP_SSE,            SSEOP(pminub_r64_rm64),         SSEOP(pminub_r64_rm64),     },
	{ 0xDB,     OP_2BYTE|OP_MMX,            MMXOP(pand_r64_rm64),           MMXOP(pand_r64_rm64),       },
	{ 0xDC,     OP_2BYTE|OP_MMX,            MMXOP(paddusb_r64_rm64),        MMXOP(paddusb_r64_rm64),    },
	{ 0xDD,     OP_2BYTE|OP_MMX,            MMXOP(paddusw_r64_rm64),        MMXOP(paddusw_r64_rm64),    },
	{ 0xDE,     OP_2BYTE|OP_SSE,            SSEOP(pmaxub_r64_rm64),         SSEOP(pmaxub_r64_rm64),     },
	{ 0xDF,     OP_2BYTE|OP_MMX,            MMXOP(pandn_r64_rm64),          MMXOP(pandn_r64_rm64),      },
	{ 0xE0,     OP_2BYTE|OP_SSE,            SSEOP(pavgb_r64_rm64),          SSEOP(pavgb_r64_rm64),      },
	{ 0xE1,     OP_2BYTE|OP_MMX,            MMXOP(psraw_r64_rm64),          MMXOP(psraw_r64_rm64),      },
	{ 0xE2,     OP_2BYTE|OP_MMX,            MMXOP(psrad_r64_rm64),          MMXOP(psrad_r64_rm64),      },
	{ 0xE3,     OP_2BYTE|OP_SSE,            SSEOP(pavgw_r64_rm64),          SSEOP(pavgw_r64_rm64),      },
	{ 0xE4,     OP_2BYTE|OP_SSE,            SSEOP(pmulhuw_r64_rm64),        SSEOP(pmulhuw_r64_rm64),    },
	{ 0xE5,     OP_2BYTE|OP_MMX,            MMXOP(pmulhw_r64_rm64),         MMXOP(pmulhw_r64_rm64),     },
	{ 0xE7,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(movntq_m64_r64),      PENTIUMOP(movntq_m64_r64),  },
	{ 0xE8,     OP_2BYTE|OP_MMX,            MMXOP(psubsb_r64_rm64),         MMXOP(psubsb_r64_rm64),     },
	{ 0xE9,     OP_2BYTE|OP_MMX,            MMXOP(psubsw_r64_rm64),         MMXOP(psubsw_r64_rm64),     },
	{ 0xEA,     OP_2BYTE|OP_SSE,            SSEOP(pminsw_r64_rm64),         SSEOP(pminsw_r64_rm64),     },
	{ 0xEB,     OP_2BYTE|OP_MMX,            MMXOP(por_r64_rm64),            MMXOP(por_r64_rm64),        },
	{ 0xEC,     OP_2BYTE|OP_MMX,            MMXOP(paddsb_r64_rm64),         MMXOP(paddsb_r64_rm64),     },
	{ 0xED,     OP_2BYTE|OP_MMX,            MMXOP(paddsw_r64_rm64),         MMXOP(paddsw_r64_rm64),     },
	{ 0xEE,     OP_2BYTE|OP_SSE,            SSEOP(pmaxsw_r64_rm64),         SSEOP(pmaxsw_r64_rm64),     },
	{ 0xEF,     OP_2BYTE|OP_MMX,            MMXOP(pxor_r64_rm64),           MMXOP(pxor_r64_rm64),       },
	{ 0xF1,     OP_2BYTE|OP_MMX,            MMXOP(psllw_r64_rm64),          MMXOP(psllw_r64_rm64),      },
	{ 0xF2,     OP_2BYTE|OP_MMX,            MMXOP(pslld_r64_rm64),          MMXOP(pslld_r64_rm64),      },
	{ 0xF3,     OP_2BYTE|OP_MMX,            MMXOP(psllq_r64_rm64),          MMXOP(psllq_r64_rm64),      },
	{ 0xF4,     OP_2BYTE|OP_SSE,            SSEOP(pmuludq_r64_rm64),        SSEOP(pmuludq_r64_rm64),    },
	{ 0xF5,     OP_2BYTE|OP_MMX,            MMXOP(pmaddwd_r64_rm64),        MMXOP(pmaddwd_r64_rm64),    },
	{ 0xF6,     OP_2BYTE|OP_SSE,            SSEOP(psadbw_r64_rm64),         SSEOP(psadbw_r64_rm64),     },
	{ 0xf7,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP(maskmovq_r64_r64),    PENTIUMOP(maskmovq_r64_r64),},
	{ 0xF8,     OP_2BYTE|OP_MMX,            MMXOP(psubb_r64_rm64),          MMXOP(psubb_r64_rm64),      },
	{ 0xF9,     OP_2BYTE|OP_MMX,            MMXOP(psubw_r64_rm64),          MMXOP(psubw_r64_rm64),      },
	{ 0xFA,     OP_2BYTE|OP_MMX,            MMXOP(psubd_r64_rm64),          MMXOP(psubd_r64_rm64),      },
	{ 0xFB,     OP_2BYTE|OP_SSE,            SSEOP(psubq_r64_rm64),          SSEOP(psubq_r64_rm64),      },
	{ 0xFC,     OP_2BYTE|OP_MMX,            MMXOP(paddb_r64_rm64),          MMXOP(paddb_r64_rm64),      },
	{ 0xFD,     OP_2BYTE|OP_MMX,            MMXOP(paddw_r64_rm64),          MMXOP(paddw_r64_rm64),      },
	{ 0xFE,     OP_2BYTE|OP_MMX,            MMXOP(paddd_r64_rm64),          MMXOP(paddd_r64_rm64),      },
	/* F3 0F ?? */
	{ 0x10,     OP_3BYTEF3|OP_SSE,          SSEOP(movss_r128_rm128),        SSEOP(movss_r128_rm128),    },
	{ 0x11,     OP_3BYTEF3|OP_SSE,          SSEOP(movss_rm128_r128),        SSEOP(movss_rm128_r128),    },
	{ 0x12,     OP_3BYTEF3|OP_SSE,          SSEOP(movsldup_r128_rm128),     SSEOP(movsldup_r128_rm128), },
	{ 0x16,     OP_3BYTEF3|OP_SSE,          SSEOP(movshdup_r128_rm128),     SSEOP(movshdup_r128_rm128), },
	{ 0x2A,     OP_3BYTEF3|OP_SSE,          SSEOP(cvtsi2ss_r128_rm32),      SSEOP(cvtsi2ss_r128_rm32),  },
	{ 0x2C,     OP_3BYTEF3|OP_SSE,          SSEOP(cvttss2si_r32_r128m32),   SSEOP(cvttss2si_r32_r128m32),},
	{ 0x2D,     OP_3BYTEF3|OP_SSE,          SSEOP(cvtss2si_r32_r128m32),    SSEOP(cvtss2si_r32_r128m32),},
	{ 0x51,     OP_3BYTEF3|OP_SSE,          SSEOP(sqrtss_r128_r128m32),     SSEOP(sqrtss_r128_r128m32), },
	{ 0x52,     OP_3BYTEF3|OP_SSE,          SSEOP(rsqrtss_r128_r128m32),    SSEOP(rsqrtss_r128_r128m32),},
	{ 0x53,     OP_3BYTEF3|OP_SSE,          SSEOP(rcpss_r128_r128m32),      SSEOP(rcpss_r128_r128m32),  },
	{ 0x58,     OP_3BYTEF3|OP_SSE,          SSEOP(addss),                   SSEOP(addss),               },
	{ 0x59,     OP_3BYTEF3|OP_SSE,          SSEOP(mulss),                   SSEOP(mulss),               },
	{ 0x5A,     OP_3BYTEF3|OP_SSE,          SSEOP(cvtss2sd_r128_r128m32),   SSEOP(cvtss2sd_r128_r128m32),},
	{ 0x5B,     OP_3BYTEF3|OP_SSE,          SSEOP(cvttps2dq_r128_rm128),    SSEOP(cvttps2dq_r128_rm128),},
	{ 0x5C,     OP_3BYTEF3|OP_SSE,          SSEOP(subss),                   SSEOP(subss),               },
	{ 0x5D,     OP_3BYTEF3|OP_SSE,          SSEOP(minss_r128_r128m32),      SSEOP(minss_r128_r128m32),  },
	{ 0x5E,     OP_3BYTEF3|OP_SSE,          SSEOP(divss),                   SSEOP(divss),               },
	{ 0x5F,     OP_3BYTEF3|OP_SSE,          SSEOP(maxss_r128_r128m32),      SSEOP(maxss_r128_r128m32),  },
	{ 0x6F,     OP_3BYTEF3|OP_SSE,          SSEOP(movdqu_r128_rm128),       SSEOP(movdqu_r128_rm128),   },
	{ 0x70,     OP_3BYTEF3|OP_SSE,          SSEOP(pshufhw_r128_rm128_i8),   SSEOP(pshufhw_r128_rm128_i8),},
	{ 0x7E,     OP_3BYTEF3|OP_SSE,          SSEOP(movq_r128_r128m64),       SSEOP(movq_r128_r128m64),   },
	{ 0x7F,     OP_3BYTEF3|OP_SSE,          SSEOP(movdqu_rm128_r128),       SSEOP(movdqu_rm128_r128),   },
	{ 0xB8,     OP_3BYTEF3|OP_PENTIUM,      PENTIUMOP(popcnt_r16_rm16),     PENTIUMOP(popcnt_r32_rm32), },
	{ 0xBC,     OP_3BYTEF3|OP_PENTIUM,      PENTIUMOP(tzcnt_r16_rm16),      PENTIUMOP(tzcnt_r32_rm32), },
	{ 0xC2,     OP_3BYTEF3|OP_SSE,          SSEOP(cmpss_r128_r128m32_i8),   SSEOP(cmpss_r128_r128m32_i8),},
	{ 0xD6,     OP_3BYTEF3|OP_SSE,          SSEOP(movq2dq_r128_r64),        SSEOP(movq2dq_r128_r64),    },
	{ 0xE6,     OP_3BYTEF3|OP_SSE,          SSEOP(cvtdq2pd_r128_r128m64),   SSEOP(cvtdq2pd_r128_r128m64)}
};
