/*
 *  KCemu -- The emulator for the KC85 homecomputer series and much more.
 *  Copyright (C) 1997-2010 Torsten Paul
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __kc_keys_h
#define __kc_keys_h

#define KC_KEY_ENTER               (0x0d)
#define KC_KEY_ESC                 (0x1b)
#define KC_KEY_SPACE               (0x20)

#define KC_KEY_F1                  (0x101)
#define KC_KEY_F2                  (0x102)
#define KC_KEY_F3                  (0x103)
#define KC_KEY_F4                  (0x104)
#define KC_KEY_F5                  (0x105)
#define KC_KEY_F6                  (0x106)
#define KC_KEY_F7                  (0x107)
#define KC_KEY_F8                  (0x108)
#define KC_KEY_F9                  (0x109)
#define KC_KEY_F10                 (0x10a)
#define KC_KEY_F11                 (0x10b)
#define KC_KEY_F12                 (0x10c)
#define KC_KEY_F13                 (0x10d)
#define KC_KEY_F14                 (0x10e)
#define KC_KEY_F15                 (0x10f)
#define KC_KEY_SHIFT               (0x110)
#define KC_KEY_CONTROL             (0x111)
#define KC_KEY_ALT                 (0x112)
#define KC_KEY_ALT_GR              (0x113)
#define KC_KEY_LEFT                (0x114)
#define KC_KEY_RIGHT               (0x115)
#define KC_KEY_DOWN                (0x116)
#define KC_KEY_UP                  (0x117)
#define KC_KEY_HOME                (0x118)
#define KC_KEY_END                 (0x119)
#define KC_KEY_DEL                 (0x11a)
#define KC_KEY_INSERT              (0x11b)
#define KC_KEY_PAGE_UP             (0x11c)
#define KC_KEY_PAGE_DOWN           (0x11d)
#define KC_KEY_PAUSE               (0x11e)
#define KC_KEY_PRINT               (0x11f)
#define KC_KEY_COLOR               (0x120)
#define KC_KEY_GRAPHIC             (0x121)
#define KC_KEY_LIST                (0x122)
#define KC_KEY_RUN                 (0x123)
#define KC_KEY_STOP                (0x124)
#define KC_KEY_SHIFT_LOCK          (0x125)
#define KC_KEY_RESET               (0x126)
#define KC_KEY_NMI                 (0x127)
#define KC_KEY_BREAK               (0x128)
#define KC_KEY_CLEAR               (0x129)

#endif /* __kc_keys_h */
