/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.aiff.AiffStrings;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class InstrumentChunk
extends Chunk {
    public InstrumentChunk(AiffModule aiffModule, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(aiffModule, chunkHeader, dataInputStream);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        AiffModule aiffModule = (AiffModule)this._module;
        int n = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)aiffModule);
        int n2 = ModuleBase.readSignedByte((DataInputStream)this._dstream, (ModuleBase)aiffModule);
        int n3 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)aiffModule);
        int n4 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)aiffModule);
        int n5 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)aiffModule);
        int n6 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)aiffModule);
        int n7 = aiffModule.readSignedShort(this._dstream);
        Loop loop = this.readLoop(aiffModule);
        Loop loop2 = this.readLoop(aiffModule);
        ArrayList<Property> arrayList = new ArrayList<Property>(9);
        arrayList.add(new Property("BaseNote", PropertyType.INTEGER, (Object)new Integer(n)));
        arrayList.add(new Property("Detune", PropertyType.INTEGER, (Object)new Integer(n2)));
        arrayList.add(new Property("LowNote", PropertyType.INTEGER, (Object)new Integer(n3)));
        arrayList.add(new Property("HighNote", PropertyType.INTEGER, (Object)new Integer(n4)));
        arrayList.add(new Property("LowVelocity", PropertyType.INTEGER, (Object)new Integer(n5)));
        arrayList.add(new Property("HighVelocity", PropertyType.INTEGER, (Object)new Integer(n6)));
        arrayList.add(new Property("Gain", PropertyType.INTEGER, (Object)new Integer(n7)));
        arrayList.add(loop.loopProp("SustainLoop"));
        arrayList.add(loop2.loopProp("ReleaseLoop"));
        aiffModule.addAiffProperty(new Property("Instrument", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }

    private Loop readLoop(AiffModule aiffModule) throws IOException {
        int n = aiffModule.readSignedShort(this._dstream);
        int n2 = aiffModule.readUnsignedShort(this._dstream);
        int n3 = aiffModule.readUnsignedShort(this._dstream);
        return new Loop(n, n2, n3);
    }

    private class Loop {
        public int playMode;
        public int beginLoop;
        public int endLoop;

        public Loop(int n, int n2, int n3) {
            this.playMode = n;
            this.beginLoop = n2;
            this.endLoop = n3;
        }

        public Property loopProp(String string) {
            Property[] propertyArray = new Property[]{InstrumentChunk.this._module.addIntegerProperty("PlayMode", this.playMode, AiffStrings.LOOP_TYPE), new Property("BeginLoop", PropertyType.INTEGER, (Object)new Integer(this.beginLoop)), new Property("EndLoop", PropertyType.INTEGER, (Object)new Integer(this.endLoop))};
            return new Property(string, PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray);
        }
    }
}

