/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.LocationAware;
import htsjdk.samtools.util.Log;
import htsjdk.tribble.AbstractFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.SynchronousLineReader;
import java.io.IOException;
import java.io.InputStream;

public abstract class AsciiFeatureCodec<T extends Feature>
extends AbstractFeatureCodec<T, LineIterator> {
    private static final Log log = Log.getInstance(AsciiFeatureCodec.class);

    protected AsciiFeatureCodec(Class<T> myClass) {
        super(myClass);
    }

    @Override
    public void close(LineIterator lineIterator) {
        CloserUtil.close(lineIterator);
    }

    @Override
    public boolean isDone(LineIterator lineIterator) {
        return !lineIterator.hasNext();
    }

    @Override
    public LocationAware makeIndexableSourceFromStream(InputStream inputStream) {
        return new AsciiLineReaderIterator(AsciiLineReader.from(inputStream));
    }

    @Override
    public LineIterator makeSourceFromStream(InputStream bufferedInputStream) {
        return new LineIteratorImpl(new SynchronousLineReader(bufferedInputStream));
    }

    @Override
    public T decode(LineIterator lineIterator) {
        return this.decode((String)lineIterator.next());
    }

    @Override
    public abstract T decode(String var1);

    @Override
    public FeatureCodecHeader readHeader(LineIterator lineIterator) throws IOException {
        return new FeatureCodecHeader(this.readActualHeader(lineIterator), 0L);
    }

    public abstract Object readActualHeader(LineIterator var1);
}

